/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseBankQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseExtMapQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInvoiceQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgTagRelQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseExtMap;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseInvoice;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoUpdateService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoUpdateService"})
public class UmcEnterpriseInfoUpdateServiceImpl
implements UmcEnterpriseInfoUpdateService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"updateEnterpriseInfo"})
    public UmcEnterpriseInfoUpdateRspBo updateEnterpriseInfo(@RequestBody UmcEnterpriseInfoUpdateReqBo reqBo) {
        this.validateParams(reqBo);
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBo.getOrgId());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (null == orgInfo) {
            throw new BaseBusinessException("201013", "\u4f01\u4e1a\u4fe1\u606f\u4fee\u6539\u5f02\u5e38\uff1a\u65e0\u6b64\u673a\u6784\u4fe1\u606f");
        }
        UmcEnterpriseInfoUpdateRspBo rspBo = UmcRu.success(UmcEnterpriseInfoUpdateRspBo.class);
        UmcOrgInfo setOrg = UmcRu.js(reqBo.getOrgInfoBo(), UmcOrgInfo.class);
        setOrg.setUpdateTime(new Date());
        setOrg.setExtField1(reqBo.getOrgInfoBo().getSupStatus());
        setOrg.setOrgId(reqBo.getOrgInfoBo().getOrgId());
        this.iUmcEnterpriseInfoModel.updateOrgInfo(setOrg);
        if (reqBo.getIsUpdateTagFlag().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)reqBo.getOrgInfoBo().getOrgTagRelList())) {
                UmcOrgTagRel orgTagRelSet = new UmcOrgTagRel();
                orgTagRelSet.setDelFlag("1");
                UmcOrgTagRel orgTagRelWhere = new UmcOrgTagRel();
                orgTagRelWhere.setOrgId(reqBo.getOrgId());
                this.iUmcEnterpriseInfoModel.updateOrgTagIdRel(orgTagRelSet, orgTagRelWhere);
            } else {
                ArrayList<UmcOrgTagRel> addOrgTagRelList = new ArrayList<UmcOrgTagRel>();
                ArrayList<UmcOrgTagRel> delOrgTagRelList = new ArrayList<UmcOrgTagRel>();
                List<UmcOrgTagRel> reqOrgTagRelList = UmcRu.jsl(reqBo.getOrgInfoBo().getOrgTagRelList(), UmcOrgTagRel.class);
                UmcOrgTagRelQryBo orgTagRelQryBo = new UmcOrgTagRelQryBo();
                orgTagRelQryBo.setOrgId(reqBo.getOrgId());
                List<UmcOrgTagRel> oldOrgTagRelList = this.iUmcEnterpriseInfoModel.getOrgTagRelList(orgTagRelQryBo);
                if (CollectionUtils.isEmpty(oldOrgTagRelList)) {
                    addOrgTagRelList.addAll(reqOrgTagRelList);
                } else {
                    ArrayList<UmcOrgTagRel> sameOldOrgTagIdRelList = new ArrayList<UmcOrgTagRel>();
                    ArrayList<UmcOrgTagRel> sameReqOrgTagIdRelList = new ArrayList<UmcOrgTagRel>();
                    for (UmcOrgTagRel oldOrgTagRel : oldOrgTagRelList) {
                        for (UmcOrgTagRel reqOrgTagRel : reqOrgTagRelList) {
                            if (!oldOrgTagRel.getTagId().equals(reqOrgTagRel.getTagId())) continue;
                            sameOldOrgTagIdRelList.add(oldOrgTagRel);
                            sameReqOrgTagIdRelList.add(reqOrgTagRel);
                        }
                    }
                    delOrgTagRelList.addAll(oldOrgTagRelList);
                    delOrgTagRelList.removeAll(sameOldOrgTagIdRelList);
                    addOrgTagRelList.addAll(reqOrgTagRelList);
                    addOrgTagRelList.removeAll(sameReqOrgTagIdRelList);
                }
                this.updateOrgTagRel(addOrgTagRelList, delOrgTagRelList, orgInfo);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseInvoiceBoList())) {
            List<UmcEnterpriseInvoice> enterpriseInvoiceList = UmcRu.jsl(reqBo.getEnterpriseInvoiceBoList(), UmcEnterpriseInvoice.class);
            for (UmcEnterpriseInvoice enterpriseInvoice : enterpriseInvoiceList) {
                if (null != enterpriseInvoice.getInvoiceId()) {
                    UmcEnterpriseInvoiceQryBo enterpriseInvoiceQryBo = new UmcEnterpriseInvoiceQryBo();
                    enterpriseInvoiceQryBo.setInvoiceId(enterpriseInvoice.getInvoiceId());
                    UmcEnterpriseInvoice umcEnterpriseInvoice = this.iUmcEnterpriseInfoModel.getEnterpriseInvoice(enterpriseInvoiceQryBo);
                    if (null == umcEnterpriseInvoice) {
                        throw new BaseBusinessException("201013", "\u4f01\u4e1a\u4fe1\u606f\u4fee\u6539\u5f02\u5e38\uff1a\u53d1\u7968\u4fee\u6539\uff0c\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f");
                    }
                    UmcEnterpriseInvoice whereInvoice = new UmcEnterpriseInvoice();
                    whereInvoice.setInvoiceId(enterpriseInvoice.getInvoiceId());
                    this.iUmcEnterpriseInfoModel.updateEnterpriseInvoice(enterpriseInvoice, whereInvoice);
                    continue;
                }
                enterpriseInvoice.setInvoiceId(IdUtil.nextId());
                this.iUmcEnterpriseInfoModel.createEnterpriseInvoice(enterpriseInvoice);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseBankBoList())) {
            List<UmcEnterpriseBank> enterpriseBankList = UmcRu.jsl(reqBo.getEnterpriseBankBoList(), UmcEnterpriseBank.class);
            for (UmcEnterpriseBank enterpriseBank : enterpriseBankList) {
                if (null != enterpriseBank.getBankId()) {
                    UmcEnterpriseBankQryBo enterpriseBankQryBo = new UmcEnterpriseBankQryBo();
                    enterpriseBankQryBo.setBankId(enterpriseBank.getBankId());
                    UmcEnterpriseBank umcEnterpriseBank = this.iUmcEnterpriseInfoModel.getEnterpriseBank(enterpriseBankQryBo);
                    if (null == umcEnterpriseBank) {
                        throw new BaseBusinessException("201013", "\u4f01\u4e1a\u4fe1\u606f\u4fee\u6539\u5f02\u5e38\uff1a\u94f6\u884c\u4fee\u6539\uff0c\u672a\u67e5\u8be2\u5230\u94f6\u884c\u4fe1\u606f");
                    }
                    UmcEnterpriseBank whereBank = new UmcEnterpriseBank();
                    whereBank.setBankId(enterpriseBank.getBankId());
                    this.iUmcEnterpriseInfoModel.updateEnterpriseBank(enterpriseBank, whereBank);
                    continue;
                }
                enterpriseBank.setBankId(IdUtil.nextId());
                this.iUmcEnterpriseInfoModel.createEnterpriseBank(enterpriseBank);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseContactBoList())) {
            List<UmcEnterpriseContact> enterpriseContactList = UmcRu.jsl(reqBo.getEnterpriseContactBoList(), UmcEnterpriseContact.class);
            for (UmcEnterpriseContact enterpriseContact : enterpriseContactList) {
                if (null != enterpriseContact.getContactId()) {
                    UmcEnterpriseContactQryBo enterpriseContactQryBo = new UmcEnterpriseContactQryBo();
                    enterpriseContactQryBo.setContactId(enterpriseContact.getContactId());
                    UmcEnterpriseContact umcEnterpriseContact = this.iUmcEnterpriseInfoModel.getEnterpriseContact(enterpriseContactQryBo);
                    if (null == umcEnterpriseContact) {
                        throw new BaseBusinessException("201013", "\u4f01\u4e1a\u4fe1\u606f\u4fee\u6539\u5f02\u5e38\uff1a\u53d1\u7968\u4fee\u6539\uff0c\u672a\u67e5\u8be2\u5230\u8054\u7cfb\u4eba\u4fe1\u606f");
                    }
                    UmcEnterpriseContact whereContact = new UmcEnterpriseContact();
                    whereContact.setContactId(enterpriseContact.getContactId());
                    UmcEnterpriseContact setContact = this.buildUpdateContact(enterpriseContact);
                    this.iUmcEnterpriseInfoModel.updateEnterpriseContact(setContact, whereContact);
                    continue;
                }
                enterpriseContact.setContactId(IdUtil.nextId());
                this.iUmcEnterpriseInfoModel.createEnterpriseContact(enterpriseContact);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseExt())) {
            List<UmcEnterpriseExtMap> enterpriseExtMapList = UmcRu.jsl(reqBo.getEnterpriseExt(), UmcEnterpriseExtMap.class);
            for (UmcEnterpriseExtMap enterpriseExtMap : enterpriseExtMapList) {
                UmcEnterpriseExtMapQryBo enterpriseExtMapQryBo = new UmcEnterpriseExtMapQryBo();
                enterpriseExtMapQryBo.setFieldCode(enterpriseExtMap.getFieldCode());
                enterpriseExtMapQryBo.setFieldName(enterpriseExtMap.getFieldName());
                List<UmcEnterpriseExtMap> umcEnterpriseExtMapList = this.iUmcEnterpriseInfoModel.getEnterpriseExtMapList(enterpriseExtMapQryBo);
                Date now = new Date();
                if (CollectionUtils.isEmpty(umcEnterpriseExtMapList)) {
                    if (null == enterpriseExtMap.getExtId()) {
                        enterpriseExtMap.setExtId(IdUtil.nextId());
                    }
                    enterpriseExtMap.setCreateTime(now);
                    enterpriseExtMap.setCreateOperId(reqBo.getUpdateOperId());
                    enterpriseExtMap.setCreateOperName(reqBo.getUpdateOperName());
                    StrUtil.noNullStringAttr(enterpriseExtMap);
                    this.iUmcEnterpriseInfoModel.createEnterpriseExtMap(enterpriseExtMap);
                    continue;
                }
                UmcEnterpriseExtMap whereExtMap = UmcRu.js(enterpriseExtMapQryBo, UmcEnterpriseExtMap.class);
                enterpriseExtMap.setUpdateOperName(reqBo.getUpdateOperName());
                enterpriseExtMap.setUpdateOperId(reqBo.getUpdateOperId());
                enterpriseExtMap.setUpdateTime(now);
                StrUtil.noNullStringAttr(enterpriseExtMap);
                this.iUmcEnterpriseInfoModel.updateEnterpriseExtMap(enterpriseExtMap, whereExtMap);
            }
        }
        UmcEnterpriseInfoDo setInfo = UmcRu.js(reqBo, UmcEnterpriseInfoDo.class);
        StrUtil.noNullStringAttr(setInfo);
        this.buildUpdateEnterprise(setInfo, reqBo);
        setInfo.setOrgId(reqBo.getOrgId());
        this.iUmcEnterpriseInfoModel.updateEnterpriseInfo(setInfo);
        return rspBo;
    }

    private UmcEnterpriseContact buildUpdateContact(UmcEnterpriseContact enterpriseContact) {
        UmcEnterpriseContact contact = UmcRu.js(enterpriseContact, UmcEnterpriseContact.class);
        StrUtil.noNullStringAttr(contact);
        if (StringUtils.isEmpty((Object)enterpriseContact.getContactName())) {
            contact.setContactName("");
        }
        if (StringUtils.isEmpty((Object)enterpriseContact.getPhoneNumber())) {
            contact.setPhoneNumber("");
        }
        if (StringUtils.isEmpty((Object)enterpriseContact.getTel())) {
            contact.setTel("");
        }
        if (StringUtils.isEmpty((Object)enterpriseContact.getEmail())) {
            contact.setEmail("");
        }
        return contact;
    }

    private void buildUpdateEnterprise(UmcEnterpriseInfoDo setInfo, UmcEnterpriseInfoUpdateReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getOrgShortName())) {
            setInfo.setOrgShortName("");
        }
        if (StringUtils.isEmpty((Object)reqBo.getIsAbroad())) {
            setInfo.setIsAbroad("");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusinessLicense())) {
            setInfo.setBusinessLicense("");
        }
        if (StringUtils.isEmpty((Object)reqBo.getFax())) {
            setInfo.setFax("");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMailBox())) {
            setInfo.setMailBox("");
        }
    }

    private void updateOrgTagRel(List<UmcOrgTagRel> add, List<UmcOrgTagRel> del, UmcOrgInfo orgInfo) {
        for (UmcOrgTagRel addOrgTagRel : add) {
            addOrgTagRel.setOrgId(orgInfo.getOrgId());
            addOrgTagRel.setRelId(IdUtil.nextId());
            addOrgTagRel.setTenantId(orgInfo.getTenantId());
            addOrgTagRel.setTagStatus("1");
            addOrgTagRel.setUpdateTime(new Date());
            StrUtil.noNullStringAttr(addOrgTagRel);
            this.iUmcEnterpriseInfoModel.createOrgTagIdRel(addOrgTagRel);
        }
        for (UmcOrgTagRel delOrgTagRel : del) {
            delOrgTagRel.setDelFlag("1");
            delOrgTagRel.setUpdateTime(new Date());
            UmcOrgTagRel orgTagRelWhere = new UmcOrgTagRel();
            orgTagRelWhere.setRelId(delOrgTagRel.getRelId());
            StrUtil.noNullStringAttr(delOrgTagRel);
            this.iUmcEnterpriseInfoModel.updateOrgTagIdRel(delOrgTagRel, orgTagRelWhere);
        }
    }

    private void validateParams(UmcEnterpriseInfoUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrgInfoBo())) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2[UmcOrgInfoBo]\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getOrgId()) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2[orgId]\u4e3a\u7a7a\uff01");
        }
    }
}

