/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.domainservice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseExtMap;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseInvoice;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.enterpriseacount.IUmcEnterpriseAccountModel;
import com.tydic.dyc.umc.model.enterpriseacount.UmcEnterpriseAccountDo;
import com.tydic.dyc.umc.model.enterpriseapply.IUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.model.enterpriseapply.UmcEnterpriseInfoApplyDo;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseBankApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseContactApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseExtMapApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseInvoiceApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcOrgInfoApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcOrgTagRelApply;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.sub.UmcCustExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcUserExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.model.userapply.IUmcUserInfoApplyModel;
import com.tydic.dyc.umc.model.userapply.UmcUserInfoApplyDo;
import com.tydic.dyc.umc.model.userapply.sub.UmcCustInfoApply;
import com.tydic.dyc.umc.service.domainservice.UmcEnterpriseUserRegisterService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseRegisterApplyInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseRegisterInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterRspBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcRegisterAccountBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserRegisterApplyInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserRegisterInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserExtMapBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.domainservice.UmcEnterpriseUserRegisterService"})
public class UmcEnterpriseUserRegisterServiceImpl
implements UmcEnterpriseUserRegisterService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcEnterpriseInfoApplyModel iUmcEnterpriseInfoApplyModel;
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private IUmcUserInfoApplyModel iUmcUserInfoApplyModel;
    @Autowired
    private IUmcEnterpriseAccountModel iUmcEnterpriseAccountModel;

    @PostMapping(value={"dealEnterpriseUserRegister"})
    public UmcEnterpriseUserRegisterRspBo dealEnterpriseUserRegister(@RequestBody UmcEnterpriseUserRegisterReqBo reqBo) {
        this.validateParams(reqBo);
        this.createOrg(reqBo.getUmcEnterpriseRegisterInfoBo());
        this.createOrgApply(reqBo.getUmcEnterpriseRegisterApplyInfoBo());
        this.createUser(reqBo.getUmcUserRegisterInfoBo());
        this.createUserApply(reqBo.getUmcUserRegisterApplyInfoBo());
        this.createrEnterpriseAccount(reqBo.getUmcRegisterAccountBo());
        return UmcRu.success(UmcEnterpriseUserRegisterRspBo.class);
    }

    private void createrEnterpriseAccount(UmcRegisterAccountBo umcRegisterAccountBo) {
        if (null == umcRegisterAccountBo) {
            return;
        }
        UmcEnterpriseAccountDo addDo = UmcRu.js(umcRegisterAccountBo, UmcEnterpriseAccountDo.class);
        addDo.setAccountType("01");
        addDo.setIsShadowAccount("0");
        if (StringUtils.isEmpty((Object)umcRegisterAccountBo.getAccountId())) {
            addDo.setAccountId(IdUtil.nextId());
        }
        addDo.setOperOrgId(Convert.toStr((Object)umcRegisterAccountBo.getDeliveryCenterId()));
        addDo.setAccountStatus("1");
        addDo.setCheckStatus("1");
        addDo.setOwnerUserId(umcRegisterAccountBo.getOwnerMemId());
        this.iUmcEnterpriseAccountModel.addEnterpriseAccount(addDo);
    }

    private void createUserApply(UmcUserRegisterApplyInfoBo umcUserRegisterApplyInfoBo) {
        if (null == umcUserRegisterApplyInfoBo) {
            return;
        }
        UmcUserInfoApplyDo userInfoApplyDo = UmcRu.js(umcUserRegisterApplyInfoBo, UmcUserInfoApplyDo.class);
        this.iUmcUserInfoApplyModel.createUserInfoApply(StrUtil.noNullStringAttr(userInfoApplyDo));
        if (ObjectUtil.isNotEmpty((Object)umcUserRegisterApplyInfoBo.getCustInfoApplyBo())) {
            UmcCustInfoApply custInfoApply = UmcRu.js(umcUserRegisterApplyInfoBo.getCustInfoApplyBo(), UmcCustInfoApply.class);
            this.iUmcUserInfoApplyModel.createCustInfoApply(StrUtil.noNullStringAttr(custInfoApply));
        }
    }

    private void createUser(UmcUserRegisterInfoBo umcUserRegisterInfoBo) {
        if (null != umcUserRegisterInfoBo.getCustInfo()) {
            UmcCustInfo custInfo = this.buildCustInfo(umcUserRegisterInfoBo);
            StrUtil.noNullStringAttr(custInfo);
            this.iUmcUserInfoModel.createCustInfo(custInfo);
        }
        UmcUserInfoDo userInfoDo = this.buildUserInfo(umcUserRegisterInfoBo);
        StrUtil.noNullStringAttr(userInfoDo);
        this.iUmcUserInfoModel.createUserInfo(userInfoDo);
    }

    private UmcCustInfo buildCustInfo(UmcUserRegisterInfoBo umcUserRegisterInfoBo) {
        UmcCustInfo custInfo = UmcRu.js(umcUserRegisterInfoBo.getCustInfo(), UmcCustInfo.class);
        custInfo.setCreateTime(new Date());
        custInfo.setUpdateTime(new Date());
        if (!StringUtils.isEmpty((Object)umcUserRegisterInfoBo.getExtField1())) {
            custInfo.setExtField1(umcUserRegisterInfoBo.getExtField1());
        }
        if (!CollectionUtils.isEmpty((Collection)umcUserRegisterInfoBo.getUserExtMapList())) {
            ArrayList<UmcCustExtMap> custExtMapList = new ArrayList<UmcCustExtMap>();
            for (UmcUserExtMapBo custBo : umcUserRegisterInfoBo.getUserExtMapList()) {
                UmcCustExtMap custExtMap = UmcRu.js(custBo, UmcCustExtMap.class);
                custExtMap.setCustId(umcUserRegisterInfoBo.getCustId());
                custExtMap.setCreateTime(new Date());
                custExtMap.setDelFlag("0");
                custExtMapList.add(custExtMap);
            }
            custInfo.setCustExtMapList(custExtMapList);
        }
        return custInfo;
    }

    private void createOrgApply(UmcEnterpriseRegisterApplyInfoBo umcEnterpriseRegisterApplyInfoBo) {
        if (null == umcEnterpriseRegisterApplyInfoBo) {
            return;
        }
        UmcOrgInfoApply umcEnterpriseOrgApply = UmcRu.js(umcEnterpriseRegisterApplyInfoBo.getOrgInfoApplyBo(), UmcOrgInfoApply.class);
        if (null == umcEnterpriseRegisterApplyInfoBo.getApplyId()) {
            umcEnterpriseOrgApply.setApplyId(IdUtil.nextId());
        }
        if (null == umcEnterpriseRegisterApplyInfoBo.getOrgId()) {
            umcEnterpriseOrgApply.setOrgId(IdUtil.nextId());
        } else {
            umcEnterpriseOrgApply.setOrgId(umcEnterpriseRegisterApplyInfoBo.getOrgId());
        }
        if (null != umcEnterpriseRegisterApplyInfoBo.getOrgInfoApplyBo() && !CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterApplyInfoBo.getOrgInfoApplyBo().getOrgTagRelApplyBoList())) {
            umcEnterpriseOrgApply.setOrgTagRelApplyList(UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getOrgInfoApplyBo().getOrgTagRelApplyBoList(), UmcOrgTagRelApply.class));
            umcEnterpriseOrgApply.getOrgTagRelApplyList().forEach(umcOrgTagRelApply -> {
                if (null == umcOrgTagRelApply.getApplyId()) {
                    umcOrgTagRelApply.setApplyId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(umcOrgTagRelApply);
            });
        }
        umcEnterpriseOrgApply = this.iUmcEnterpriseInfoApplyModel.createOrgInfoApply(StrUtil.noNullStringAttr(umcEnterpriseOrgApply));
        if (ObjectUtil.isNotEmpty((Object)umcEnterpriseRegisterApplyInfoBo.getEnterpriseInvoiceApplyBoList())) {
            List<UmcEnterpriseInvoiceApply> umcEnterpriseInvoiceApplyList = UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getEnterpriseInvoiceApplyBoList(), UmcEnterpriseInvoiceApply.class);
            for (UmcEnterpriseInvoiceApply enterpriseInvoiceApply : umcEnterpriseInvoiceApplyList) {
                enterpriseInvoiceApply.setApplyId(umcEnterpriseOrgApply.getApplyId());
                enterpriseInvoiceApply.setOrgId(umcEnterpriseOrgApply.getOrgId());
                if (null == enterpriseInvoiceApply.getInvoiceId()) {
                    enterpriseInvoiceApply.setInvoiceId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseInvoiceApply);
            }
            UmcEnterpriseInfoApplyDo invoiceApply = new UmcEnterpriseInfoApplyDo();
            invoiceApply.setEnterpriseInvoiceApplyList(umcEnterpriseInvoiceApplyList);
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseInvoiceApply(invoiceApply);
        }
        if (ObjectUtil.isNotEmpty((Object)umcEnterpriseRegisterApplyInfoBo.getEnterpriseBankApplyBoList())) {
            List<UmcEnterpriseBankApply> enterpriseBankApplyList = UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getEnterpriseBankApplyBoList(), UmcEnterpriseBankApply.class);
            for (UmcEnterpriseBankApply enterpriseBankApply : enterpriseBankApplyList) {
                enterpriseBankApply.setApplyId(umcEnterpriseOrgApply.getApplyId());
                enterpriseBankApply.setOrgId(umcEnterpriseOrgApply.getOrgId());
                if (null == enterpriseBankApply.getBankId()) {
                    enterpriseBankApply.setBankId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseBankApply);
            }
            UmcEnterpriseInfoApplyDo bankApplyList = new UmcEnterpriseInfoApplyDo();
            bankApplyList.setEnterpriseBankApplyList(enterpriseBankApplyList);
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseBankApply(bankApplyList);
        }
        if (ObjectUtil.isNotEmpty((Object)umcEnterpriseRegisterApplyInfoBo.getEnterpriseContactApplyBoList())) {
            List<UmcEnterpriseContactApply> enterpriseContactApplyList = UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getEnterpriseContactApplyBoList(), UmcEnterpriseContactApply.class);
            for (UmcEnterpriseContactApply enterpriseContactApply : enterpriseContactApplyList) {
                enterpriseContactApply.setApplyId(umcEnterpriseOrgApply.getApplyId());
                enterpriseContactApply.setOrgId(umcEnterpriseOrgApply.getOrgId());
                if (null == enterpriseContactApply.getContactId()) {
                    enterpriseContactApply.setContactId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseContactApply);
            }
            UmcEnterpriseInfoApplyDo contactApplyList = new UmcEnterpriseInfoApplyDo();
            contactApplyList.setEnterpriseContactApplyList(enterpriseContactApplyList);
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseContactApply(contactApplyList);
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterApplyInfoBo.getEnterpriseExtMapApply())) {
            List<UmcEnterpriseExtMapApply> enterpriseExtMapApplyList = UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getEnterpriseExtMapApply(), UmcEnterpriseExtMapApply.class);
            for (UmcEnterpriseExtMapApply enterpriseExtMapApply : enterpriseExtMapApplyList) {
                if (null == enterpriseExtMapApply.getExtId()) {
                    enterpriseExtMapApply.setExtId(IdUtil.nextId());
                }
                enterpriseExtMapApply.setTenantId(umcEnterpriseOrgApply.getTenantId());
                enterpriseExtMapApply.setOrgId(umcEnterpriseOrgApply.getOrgId());
                enterpriseExtMapApply.setApplyId(umcEnterpriseOrgApply.getApplyId());
                Date date = new Date();
                enterpriseExtMapApply.setCreateTime(date);
                enterpriseExtMapApply.setUpdateTime(date);
                enterpriseExtMapApply.setDelFlag("0");
                StrUtil.noNullStringAttr(enterpriseExtMapApply);
            }
            UmcEnterpriseInfoApplyDo umcEnterpriseInfoApplyExt = new UmcEnterpriseInfoApplyDo();
            umcEnterpriseInfoApplyExt.setEnterpriseExtMapApply(enterpriseExtMapApplyList);
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseExtMapApply(umcEnterpriseInfoApplyExt);
        }
        UmcEnterpriseInfoApplyDo umcEnterpriseInfoApplyDo = UmcRu.js(umcEnterpriseRegisterApplyInfoBo, UmcEnterpriseInfoApplyDo.class);
        umcEnterpriseInfoApplyDo.setOrgId(umcEnterpriseOrgApply.getOrgId());
        umcEnterpriseInfoApplyDo.setUpdateOperName(umcEnterpriseInfoApplyDo.getCreateOperName());
        this.iUmcEnterpriseInfoApplyModel.createEnterpriseInfoApply(StrUtil.noNullStringAttr(umcEnterpriseInfoApplyDo));
    }

    private void createOrg(UmcEnterpriseRegisterInfoBo umcEnterpriseRegisterInfoBo) {
        UmcOrgInfo orgInfo = this.buildOrgInfo(umcEnterpriseRegisterInfoBo);
        this.iUmcEnterpriseInfoModel.createOrgInfo(orgInfo);
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterInfoBo.getEnterpriseInvoiceBoList())) {
            List<UmcEnterpriseInvoice> enterpriseInvoiceList = UmcRu.jsl(umcEnterpriseRegisterInfoBo.getEnterpriseInvoiceBoList(), UmcEnterpriseInvoice.class);
            for (UmcEnterpriseInvoice enterpriseInvoice : enterpriseInvoiceList) {
                enterpriseInvoice.setOrgId(orgInfo.getOrgId());
                enterpriseInvoice.setDelFlag("0");
                enterpriseInvoice.setCreateTime(new Date());
                enterpriseInvoice.setUpdateTime(enterpriseInvoice.getCreateTime());
                if (null != enterpriseInvoice.getInvoiceId()) continue;
                enterpriseInvoice.setInvoiceId(IdUtil.nextId());
            }
            UmcEnterpriseInfoDo batchInvoice = new UmcEnterpriseInfoDo();
            batchInvoice.setEnterpriseInvoiceList(enterpriseInvoiceList);
            this.iUmcEnterpriseInfoModel.createEnterpriseInvoice((UmcEnterpriseInfoDo)((Object)StrUtil.noNullStringAttr(batchInvoice)));
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterInfoBo.getEnterpriseBankBoList())) {
            List<UmcEnterpriseBank> enterpriseBankList = UmcRu.jsl(umcEnterpriseRegisterInfoBo.getEnterpriseBankBoList(), UmcEnterpriseBank.class);
            for (UmcEnterpriseBank enterpriseBank : enterpriseBankList) {
                enterpriseBank.setOrgId(orgInfo.getOrgId());
                enterpriseBank.setDelFlag("0");
                enterpriseBank.setCreateTime(new Date());
                enterpriseBank.setUpdateTime(enterpriseBank.getCreateTime());
                if (null == enterpriseBank.getBankId()) {
                    enterpriseBank.setBankId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseBank);
            }
            UmcEnterpriseInfoDo batchBankInfo = new UmcEnterpriseInfoDo();
            batchBankInfo.setEnterpriseBankList(enterpriseBankList);
            this.iUmcEnterpriseInfoModel.createEnterpriseBank(batchBankInfo);
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterInfoBo.getEnterpriseContactBoList())) {
            List<UmcEnterpriseContact> enterpriseContactList = UmcRu.jsl(umcEnterpriseRegisterInfoBo.getEnterpriseContactBoList(), UmcEnterpriseContact.class);
            for (UmcEnterpriseContact enterpriseContact : enterpriseContactList) {
                enterpriseContact.setOrgId(orgInfo.getOrgId());
                enterpriseContact.setDelFlag("0");
                enterpriseContact.setCreateTime(new Date());
                enterpriseContact.setUpdateTime(enterpriseContact.getCreateTime());
                if (null == enterpriseContact.getContactId()) {
                    enterpriseContact.setContactId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseContact);
            }
            UmcEnterpriseInfoDo batchContact = new UmcEnterpriseInfoDo();
            batchContact.setEnterpriseContactList(enterpriseContactList);
            this.iUmcEnterpriseInfoModel.createEnterpriseContact(batchContact);
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterInfoBo.getEnterpriseExt())) {
            List<UmcEnterpriseExtMap> enterpriseExtMapList = UmcRu.jsl(umcEnterpriseRegisterInfoBo.getEnterpriseExt(), UmcEnterpriseExtMap.class);
            for (UmcEnterpriseExtMap enterpriseExtMap : enterpriseExtMapList) {
                if (null == enterpriseExtMap.getExtId()) {
                    enterpriseExtMap.setExtId(IdUtil.nextId());
                }
                enterpriseExtMap.setTenantId(orgInfo.getTenantId());
                enterpriseExtMap.setOrgId(orgInfo.getOrgId());
                Date date = new Date();
                enterpriseExtMap.setCreateTime(date);
                enterpriseExtMap.setUpdateTime(date);
                enterpriseExtMap.setDelFlag("0");
                StrUtil.noNullStringAttr(enterpriseExtMap);
            }
            UmcEnterpriseInfoDo extMapList = new UmcEnterpriseInfoDo();
            extMapList.setEnterpriseExt(enterpriseExtMapList);
            this.iUmcEnterpriseInfoModel.createEnterpriseExtMap(extMapList);
        }
        UmcEnterpriseInfoDo umcEnterpriseInfoDo = UmcRu.js(umcEnterpriseRegisterInfoBo, UmcEnterpriseInfoDo.class);
        umcEnterpriseInfoDo.setOrgId(orgInfo.getOrgId());
        umcEnterpriseInfoDo.setCreateTime(new Date());
        umcEnterpriseInfoDo.setUpdateTime(umcEnterpriseInfoDo.getCreateTime());
        StrUtil.noNullStringAttr(umcEnterpriseInfoDo);
        this.iUmcEnterpriseInfoModel.createEnterpriseInfo(StrUtil.noNullStringAttr(umcEnterpriseInfoDo));
    }

    private UmcOrgInfo buildOrgInfo(UmcEnterpriseRegisterInfoBo reqBo) {
        UmcOrgInfo umcEnterpriseOrg = UmcRu.js(reqBo.getOrgInfoBo(), UmcOrgInfo.class);
        if (null == umcEnterpriseOrg.getOrgId()) {
            umcEnterpriseOrg.setOrgId(IdUtil.nextId());
        }
        umcEnterpriseOrg.setOrgStatus("1");
        umcEnterpriseOrg.setCreateTime(new Date());
        umcEnterpriseOrg.setUpdateTime(umcEnterpriseOrg.getCreateTime());
        umcEnterpriseOrg.setDelFlag("0");
        if (!CollectionUtils.isEmpty(umcEnterpriseOrg.getOrgTagRelList())) {
            for (UmcOrgTagRel orgTagRel : umcEnterpriseOrg.getOrgTagRelList()) {
                if (null == orgTagRel.getRelId()) {
                    orgTagRel.setRelId(IdUtil.nextId());
                }
                orgTagRel.setDelFlag("0");
            }
        }
        return umcEnterpriseOrg;
    }

    private UmcUserInfoDo buildUserInfo(UmcUserRegisterInfoBo reqBo) {
        UmcUserInfoDo userInfoDo = UmcRu.js(reqBo, UmcUserInfoDo.class);
        userInfoDo.setCreateTime(new Date());
        userInfoDo.setUpdateTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            List<UmcUserTagRel> userTagRelList = UmcRu.jsl(reqBo.getUserTagRelList(), UmcUserTagRel.class);
            for (UmcUserTagRel userTagRel : userTagRelList) {
                userTagRel.setRelId(IdUtil.nextId());
                userTagRel.setCreateTime(new Date());
                userTagRel.setUserId(reqBo.getUserId());
                userTagRel.setDelFlag("0");
            }
            userInfoDo.setUserTagRelList(userTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserRoleRelList())) {
            List<UmcUserRoleRel> userRoleRelList = UmcRu.jsl(reqBo.getUserRoleRelList(), UmcUserRoleRel.class);
            for (UmcUserRoleRel userRoleRel : userRoleRelList) {
                userRoleRel.setRelId(IdUtil.nextId());
                userRoleRel.setUserId(reqBo.getUserId());
                userRoleRel.setCreateTime(new Date());
                userRoleRel.setDelFlag("0");
            }
            userInfoDo.setUserRoleRelList(userRoleRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserExtMapList())) {
            List<UmcUserExtMap> userExtMapList = UmcRu.jsl(reqBo.getUserExtMapList(), UmcUserExtMap.class);
            for (UmcUserExtMap userExtMap : userExtMapList) {
                userExtMap.setExtId(IdUtil.nextId());
                userExtMap.setUserId(reqBo.getUserId());
                userExtMap.setCreateTime(new Date());
                userExtMap.setDelFlag("0");
            }
            userInfoDo.setUserExtMapList(userExtMapList);
        }
        return userInfoDo;
    }

    private void validateParams(UmcEnterpriseUserRegisterReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u7528\u6237\u6ce8\u518c\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getUmcEnterpriseRegisterInfoBo()) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u7528\u6237\u6ce8\u518c\u5165\u53c2\u5bf9\u8c61\u4f01\u4e1a\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (null == reqBo.getUmcEnterpriseRegisterInfoBo().getOrgInfoBo()) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u7528\u6237\u6ce8\u518c\u5165\u53c2\u5bf9\u8c61\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (null == reqBo.getUmcUserRegisterInfoBo()) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u7528\u6237\u6ce8\u518c\u5165\u53c2\u5bf9\u8c61\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (null == reqBo.getUmcUserRegisterInfoBo().getCustInfo() && null == reqBo.getUmcUserRegisterInfoBo().getCustId()) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5ba2\u6237\u4fe1\u606f\u548c\u5ba2\u6237ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

