/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.signcontrat;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.signcontract.IUmcSignContractModel;
import com.tydic.dyc.umc.model.signcontract.SignContractDo;
import com.tydic.dyc.umc.service.signcontract.UmcDeleteSignContractService;
import com.tydic.dyc.umc.service.signcontract.bo.UmcDeleteSignContractReqBo;
import com.tydic.dyc.umc.service.signcontract.bo.UmcDeleteSignContractRspBo;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.signcontract.UmcDeleteSignContractService"})
public class UmcDeleteSignContractServiceImpl
implements UmcDeleteSignContractService {
    private static final Logger log = LoggerFactory.getLogger(UmcDeleteSignContractServiceImpl.class);
    @Autowired
    private IUmcSignContractModel iUmcSignContractModel;

    @PostMapping(value={"deleteSignContract"})
    public UmcDeleteSignContractRspBo deleteSignContract(@RequestBody UmcDeleteSignContractReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSignContractId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u7b7e\u7ea6\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SignContractDo deleteDo = new SignContractDo();
        deleteDo.setSignContractId(reqBo.getSignContractId());
        deleteDo.setUpdateTime(new Date());
        deleteDo.setUpdateOperName(reqBo.getUserName());
        deleteDo.setUpdateOperId(reqBo.getUserId());
        deleteDo.setSignStatus(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.DELETE);
        this.iUmcSignContractModel.updateSignContract(deleteDo);
        UmcDeleteSignContractRspBo rspBo = new UmcDeleteSignContractRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

