/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.sysdictionary;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.sysdictionary.UmcQueryDicByCacheService;
import com.tydic.dyc.umc.service.sysdictionary.bo.UmcDicDictionaryBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.sysdictionary.UmcQueryDicByCacheService"})
public class UmcQueryDicByCacheServiceImpl
implements UmcQueryDicByCacheService {
    private static final Logger log = LoggerFactory.getLogger(UmcQueryDicByCacheServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"queryDicByCache"})
    public List<UmcDicDictionaryBO> queryDicByCache(@RequestBody String pCode) {
        if (StringUtils.isBlank((CharSequence)pCode)) {
            return new ArrayList<UmcDicDictionaryBO>();
        }
        Object obj = this.cacheClient.get("PES_UMC_DIC_CACHE_REDIS_" + pCode);
        ArrayList busiList = (ArrayList)obj;
        if (CollectionUtils.isEmpty((Collection)busiList)) {
            SysDicDictionaryDo sysDicDictionaryDo = new SysDicDictionaryDo();
            sysDicDictionaryDo.setSysCode("UMC");
            sysDicDictionaryDo.setPCode(pCode);
            List<SysDicDictionaryDo> sysDicDictionaryDos = this.iUmcSysDicDictionaryModel.queryBypCodeBackPo(sysDicDictionaryDo);
            busiList = JSONObject.parseArray((String)JSONObject.toJSONString(sysDicDictionaryDos), UmcDicDictionaryBO.class);
            if (CollectionUtils.isEmpty((Collection)busiList)) {
                busiList = new ArrayList();
            }
            this.cacheClient.set("PES_UMC_DIC_CACHE_REDIS_" + pCode, busiList);
        }
        return busiList;
    }
}

