/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoCount;
import com.tydic.dyc.umc.service.todo.UmcQueryToDoCountService;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoCountReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoCountRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoItemCountInfoBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoModuleCountInfoBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcQueryToDoCountService"})
public class UmcQueryToDoCountServiceImpl
implements UmcQueryToDoCountService {
    @Autowired
    private IUmcTodoModel iUmcTodoModel;

    @PostMapping(value={"queryToDoCount"})
    public UmcQueryToDoCountRspBo queryToDoCount(@RequestBody UmcQueryToDoCountReqBo reqBO) {
        UmcQueryToDoCountRspBo rspBO = UmcRu.success(UmcQueryToDoCountRspBo.class);
        UmcTodoQryBo selectUmcTodoPO = UmcRu.js(reqBO, UmcTodoQryBo.class);
        List<UmcTodoCount> totalCountPOs = this.iUmcTodoModel.selectTodoCount(selectUmcTodoPO);
        if (CollectionUtils.isEmpty(totalCountPOs)) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        Map<String, List<UmcToDoItemCountInfoBo>> totoalCountMap = totalCountPOs.stream().map(po -> {
            UmcToDoItemCountInfoBo umcToDoItemCountInfoBO = new UmcToDoItemCountInfoBo();
            BeanUtils.copyProperties((Object)po, (Object)umcToDoItemCountInfoBO);
            umcToDoItemCountInfoBO.setTodoItemCount(po.getCount());
            umcToDoItemCountInfoBO.setNewTodoItemCount(po.getNewCount());
            return umcToDoItemCountInfoBO;
        }).collect(Collectors.groupingBy(UmcToDoItemCountInfoBo::getTodoModuleCode));
        ArrayList<UmcToDoModuleCountInfoBo> rows = new ArrayList<UmcToDoModuleCountInfoBo>();
        for (Map.Entry<String, List<UmcToDoItemCountInfoBo>> entry : totoalCountMap.entrySet()) {
            UmcToDoModuleCountInfoBo umcToDoModuleCountInfoBO = new UmcToDoModuleCountInfoBo();
            umcToDoModuleCountInfoBO.setTodoItemCountInfos(entry.getValue());
            umcToDoModuleCountInfoBO.setTodoModuleCode(entry.getValue().get(0).getTodoModuleCode());
            umcToDoModuleCountInfoBO.setTodoModuleName(entry.getValue().get(0).getTodoModuleName());
            umcToDoModuleCountInfoBO.setTodoModuleCount(Integer.valueOf(entry.getValue().stream().mapToInt(UmcToDoItemCountInfoBo::getTodoItemCount).sum()));
            umcToDoModuleCountInfoBO.setNewTodoModuleCount(Integer.valueOf(entry.getValue().stream().mapToInt(UmcToDoItemCountInfoBo::getNewTodoItemCount).sum()));
            rows.add(umcToDoModuleCountInfoBO);
        }
        rspBO.setRows(rows);
        return rspBO;
    }
}

