/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.logisticsrela;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.logisticsrela.IUmcLogisticsRelaModel;
import com.tydic.dyc.umc.model.logisticsrela.UmcLogisticsRelaDo;
import com.tydic.dyc.umc.model.logisticsrela.UmcLogisticsRelaRspDo;
import com.tydic.dyc.umc.service.logisticsrela.UmcUpdateLogisticsRelaService;
import com.tydic.dyc.umc.service.logisticsrela.bo.UmcLogisticsRelaBO;
import com.tydic.dyc.umc.service.logisticsrela.bo.UmcUpdateLogisticsRelaReqBo;
import com.tydic.dyc.umc.service.logisticsrela.bo.UmcUpdateLogisticsRelaRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.logisticsrela.UmcUpdateLogisticsRelaService"})
public class UmcUpdateLogisticsRelaServiceImpl
implements UmcUpdateLogisticsRelaService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateLogisticsRelaServiceImpl.class);
    @Autowired
    private IUmcLogisticsRelaModel iUmcLogisticsRelaModel;

    @PostMapping(value={"updateLogisticsRela"})
    public UmcUpdateLogisticsRelaRspBo updateLogisticsRela(@RequestBody UmcUpdateLogisticsRelaReqBo reqBo) {
        UmcUpdateLogisticsRelaRspBo rspBo = new UmcUpdateLogisticsRelaRspBo();
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getLogisticsRelaList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u6536\u8d27\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcLogisticsRelaBO bo : reqBo.getLogisticsRelaList()) {
            UmcLogisticsRelaDo updateDo;
            UmcLogisticsRelaDo checkDo = new UmcLogisticsRelaDo();
            checkDo.setContactId(bo.getContactId());
            UmcLogisticsRelaRspDo logisticsRelaList = this.iUmcLogisticsRelaModel.getLogisticsRelaList(checkDo);
            if (CollectionUtils.isEmpty((Collection)logisticsRelaList.getRows())) {
                throw new BaseBusinessException("200100", "\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8be5\u6536\u83b7\u5730\u5740\uff01");
            }
            UmcLogisticsRelaDo haveDo = StrUtil.noNullStringAttr(UmcRu.js(bo, UmcLogisticsRelaDo.class));
            if (reqBo.getIsDelete() == 0) {
                haveDo.setContactId(null);
                haveDo.setUserId(reqBo.getUserId());
                haveDo.setIsDefault(null);
                UmcLogisticsRelaRspDo allList = this.iUmcLogisticsRelaModel.getLogisticsRelaList(haveDo);
                if (!(CollectionUtils.isEmpty((Collection)allList.getRows()) || allList.getRows().size() == 1 && bo.getContactId().equals(((UmcLogisticsRelaDo)((Object)allList.getRows().get(0))).getContactId()))) {
                    throw new BaseBusinessException("200100", "\u5df2\u5b58\u5728\u76f8\u540c\u6536\u8d27\u4eba\u4fe1\u606f\uff01");
                }
                if (UmcCommConstant.LogisticsRelaIsDefault.IS_DEFAULT_YES.equals(bo.getIsDefault())) {
                    UmcLogisticsRelaDo setDefaultDo = new UmcLogisticsRelaDo();
                    setDefaultDo.setUserId(reqBo.getUserId());
                    this.iUmcLogisticsRelaModel.setDefaultByUserId(setDefaultDo);
                }
            }
            if (!StringUtils.isEmpty((Object)(updateDo = StrUtil.noNullStringAttr(UmcRu.js(bo, UmcLogisticsRelaDo.class))).getContactProvinceId()) && StringUtils.isEmpty((Object)updateDo.getContactTownId())) {
                updateDo.setContactTownId("");
                updateDo.setContactTown("");
            }
            updateDo.setUpdateTime(new Date());
            updateDo.setUpdateOperId(reqBo.getUserId());
            updateDo.setUpdateOperName(reqBo.getUserName());
            updateDo.setContactId(null);
            if (reqBo.getIsDelete() == 1) {
                updateDo.setDelFlag("1");
            }
            UmcLogisticsRelaDo whereDo = new UmcLogisticsRelaDo();
            whereDo.setContactId(bo.getContactId());
            this.iUmcLogisticsRelaModel.updateLogisticsRelaByCondition(updateDo, whereDo);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

