/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.supplieraccess;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterpriseapply.IUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.model.enterpriseapply.UmcEnterpriseInfoApplyDo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseInfoApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseInfoApplyListRspBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.supplieraccess.api.UmcQrySupplierAccessListService;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcQrySupplierAccessListReqBo;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcQrySupplierAccessListRspBo;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcQrySupplierAccessPageBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.supplieraccess.api.UmcQrySupplierAccessListService"})
public class UmcQrySupplierAccessListServiceImpl
implements UmcQrySupplierAccessListService {
    private static final Logger log = LoggerFactory.getLogger(UmcQrySupplierAccessListServiceImpl.class);
    @Autowired
    private IUmcEnterpriseInfoApplyModel iUmcEnterpriseInfoApplyModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"qrySupplierAccessList"})
    public UmcQrySupplierAccessListRspBo qrySupplierAccessList(@RequestBody UmcQrySupplierAccessListReqBo reqBo) {
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200100", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        UmcQrySupplierAccessListRspBo rspBo = new UmcQrySupplierAccessListRspBo();
        ArrayList<UmcQrySupplierAccessPageBo> list = new ArrayList<UmcQrySupplierAccessPageBo>();
        UmcEnterpriseInfoApplyQryBo qryBo = new UmcEnterpriseInfoApplyQryBo();
        qryBo.setOrgName(reqBo.getSupplierName());
        qryBo.setAddress(reqBo.getAddress());
        qryBo.setCreateTimeStart(reqBo.getAccessSubmitStartTime());
        qryBo.setCreateTimeEnd(reqBo.getAccessSubmitEndTime());
        qryBo.setContactName(reqBo.getConsignerName());
        qryBo.setUserId(reqBo.getUserId());
        qryBo.setPageNo(reqBo.getPageNo());
        qryBo.setPageSize(reqBo.getPageSize());
        qryBo.setTabId(reqBo.getTabId());
        UmcEnterpriseInfoApplyListRspBo accessList = this.iUmcEnterpriseInfoApplyModel.qrySupplierAccessList(qryBo);
        if (CollectionUtils.isEmpty((Collection)accessList.getRows())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        rspBo = UmcRu.js((Object)accessList, UmcQrySupplierAccessListRspBo.class);
        Map<String, String> supplierTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "UMC_SUPPLIER_TYPE")).getMap();
        Map<String, String> applyStatusMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "UMC_APPLY_STATUS")).getMap();
        for (UmcEnterpriseInfoApplyDo bo : accessList.getRows()) {
            UmcQrySupplierAccessPageBo accessPageBo = new UmcQrySupplierAccessPageBo();
            BeanUtils.copyProperties((Object)bo, (Object)accessPageBo);
            accessPageBo.setSupplierId(bo.getOrgId());
            accessPageBo.setSupplierName(bo.getOrgName());
            accessPageBo.setConsignerName(bo.getContactName());
            accessPageBo.setSupplierType(bo.getSupplierType());
            if (supplierTypeMap != null && supplierTypeMap.containsKey(accessPageBo.getSupplierType())) {
                accessPageBo.setSupplierTypeStr(supplierTypeMap.get(accessPageBo.getSupplierType()));
            }
            try {
                accessPageBo.setAccessSubmitTime(sdf.parse(bo.getSupplierAccessTime()));
            }
            catch (ParseException e) {
                log.error("\u5f02\u5e38", (Throwable)e);
                throw new BaseBusinessException("200100", e.getMessage());
            }
            accessPageBo.setAccessStatus(bo.getApplyStatus());
            if (applyStatusMap != null && applyStatusMap.containsKey(bo.getApplyStatus())) {
                accessPageBo.setAccessStatusStr(applyStatusMap.get(bo.getApplyStatus()));
            }
            list.add(accessPageBo);
        }
        rspBo.setRows(list);
        return rspBo;
    }
}

