/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.service.enterprise.UmcQrySupplierAccessService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQrySupplierAccessReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQrySupplierAccessRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcQrySupplierAccessService.class)
public class UmcQrySupplierAccessServiceImpl
implements UmcQrySupplierAccessService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    public UmcQrySupplierAccessRspBO qrySupplierAccess(UmcQrySupplierAccessReqBO reqBo) {
        this.var(reqBo);
        UmcQrySupplierAccessRspBO rspBo = UmcRu.success(UmcQrySupplierAccessRspBO.class);
        UmcOrgInfoQryBo umcOrgInfoQryBo = new UmcOrgInfoQryBo();
        umcOrgInfoQryBo.setOrgName(reqBo.getSupplierName());
        umcOrgInfoQryBo.setApplyStatus(reqBo.getAccessStatus());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfoBySupplierName(umcOrgInfoQryBo);
        rspBo.setSupplierId(orgInfo.getOrgId());
        rspBo.setSupplierName(orgInfo.getOrgName());
        rspBo.setAccessStatus(orgInfo.getApplyStatus());
        return rspBo;
    }

    private void var(UmcQrySupplierAccessReqBO reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getSupplierName())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAccessStatus()) {
            throw new BaseBusinessException("200001", "\u5165\u53c2[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

