/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoice;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.invoice.IUmcInvoiceInfoModel;
import com.tydic.dyc.umc.model.invoice.UmcInvoiceInfoDo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoQryBo;
import com.tydic.dyc.umc.service.invoice.UmcInvoiceInfoUpdateService;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoUpdateReqBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoUpdateRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcInvoiceInfoUpdateService.class)
public class UmcInvoiceInfoUpdateServiceImpl
implements UmcInvoiceInfoUpdateService {
    @Autowired
    private IUmcInvoiceInfoModel iUmcInvoiceInfoModel;
    private final String updateInfo = "1";
    private final String msgHead = "\u8d26\u5957\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2";

    public UmcInvoiceInfoUpdateRspBo updateInvoiceInfo(UmcInvoiceInfoUpdateReqBo reqBo) {
        List<UmcInvoiceInfoDo> invoiceInfoDoList;
        if (null == reqBo) {
            throw new BaseBusinessException("201001", "\u8d26\u5957\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u5bf9\u8c61BO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getOperType())) {
            throw new BaseBusinessException("201001", "\u8d26\u5957\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b[operType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getInvoiceId() == null) {
            throw new BaseBusinessException("201001", "\u8d26\u5957\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u53d1\u7968ID[invoiceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOperType().equals("1")) {
            if ("COMPANY".equals(reqBo.getAccountOwner())) {
                this.validationConpanyParams(reqBo);
            } else if ("PERSON".equals(reqBo.getInvoiceType())) {
                this.validationPersonParams(reqBo);
            }
        }
        UmcInvoiceInfoUpdateRspBo rspBo = UmcRu.success(UmcInvoiceInfoUpdateRspBo.class);
        UmcInvoiceInfoDo invoiceInfoDo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcInvoiceInfoDo.class));
        invoiceInfoDo.setUpdateTime(new Date());
        invoiceInfoDo.setExtinvoiceStatus(reqBo.getExtInvoiceStatus());
        if (reqBo.getMainFlag().equals(UmcCommConstant.EntInvMainFlag.YES) && !CollectionUtils.isEmpty(invoiceInfoDoList = this.qryInvByAccountId(reqBo.getAccountId()))) {
            this.cancleMainFlagAddr(invoiceInfoDoList);
        }
        this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo);
        return rspBo;
    }

    private List<UmcInvoiceInfoDo> qryInvByAccountId(Long accountId) {
        UmcInvoiceInfoQryBo qryBo = new UmcInvoiceInfoQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        return this.iUmcInvoiceInfoModel.getInvoiceInfoList(qryBo);
    }

    private void cancleMainFlagAddr(List<UmcInvoiceInfoDo> invoiceInfoDoList) {
        for (UmcInvoiceInfoDo invoiceInfoDo : invoiceInfoDoList) {
            UmcInvoiceInfoDo invoiceInfoDo1 = new UmcInvoiceInfoDo();
            invoiceInfoDo1.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            invoiceInfoDo1.setInvoiceId(invoiceInfoDo.getInvoiceId());
            invoiceInfoDo1.setDelFlag("0");
            this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo1);
        }
    }

    private void validationConpanyParams(UmcInvoiceInfoUpdateReqBo reqBo) {
        if (null == reqBo.getAccountId()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8d26\u5957ID[accountId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceType())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u578b[invoiceType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceTitle())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u62ac\u5934[invoiceTitle]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceClass())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u522b[invoiceClass]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.EntInvMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.EntInvMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u503c\u53ea\u80fd\u4e3a0\u62161");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerId())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerIdConfim())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u786e\u8ba4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerIdConfim]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBo.getTaxpayerId().equals(reqBo.getTaxpayerIdConfim())) {
            throw new BaseBusinessException("201001", "\u786e\u8ba4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4");
        }
        if ("00".equals(reqBo.getInvoiceType())) {
            if (StringUtils.isEmpty((CharSequence)reqBo.getAccount())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8d26\u6237[account]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getBank())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u5f00\u6237\u884c[bank]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getPhone())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7535\u8bdd[phone]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getAddress())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u5730\u5740[address]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void validationPersonParams(UmcInvoiceInfoUpdateReqBo reqBo) {
        if (null == reqBo.getAccountId()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8d26\u5957ID[accountId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceType())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u578b[invoiceType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceTitle())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u62ac\u5934[invoiceTitle]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceClass())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u522b[invoiceClass]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.EntInvMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.EntInvMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u503c\u53ea\u80fd\u4e3a0\u62161");
        }
        if ("COMPANY".equals(reqBo.getTitleType())) {
            if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerId())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerIdConfim())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u786e\u8ba4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerIdConfim]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

