/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.shoppingcart;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.shoppingcart.IUmcShoppingCartModel;
import com.tydic.dyc.umc.model.shoppingcart.UmcShoppingCartDo;
import com.tydic.dyc.umc.model.shoppingcart.qrybo.GetShoppingCartPageListReqBo;
import com.tydic.dyc.umc.model.shoppingcart.sub.UmcShoppingCartLog;
import com.tydic.dyc.umc.service.shoppingcart.UmcUpdateSoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcUpdateSoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcUpdateSoppingCartRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcUpdateSoppingCartService.class)
public class UmcUpdateSoppingCartServiceImpl
implements UmcUpdateSoppingCartService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateSoppingCartServiceImpl.class);
    @Autowired
    private IUmcShoppingCartModel iUmcShoppingCartModel;

    public UmcUpdateSoppingCartRspBo updateSoppingCart(UmcUpdateSoppingCartReqBo reqBo) {
        this.validateAgr(reqBo);
        ArrayList<UmcAddShoppingCartBo> rspBos = new ArrayList<UmcAddShoppingCartBo>();
        for (UmcAddShoppingCartBo bo : reqBo.getUmcAddShoppingCartBos()) {
            GetShoppingCartPageListReqBo qryBo = new GetShoppingCartPageListReqBo();
            qryBo.setUserId(reqBo.getUserId());
            qryBo.setSpId(bo.getSpId());
            BasePageRspBo<UmcShoppingCartDo> shoppingCartPageList = this.iUmcShoppingCartModel.getShoppingCartPageList(qryBo);
            if (shoppingCartPageList == null || CollectionUtils.isEmpty((Collection)shoppingCartPageList.getRows())) continue;
            UmcShoppingCartDo umcShoppingCartDo = new UmcShoppingCartDo();
            UmcShoppingCartLog shoppingCartLog = UmcRu.js(shoppingCartPageList.getRows().get(0), UmcShoppingCartLog.class);
            umcShoppingCartDo.setDelFlag("0");
            umcShoppingCartDo.setUpdateOperId(reqBo.getUserId());
            umcShoppingCartDo.setUpdateOperName(reqBo.getUserName());
            umcShoppingCartDo.setUpdateTime(new Date());
            umcShoppingCartDo.setUserId(reqBo.getUserId());
            umcShoppingCartDo.setSpId(bo.getSpId());
            umcShoppingCartDo.setProductAmount(bo.getProductAmount());
            umcShoppingCartDo.setTenantId(bo.getTenantId());
            umcShoppingCartDo.setIsChoice(bo.getIsChoice());
            if (reqBo.getNeedLog() == 1) {
                shoppingCartLog.setDelFlag("0");
                shoppingCartLog.setCreateOperId(reqBo.getUserId());
                shoppingCartLog.setCreateOperName(reqBo.getUserName());
                shoppingCartLog.setCreateTime(new Date());
                shoppingCartLog.setUserId(reqBo.getUserId());
                shoppingCartLog.setJoinTime(new Date());
                shoppingCartLog.setOperTime(new Date());
                shoppingCartLog.setOperNum(bo.getProductAmount());
                shoppingCartLog.setLoginSource(reqBo.getLoginSource());
                shoppingCartLog.setOperType(10);
                umcShoppingCartDo.setShoppingCartLogs(Collections.singletonList(shoppingCartLog));
            }
            UmcShoppingCartDo umcShoppingCartDo1 = this.iUmcShoppingCartModel.updateSoppingCart(umcShoppingCartDo);
            rspBos.add(UmcRu.js((Object)umcShoppingCartDo1, UmcAddShoppingCartBo.class));
        }
        UmcUpdateSoppingCartRspBo rspBo = new UmcUpdateSoppingCartRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setUmcAddShoppingCartBos(rspBos);
        return rspBo;
    }

    private void validateAgr(UmcUpdateSoppingCartReqBo reqBo) {
        if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getUmcAddShoppingCartBos())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2UserId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcAddShoppingCartBo bo : reqBo.getUmcAddShoppingCartBos()) {
            if (bo.getSpId() != null) continue;
            throw new BaseBusinessException("200001", "\u5165\u53c2spId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

