/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.user.UmcUserInfoPartService;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoPartReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoPartRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcUserInfoPartService.class)
public class UmcUserInfoPartServiceImpl
implements UmcUserInfoPartService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;

    public UmcUserInfoPartRspBo partUserInfo(UmcUserInfoPartReqBo reqBo) {
        this.validReqParam(reqBo);
        UmcUserInfoPartRspBo rspBo = UmcRu.success(UmcUserInfoPartRspBo.class);
        UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
        userInfoQryBo.setUserId(reqBo.getUserId());
        userInfoQryBo.setDelFlag("0");
        UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getUserInfo(userInfoQryBo);
        if (null == userInfoDo) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        UmcUserInfoDo umcUserInfoDo = this.buildUserInfo(reqBo, userInfoDo);
        this.iUmcUserInfoModel.createUserInfo(umcUserInfoDo);
        rspBo.setUserInfoBo(UmcRu.js(umcUserInfoDo, UmcUserInfoBo.class));
        return rspBo;
    }

    private UmcUserInfoDo buildUserInfo(UmcUserInfoPartReqBo reqBo, UmcUserInfoDo userInfoDo) {
        UmcUserInfoDo umcUserInfoDo = UmcRu.js(userInfoDo, UmcUserInfoDo.class);
        umcUserInfoDo.setUserId(reqBo.getNewUserId());
        umcUserInfoDo.setOrgId(reqBo.getNewOrgId());
        umcUserInfoDo.setCustInfo(null);
        umcUserInfoDo.setExtField1(reqBo.getRemark());
        umcUserInfoDo.setCreateOperId(reqBo.getCreateOperId());
        umcUserInfoDo.setCreateOperName(reqBo.getCreateOperName());
        umcUserInfoDo.setCreateTime(reqBo.getCreateTime());
        umcUserInfoDo.setUpdateOperId(reqBo.getUpdateOperId());
        umcUserInfoDo.setUpdateOperName(reqBo.getUpdateOperName());
        umcUserInfoDo.setUpdateTime(reqBo.getUpdateTime());
        umcUserInfoDo.setIsMain("0");
        if (!CollectionUtils.isEmpty(userInfoDo.getUserTagRelList())) {
            for (UmcUserTagRel userTagRel : userInfoDo.getUserTagRelList()) {
                userTagRel.setRelId(IdUtil.nextId());
                userTagRel.setUserId(reqBo.getNewUserId());
            }
            umcUserInfoDo.setUserTagRelList(userInfoDo.getUserTagRelList());
        }
        if (!CollectionUtils.isEmpty(userInfoDo.getUserRoleRelList())) {
            for (UmcUserRoleRel userRoleRel : userInfoDo.getUserRoleRelList()) {
                userRoleRel.setRelId(IdUtil.nextId());
                userRoleRel.setUserId(reqBo.getNewUserId());
            }
            umcUserInfoDo.setUserRoleRelList(userInfoDo.getUserRoleRelList());
        }
        return umcUserInfoDo;
    }

    private void validReqParam(UmcUserInfoPartReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[newUserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewOrgId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[NewOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

