/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.umc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.umc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.umc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.umc.service.domainservice.UmcApproveCreateService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcApproveCreateServiceReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcApproveCreateServiceRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcApproveCreateService.class)
public class UmcApproveCreateServiceImpl
implements UmcApproveCreateService {
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    public UmcApproveCreateServiceRspBo createApprove(UmcApproveCreateServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UmcApproveCreateServiceRspBo rspBo = UmcRu.success(UmcApproveCreateServiceRspBo.class);
        long auditId = IdUtil.nextId();
        UocAuditOrderDo auditDo = UmcRu.js(reqBo, UocAuditOrderDo.class);
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBo.getUserId().toString());
        auditDo.setCreateOperName(reqBo.getName());
        auditDo.setOrderId(reqBo.getOrderId());
        auditDo.setAuditOrderStatus("2");
        ArrayList<UocApprovalObj> objList = new ArrayList<UocApprovalObj>();
        auditDo.setApprovalObjs(objList);
        UocApprovalObj approvalObj = new UocApprovalObj();
        objList.add(approvalObj);
        approvalObj.setObjId(reqBo.getObjId().toString());
        approvalObj.setId(IdUtil.nextId());
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(reqBo.getOrderId());
        approvalObj.setObjType(reqBo.getObjType());
        approvalObj.setObjBusiType(reqBo.getObjBusiType());
        UocApprovalLog uocApprovalLog = new UocApprovalLog();
        uocApprovalLog.setAuditOrderId(auditId);
        uocApprovalLog.setId(IdUtil.nextId());
        uocApprovalLog.setOperid(reqBo.getUserId().toString());
        uocApprovalLog.setOperName(reqBo.getName());
        uocApprovalLog.setOperDept(reqBo.getOrgId() + "");
        uocApprovalLog.setCreateTime(new Date());
        uocApprovalLog.setObjNum(objList.size());
        uocApprovalLog.setObjType(reqBo.getObjBusiType());
        uocApprovalLog.setAuditResult(UmcCommConstant.AUDIT_TYPE.CREATE);
        auditDo.setApprovalLog(uocApprovalLog);
        this.iUocAuditOrderModel.saveAudit(auditDo);
        rspBo.setAuditOrderId(Long.valueOf(auditId));
        return rspBo;
    }

    private void validateArg(UmcApproveCreateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[UocApproveCreateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61id\uff0c\u4f8b\u5982\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjType())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjBusiType())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61\u4e1a\u52a1\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

