/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.addrprovince;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.addrprovince.IUmcAddProvinceModel;
import com.tydic.dyc.umc.service.addrprovince.UmcSyncAddrService;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcAddrSyncBo;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcSyncAddrReqBo;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcSyncAddrRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.addrprovince.UmcSyncAddrService"})
public class UmcSyncAddrServiceImpl
implements UmcSyncAddrService {
    @Autowired
    private IUmcAddProvinceModel iUmcAddProvinceModel;

    @PostMapping(value={"syncAddr"})
    public UmcSyncAddrRspBo syncAddr(@RequestBody UmcSyncAddrReqBo reqBo) {
        this.validate(reqBo);
        reqBo.setUmcAddrBoList(reqBo.getUmcAddrBoList().stream().distinct().collect(Collectors.toList()));
        List umcAddrBoList = reqBo.getUmcAddrBoList();
        ArrayList<UmcAddrSyncBo> provinceInsertList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> provinceUpdateList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> cityInsertList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> cityUpdateList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> areaInsertList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> areaUpdateList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> townsInsertList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> townsUpdateList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> deleteList = new ArrayList<UmcAddrSyncBo>();
        for (UmcAddrSyncBo umcAddrSyncBo : umcAddrBoList) {
            String addrType = umcAddrSyncBo.getAddrType();
            if (umcAddrSyncBo.getDelFlag().equals(String.valueOf(UmcCommConstant.IsDel.IS_DEL_NO))) {
                if ("1".equals(addrType) && this.iUmcAddProvinceModel.qryIsExistsAddrByType(umcAddrSyncBo, addrType)) {
                    provinceUpdateList.add(umcAddrSyncBo);
                } else if ("1".equals(addrType)) {
                    provinceInsertList.add(umcAddrSyncBo);
                }
                if ("2".equals(addrType) && this.iUmcAddProvinceModel.qryIsExistsAddrByType(umcAddrSyncBo, addrType)) {
                    cityUpdateList.add(umcAddrSyncBo);
                } else if ("2".equals(addrType)) {
                    cityInsertList.add(umcAddrSyncBo);
                }
                if ("3".equals(addrType) && this.iUmcAddProvinceModel.qryIsExistsAddrByType(umcAddrSyncBo, addrType)) {
                    areaUpdateList.add(umcAddrSyncBo);
                } else if ("3".equals(addrType)) {
                    areaInsertList.add(umcAddrSyncBo);
                }
                if ("4".equals(addrType) && this.iUmcAddProvinceModel.qryIsExistsAddrByType(umcAddrSyncBo, addrType)) {
                    townsUpdateList.add(umcAddrSyncBo);
                    continue;
                }
                if (!"4".equals(addrType)) continue;
                townsInsertList.add(umcAddrSyncBo);
                continue;
            }
            deleteList.add(umcAddrSyncBo);
        }
        this.iUmcAddProvinceModel.insertAddr(provinceInsertList, "1");
        this.iUmcAddProvinceModel.insertAddr(cityInsertList, "2");
        this.iUmcAddProvinceModel.insertAddr(areaInsertList, "3");
        this.iUmcAddProvinceModel.insertAddr(townsInsertList, "4");
        this.iUmcAddProvinceModel.updateAddr(provinceUpdateList, "1");
        this.iUmcAddProvinceModel.updateAddr(cityUpdateList, "2");
        this.iUmcAddProvinceModel.updateAddr(areaUpdateList, "3");
        this.iUmcAddProvinceModel.updateAddr(townsUpdateList, "4");
        this.iUmcAddProvinceModel.deleteAddr(deleteList);
        return UmcRu.success(UmcSyncAddrRspBo.class);
    }

    public void validate(UmcSyncAddrReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getUmcAddrBoList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[umcAddrBoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

