/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactRspBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.signcontract.IUmcSignContractModel;
import com.tydic.dyc.umc.model.signcontract.SignContractDo;
import com.tydic.dyc.umc.model.signcontract.sup.SignSalesCategory;
import com.tydic.dyc.umc.model.signcontractapply.IUmcSignContractApplyModel;
import com.tydic.dyc.umc.model.signcontractapply.UmcSignContractApplyDo;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractLog;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignSalesCategoryApply;
import com.tydic.dyc.umc.service.domainservice.UmcCreateSignContractService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcCreateSignContractReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcCreateSignContractRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.domainservice.UmcCreateSignContractService"})
public class UmcCreateSignContractServiceImpl
implements UmcCreateSignContractService {
    private static final Logger log = LoggerFactory.getLogger(UmcCreateSignContractServiceImpl.class);
    @Autowired
    private IUmcSignContractModel iUmcSignContractModel;
    @Autowired
    private IUmcSignContractApplyModel iUmcSignContractApplyModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    public static final Integer innerAddFlag = 1;

    @PostMapping(value={"createSignContract"})
    public UmcCreateSignContractRspBo createSignContract(@RequestBody UmcCreateSignContractReqBo reqBo) {
        UmcCreateSignContractRspBo rspBo = new UmcCreateSignContractRspBo();
        UmcEnterpriseContact umcEnterpriseContact = this.getUmcEnterpriseContact(reqBo);
        this.validateArg(reqBo);
        long applyId = IdUtil.nextId();
        long signContractId = IdUtil.nextId();
        UmcSignContractApplyDo applyDo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcSignContractApplyDo.class));
        applyDo.setStatus(reqBo.getSignStatus());
        applyDo.setApplyId(applyId);
        applyDo.setSignContractId(signContractId);
        applyDo.setTenantId(reqBo.getTenantId());
        applyDo.setCreateTime(new Date());
        if (innerAddFlag.equals(reqBo.getInnerAddFlag())) {
            applyDo.setCreateOperId(reqBo.getUserId());
            applyDo.setCreateOperName(reqBo.getUserName());
        } else {
            applyDo.setCreateOperId(null != umcEnterpriseContact ? umcEnterpriseContact.getCreateOperId() : reqBo.getUserId());
            applyDo.setCreateOperName(null != umcEnterpriseContact ? umcEnterpriseContact.getContactName() : reqBo.getUserName());
        }
        applyDo.setDelFlag("0");
        applyDo.setOrgId(reqBo.getOrgId());
        applyDo.setOrgName(reqBo.getOrgName());
        applyDo.setApplyType("1");
        List<SignSalesCategoryApply> signSalesCategoryApplies = UmcRu.jsl(reqBo.getSignSalesCategoryBoList(), SignSalesCategoryApply.class);
        for (SignSalesCategoryApply bo : signSalesCategoryApplies) {
            if (bo.getServiceFeeRate() == null) {
                bo.setServiceFeeRate(0.0);
            }
            bo.setSignContractId(signContractId);
            bo.setApplyId(applyId);
            bo.setCreateTime(new Date());
            if (innerAddFlag.equals(reqBo.getInnerAddFlag())) {
                bo.setCreateOperId(reqBo.getUserId());
                bo.setCreateOperName(reqBo.getUserName());
            } else {
                bo.setCreateOperId(null != umcEnterpriseContact ? umcEnterpriseContact.getCreateOperId() : reqBo.getUserId());
                bo.setCreateOperName(null != umcEnterpriseContact ? umcEnterpriseContact.getContactName() : reqBo.getUserName());
            }
            bo.setTenantId(reqBo.getTenantId());
            bo.setDelFlag("0");
            bo.setChngType("4");
        }
        applyDo.setSignSalesCategoryApplies(signSalesCategoryApplies);
        SignContractLog log = StrUtil.noNullStringAttr(UmcRu.js(reqBo, SignContractLog.class));
        log.setOperType(applyDo.getStatus() + "");
        log.setApplyId(applyId);
        log.setSignContractId(signContractId);
        log.setCreateTime(new Date());
        if (innerAddFlag.equals(reqBo.getInnerAddFlag())) {
            log.setCreateOperId(reqBo.getUserId());
            log.setCreateOperName(reqBo.getUserName());
        } else {
            log.setCreateOperId(null != umcEnterpriseContact ? umcEnterpriseContact.getCreateOperId() : reqBo.getUserId());
            log.setCreateOperName(null != umcEnterpriseContact ? umcEnterpriseContact.getContactName() : reqBo.getUserName());
        }
        log.setDelFlag("0");
        log.setOperTypeStr(applyDo.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.Draft) ? "\u4fdd\u5b58" : "\u63d0\u4ea4");
        applyDo.setSignContractLogs(Collections.singletonList(log));
        this.iUmcSignContractApplyModel.createSignContractApply(applyDo);
        SignContractDo signContractDo = UmcRu.js((Object)applyDo, SignContractDo.class);
        signContractDo.setSignStatus(reqBo.getSignStatus());
        List<SignSalesCategory> signSalesCategories = UmcRu.jsl(signSalesCategoryApplies, SignSalesCategory.class);
        signContractDo.setSignSalesCategories(signSalesCategories);
        this.iUmcSignContractModel.createSignContract(signContractDo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UmcEnterpriseContact getUmcEnterpriseContact(UmcCreateSignContractReqBo reqBo) {
        UmcEnterpriseContactQryBo umcEnterpriseContactQryBo = new UmcEnterpriseContactQryBo();
        umcEnterpriseContactQryBo.setPageNo(1);
        umcEnterpriseContactQryBo.setPageSize(1);
        umcEnterpriseContactQryBo.setOrgId(reqBo.getOrgId());
        umcEnterpriseContactQryBo.setOrderBy("create_time asc");
        UmcEnterpriseContact umcEnterpriseContact = null;
        UmcEnterpriseContactRspBo enterpriseContactPage = this.iUmcEnterpriseInfoModel.getEnterpriseContactPageList(umcEnterpriseContactQryBo);
        if (!CollectionUtils.isEmpty((Collection)enterpriseContactPage.getRows())) {
            umcEnterpriseContact = (UmcEnterpriseContact)enterpriseContactPage.getRows().get(0);
        }
        return umcEnterpriseContact;
    }

    private void validateArg(UmcCreateSignContractReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("200001", "\u673a\u6784ID OrgId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBo.getOrgId());
        Integer checkOrgInfo = this.iUmcEnterpriseInfoModel.getCheckOrgInfo(orgInfoQryBo).getNumber();
        if (checkOrgInfo < 1) {
            throw new BaseBusinessException("200001", "\u8be5\u673a\u6784\u4e0d\u5b58\u5728");
        }
        if (reqBo.getSignStatus() == null) {
            throw new BaseBusinessException("200001", "\u7b7e\u7ea6\u72b6\u6001Status\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getSignContractCode())) {
            DateTime dateTime = new DateTime();
            String yyyyMMdd = dateTime.toString("yyyyMMdd");
            UmcSignContractApplyDo applyDo = this.iUmcSignContractApplyModel.queryLastContract();
            if (applyDo == null || StringUtils.isEmpty((Object)applyDo.getSignContractCode())) {
                reqBo.setSignContractCode("QYSQ-" + yyyyMMdd + "-001");
            } else {
                String[] split = applyDo.getSignContractCode().split("-");
                if (split.length > 2 && yyyyMMdd.equals(split[1])) {
                    Integer i = Integer.parseInt(split[2]) + 1;
                    String s = String.valueOf(i);
                    if (s.length() == 1) {
                        reqBo.setSignContractCode("QYSQ-" + yyyyMMdd + "-00" + s);
                    }
                    if (s.length() == 2) {
                        reqBo.setSignContractCode("QYSQ-" + yyyyMMdd + "-0" + s);
                    }
                    if (s.length() == 3) {
                        reqBo.setSignContractCode("QYSQ-" + yyyyMMdd + "-" + s);
                    }
                } else {
                    reqBo.setSignContractCode("QYSQ-" + yyyyMMdd + "-001");
                }
            }
        }
        if (!reqBo.getSignStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.Draft) && !reqBo.getSignStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.APPLYING)) {
            throw new BaseBusinessException("200001", "\u7b7e\u7ea6\u72b6\u6001Status\u9519\u8bef");
        }
    }
}

