/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.shoppingcart;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.shoppingcart.IUmcShoppingCartModel;
import com.tydic.dyc.umc.model.shoppingcart.UmcShoppingCartDo;
import com.tydic.dyc.umc.model.shoppingcart.qrybo.GetShoppingCartPageListReqBo;
import com.tydic.dyc.umc.model.shoppingcart.qrybo.UmcShoppingCartQryRspBo;
import com.tydic.dyc.umc.model.shoppingcart.sub.UmcShoppingCartLog;
import com.tydic.dyc.umc.service.shoppingcart.UmcRemoveShoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.shoppingcart.UmcRemoveShoppingCartService"})
public class UmcRemoveShoppingCartServiceImpl
implements UmcRemoveShoppingCartService {
    private static final Logger log = LoggerFactory.getLogger(UmcRemoveShoppingCartServiceImpl.class);
    @Autowired
    private IUmcShoppingCartModel iUmcShoppingCartModel;

    @PostMapping(value={"removeShoppingCart"})
    public UmcRemoveShoppingCartRspBo removeShoppingCart(@RequestBody UmcRemoveShoppingCartReqBo reqBo) {
        this.validateAgr(reqBo);
        for (UmcAddShoppingCartBo bo : reqBo.getGoodsInfoList()) {
            GetShoppingCartPageListReqBo qryBo = new GetShoppingCartPageListReqBo();
            qryBo.setUserId(reqBo.getUserId());
            qryBo.setSpId(bo.getSpId());
            qryBo.setSkuId(bo.getSkuId());
            UmcShoppingCartQryRspBo shoppingCartPageList = this.iUmcShoppingCartModel.getShoppingCartPageList(qryBo);
            if (shoppingCartPageList == null || CollectionUtils.isEmpty((Collection)shoppingCartPageList.getRows())) continue;
            UmcShoppingCartDo cancelDo = new UmcShoppingCartDo();
            cancelDo.setSpId(((UmcShoppingCartDo)((Object)shoppingCartPageList.getRows().get(0))).getSpId());
            cancelDo.setUpdateTime(new Date());
            cancelDo.setUpdateOperId(reqBo.getUserId());
            cancelDo.setUpdateOperName(reqBo.getUserName());
            cancelDo.setDelFlag("1");
            UmcShoppingCartLog shoppingCartLog = UmcRu.js(shoppingCartPageList.getRows().get(0), UmcShoppingCartLog.class);
            shoppingCartLog.setCreateTime(new Date());
            shoppingCartLog.setCreateOperId(reqBo.getUserId());
            shoppingCartLog.setCreateOperName(reqBo.getUserName());
            shoppingCartLog.setDelFlag("0");
            shoppingCartLog.setOperTime(new Date());
            shoppingCartLog.setUserId(reqBo.getUserId());
            shoppingCartLog.setOperType(2);
            shoppingCartLog.setLoginSource(reqBo.getLoginSource());
            cancelDo.setShoppingCartLogs(Collections.singletonList(shoppingCartLog));
            this.iUmcShoppingCartModel.updateSoppingCart(cancelDo);
        }
        UmcRemoveShoppingCartRspBo rspBo = new UmcRemoveShoppingCartRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateAgr(UmcRemoveShoppingCartReqBo reqBo) {
        if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getGoodsInfoList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2UserId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcAddShoppingCartBo bo : reqBo.getGoodsInfoList()) {
            if (bo.getSpId() != null || bo.getSkuId() != null) continue;
            throw new BaseBusinessException("200001", "\u5165\u53c2spId \u548c skuId \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

