/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.logisticsrela;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.logisticsrela.IUmcLogisticsRelaModel;
import com.tydic.dyc.umc.model.logisticsrela.UmcLogisticsRelaDo;
import com.tydic.dyc.umc.model.logisticsrela.UmcLogisticsRelaRspDo;
import com.tydic.dyc.umc.service.logisticsrela.UmcAddLogisticsRelaService;
import com.tydic.dyc.umc.service.logisticsrela.bo.UmcAddLogisticsRelaReqBo;
import com.tydic.dyc.umc.service.logisticsrela.bo.UmcAddLogisticsRelaRspBo;
import com.tydic.dyc.umc.service.logisticsrela.bo.UmcLogisticsRelaBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.logisticsrela.UmcAddLogisticsRelaService"})
public class UmcAddLogisticsRelaServiceImpl
implements UmcAddLogisticsRelaService {
    private static final Logger log = LoggerFactory.getLogger(UmcAddLogisticsRelaServiceImpl.class);
    @Value(value="${umc.logistics.orgOrPerson.value}")
    private String logisticsValue;
    @Autowired
    private IUmcLogisticsRelaModel iUmcLogisticsRelaModel;

    @PostMapping(value={"addLogisticsRela"})
    public UmcAddLogisticsRelaRspBo addLogisticsRela(@RequestBody UmcAddLogisticsRelaReqBo reqBo) {
        UmcAddLogisticsRelaRspBo rspBo = new UmcAddLogisticsRelaRspBo();
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getLogisticsRelaList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u6536\u8d27\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcLogisticsRelaBO bo : reqBo.getLogisticsRelaList()) {
            UmcLogisticsRelaDo isHaveDo = new UmcLogisticsRelaDo();
            BeanUtils.copyProperties((Object)bo, (Object)((Object)isHaveDo));
            if (ObjectUtil.isNotEmpty((Object)this.logisticsValue) && "1".equals(this.logisticsValue)) {
                if (ObjectUtil.isEmpty((Object)reqBo.getAdmOrgId())) {
                    throw new BaseBusinessException("200001", "\u5165\u53c2\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                isHaveDo.setAdmOrgId(reqBo.getAdmOrgId());
            } else {
                isHaveDo.setUserId(reqBo.getUserId());
            }
            isHaveDo.setCreateOperId(null);
            isHaveDo.setCreateTime(null);
            isHaveDo.setCreateOperName(null);
            isHaveDo.setUpdateOperId(null);
            isHaveDo.setUpdateTime(null);
            isHaveDo.setUpdateOperName(null);
            UmcLogisticsRelaRspDo isHaveResultDO = this.iUmcLogisticsRelaModel.getLogisticsRelaList(isHaveDo);
            if (!CollectionUtils.isEmpty((Collection)isHaveResultDO.getRows())) {
                throw new BaseBusinessException("200100", "\u5df2\u5b58\u5728\u76f8\u540c\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff01");
            }
            if (bo.getIsDefault() == null) {
                bo.setIsDefault(UmcCommConstant.LogisticsRelaIsDefault.IS_DEFAULT_NO);
            } else if (UmcCommConstant.LogisticsRelaIsDefault.IS_DEFAULT_YES.equals(bo.getIsDefault())) {
                UmcLogisticsRelaDo setDefaultDo = new UmcLogisticsRelaDo();
                setDefaultDo.setUserId(reqBo.getUserId());
                this.iUmcLogisticsRelaModel.setDefaultByUserId(setDefaultDo);
            }
            UmcLogisticsRelaDo reqDo = new UmcLogisticsRelaDo();
            reqDo.setUserId(reqBo.getUserId());
            UmcLogisticsRelaDo insertDo = UmcRu.js(bo, UmcLogisticsRelaDo.class);
            insertDo.setAdmOrgId(reqDo.getAdmOrgId());
            insertDo.setUserId(reqBo.getUserId());
            insertDo.setContactId(IdUtil.nextId());
            insertDo.setCreateOperName(reqBo.getUserName());
            insertDo.setCreateOperId(reqBo.getUserId());
            insertDo.setCreateTime(new Date());
            insertDo.setDelFlag("0");
            this.iUmcLogisticsRelaModel.addLogisticsRela(insertDo);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

