/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoItemQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItemPageRspBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoListDo;
import com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoPushBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService"})
public class UmcSendRevokeTodoServiceImpl
implements UmcSendRevokeTodoService {
    private static final Logger log = LoggerFactory.getLogger(UmcSendRevokeTodoServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Value(value="${umc.revoke.todo.sync.enable:true}")
    private boolean revokeTodoSyncEnable;

    @PostMapping(value={"revokeTodo"})
    public UmcSendRevokeTodoRspBo revokeTodo(@RequestBody UmcSendRevokeTodoReqBo reqBO) {
        UmcTodoDone umcTodoDone = new UmcTodoDone();
        umcTodoDone.setTodoId(reqBO.getTodoId());
        umcTodoDone.setBusiId(reqBO.getBusiId());
        umcTodoDone.setOperId(reqBO.getOperUserId());
        umcTodoDone.setOperName(reqBO.getOperUserName());
        UmcTodoListDo umcTodoListDo = this.iUmcTodoModel.sendHaveDone(umcTodoDone);
        if (this.revokeTodoSyncEnable && !CollectionUtils.isEmpty(umcTodoListDo.getUmcTodoDos())) {
            this.sendMq(reqBO, umcTodoListDo);
        }
        return UmcRu.success(UmcSendRevokeTodoRspBo.class);
    }

    private void sendMq(UmcSendRevokeTodoReqBo reqBO, UmcTodoListDo umcTodoListDo) {
        UmcTodoItem umcTodoItem;
        UmcTodoDo umcTodoDo = umcTodoListDo.getUmcTodoDos().get(0);
        UmcTodoItemQryBo umcTodoItemQryBo = new UmcTodoItemQryBo();
        umcTodoItemQryBo.setTodoItemCode(umcTodoDo.getTodoItemCode());
        UmcTodoItemPageRspBo umcTodoItemPageRspBo = this.iUmcTodoModel.selectTodoItemList(umcTodoItemQryBo);
        log.debug("umcTodoItemPageRspBo:{}", (Object)JSON.toJSONString((Object)((Object)umcTodoItemPageRspBo)));
        if (!CollectionUtils.isEmpty((Collection)umcTodoItemPageRspBo.getRows()) && "1".equals((umcTodoItem = (UmcTodoItem)umcTodoItemPageRspBo.getRows().get(0)).getPushFlag())) {
            UmcToDoPushBo umcToDoPushBo = new UmcToDoPushBo();
            umcToDoPushBo.setBusiId(reqBO.getBusiId());
            umcToDoPushBo.setTodoId(reqBO.getTodoId());
            umcToDoPushBo.setOperUserId(reqBO.getOperUserId());
            umcToDoPushBo.setOperUserName(reqBO.getOperUserName());
            umcToDoPushBo.setTodoType(UmcCommConstant.TODO_TYPE.REVOKE);
            umcToDoPushBo.setTodoItemCode(umcTodoItem.getTodoItemCode());
            umcToDoPushBo.setTodoItemName(umcTodoItem.getTodoItemName());
            umcToDoPushBo.setTodoModuleCode(umcTodoItem.getTodoModuleCode());
            umcToDoPushBo.setTodoModuleName(umcTodoItem.getTodoModuleName());
            this.proxyMessageProducer.send(new ProxyMessage(this.todoSyncTopic, this.todoSyncTag, JSON.toJSONString((Object)umcToDoPushBo)));
        }
    }
}

