/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoListDo;
import com.tydic.dyc.umc.service.todo.UmcDealTransferTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcDealTransferTodoBo;
import com.tydic.dyc.umc.service.todo.bo.UmcDealTransferTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcDealTransferTodoService"})
public class UmcDealTransferTodoServiceImpl
implements UmcDealTransferTodoService {
    @Autowired
    private IUmcTodoModel iUmcTodoModel;

    @PostMapping(value={"dealTransferTodo"})
    public UmcSendTodoRspBo dealTransferTodo(@RequestBody UmcDealTransferTodoReqBo reqBo) {
        this.val(reqBo);
        UmcSendTodoRspBo umcSendTodoRspBo = UmcRu.success(UmcSendTodoRspBo.class);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUmcDealTransferTodoBoList())) {
            List<String> busiIdList = reqBo.getUmcDealTransferTodoBoList().stream().map(UmcDealTransferTodoBo::getBusiId).collect(Collectors.toList());
            UmcTodoQryBo umcTodoQryBo = new UmcTodoQryBo();
            umcTodoQryBo.setBusiIdList(busiIdList);
            UmcTodoListDo umcTodoListDo = this.iUmcTodoModel.selectTodoList(umcTodoQryBo);
            if (!CollectionUtils.isEmpty((Collection)umcTodoListDo.getRows())) {
                Map<String, UmcTodoDo> umcTodoDoMap = umcTodoListDo.getRows().stream().collect(Collectors.toMap(UmcTodoDo::getBusiId, o -> o));
                for (UmcDealTransferTodoBo umcDealTransferTodoBo : reqBo.getUmcDealTransferTodoBoList()) {
                    this.dealHaveDone(umcDealTransferTodoBo, umcTodoDoMap.get(umcDealTransferTodoBo.getBusiId()));
                }
            }
        }
        return umcSendTodoRspBo;
    }

    private void val(UmcDealTransferTodoReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcDealTransferTodoBoList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcDealTransferTodoBo umcDealTransferTodoBo : reqBo.getUmcDealTransferTodoBoList()) {
            if (StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getBusiId())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getOperUserId())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getOperUserName())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getCandidateOperId())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5019\u9009\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getCandidateOperName())) continue;
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5019\u9009\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void dealHaveDone(UmcDealTransferTodoBo umcDealTransferTodoBo, UmcTodoDo umcTodoDoReq) {
        UmcTodoDone umcTodoDone = new UmcTodoDone();
        umcTodoDone.setBusiId(umcDealTransferTodoBo.getBusiId());
        umcTodoDone.setOperId(umcDealTransferTodoBo.getOperUserId());
        umcTodoDone.setOperName(umcDealTransferTodoBo.getOperUserName());
        umcTodoDone.setTodoItemCode(umcTodoDoReq.getTodoItemCode());
        this.iUmcTodoModel.sendHaveDone(umcTodoDone);
        UmcTodoListDo umcTodoListDo = new UmcTodoListDo();
        umcTodoDoReq.setCandidateOperId(umcDealTransferTodoBo.getCandidateOperId());
        umcTodoDoReq.setCandidateOperName(umcDealTransferTodoBo.getCandidateOperName());
        umcTodoDoReq.setCreateOperId(umcDealTransferTodoBo.getOperUserId());
        umcTodoDoReq.setCreateOperName(umcDealTransferTodoBo.getCandidateOperName());
        umcTodoDoReq.setCreateTime(new Date());
        umcTodoDoReq.setTodoId(IdUtil.nextId());
        umcTodoListDo.setUmcTodoDos(Collections.singletonList(umcTodoDoReq));
        this.iUmcTodoModel.createTodo(umcTodoListDo);
    }
}

