/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.signcontractapply;

import cn.hutool.core.convert.Convert;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.signcontractapply.IUmcSignContractApplyModel;
import com.tydic.dyc.umc.model.signcontractapply.UmcSignContractApplyDo;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractLog;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractYearRuleApply;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignSalesCategoryApply;
import com.tydic.dyc.umc.service.signcontractapply.UmcUpdateSignContractApplyService;
import com.tydic.dyc.umc.service.signcontractapply.bo.SignContractYearRuleApplyBo;
import com.tydic.dyc.umc.service.signcontractapply.bo.SignSalesCategoryApplyBo;
import com.tydic.dyc.umc.service.signcontractapply.bo.UmcUpdateSignContractApplyReqBo;
import com.tydic.dyc.umc.service.signcontractapply.bo.UmcUpdateSignContractApplyRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.signcontractapply.UmcUpdateSignContractApplyService"})
public class UmcUpdateSignContractApplyServiceImpl
implements UmcUpdateSignContractApplyService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateSignContractApplyServiceImpl.class);
    @Autowired
    private IUmcSignContractApplyModel iUmcSignContractApplyModel;
    private static final String YEAR_FEE_CONFIRM = "3";
    private static final String YEAR_FEE_NOT_CONFIRM = "4";
    private static final String CHARGE_YEAR_FEE_CONFIRM = "1";
    private static final String NOT_CHARGE_YEAR_FEE = "0";
    public static final String CHANGE_APPLY = "2";

    @PostMapping(value={"updateSignContractApply"})
    public UmcUpdateSignContractApplyRspBo updateSignContractApply(@RequestBody UmcUpdateSignContractApplyReqBo reqBo) {
        boolean anyMatchChangeApply;
        this.validateAgr(reqBo);
        UmcSignContractApplyDo qryDetailDo = new UmcSignContractApplyDo();
        qryDetailDo.setApplyId(reqBo.getApplyId());
        UmcSignContractApplyDo detail = this.iUmcSignContractApplyModel.getSignContractApplyInfo(qryDetailDo);
        if (null == detail) {
            throw new BaseBusinessException("200100", "\u8be5\u7b7e\u7ea6\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
        }
        if (UmcCommConstant.SUP_CONTRACT_STATUS.CREATED.equals(reqBo.getContractStatus()) && !UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.COMPLITE.equals(detail.getStatus())) {
            throw new BaseBusinessException("200100", "\u672a\u7b7e\u7ea6\u5b8c\u6bd5\uff0c\u4e0d\u80fd\u8fdb\u884c\u5408\u540c\u7b7e\u7f72\u56de\u8c03");
        }
        if (!CollectionUtils.isEmpty(detail.getSignContractLogs()) && UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.APPLYING.equals(reqBo.getStatus()) && (anyMatchChangeApply = detail.getSignContractLogs().stream().anyMatch(signContractLog -> UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.CHANGE_APPLY.equals(Convert.toInt((Object)signContractLog.getOperType()))))) {
            reqBo.setApplyType(CHANGE_APPLY);
            reqBo.setStatus(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.CHANGE_APPLY);
        }
        UmcSignContractApplyDo updateSignApplyDo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcSignContractApplyDo.class));
        updateSignApplyDo.setUpdateTime(new Date());
        updateSignApplyDo.setUpdateOperId(reqBo.getUserId());
        updateSignApplyDo.setUpdateOperName(reqBo.getUserName());
        this.iUmcSignContractApplyModel.updateSignContractApply(updateSignApplyDo);
        if ((detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.Draft) || detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.COMPLITE) && CHANGE_APPLY.equals(reqBo.getApplyType()) || detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.CHANGE_APPLY) || detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.FEFUSE)) && null != reqBo.getSignSalesCategoryApplyBos() && !CollectionUtils.isEmpty((Collection)reqBo.getSignSalesCategoryApplyBos())) {
            Object addCategoryDo;
            ArrayList<SignSalesCategoryApply> addSalesCategories = new ArrayList<SignSalesCategoryApply>();
            ArrayList<SignSalesCategoryApply> updateSalesCategories = new ArrayList<SignSalesCategoryApply>();
            for (SignSalesCategoryApplyBo umcSupSalesCategoryBO : reqBo.getSignSalesCategoryApplyBos()) {
                SignSalesCategoryApply supSalesCategoryPO = new SignSalesCategoryApply();
                BeanUtils.copyProperties((Object)umcSupSalesCategoryBO, (Object)supSalesCategoryPO);
                supSalesCategoryPO.setDelFlag(NOT_CHARGE_YEAR_FEE);
                supSalesCategoryPO.setApplyId(reqBo.getApplyId());
                supSalesCategoryPO.setSignContractId(reqBo.getSignContractId());
                if (umcSupSalesCategoryBO.getServiceFeeRate() == null) {
                    supSalesCategoryPO.setServiceFeeRate(0.0);
                }
                if (CHARGE_YEAR_FEE_CONFIRM.equals(umcSupSalesCategoryBO.getChngType()) && umcSupSalesCategoryBO.getSalesCategoryId() == null) {
                    if (detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.Draft) || detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.FEFUSE)) {
                        supSalesCategoryPO.setChngType(YEAR_FEE_NOT_CONFIRM);
                    } else {
                        supSalesCategoryPO.setChngType(CHARGE_YEAR_FEE_CONFIRM);
                    }
                    supSalesCategoryPO.setCreateOperId(reqBo.getUserId());
                    supSalesCategoryPO.setCreateOperName(reqBo.getUserName());
                    supSalesCategoryPO.setCreateTime(new Date());
                    addSalesCategories.add(supSalesCategoryPO);
                    continue;
                }
                if ((YEAR_FEE_NOT_CONFIRM.equals(umcSupSalesCategoryBO.getChngType()) || umcSupSalesCategoryBO.getChngType() == null) && umcSupSalesCategoryBO.getSalesCategoryId() != null) {
                    if (detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.Draft) || detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.FEFUSE)) {
                        supSalesCategoryPO.setChngType(YEAR_FEE_NOT_CONFIRM);
                    }
                    supSalesCategoryPO.setUpdateTime(new Date());
                    supSalesCategoryPO.setUpdateOperId(reqBo.getUserId());
                    supSalesCategoryPO.setUpdateOperName(reqBo.getUserName());
                    updateSalesCategories.add(supSalesCategoryPO);
                    continue;
                }
                if (!CHANGE_APPLY.equals(umcSupSalesCategoryBO.getChngType())) continue;
                SignSalesCategoryApply supSalesCategoryDelPO = new SignSalesCategoryApply();
                supSalesCategoryDelPO.setSalesCategoryId(umcSupSalesCategoryBO.getSalesCategoryId());
                if (detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.Draft) || detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.FEFUSE)) {
                    supSalesCategoryDelPO.setDelFlag(CHARGE_YEAR_FEE_CONFIRM);
                    supSalesCategoryDelPO.setUpdateTime(new Date());
                    supSalesCategoryDelPO.setUpdateOperId(reqBo.getUserId());
                    supSalesCategoryDelPO.setUpdateOperName(reqBo.getUserName());
                    updateSalesCategories.add(supSalesCategoryDelPO);
                    continue;
                }
                supSalesCategoryDelPO.setChngType(CHANGE_APPLY);
                supSalesCategoryDelPO.setUpdateTime(new Date());
                supSalesCategoryDelPO.setUpdateOperId(reqBo.getUserId());
                supSalesCategoryDelPO.setUpdateOperName(reqBo.getUserName());
                updateSalesCategories.add(supSalesCategoryDelPO);
            }
            if (!CollectionUtils.isEmpty(addSalesCategories)) {
                addCategoryDo = new UmcSignContractApplyDo();
                ((UmcSignContractApplyDo)((Object)addCategoryDo)).setSignSalesCategoryApplies(addSalesCategories);
                this.iUmcSignContractApplyModel.addSignSalesCategoryApplies((UmcSignContractApplyDo)((Object)addCategoryDo));
            }
            if (!CollectionUtils.isEmpty(updateSalesCategories)) {
                addCategoryDo = new UmcSignContractApplyDo();
                ((UmcSignContractApplyDo)((Object)addCategoryDo)).setSignSalesCategoryApplies(updateSalesCategories);
                this.iUmcSignContractApplyModel.updateSignSalesCategoryApplies((UmcSignContractApplyDo)((Object)addCategoryDo));
            }
        }
        if (detail.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.APPLYING) && !CollectionUtils.isEmpty((Collection)reqBo.getSignContractYearRuleApplyBos())) {
            SignContractYearRuleApply where = new SignContractYearRuleApply();
            where.setApplyId(detail.getApplyId());
            where.setDelFlag(CHARGE_YEAR_FEE_CONFIRM);
            where.setUpdateOperId(reqBo.getUserId());
            where.setUpdateOperName(reqBo.getUserName());
            where.setUpdateTime(new Date());
            this.iUmcSignContractApplyModel.updateSignContractYearRuleApplies(where);
            ArrayList<SignContractYearRuleApply> addYearRule = new ArrayList<SignContractYearRuleApply>();
            for (SignContractYearRuleApplyBo umcSupSignContractYearRuleBO : reqBo.getSignContractYearRuleApplyBos()) {
                SignContractYearRuleApply signContractYearRulePO = new SignContractYearRuleApply();
                BeanUtils.copyProperties((Object)umcSupSignContractYearRuleBO, (Object)signContractYearRulePO);
                signContractYearRulePO.setCreateOperId(reqBo.getUserId());
                signContractYearRulePO.setCreateOperName(reqBo.getUserName());
                signContractYearRulePO.setCreateTime(new Date());
                signContractYearRulePO.setSignContractId(reqBo.getSignContractId());
                signContractYearRulePO.setApplyId(detail.getApplyId());
                signContractYearRulePO.setChngType(YEAR_FEE_NOT_CONFIRM);
                signContractYearRulePO.setDelFlag(NOT_CHARGE_YEAR_FEE);
                signContractYearRulePO.setRuleId(IdUtil.nextId());
                addYearRule.add(signContractYearRulePO);
            }
            if (!CollectionUtils.isEmpty(addYearRule)) {
                UmcSignContractApplyDo addYearDo = new UmcSignContractApplyDo();
                addYearDo.setSignContractYearRuleApplies(addYearRule);
                this.iUmcSignContractApplyModel.addSignContractYearRuleApplies(addYearDo);
            }
        }
        if (UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.COMPLITE.equals(reqBo.getStatus()) && !NOT_CHARGE_YEAR_FEE.equals(detail.getYearServiceFee())) {
            SignContractYearRuleApply apply = new SignContractYearRuleApply();
            apply.setOrgId(detail.getOrgId());
            apply.setChngType(YEAR_FEE_CONFIRM);
            apply.setDelFlag(CHARGE_YEAR_FEE_CONFIRM);
            apply.setUpdateOperId(reqBo.getUserId());
            apply.setUpdateOperName(reqBo.getUserName());
            apply.setUpdateTime(new Date());
            this.iUmcSignContractApplyModel.updateSignContractYearRuleApplies(apply);
            SignContractYearRuleApply applyOther = new SignContractYearRuleApply();
            applyOther.setApplyId(detail.getApplyId());
            applyOther.setChngType(YEAR_FEE_CONFIRM);
            applyOther.setUpdateOperId(reqBo.getUserId());
            applyOther.setUpdateOperName(reqBo.getUserName());
            applyOther.setUpdateTime(new Date());
            this.iUmcSignContractApplyModel.updateSignContractYearRuleApplies(applyOther);
        }
        UmcSignContractApplyDo logDo = new UmcSignContractApplyDo();
        SignContractLog logReqPo = new SignContractLog();
        logReqPo.setApplyId(reqBo.getApplyId());
        logReqPo.setCreateOperId(reqBo.getUserId());
        logReqPo.setCreateOperName(reqBo.getUserName());
        logReqPo.setCreateTime(new Date());
        logReqPo.setDelFlag(NOT_CHARGE_YEAR_FEE);
        logReqPo.setTenantId(reqBo.getTenantId());
        logReqPo.setOperType(reqBo.getStatus().toString());
        if (reqBo.getStatus() != null) {
            if (reqBo.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.Draft)) {
                logReqPo.setOperTypeStr("\u4fdd\u5b58");
            } else if (reqBo.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.APPLYING)) {
                logReqPo.setOperTypeStr("\u63d0\u4ea4");
            } else if (reqBo.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.CONFIRM)) {
                logReqPo.setOperTypeStr("\u529e\u7406");
            } else if (reqBo.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.COMPLITE)) {
                logReqPo.setOperTypeStr("\u786e\u8ba4");
            } else if (reqBo.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.FEFUSE)) {
                logReqPo.setOperTypeStr("\u62d2\u7edd");
            } else if (reqBo.getStatus().equals(UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.CHANGE_APPLY)) {
                logReqPo.setOperTypeStr("\u53d8\u66f4");
            }
        }
        logReqPo.setSignContractId(reqBo.getSignContractId());
        logDo.setSignContractLogs(Collections.singletonList(logReqPo));
        this.iUmcSignContractApplyModel.addSignContractLogs(logDo);
        UmcUpdateSignContractApplyRspBo rspBo = new UmcUpdateSignContractApplyRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateAgr(UmcUpdateSignContractApplyReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplyId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u7533\u8bf7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

