/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.addrprovince;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.nacos.client.utils.StringUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.addrprovince.IUmcAddProvinceModel;
import com.tydic.dyc.umc.service.addrprovince.UmcSyncAddrService;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcAddrSyncBo;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcSyncAddrReqBo;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcSyncAddrRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.addrprovince.UmcSyncAddrService"})
public class UmcSyncAddrServiceImpl
implements UmcSyncAddrService {
    @Autowired
    private IUmcAddProvinceModel iUmcAddProvinceModel;

    @PostMapping(value={"syncAddr"})
    public UmcSyncAddrRspBo syncAddr(@RequestBody UmcSyncAddrReqBo reqBo) {
        this.validate(reqBo);
        Map<String, List<UmcAddrSyncBo>> listMap = reqBo.getUmcAddrBoList().stream().distinct().collect(Collectors.groupingBy(UmcAddrSyncBo::getAddrType));
        listMap.forEach((key, value) -> this.dealData((String)key, (List)listMap.get(key)));
        return UmcRu.success(UmcSyncAddrRspBo.class);
    }

    public void dealData(String addrType, List<UmcAddrSyncBo> tempList) {
        ArrayList<UmcAddrSyncBo> insertList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> updateList = new ArrayList<UmcAddrSyncBo>();
        ArrayList<UmcAddrSyncBo> deleteList = new ArrayList<UmcAddrSyncBo>();
        this.dealListData(addrType, tempList, insertList, updateList, deleteList);
    }

    public void dealListData(String addrType, List<UmcAddrSyncBo> tempList, List<UmcAddrSyncBo> insertList, List<UmcAddrSyncBo> updateList, List<UmcAddrSyncBo> deleteList) {
        int count = 0;
        ArrayList<Object> searchList = new ArrayList<UmcAddrSyncBo>();
        List<Object> existsList = new ArrayList();
        List<Object> differentList = new ArrayList();
        for (UmcAddrSyncBo umcAddrSyncBo : tempList) {
            if (umcAddrSyncBo.getDelFlag().equals(String.valueOf(UmcCommConstant.IsDel.IS_DEL_NO))) {
                searchList.add(umcAddrSyncBo);
                if (++count % 100 != 0 && count != tempList.size()) continue;
                existsList = this.iUmcAddProvinceModel.queryExistsAddrByType(searchList, addrType);
                if (ObjectUtil.isNotEmpty(existsList)) {
                    List<Object> finalExistsList = existsList;
                    existsList = searchList.stream().filter(e -> {
                        List collect = finalExistsList.stream().filter(e2 -> e2.getAddrCode().equals(e.getAddrCode())).collect(Collectors.toList());
                        if (!ObjectUtil.isEmpty(collect)) {
                            return e.getAddrCode().equals(((UmcAddrSyncBo)collect.get(0)).getAddrCode());
                        }
                        return false;
                    }).collect(Collectors.toList());
                    List existsAddrCodeList = existsList.stream().map(UmcAddrSyncBo::getAddrCode).collect(Collectors.toList());
                    differentList = searchList.stream().filter(e -> !existsAddrCodeList.contains(e.getAddrCode())).collect(Collectors.toList());
                    insertList = differentList;
                    updateList = existsList;
                } else {
                    insertList = searchList;
                }
                searchList = new ArrayList();
                if (!StringUtils.isNotEmpty((String)addrType)) continue;
                switch (addrType) {
                    case "1": {
                        this.iUmcAddProvinceModel.insertAddr(insertList, "1");
                        this.iUmcAddProvinceModel.updateAddr(updateList, "1");
                        break;
                    }
                    case "2": {
                        this.iUmcAddProvinceModel.insertAddr(insertList, "2");
                        this.iUmcAddProvinceModel.updateAddr(updateList, "2");
                        break;
                    }
                    case "3": {
                        this.iUmcAddProvinceModel.insertAddr(insertList, "3");
                        this.iUmcAddProvinceModel.updateAddr(updateList, "3");
                        break;
                    }
                    case "4": {
                        this.iUmcAddProvinceModel.insertAddr(insertList, "4");
                        this.iUmcAddProvinceModel.updateAddr(updateList, "4");
                    }
                }
                continue;
            }
            deleteList.add(umcAddrSyncBo);
        }
        if (ObjectUtil.isNotEmpty(deleteList)) {
            this.iUmcAddProvinceModel.deleteAddr(deleteList);
        }
    }

    public void validate(UmcSyncAddrReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getUmcAddrBoList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[umcAddrBoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

