/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoItemQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItemPageRspBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoListDo;
import com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoPushBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService"})
public class UmcSendHaveDoneServiceImpl
implements UmcSendHaveDoneService {
    private static final Logger log = LoggerFactory.getLogger(UmcSendHaveDoneServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Value(value="${umc.have.done.sync.enable:true}")
    private boolean haveDoneSyncEnable;

    @PostMapping(value={"sendHaveDone"})
    public UmcSendHaveDoneRspBo sendHaveDone(@RequestBody UmcSendHaveDoneReqBo reqBO) {
        UmcTodoDone umcTodoDone = new UmcTodoDone();
        umcTodoDone.setTodoId(reqBO.getTodoId());
        umcTodoDone.setBusiId(reqBO.getBusiId());
        umcTodoDone.setOperId(reqBO.getOperUserId());
        umcTodoDone.setOperName(reqBO.getOperUserName());
        umcTodoDone.setTodoItemCode(reqBO.getTodoItemCode());
        umcTodoDone.setTodoUrl(reqBO.getDoneUrl());
        umcTodoDone.setTodoName(reqBO.getDoneName());
        UmcTodoListDo umcTodoListDo = this.iUmcTodoModel.sendHaveDone(umcTodoDone);
        if (this.haveDoneSyncEnable && !CollectionUtils.isEmpty(umcTodoListDo.getUmcTodoDos())) {
            this.sendMq(reqBO, umcTodoListDo);
        }
        return UmcRu.success(UmcSendHaveDoneRspBo.class);
    }

    private void sendMq(UmcSendHaveDoneReqBo reqBO, UmcTodoListDo umcTodoListDo) {
        UmcTodoItem umcTodoItem;
        UmcTodoDo umcTodoDo = umcTodoListDo.getUmcTodoDos().get(0);
        UmcTodoItemQryBo umcTodoItemQryBo = new UmcTodoItemQryBo();
        umcTodoItemQryBo.setTodoItemCode(umcTodoDo.getTodoItemCode());
        UmcTodoItemPageRspBo umcTodoItemPageRspBo = this.iUmcTodoModel.selectTodoItemList(umcTodoItemQryBo);
        log.debug("umcTodoItemPageRspBo:{}", (Object)JSON.toJSONString((Object)((Object)umcTodoItemPageRspBo)));
        if (!CollectionUtils.isEmpty((Collection)umcTodoItemPageRspBo.getRows()) && "1".equals((umcTodoItem = (UmcTodoItem)umcTodoItemPageRspBo.getRows().get(0)).getPushFlag())) {
            UmcToDoPushBo umcToDoPushBo = new UmcToDoPushBo();
            umcToDoPushBo.setBusiId(reqBO.getBusiId());
            umcToDoPushBo.setTodoId(reqBO.getTodoId());
            umcToDoPushBo.setOperUserId(reqBO.getOperUserId());
            umcToDoPushBo.setOperUserName(reqBO.getOperUserName());
            umcToDoPushBo.setHaveDoneUrl(reqBO.getDoneUrl());
            umcToDoPushBo.setTodoType(UmcCommConstant.TODO_TYPE.DONE);
            umcToDoPushBo.setTodoItemCode(umcTodoItem.getTodoItemCode());
            umcToDoPushBo.setTodoItemName(umcTodoItem.getTodoItemName());
            umcToDoPushBo.setTodoModuleCode(umcTodoItem.getTodoModuleCode());
            umcToDoPushBo.setTodoModuleName(umcTodoItem.getTodoModuleName());
            this.proxyMessageProducer.send(new ProxyMessage(this.todoSyncTopic, this.todoSyncTag, JSON.toJSONString((Object)umcToDoPushBo)));
        }
    }
}

