/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoItemQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoUrlQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoListDo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoUrl;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoUrlList;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.service.todo.UmcSendTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoPushBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendTodoService"})
public class UmcSendTodoServiceImpl
implements UmcSendTodoService {
    private static final Logger log = LoggerFactory.getLogger(UmcSendTodoServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Value(value="${umc.todo.sync.enable:true}")
    private boolean todoSyncEnable;
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;

    @PostMapping(value={"sendTodo"})
    public UmcSendTodoRspBo sendTodo(@RequestBody UmcSendTodoReqBo reqBO) {
        this.valdateParam(reqBO);
        Map userMap = new HashMap();
        UmcUserInfoQryBo umcUserInfoQryBo = new UmcUserInfoQryBo();
        umcUserInfoQryBo.setUserIdList(reqBO.getTodoList().stream().map(o -> Convert.toLong((Object)o.getCandidateOperId())).collect(Collectors.toList()));
        List umcUserInfoQryBoList = this.iUmcUserInfoModel.getUserOrgBaseInfoList(umcUserInfoQryBo).getRows();
        if (!CollectionUtils.isEmpty((Collection)umcUserInfoQryBoList)) {
            userMap = umcUserInfoQryBoList.stream().collect(Collectors.toConcurrentMap(o -> o.getUserId().toString(), o -> o));
        }
        ArrayList<String> todoItemCodeList = new ArrayList<String>();
        ArrayList<String> todoUrlKeyList = new ArrayList<String>();
        reqBO.getTodoList().forEach(umcTodoBo -> {
            todoItemCodeList.add(umcTodoBo.getTodoItemCode());
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)umcTodoBo.getTodoUrlKey())) {
                todoUrlKeyList.add(umcTodoBo.getTodoUrlKey());
            }
        });
        Map<Object, Object> todoUrlMap = new HashMap();
        Map<Object, Object> todoDefaultUrlMap = new HashMap();
        if (!CollectionUtils.isEmpty(todoUrlKeyList)) {
            UmcTodoUrlQryBo umcTodoUrlQryBo = new UmcTodoUrlQryBo();
            umcTodoUrlQryBo.setTodoItemCodeList(todoItemCodeList.stream().distinct().collect(Collectors.toList()));
            umcTodoUrlQryBo.setTodoUrlKeyList(todoUrlKeyList);
            UmcTodoUrlList umcTodoUrlList = this.iUmcTodoModel.getTodoUrlList(umcTodoUrlQryBo);
            if (!CollectionUtils.isEmpty(umcTodoUrlList.getTodoUrlList())) {
                todoUrlMap = umcTodoUrlList.getTodoUrlList().stream().collect(Collectors.toMap(o -> o.getTodoItemCode() + o.getTodoUrlKey(), o -> o, (o1, o2) -> o2));
            }
            UmcTodoUrlQryBo qryDefaultTodoUrl = new UmcTodoUrlQryBo();
            qryDefaultTodoUrl.setTodoItemCodeList(todoItemCodeList);
            qryDefaultTodoUrl.setDefaultFlag(1);
            UmcTodoUrlList todoDefault = this.iUmcTodoModel.getTodoUrlList(qryDefaultTodoUrl);
            if (!CollectionUtils.isEmpty(todoDefault.getTodoUrlList())) {
                todoDefaultUrlMap = todoDefault.getTodoUrlList().stream().collect(Collectors.toMap(o -> o.getTodoItemCode(), o -> o, (o1, o2) -> o2));
            }
        }
        UmcSendTodoRspBo rsp = UmcRu.success(UmcSendTodoRspBo.class);
        ArrayList<UmcTodoDo> umcTodoDoList = new ArrayList<UmcTodoDo>();
        ArrayList<UmcTodoItem> todoItemList = new ArrayList<UmcTodoItem>();
        for (UmcTodoBo bo : reqBO.getTodoList()) {
            UmcTodoUrl umcTodoUrl;
            UmcTodoItemQryBo umcTodoItemQryBo = new UmcTodoItemQryBo();
            umcTodoItemQryBo.setTodoItemCode(bo.getTodoItemCode());
            umcTodoItemQryBo.setTodoModuleCode(bo.getTodoModuleCode());
            List umcTodoItemList = this.iUmcTodoModel.selectTodoItemList(umcTodoItemQryBo).getRows();
            if (CollectionUtils.isEmpty((Collection)umcTodoItemList)) {
                throw new BaseBusinessException("101021", "\u4ee3\u529e\u9879\u8868\u4e3a\u7a7a\uff01");
            }
            if (umcTodoItemList.size() != 1) {
                throw new BaseBusinessException("101021", "\u4ee3\u529e\u9879\u5b58\u5728\u591a\u6761\u6570\u636e\uff01");
            }
            UmcTodoDo umcTodoDo = new UmcTodoDo();
            BeanUtils.copyProperties((Object)bo, (Object)umcTodoDo);
            umcTodoDo.setTodoItemCode(((UmcTodoItem)umcTodoItemList.get(0)).getTodoItemCode());
            if (!StringUtils.hasText((String)bo.getTodoName())) {
                umcTodoDo.setTodoName(((UmcTodoItem)umcTodoItemList.get(0)).getTodoItemName() + bo.getBusiId());
            }
            umcTodoDo.setTodoItemName(((UmcTodoItem)umcTodoItemList.get(0)).getTodoItemName());
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getTodoUrlKey())) {
                umcTodoUrl = (UmcTodoUrl)todoUrlMap.get(bo.getTodoItemCode() + bo.getTodoUrlKey());
                if (null != umcTodoUrl && umcTodoUrl.getTodoUrl().endsWith("?")) {
                    umcTodoDo.setTodoUrl(umcTodoUrl.getTodoUrl() + "objId=" + bo.getObjId() + "&objType=" + bo.getObjType());
                }
            } else if (StringUtils.hasText((String)bo.getTodoUrl())) {
                umcTodoDo.setTodoUrl(bo.getTodoUrl() + bo.getUrlSuffix());
            } else {
                umcTodoUrl = (UmcTodoUrl)todoDefaultUrlMap.get(bo.getTodoItemCode());
                if (null != umcTodoUrl) {
                    if (StringUtils.isEmpty((Object)bo.getUrlSuffix())) {
                        umcTodoDo.setTodoUrl(umcTodoUrl.getTodoUrl());
                    } else {
                        umcTodoDo.setTodoUrl(umcTodoUrl.getTodoUrl() + bo.getUrlSuffix());
                    }
                }
            }
            umcTodoDo.setTodoModuleCode(((UmcTodoItem)umcTodoItemList.get(0)).getTodoModuleCode());
            umcTodoDo.setTodoModuleName(((UmcTodoItem)umcTodoItemList.get(0)).getTodoModuleName());
            umcTodoDo.setTodoId(IdUtil.nextId());
            umcTodoDo.setCreateTime(new Date());
            UmcUserInfoQryBo candidateOperBo = (UmcUserInfoQryBo)((Object)userMap.get(umcTodoDo.getCandidateOperId()));
            if (null != candidateOperBo) {
                umcTodoDo.setCandidateOperExtId(candidateOperBo.getExtCustId());
                umcTodoDo.setCandidateOperOrgId(Convert.toStr((Object)candidateOperBo.getOrgId()));
                umcTodoDo.setCandidateOperOrgExtId(candidateOperBo.getExtOrgId());
                umcTodoDo.setCandidateOperOrgName(candidateOperBo.getOrgName());
            }
            umcTodoDoList.add(umcTodoDo);
            bo.setTodoId(umcTodoDo.getTodoId());
            bo.setTodoShopShow(((UmcTodoItem)umcTodoItemList.get(0)).getTodoShopShow());
            todoItemList.add((UmcTodoItem)umcTodoItemList.get(0));
        }
        UmcTodoListDo umcTodoListDo = new UmcTodoListDo();
        umcTodoListDo.setUmcTodoDos(umcTodoDoList);
        int isInsert = this.iUmcTodoModel.createTodo(umcTodoListDo).getCheck();
        if (isInsert != umcTodoDoList.size()) {
            throw new BaseBusinessException("101021", "\u63d2\u5165\u4ee3\u529e\u4fe1\u606f\u8868\u5931\u8d25\uff01");
        }
        rsp.setTodoList(reqBO.getTodoList());
        if (this.todoSyncEnable) {
            this.sendMq(todoItemList, umcTodoDoList);
        }
        return rsp;
    }

    private void sendMq(List<UmcTodoItem> todoItemList, List<UmcTodoDo> umcTodoDoList) {
        log.debug("todoItemList:{}", (Object)JSON.toJSONString(todoItemList));
        Map<String, UmcTodoItem> todoItemMap = todoItemList.stream().distinct().filter(a -> "1".equals(a.getPushFlag())).collect(Collectors.toMap(UmcTodoItem::getTodoItemCode, o -> o, (o1, o2) -> o1));
        log.debug("todoItemMap:{}", (Object)JSON.toJSONString(todoItemMap));
        for (UmcTodoDo umcTodoDo : umcTodoDoList) {
            UmcTodoItem umcTodoItem = todoItemMap.get(umcTodoDo.getTodoItemCode());
            if (null == umcTodoItem) continue;
            UmcToDoPushBo umcToDoPushBo = UmcRu.js(umcTodoDo, UmcToDoPushBo.class);
            umcToDoPushBo.setTodoType(UmcCommConstant.TODO_TYPE.TODO);
            umcToDoPushBo.setTodoModuleName(umcTodoItem.getTodoModuleName());
            umcToDoPushBo.setTodoModuleCode(umcTodoItem.getTodoModuleCode());
            umcToDoPushBo.setTodoItemCode(umcTodoItem.getTodoItemCode());
            umcToDoPushBo.setTodoItemName(umcTodoItem.getTodoItemName());
            umcToDoPushBo.setTodoClass(umcTodoItem.getTodoClass());
            this.proxyMessageProducer.send(new ProxyMessage(this.todoSyncTopic, this.todoSyncTag, JSON.toJSONString((Object)umcToDoPushBo)));
        }
    }

    private void valdateParam(UmcSendTodoReqBo reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getTodoList())) {
            throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcTodoBo bo : reqBO.getTodoList()) {
            if (!StringUtils.hasText((String)bo.getBusiId())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.busiId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getTodoItemCode())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.todoItemCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getCreateOperId())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.createOperId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getCreateOperName())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.createOperName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getCandidateOperId())) {
                throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.candidateOperId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.hasText((String)bo.getCandidateOperName())) continue;
            throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList.candidateOperName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

