/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterpriseacount.IUmcEnterpriseAccountModel;
import com.tydic.dyc.umc.model.enterpriseacount.UmcEnterpriseAccountDo;
import com.tydic.dyc.umc.model.enterpriseacount.qrybo.UmcEnterpriseAccountDoRspBo;
import com.tydic.dyc.umc.model.enterpriseacount.qrybo.UmcEnterpriseAccountQryBo;
import com.tydic.dyc.umc.model.invoice.IUmcInvoiceInfoModel;
import com.tydic.dyc.umc.model.invoice.UmcInvoiceInfoDo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoListRspBo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoQryBo;
import com.tydic.dyc.umc.service.invoice.UmcInvoiceInfoAddService;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoAddReqBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoAddRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.invoice.UmcInvoiceInfoAddService"})
public class UmcInvoiceInfoAddServiceImpl
implements UmcInvoiceInfoAddService {
    @Autowired
    private IUmcInvoiceInfoModel iUmcInvoiceInfoModel;
    @Autowired
    private IUmcEnterpriseAccountModel iUmcEnterpriseAccountModel;
    @Value(value="${umc.invoice.companyOrPerson.value}")
    private String companyOrPerson;

    @PostMapping(value={"createInvoiceInfo"})
    public UmcInvoiceInfoAddRspBo createInvoiceInfo(@RequestBody UmcInvoiceInfoAddReqBo reqBo) {
        List<UmcInvoiceInfoDo> invoiceInfoDoList;
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        UmcInvoiceInfoAddRspBo rspBo = UmcRu.success(UmcInvoiceInfoAddRspBo.class);
        UmcInvoiceInfoDo invoiceInfoDo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcInvoiceInfoDo.class));
        invoiceInfoDo.setCreateTime(new Date());
        invoiceInfoDo.setDelFlag("0");
        invoiceInfoDo.setOrgId(reqBo.getOrgIdWeb());
        if (ObjectUtil.isEmpty((Object)reqBo.getAccountId())) {
            invoiceInfoDoList = this.qryInvByOrgId(reqBo.getOrgIdWeb());
            if (CollectionUtils.isEmpty(invoiceInfoDoList)) {
                invoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.YES);
            } else if (!ObjectUtils.isEmpty((Object)reqBo.getMainFlag()) && reqBo.getMainFlag().equals(UmcCommConstant.EntInvMainFlag.YES)) {
                this.cancleMainFlagAddr(invoiceInfoDoList);
            } else {
                invoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.NO);
            }
        } else {
            invoiceInfoDoList = this.qryInvByAccountId(reqBo.getAccountId());
            if (CollectionUtils.isEmpty(invoiceInfoDoList)) {
                invoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.YES);
            } else if (!ObjectUtils.isEmpty((Object)reqBo.getMainFlag()) && reqBo.getMainFlag().equals(UmcCommConstant.EntInvMainFlag.YES)) {
                this.cancleMainFlagAddr(invoiceInfoDoList);
            } else {
                invoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.NO);
            }
            if (reqBo.getAccountId() == null && reqBo.getOrgIdWeb() != null) {
                UmcEnterpriseAccountQryBo accountQryBo = new UmcEnterpriseAccountQryBo();
                accountQryBo.setOrgIdWeb(reqBo.getOrgIdWeb());
                UmcEnterpriseAccountDoRspBo enterpriseAccountPage = this.iUmcEnterpriseAccountModel.getEnterpriseAccountPage(accountQryBo);
                if (!CollectionUtils.isEmpty((Collection)enterpriseAccountPage.getRows())) {
                    invoiceInfoDo.setAccountId(((UmcEnterpriseAccountDo)enterpriseAccountPage.getRows().get(0)).getAccountId());
                }
            }
        }
        UmcInvoiceInfoDo invoiceInfo = this.iUmcInvoiceInfoModel.createInvoiceInfo(invoiceInfoDo);
        rspBo.setInvoiceId(invoiceInfo.getInvoiceId());
        return rspBo;
    }

    private List<UmcInvoiceInfoDo> qryInvByAccountId(Long accountId) {
        UmcInvoiceInfoQryBo qryBo = new UmcInvoiceInfoQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceInfoListRspBo umcInvoiceInfoListRspBo = this.iUmcInvoiceInfoModel.getInvoiceInfoList(qryBo);
        return umcInvoiceInfoListRspBo.getRows();
    }

    private List<UmcInvoiceInfoDo> qryInvByOrgId(Long orgId) {
        UmcInvoiceInfoQryBo qryBo = new UmcInvoiceInfoQryBo();
        qryBo.setOrgId(orgId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceInfoListRspBo umcInvoiceInfoListRspBo = this.iUmcInvoiceInfoModel.getInvoiceInfoList(qryBo);
        return umcInvoiceInfoListRspBo.getRows();
    }

    private void cancleMainFlagAddr(List<UmcInvoiceInfoDo> invoiceInfoDoList) {
        for (UmcInvoiceInfoDo invoiceInfoDo : invoiceInfoDoList) {
            UmcInvoiceInfoDo invoiceInfoDo1 = new UmcInvoiceInfoDo();
            invoiceInfoDo1.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            invoiceInfoDo1.setInvoiceId(invoiceInfoDo.getInvoiceId());
            invoiceInfoDo1.setDelFlag("0");
            this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo1);
        }
    }

    private void validationConpanyParams(UmcInvoiceInfoAddReqBo reqBo) {
        if (null == reqBo.getAccountId()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8d26\u5957ID[accountId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceType())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u578b[invoiceType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceTitle())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u62ac\u5934[invoiceTitle]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceClass())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u522b[invoiceClass]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.EntInvMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.EntInvMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u503c\u53ea\u80fd\u4e3a0\u62161");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerId())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerIdConfim())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u786e\u8ba4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerIdConfim]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBo.getTaxpayerId().equals(reqBo.getTaxpayerIdConfim())) {
            throw new BaseBusinessException("201001", "\u786e\u8ba4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4");
        }
        if ("00".equals(reqBo.getInvoiceType())) {
            if (StringUtils.isEmpty((CharSequence)reqBo.getAccount())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8d26\u6237[account]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getBank())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u5f00\u6237\u884c[bank]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getPhone())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7535\u8bdd[phone]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getAddress())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u5730\u5740[address]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void validationPersonParams(UmcInvoiceInfoAddReqBo reqBo) {
        if (null == reqBo.getAccountId()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8d26\u5957ID[accountId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceType())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u578b[invoiceType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceTitle())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u62ac\u5934[invoiceTitle]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceClass())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u522b[invoiceClass]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.EntInvMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.EntInvMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u503c\u53ea\u80fd\u4e3a0\u62161");
        }
        if ("COMPANY".equals(reqBo.getTitleType())) {
            if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerId())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerIdConfim())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u786e\u8ba4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerIdConfim]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

