/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoItemQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItemPageRspBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoListDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.repository.UmcUserInfoRepository;
import com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoPushBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService"})
public class UmcSendHaveDoneServiceImpl
implements UmcSendHaveDoneService {
    private static final Logger log = LoggerFactory.getLogger(UmcSendHaveDoneServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Value(value="${umc.have.done.sync.enable:true}")
    private boolean haveDoneSyncEnable;
    @Autowired
    private UmcUserInfoRepository umcUserInfoRepository;

    @PostMapping(value={"sendHaveDone"})
    public UmcSendHaveDoneRspBo sendHaveDone(@RequestBody UmcSendHaveDoneReqBo reqBO) {
        if (null == reqBO.getTodoId() && StringUtils.isBlank((CharSequence)reqBO.getBusiId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5f85\u529eid\uff0c\u4e1a\u52a1id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperUserId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5904\u7406\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperUserName())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5904\u7406\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcUserInfoQryBo umcUserInfoQryBo = new UmcUserInfoQryBo();
        umcUserInfoQryBo.setUserIdList(Collections.singletonList(Convert.toLong((Object)reqBO.getOperUserId())));
        List umcUserInfoQryBoList = this.umcUserInfoRepository.getUserOrgBaseInfoList(umcUserInfoQryBo).getRows();
        if (CollectionUtils.isEmpty((Collection)umcUserInfoQryBoList)) {
            throw new BaseBusinessException("200001", "\u64cd\u4f5c\u4eba\u9519\u8bef");
        }
        UmcUserInfoQryBo userInfo = (UmcUserInfoQryBo)((Object)umcUserInfoQryBoList.get(0));
        UmcTodoDone umcTodoDone = new UmcTodoDone();
        umcTodoDone.setTodoId(reqBO.getTodoId());
        umcTodoDone.setBusiId(reqBO.getBusiId());
        umcTodoDone.setOperId(reqBO.getOperUserId());
        umcTodoDone.setOperName(reqBO.getOperUserName());
        umcTodoDone.setTodoItemCode(reqBO.getTodoItemCode());
        umcTodoDone.setTodoUrl(reqBO.getDoneUrl());
        umcTodoDone.setTodoName(reqBO.getDoneName());
        umcTodoDone.setOperExtId(userInfo.getExtCustId());
        umcTodoDone.setOperOrgId(userInfo.getOrgId().toString());
        umcTodoDone.setOperOrgExtId(userInfo.getExtOrgId());
        umcTodoDone.setOperOrgName(userInfo.getOrgName());
        umcTodoDone.setOperTime(new Date());
        UmcTodoListDo umcTodoListDo = this.iUmcTodoModel.sendHaveDone(umcTodoDone);
        if (this.haveDoneSyncEnable && !CollectionUtils.isEmpty(umcTodoListDo.getUmcTodoDos())) {
            this.sendMq(reqBO, umcTodoListDo, umcTodoDone);
        }
        return UmcRu.success(UmcSendHaveDoneRspBo.class);
    }

    private void sendMq(UmcSendHaveDoneReqBo reqBO, UmcTodoListDo umcTodoListDo, UmcTodoDone umcTodoDone) {
        UmcTodoItem umcTodoItem;
        UmcTodoDo umcTodoDo = umcTodoListDo.getUmcTodoDos().get(0);
        UmcTodoItemQryBo umcTodoItemQryBo = new UmcTodoItemQryBo();
        umcTodoItemQryBo.setTodoItemCode(umcTodoDo.getTodoItemCode());
        UmcTodoItemPageRspBo umcTodoItemPageRspBo = this.iUmcTodoModel.selectTodoItemList(umcTodoItemQryBo);
        log.debug("umcTodoItemPageRspBo:{}", (Object)JSON.toJSONString((Object)((Object)umcTodoItemPageRspBo)));
        if (!CollectionUtils.isEmpty((Collection)umcTodoItemPageRspBo.getRows()) && "1".equals((umcTodoItem = (UmcTodoItem)umcTodoItemPageRspBo.getRows().get(0)).getPushFlag())) {
            for (UmcTodoDo todoDo : umcTodoListDo.getUmcTodoDos()) {
                UmcToDoPushBo umcToDoPushBo = new UmcToDoPushBo();
                umcToDoPushBo.setBusiId(todoDo.getBusiId());
                umcToDoPushBo.setTodoId(todoDo.getTodoId());
                umcToDoPushBo.setOperTime(umcTodoDone.getOperTime());
                umcToDoPushBo.setOperUserExtId(umcTodoDone.getOperExtId());
                umcToDoPushBo.setOperOrgId(umcTodoDone.getOperOrgId());
                umcToDoPushBo.setOperOrgExtId(umcTodoDone.getOperOrgExtId());
                umcToDoPushBo.setOperOrgName(umcTodoDone.getOperOrgName());
                umcToDoPushBo.setOperUserId(todoDo.getCandidateOperId());
                umcToDoPushBo.setOperUserName(todoDo.getCandidateOperName());
                umcToDoPushBo.setProcInstId(todoDo.getProcInstId());
                umcToDoPushBo.setProcInstKey(todoDo.getProcInstKey());
                umcToDoPushBo.setHaveDoneUrl(reqBO.getDoneUrl());
                if (UmcCommConstant.TodoState.DONE.equals(todoDo.getTodoState())) {
                    umcToDoPushBo.setTodoType(UmcCommConstant.TODO_TYPE.DONE);
                } else {
                    umcToDoPushBo.setTodoType(UmcCommConstant.TODO_TYPE.REVOKE);
                }
                this.proxyMessageProducer.send(new ProxyMessage(this.todoSyncTopic, this.todoSyncTag, JSON.toJSONString((Object)umcToDoPushBo)));
            }
        }
    }
}

