/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.supapproval.qrybo.UmcSupMisconductAuditBusiReqBO;
import com.tydic.dyc.umc.model.supapproval.sub.UmcSupMisconductAuditBusiRspBO;
import com.tydic.dyc.umc.repository.UmcSupMisconductAuditRepository;
import com.tydic.dyc.umc.repository.dao.SupplierAuditMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductDescMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductMapper;
import com.tydic.dyc.umc.repository.po.SupplierMisconductDescPO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductPO;
import java.util.Date;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmcSupMisconductAuditRepositoryImpl
implements UmcSupMisconductAuditRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcSupMisconductAuditRepositoryImpl.class);
    @Autowired
    private SupplierMisconductMapper supplierMisconductMapper;
    @Autowired
    private SupplierMisconductDescMapper supplierMisconductDescMapper;
    @Autowired
    private SupplierAuditMapper supplierAuditMapper;

    public UmcSupMisconductAuditBusiRspBO supMisconductAudit(UmcSupMisconductAuditBusiReqBO reqBO) {
        UmcSupMisconductAuditBusiRspBO rspBO = new UmcSupMisconductAuditBusiRspBO();
        HashSet<Long> misconductIds = new HashSet<Long>();
        for (Long misconductId : reqBO.getMisconductIds()) {
            misconductIds.add(misconductId);
        }
        HashSet auditSize = new HashSet();
        for (Long misconductId : reqBO.getMisconductIds()) {
            SupplierMisconductPO smPO = new SupplierMisconductPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)smPO);
            smPO.setOrgId(null);
            smPO.setOrgName(null);
            smPO.setAuditId(reqBO.getUserId());
            smPO.setAuditName(reqBO.getUserName());
            smPO.setAuditTime(new Date());
            smPO.setMisconductId(misconductId);
            if (reqBO.getAuditType().equals(UmcCommConstants.MisconductAuditType.APPROVED)) {
                smPO.setMisconductStatus(UmcCommConstants.MisconductStatus.APPROVED);
                smPO.setHandleStatus(UmcCommConstants.MisconductHandleStatus.HANDLED);
                smPO.setAppealStatus(UmcCommConstants.MisconductAppealStatus.APPEAL_WAIT);
            } else if (reqBO.getAuditType().equals(UmcCommConstants.MisconductAuditType.REFUSE)) {
                smPO.setMisconductStatus(UmcCommConstants.MisconductStatus.REFUSE);
                smPO.setHandleStatus(UmcCommConstants.MisconductHandleStatus.HANDLED_BACK);
            }
            this.supplierMisconductMapper.updateByPrimaryKeySelective(smPO);
            SupplierMisconductDescPO smdPO = new SupplierMisconductDescPO();
            smdPO.setMisconductId(misconductId);
            smdPO.setAuditDesc(reqBO.getAuditDesc());
            this.supplierMisconductDescMapper.updateByPrimaryKeySelective(smdPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

