/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.model.rating.DycUmcSupplierQueryRatingListBusiService;
import com.tydic.dyc.umc.model.rating.qrybo.DycUmcSupplierQueryRatingListBusiReqBO;
import com.tydic.dyc.umc.model.rating.sub.DycUmcSupplierQueryRatingListBusiRspBO;
import com.tydic.dyc.umc.repository.dao.AssessmentLevelSetMapper;
import com.tydic.dyc.umc.repository.dao.AssessmentRatingScoreMapper;
import com.tydic.dyc.umc.repository.dao.AssessmentScoreRecordTargetMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseAuditLogMapper;
import com.tydic.dyc.umc.repository.po.AssessmentLevelSetPO;
import com.tydic.dyc.umc.repository.po.AssessmentRatingScorePO;
import com.tydic.dyc.umc.repository.po.AssessmentScoreRecordTargetPO;
import com.tydic.dyc.umc.repository.po.UmcTaskPO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.rating.bo.QueryRatingListBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUmcSupplierQueryRatingListBusiServiceImpl
implements DycUmcSupplierQueryRatingListBusiService {
    @Autowired
    private AssessmentRatingScoreMapper assessmentRatingScoreMapper;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private AssessmentScoreRecordTargetMapper assessmentScoreRecordTargetMapper;
    @Autowired
    private AssessmentLevelSetMapper assessmentLevelSetMapper;
    @Autowired
    private UmcEnterpriseAuditLogMapper umcEnterpriseAuditLogMapper;
    private static final String SCORESTATUS = "1";

    public DycUmcSupplierQueryRatingListBusiRspBO queryRatingList(DycUmcSupplierQueryRatingListBusiReqBO reqBO) {
        DycUmcSupplierQueryRatingListBusiRspBO rspBO = new DycUmcSupplierQueryRatingListBusiRspBO();
        AssessmentRatingScorePO assessmentRatingScorePO = new AssessmentRatingScorePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)assessmentRatingScorePO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<AssessmentRatingScorePO> ratingScorePOS = null;
        if (!StringUtils.isBlank((String)reqBO.getScoreMin())) {
            assessmentRatingScorePO.setScoreMin(Double.parseDouble(reqBO.getScoreMin()));
        }
        if (!StringUtils.isBlank((String)reqBO.getScoreMax())) {
            assessmentRatingScorePO.setScoreMax(Double.parseDouble(reqBO.getScoreMax()));
        }
        if (!StringUtils.isEmpty((String)reqBO.getScoreStatus()) && reqBO.getScoreStatus().equals(SCORESTATUS)) {
            System.err.println("\u4e00\u8bc4\u5206");
            ratingScorePOS = this.assessmentRatingScoreMapper.selectListScoreFullAssess(assessmentRatingScorePO, (Page<AssessmentRatingScorePO>)page);
        } else {
            ratingScorePOS = this.assessmentRatingScoreMapper.selectListScore(assessmentRatingScorePO, (Page<AssessmentRatingScorePO>)page);
        }
        Map scoreStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "SCORE_STATUS");
        Map<Object, Object> levelMap = new HashMap();
        AssessmentLevelSetPO assessmentLevelSetPO = new AssessmentLevelSetPO();
        List<AssessmentLevelSetPO> assessmentLevelSetPOS = this.assessmentLevelSetMapper.selectRecList(assessmentLevelSetPO);
        if (!CollectionUtils.isEmpty(assessmentLevelSetPOS)) {
            levelMap = assessmentLevelSetPOS.stream().collect(Collectors.toMap(AssessmentLevelSetPO::getLevelCode, AssessmentLevelSetPO::getLevelName));
        }
        Map ratingRuleTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "RATING_RULE_TYPE");
        if (!CollectionUtils.isEmpty(ratingScorePOS)) {
            ArrayList<QueryRatingListBO> queryRatingListBOS = new ArrayList<QueryRatingListBO>();
            for (AssessmentRatingScorePO ratingScorePO : ratingScorePOS) {
                UmcTaskPO procInstId;
                QueryRatingListBO queryRatingListBO = new QueryRatingListBO();
                BeanUtils.copyProperties((Object)ratingScorePO, (Object)queryRatingListBO);
                if (null != ratingScorePO.getScoreStatus()) {
                    queryRatingListBO.setScoreStatusStr((String)scoreStatusMap.get(ratingScorePO.getScoreStatus()));
                }
                if (null != ratingScorePO.getScoreLevel()) {
                    queryRatingListBO.setScoreLevelStr((String)levelMap.get(ratingScorePO.getScoreLevel()));
                }
                if (null != ratingScorePO.getRatingRulesType()) {
                    queryRatingListBO.setRatingRulesTypeStr((String)ratingRuleTypeMap.get(ratingScorePO.getRatingRulesType()));
                }
                AssessmentScoreRecordTargetPO scoreRecordTargetPO = new AssessmentScoreRecordTargetPO();
                scoreRecordTargetPO.setSupplierRatingId(ratingScorePO.getSupplierRatingId());
                Integer allScored = this.assessmentScoreRecordTargetMapper.countRatingStatus(scoreRecordTargetPO);
                scoreRecordTargetPO.setScoreTargetStatus(SCORESTATUS);
                Integer scored = this.assessmentScoreRecordTargetMapper.countRatingStatus(scoreRecordTargetPO);
                queryRatingListBO.setScoringProgress(scored + "/" + allScored);
                if (allScored.equals(scored) && !"3".equals(queryRatingListBO.getScoreStatus())) {
                    queryRatingListBO.setScoreStatusStr("\u5df2\u8bc4\u5206");
                }
                if (null != ratingScorePO.getQuarterMonth()) {
                    queryRatingListBO.setRatingCycle(ratingScorePO.getYear() + "-" + ratingScorePO.getQuarterMonth());
                } else {
                    queryRatingListBO.setRatingCycle(ratingScorePO.getYear());
                }
                if (queryRatingListBO.getSupplierRatingId() != null && (procInstId = this.umcEnterpriseAuditLogMapper.procInst(queryRatingListBO.getSupplierRatingId())) != null) {
                    queryRatingListBO.setTaskId(procInstId.getTaskId());
                    queryRatingListBO.setProcInstId(procInstId.getProcInstId());
                }
                queryRatingListBOS.add(queryRatingListBO);
                rspBO.setRows(queryRatingListBOS);
            }
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

