/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.qualif.UmcEnterpriseQualifSaveBusiService;
import com.tydic.dyc.umc.model.qualif.qrybo.UmcEnterpriseQualifSaveBusiReqBO;
import com.tydic.dyc.umc.model.qualif.sub.UmcEnterpriseQualifSaveBusiRspBO;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseQualifMapper;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseQualifPO;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UmcEnterpriseQualifSaveBusiServiceImpl
implements UmcEnterpriseQualifSaveBusiService {
    @Autowired
    private UmcEnterpriseQualifMapper umcEnterpriseQualifMapper;
    private static final String INVALID = "0";
    private static final String EFFECTIVE = "1";

    public UmcEnterpriseQualifSaveBusiRspBO saveEnterpriseQualif(UmcEnterpriseQualifSaveBusiReqBO reqBO) {
        UmcEnterpriseQualifSaveBusiRspBO rspBO = new UmcEnterpriseQualifSaveBusiRspBO();
        UmcEnterpriseQualifPO umcEnterpriseQualifPO = new UmcEnterpriseQualifPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)umcEnterpriseQualifPO);
        LocalDateTime dateTime = LocalDateTime.now();
        LocalDateTime expTime = LocalDateTime.ofInstant(reqBO.getExpDate().toInstant(), ZoneId.systemDefault());
        if (dateTime.isAfter(expTime)) {
            umcEnterpriseQualifPO.setValidStatus(EFFECTIVE);
        } else {
            umcEnterpriseQualifPO.setValidStatus(INVALID);
        }
        if (StringUtils.isEmpty((Object)reqBO.getQualifSource())) {
            umcEnterpriseQualifPO.setQualifSource(EFFECTIVE);
        }
        umcEnterpriseQualifPO.setQualifFile(JSONObject.toJSONString((Object)reqBO.getQualifFile()));
        umcEnterpriseQualifPO.setCreateNo(reqBO.getMemIdIn());
        umcEnterpriseQualifPO.setCreateName(reqBO.getUserName());
        umcEnterpriseQualifPO.setCreateTime(new Date());
        umcEnterpriseQualifPO.setQualifId(Sequence.getInstance().nextId());
        umcEnterpriseQualifPO.setAuditStatus(reqBO.getAuditStatus());
        umcEnterpriseQualifPO.setQualifStatus(EFFECTIVE);
        umcEnterpriseQualifPO.setOrgId(reqBO.getOrgIdIn());
        umcEnterpriseQualifPO.setEnterpriseId(reqBO.getOrgIdIn());
        umcEnterpriseQualifPO.setEnterpriseName(reqBO.getCompanyName());
        umcEnterpriseQualifPO.setSupplierId(reqBO.getOrgIdIn());
        umcEnterpriseQualifPO.setSupplierName(reqBO.getCompanyName());
        umcEnterpriseQualifPO.setSubmitName(reqBO.getName());
        umcEnterpriseQualifPO.setSubmitNo(reqBO.getMemIdIn());
        umcEnterpriseQualifPO.setSubmitTime(new Date());
        int insertFlag = this.umcEnterpriseQualifMapper.insert(umcEnterpriseQualifPO);
        if (insertFlag < 1) {
            throw new BaseBusinessException("161003", "\u4f01\u4e1a\u8d44\u8d28\u4fe1\u606f\u65b0\u589e\u5931\u8d25!");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f01\u4e1a\u8d44\u8d28\u4fe1\u606f\u65b0\u589e\u6210\u529f\uff01");
        rspBO.setQualifId(umcEnterpriseQualifPO.getQualifId());
        return rspBO;
    }
}

