/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcQryWaitDoneConfigListQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoDoneQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoItemQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoCount;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.model.todo.sub.UmcWaitDoneConfig;
import com.tydic.dyc.umc.repository.UmcTodoRepository;
import com.tydic.dyc.umc.repository.dao.UmcTodoDoneMapper;
import com.tydic.dyc.umc.repository.dao.UmcTodoItemMapper;
import com.tydic.dyc.umc.repository.dao.UmcTodoMapper;
import com.tydic.dyc.umc.repository.dao.UmcWaitDoneConfigMapper;
import com.tydic.dyc.umc.repository.dao.UmcWaitDoneItemMapper;
import com.tydic.dyc.umc.repository.po.UmcTodoCountPo;
import com.tydic.dyc.umc.repository.po.UmcTodoDonePo;
import com.tydic.dyc.umc.repository.po.UmcTodoItemPo;
import com.tydic.dyc.umc.repository.po.UmcTodoPo;
import com.tydic.dyc.umc.repository.po.UmcWaitDoneConfigPo;
import com.tydic.dyc.umc.repository.po.UmcWaitDoneItemPo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcTodoRepositoryImpl
implements UmcTodoRepository {
    @Autowired
    private UmcTodoMapper umcTodoMapper;
    @Autowired
    private UmcTodoDoneMapper umcTodoDoneMapper;
    @Autowired
    private UmcTodoItemMapper umcTodoItemMapper;
    @Autowired
    private UmcWaitDoneItemMapper umcWaitDoneItemMapper;
    @Autowired
    private UmcWaitDoneConfigMapper umcWaitDoneConfigMapper;

    public List<UmcTodoCount> selectTodoCount(UmcTodoQryBo umcTodoQryBo) {
        List<UmcTodoCountPo> umcTodoCountPos = this.umcTodoMapper.selectTodoCount((UmcTodoPo)UmcRu.js((Object)umcTodoQryBo, UmcTodoPo.class));
        return UmcRu.jsl(umcTodoCountPos, UmcTodoCount.class);
    }

    public BasePageRspBo<UmcTodoItem> selectTodoItemListPage(UmcTodoItemQryBo umcTodoItemQryBo) {
        UmcTodoItemPo umcTodoItemPo = (UmcTodoItemPo)UmcRu.js((Object)umcTodoItemQryBo, UmcTodoItemPo.class);
        Page page = new Page(umcTodoItemQryBo.getPageNo(), umcTodoItemQryBo.getPageSize());
        List<UmcTodoItemPo> umcTodoItemPos = this.umcTodoItemMapper.selectListPage(umcTodoItemPo, (Page<UmcTodoItemPo>)page);
        BasePageRspBo pageRspBo = new BasePageRspBo();
        pageRspBo.setPageNo(page.getPageNo());
        pageRspBo.setTotal(page.getTotalPages());
        pageRspBo.setRecordsTotal(page.getTotalCount());
        pageRspBo.setRows(UmcRu.jsl(umcTodoItemPos, UmcTodoItem.class));
        return pageRspBo;
    }

    public List<UmcTodoItem> selectTodoItemList(UmcTodoItemQryBo umcTodoItemQryBo) {
        UmcTodoItemPo umcTodoItemPo = (UmcTodoItemPo)UmcRu.js((Object)umcTodoItemQryBo, UmcTodoItemPo.class);
        List<UmcTodoItemPo> umcTodoItemPos = this.umcTodoItemMapper.selectByCondition(umcTodoItemPo);
        return UmcRu.jsl(umcTodoItemPos, UmcTodoItem.class);
    }

    public BasePageRspBo<UmcTodoDo> selectTodoListPage(UmcTodoQryBo umcTodoQryBo) {
        Page page = new Page(umcTodoQryBo.getPageNo(), umcTodoQryBo.getPageSize());
        List<UmcTodoPo> umcTodoPos = this.umcTodoMapper.selectListPage((UmcTodoPo)UmcRu.js((Object)umcTodoQryBo, UmcTodoPo.class), (Page<UmcTodoPo>)page);
        List umcTodoDos = UmcRu.jsl(umcTodoPos, UmcTodoDo.class);
        BasePageRspBo pageRspBo = new BasePageRspBo();
        pageRspBo.setPageNo(page.getPageNo());
        pageRspBo.setRecordsTotal(page.getTotalCount());
        pageRspBo.setTotal(page.getTotalPages());
        pageRspBo.setRows(umcTodoDos);
        return pageRspBo;
    }

    public List<UmcTodoDo> selectTodoList(UmcTodoQryBo umcTodoQryBo) {
        List<UmcTodoPo> umcTodoPos = this.umcTodoMapper.selectByCondition((UmcTodoPo)UmcRu.js((Object)umcTodoQryBo, UmcTodoPo.class));
        return UmcRu.jsl(umcTodoPos, UmcTodoDo.class);
    }

    public BasePageRspBo<UmcTodoDone> selectDoneListPage(UmcTodoDoneQryBo umcTodoDoneQryBo) {
        Page page = new Page(umcTodoDoneQryBo.getPageNo(), umcTodoDoneQryBo.getPageSize());
        UmcTodoDonePo umcTodoDonePo = (UmcTodoDonePo)UmcRu.js((Object)umcTodoDoneQryBo, UmcTodoDonePo.class);
        List<UmcTodoDonePo> umcTodoDonePos = this.umcTodoDoneMapper.selectListPage(umcTodoDonePo, (Page<UmcTodoDonePo>)page);
        BasePageRspBo pageRspBo = new BasePageRspBo();
        pageRspBo.setPageNo(page.getPageNo());
        pageRspBo.setTotal(page.getTotalPages());
        pageRspBo.setRecordsTotal(page.getTotalCount());
        pageRspBo.setRows(UmcRu.jsl(umcTodoDonePos, UmcTodoDone.class));
        return pageRspBo;
    }

    public int createTodo(List<UmcTodoDo> umcTodoDos) {
        return this.umcTodoMapper.insertBatch(UmcRu.jsl(umcTodoDos, UmcTodoPo.class));
    }

    public int createDone(List<UmcTodoDone> umcTodoDones) {
        return this.umcTodoDoneMapper.insertBatch(UmcRu.jsl(umcTodoDones, UmcTodoDonePo.class));
    }

    public int deleteTodo(UmcTodoDo umcTodoDo) {
        return this.umcTodoMapper.delete((UmcTodoPo)UmcRu.js((Object)umcTodoDo, UmcTodoPo.class));
    }

    public List<UmcTodoItem> selectWaitDoneList(UmcTodoItem js) {
        List itemCodes;
        String fieldValue;
        if (js.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2userID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<UmcTodoItem> umcWaitDoneBOS = new ArrayList<UmcTodoItem>();
        UmcWaitDoneItemPo js1 = (UmcWaitDoneItemPo)UmcRu.js((Object)js, UmcWaitDoneItemPo.class);
        js1.setDelFlag("0");
        List<UmcWaitDoneItemPo> list = this.umcWaitDoneItemMapper.getList(js1);
        if (!(CollectionUtils.isEmpty(list) || StringUtils.isBlank((CharSequence)(fieldValue = list.get(0).getWaitDoneValue())) || CollectionUtils.isEmpty((Collection)(itemCodes = JSON.parseArray((String)fieldValue, String.class))))) {
            for (String itemCode : itemCodes) {
                UmcTodoItem umcWaitDoneBO = new UmcTodoItem();
                umcWaitDoneBO.setTodoItemCode(itemCode);
                umcWaitDoneBOS.add(umcWaitDoneBO);
            }
        }
        return umcWaitDoneBOS;
    }

    public void ealWaitDoneSet(UmcTodoItem reqItem) {
        UmcWaitDoneItemPo insertPo = new UmcWaitDoneItemPo();
        insertPo.setWaitDoneId(IdUtil.nextId());
        insertPo.setUserId(reqItem.getUserId());
        insertPo.setDelFlag("0");
        insertPo.setWaitDoneValue(reqItem.getTodoItemCode());
        int insert = this.umcWaitDoneItemMapper.insert(insertPo);
        if (insert < 1) {
            throw new BaseBusinessException("200100", "\u63d2\u5165\u6570\u636e\u5931\u8d25");
        }
    }

    public void deleteWaiteDoneItem(UmcTodoItem deleteItem) {
        UmcWaitDoneItemPo deleteWherePo = new UmcWaitDoneItemPo();
        deleteWherePo.setUserId(deleteItem.getUserId());
        UmcWaitDoneItemPo deleteSetPo = new UmcWaitDoneItemPo();
        deleteSetPo.setDelFlag("1");
        int i = this.umcWaitDoneItemMapper.updateBy(deleteSetPo, deleteWherePo);
    }

    public List<UmcWaitDoneConfig> qryWaitDoneList(UmcQryWaitDoneConfigListQryBo noNullStringAttr) {
        ArrayList configs = new ArrayList();
        Page page = new Page(noNullStringAttr.getPageNo().intValue(), noNullStringAttr.getPageSize().intValue());
        List<UmcWaitDoneConfigPo> listPage = this.umcWaitDoneConfigMapper.getListPage((UmcWaitDoneConfigPo)UmcRu.js((Object)noNullStringAttr, UmcWaitDoneConfigPo.class), (Page<UmcWaitDoneConfigPo>)page);
        if (CollectionUtils.isEmpty(listPage)) {
            return new ArrayList<UmcWaitDoneConfig>();
        }
        return UmcRu.jsl(listPage, UmcWaitDoneConfig.class);
    }
}

