/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoSyncListQryReqBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoSyncListQryRspBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcMemberQryListPageQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserRoleRelQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserTagRelQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcBatchAddUser;
import com.tydic.dyc.umc.model.user.sub.UmcCustExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfoSyncTemp;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfos;
import com.tydic.dyc.umc.model.user.sub.UmcMember;
import com.tydic.dyc.umc.model.user.sub.UmcMemberQryListPageRspBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcUserInfoDos;
import com.tydic.dyc.umc.model.user.sub.UmcUserInfoQryRspBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRelListBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRelDos;
import com.tydic.dyc.umc.repository.UmcUserInfoRepository;
import com.tydic.dyc.umc.repository.dao.UmcCustExtMapMapper;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoSyncTempMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserExtMapMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserRoleRelMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserTagRelMapper;
import com.tydic.dyc.umc.repository.po.UmcCustExtMapPo;
import com.tydic.dyc.umc.repository.po.UmcCustInfoPo;
import com.tydic.dyc.umc.repository.po.UmcCustInfoSyncTempPO;
import com.tydic.dyc.umc.repository.po.UmcMemberPo;
import com.tydic.dyc.umc.repository.po.UmcMemberQryListPageQryPo;
import com.tydic.dyc.umc.repository.po.UmcUserExtMapPo;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserRoleRelPo;
import com.tydic.dyc.umc.repository.po.UmcUserTagRelPo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcUserInfoRepositoryImpl
implements UmcUserInfoRepository {
    @Autowired
    private UmcCustExtMapMapper umcCustExtMapMapper;
    @Autowired
    private UmcCustInfoMapper umcCustInfoMapper;
    @Autowired
    private UmcUserExtMapMapper umcUserExtMapMapper;
    @Autowired
    private UmcUserInfoMapper umcUserInfoMapper;
    @Autowired
    private UmcUserRoleRelMapper umcUserRoleRelMapper;
    @Autowired
    private UmcUserTagRelMapper umcUserTagRelMapper;
    @Autowired
    private UmcCustInfoSyncTempMapper umcCustInfoSyncTempMapper;

    public UmcUserInfoDo createUserInfo(UmcUserInfoDo userInfoDo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)userInfoDo, UmcUserInfoPo.class);
        this.umcUserInfoMapper.insert(umcUserInfoPo);
        if (ObjectUtil.isNotEmpty((Object)userInfoDo.getUserTagRelList())) {
            List umcUserTagRelPoList = UmcRu.jsl((List)userInfoDo.getUserTagRelList(), UmcUserTagRelPo.class);
            this.umcUserTagRelMapper.insertBatch(umcUserTagRelPoList);
        }
        if (ObjectUtil.isNotEmpty((Object)userInfoDo.getUserRoleRelList())) {
            List umcUserRoleRelPoList = UmcRu.jsl((List)userInfoDo.getUserRoleRelList(), UmcUserRoleRelPo.class);
            this.umcUserRoleRelMapper.insertBatch(umcUserRoleRelPoList);
        }
        if (ObjectUtil.isNotEmpty((Object)userInfoDo.getUserExtMapList())) {
            List umcUserExtMapPoList = UmcRu.jsl((List)userInfoDo.getUserExtMapList(), UmcUserExtMapPo.class);
            this.umcUserExtMapMapper.insertBatch(umcUserExtMapPoList);
        }
        return userInfoDo;
    }

    public UmcCustInfo createCustInfo(UmcCustInfo custInfo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)custInfo, UmcCustInfoPo.class);
        this.umcCustInfoMapper.insert(umcCustInfoPo);
        if (ObjectUtil.isNotEmpty((Object)custInfo.getCustExtMapList())) {
            List umcCustExtMapPoList = UmcRu.jsl((List)custInfo.getCustExtMapList(), UmcCustExtMapPo.class);
            this.umcCustExtMapMapper.insertBatch(umcCustExtMapPoList);
        }
        return custInfo;
    }

    public void updateUserInfo(UmcUserInfoDo set) {
        UmcUserInfoPo setPo = (UmcUserInfoPo)UmcRu.js((Object)set, UmcUserInfoPo.class);
        UmcUserInfoPo wherePo = new UmcUserInfoPo();
        wherePo.setUserId(set.getUserId());
        StrUtil.noNullStringAttr((Object)setPo);
        StrUtil.noNullStringAttr((Object)wherePo);
        this.umcUserInfoMapper.updateBy(setPo, wherePo);
        if (ObjectUtil.isNotEmpty((Object)set.getUserRoleRelList())) {
            for (UmcUserRoleRel userRoleRel : set.getUserRoleRelList()) {
                UmcUserRoleRelPo umcUserRoleRelPo = (UmcUserRoleRelPo)UmcRu.js((Object)userRoleRel, UmcUserRoleRelPo.class);
                StrUtil.noNullStringAttr((Object)umcUserRoleRelPo);
                if (null == umcUserRoleRelPo.getRelId()) {
                    umcUserRoleRelPo.setRelId(IdUtil.nextId());
                    this.umcUserRoleRelMapper.insert(umcUserRoleRelPo);
                    continue;
                }
                int i = this.umcUserRoleRelMapper.updateById(umcUserRoleRelPo);
                if (i == 1) continue;
                throw new BaseBusinessException("203003", "\u7528\u6237\u66f4\u65b0\u5931\u8d25\uff0c\u66f4\u65b0\u7528\u6237\u89d2\u8272\u5931\u8d25\uff01");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)set.getUserExtMapList())) {
            for (UmcUserExtMap userExtMap : set.getUserExtMapList()) {
                UmcUserExtMapPo umcUserExtMapPo = (UmcUserExtMapPo)UmcRu.js((Object)userExtMap, UmcUserExtMapPo.class);
                StrUtil.noNullStringAttr((Object)umcUserExtMapPo);
                this.umcUserExtMapMapper.updateById(umcUserExtMapPo);
            }
        }
    }

    public void updateCustInfo(UmcCustInfo set) {
        UmcCustInfoPo setPo = (UmcCustInfoPo)UmcRu.js((Object)set, UmcCustInfoPo.class);
        UmcCustInfoPo wherePo = new UmcCustInfoPo();
        wherePo.setCustId(setPo.getCustId());
        StrUtil.noNullStringAttr((Object)setPo);
        StrUtil.noNullStringAttr((Object)wherePo);
        this.umcCustInfoMapper.updateBy(setPo, wherePo);
        if (ObjectUtil.isNotEmpty((Object)set.getCustExtMapList())) {
            for (UmcCustExtMap custExtMap : set.getCustExtMapList()) {
                UmcCustExtMapPo umcCustExtMapPo = (UmcCustExtMapPo)UmcRu.js((Object)custExtMap, UmcCustExtMapPo.class);
                StrUtil.noNullStringAttr((Object)umcCustExtMapPo);
                this.umcCustExtMapMapper.updateById(umcCustExtMapPo);
            }
        }
    }

    public UmcUserInfoDo getUserInfo(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        if (null == (umcUserInfoPo = this.umcUserInfoMapper.getModelBy(umcUserInfoPo))) {
            throw new BaseBusinessException("203004", "\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u7528\u6237\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcUserInfoDo userInfoDo = (UmcUserInfoDo)UmcRu.js((Object)umcUserInfoPo, UmcUserInfoDo.class);
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        umcUserTagRelPo.setUserId(umcUserInfoPo.getUserId());
        List<UmcUserTagRelPo> umcUserTagRelPoList = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        if (!CollectionUtils.isEmpty(umcUserTagRelPoList)) {
            userInfoDo.setUserTagRelList(UmcRu.jsl(umcUserTagRelPoList, UmcUserTagRel.class));
        }
        UmcUserRoleRelPo userRoleRelPo = new UmcUserRoleRelPo();
        userRoleRelPo.setUserId(umcUserInfoPo.getUserId());
        List<UmcUserRoleRelPo> umcUserRoleRelPoList = this.umcUserRoleRelMapper.getList(userRoleRelPo);
        if (!CollectionUtils.isEmpty(umcUserRoleRelPoList)) {
            userInfoDo.setUserRoleRelList(UmcRu.jsl(umcUserRoleRelPoList, UmcUserRoleRel.class));
        }
        UmcUserExtMapPo umcUserExtMapPo = new UmcUserExtMapPo();
        umcUserExtMapPo.setUserId(umcUserInfoPo.getUserId());
        List<UmcUserExtMapPo> umcUserExtMapPoList = this.umcUserExtMapMapper.getList(umcUserExtMapPo);
        if (!CollectionUtils.isEmpty(umcUserExtMapPoList)) {
            userInfoDo.setUserExtMapList(UmcRu.jsl(umcUserExtMapPoList, UmcUserExtMap.class));
        }
        return userInfoDo;
    }

    public UmcCustInfo getCustInfo(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)qryBo, UmcCustInfoPo.class);
        if (ObjectUtil.isEmpty((Object)(umcCustInfoPo = this.umcCustInfoMapper.getModelBy(umcCustInfoPo)))) {
            throw new BaseBusinessException("203004", "\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u5ba2\u6237\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcCustInfo custInfo = (UmcCustInfo)UmcRu.js((Object)umcCustInfoPo, UmcCustInfo.class);
        UmcCustExtMapPo umcCustExtMapPo = new UmcCustExtMapPo();
        umcCustExtMapPo.setCustId(umcCustInfoPo.getCustId());
        List<UmcCustExtMapPo> umcCustExtMapPoList = this.umcCustExtMapMapper.getList(umcCustExtMapPo);
        if (ObjectUtil.isNotEmpty(umcCustExtMapPoList)) {
            custInfo.setCustExtMapList(UmcRu.jsl(umcCustExtMapPoList, UmcCustExtMap.class));
        }
        return custInfo;
    }

    public UmcUserInfoDos getUserInfoPageList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        if (null != qryBo.getCustInfo()) {
            umcUserInfoPo.setRegAccount(qryBo.getCustInfo().getRegAccount());
            umcUserInfoPo.setRegMobile(qryBo.getCustInfo().getRegMobile());
            umcUserInfoPo.setCustName(qryBo.getCustInfo().getCustName());
        }
        StrUtil.noNullStringAttr((Object)umcUserInfoPo);
        List<UmcUserInfoDo> umcUserInfoDoList = this.umcUserInfoMapper.getListPage(umcUserInfoPo, (Page<UmcUserInfoPo>)page);
        if (!CollectionUtils.isEmpty(umcUserInfoDoList)) {
            for (UmcUserInfoDo row : umcUserInfoDoList) {
                if (StringUtils.isEmpty((CharSequence)row.getUserTagRel())) continue;
                List<String> userTagRels = Arrays.asList(row.getUserTagRel().split(","));
                List userTagRelList = userTagRels.stream().map(item -> {
                    UmcUserTagRel userTagRel = new UmcUserTagRel();
                    userTagRel.setUserId(row.getUserId());
                    userTagRel.setTagId(item);
                    return userTagRel;
                }).collect(Collectors.toList());
                row.setUserTagRelList(userTagRelList);
            }
        }
        UmcUserInfoDos rspBo = new UmcUserInfoDos();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(umcUserInfoDoList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UmcCustInfos getCustInfoPageList(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)qryBo, UmcCustInfoPo.class);
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        List<UmcCustInfoPo> umcCustInfoPoList = this.umcCustInfoMapper.getListPage(umcCustInfoPo, (Page<UmcCustInfoPo>)page);
        UmcCustInfos rspBo = new UmcCustInfos();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(umcCustInfoPoList) ? UmcRu.jsl(umcCustInfoPoList, UmcCustInfo.class) : new ArrayList(0));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UmcCustInfos getCustInfoList(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)qryBo, UmcCustInfoPo.class);
        List<UmcCustInfoPo> umcCustInfoPoList = this.umcCustInfoMapper.getList(umcCustInfoPo);
        UmcCustInfos umcUserInfoDos = new UmcCustInfos();
        umcUserInfoDos.setRows(UmcRu.jsl(umcCustInfoPoList, UmcCustInfo.class));
        return umcUserInfoDos;
    }

    public UmcUserInfoDo getCheckUserInfo(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        int checkBy = this.umcUserInfoMapper.getCheckBy(umcUserInfoPo);
        UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
        umcUserInfoDo.setCheck(Integer.valueOf(checkBy));
        return umcUserInfoDo;
    }

    public UmcUserTagRelDos getUserTagRel(UmcUserTagRelQryBo qryBo) {
        UmcUserTagRelPo umcUserTagRelPo = (UmcUserTagRelPo)UmcRu.js((Object)qryBo, UmcUserTagRelPo.class);
        List<UmcUserTagRelPo> umcUserTagRelPoList = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        UmcUserTagRelDos umcUserTagRelDos = new UmcUserTagRelDos();
        umcUserTagRelDos.setRows(UmcRu.jsl(umcUserTagRelPoList, UmcUserTagRel.class));
        return umcUserTagRelDos;
    }

    public UmcUserRoleRelListBo getUserRoleRel(UmcUserRoleRelQryBo qryBo) {
        UmcUserRoleRelPo umcUserRoleRelPo = (UmcUserRoleRelPo)UmcRu.js((Object)qryBo, UmcUserRoleRelPo.class);
        List<UmcUserRoleRelPo> umcUserRoleRelPoList = this.umcUserRoleRelMapper.getList(umcUserRoleRelPo);
        UmcUserRoleRelListBo umcUserRoleRelListBo = new UmcUserRoleRelListBo();
        umcUserRoleRelListBo.setRows(UmcRu.jsl(umcUserRoleRelPoList, UmcUserRoleRel.class));
        return umcUserRoleRelListBo;
    }

    public UmcUserInfoQryRspBo getUserInfoList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getList(umcUserInfoPo);
        List rows = new ArrayList(umcUserInfoPoList.size());
        if (!CollectionUtils.isEmpty(umcUserInfoPoList)) {
            rows = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoQryBo.class);
            for (UmcUserInfoQryBo row : rows) {
                UmcCustInfoPo umcCustInfoPo = new UmcCustInfoPo();
                umcCustInfoPo.setCustId(row.getCustId());
                UmcCustInfoPo umcCustInfoPo1 = this.umcCustInfoMapper.getModelBy(umcCustInfoPo);
                if (null == umcCustInfoPo1) {
                    throw new BaseBusinessException("203004", "\u7528\u6237\u5206\u9875\u5217\u8868\u67e5\u8be2\uff0c\u7528\u6237\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
                }
                row.setCustInfo((UmcCustInfo)UmcRu.js((Object)umcCustInfoPo1, UmcCustInfo.class));
            }
        }
        UmcUserInfoQryRspBo umcUserInfoQryRspBo = new UmcUserInfoQryRspBo();
        umcUserInfoQryRspBo.setRows(rows);
        return umcUserInfoQryRspBo;
    }

    public UmcUserInfoQryRspBo getUserInfoWithoutCustList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getList(umcUserInfoPo);
        List rows = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoQryBo.class);
        UmcUserInfoQryRspBo umcUserInfoQryRspBo = new UmcUserInfoQryRspBo();
        umcUserInfoQryRspBo.setRows(rows);
        return umcUserInfoQryRspBo;
    }

    public UmcMemberQryListPageRspBo qryMemberListPage(UmcMemberQryListPageQryBo qryBo) {
        UmcMemberQryListPageRspBo rspBo = new UmcMemberQryListPageRspBo();
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        List<UmcMemberPo> list = this.umcUserInfoMapper.qryMemberListPage((UmcMemberQryListPageQryPo)((Object)UmcRu.js((Object)qryBo, UmcMemberQryListPageQryPo.class)), (Page<UmcMemberPo>)page);
        if (CollectionUtils.isEmpty(list)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        rspBo.setRows(UmcRu.jsl(list, UmcMember.class));
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setRespCode("0000");
        rspBo.setPageNo(qryBo.getPageNo());
        return rspBo;
    }

    public UmcUserInfoDo getCheckCustInfo(UmcCustInfoQryBo umcCustInfoQryBo) {
        int checkBy = this.umcCustInfoMapper.getCheckBy((UmcCustInfoPo)UmcRu.js((Object)umcCustInfoQryBo, UmcCustInfoPo.class));
        UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
        umcUserInfoDo.setCheck(Integer.valueOf(checkBy));
        return umcUserInfoDo;
    }

    public UmcUserTagRel addUserTagRel(UmcUserTagRel userTagRel) {
        if (null == userTagRel.getRelId()) {
            userTagRel.setRelId(Long.valueOf(IdUtil.nextId()));
        }
        UmcUserTagRelPo umcUserTagRelPo = (UmcUserTagRelPo)UmcRu.js((Object)userTagRel, UmcUserTagRelPo.class);
        this.umcUserTagRelMapper.insert(umcUserTagRelPo);
        return userTagRel;
    }

    public UmcUserTagRel updateUserTagRel(UmcUserTagRel set) {
        UmcUserTagRelPo setPo = (UmcUserTagRelPo)UmcRu.js((Object)set, UmcUserTagRelPo.class);
        UmcUserTagRelPo wherePo = new UmcUserTagRelPo();
        wherePo.setRelId(set.getRelId());
        wherePo.setUserId(set.getUserId());
        wherePo.setTagId(set.getTagId());
        this.umcUserTagRelMapper.updateBy(setPo, wherePo);
        return set;
    }

    public UmcUserInfoDos qryOrgUserByUserTag(UmcUserInfoQryBo qryBo) {
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.qryOrgUserByUserTag(qryBo);
        UmcUserInfoDos umcUserInfoDos = new UmcUserInfoDos();
        umcUserInfoDos.setRows(UmcRu.jsl(umcUserInfoPoList, UmcUserInfoDo.class));
        return umcUserInfoDos;
    }

    public void addCustInfoSyncTemp(UmcUserInfoDo umcUserInfoDo) {
        List<UmcCustInfoSyncTempPO> umcCustInfoSyncTempPOS = umcUserInfoDo.getUmcCustInfoSyncTemps().stream().map(umcCustInfoSyncTemp -> {
            UmcCustInfoSyncTempPO umcCustInfoSyncTempPO = (UmcCustInfoSyncTempPO)UmcRu.js((Object)umcCustInfoSyncTemp, UmcCustInfoSyncTempPO.class);
            umcCustInfoSyncTempPO.setId(Sequence.getInstance().nextId());
            umcCustInfoSyncTempPO.setSyncTime(new Date());
            if (null == umcCustInfoSyncTemp.getDealResult()) {
                umcCustInfoSyncTempPO.setDealResult(UmcStatusConstant.SyncDealResult.TO_DEAL);
            }
            if (!CollectionUtils.isEmpty((Collection)umcCustInfoSyncTemp.getUmcSyncExtBoList())) {
                umcCustInfoSyncTempPO.setExtField(JSONObject.toJSONString((Object)umcCustInfoSyncTemp.getUmcSyncExtBoList()));
            }
            if (!CollectionUtils.isEmpty((Collection)umcCustInfoSyncTemp.getUmcUserSyncRoleBos())) {
                umcCustInfoSyncTempPO.setRoleJson(JSONObject.toJSONString((Object)umcCustInfoSyncTemp.getUmcUserSyncRoleBos()));
            }
            return umcCustInfoSyncTempPO;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(umcCustInfoSyncTempPOS)) {
            this.umcCustInfoSyncTempMapper.insertBatch(umcCustInfoSyncTempPOS);
        }
    }

    public UmcCustInfoSyncListQryRspBo qryCustInfoTempList(UmcCustInfoSyncListQryReqBo umcCustInfoSyncListQryReqBo) {
        Page poPag = new Page(umcCustInfoSyncListQryReqBo.getPageNo().intValue(), umcCustInfoSyncListQryReqBo.getPageSize().intValue());
        UmcCustInfoSyncTempPO umcCustInfoSyncTempPO = (UmcCustInfoSyncTempPO)UmcRu.js((Object)umcCustInfoSyncListQryReqBo, UmcCustInfoSyncTempPO.class);
        List<UmcCustInfoSyncTempPO> umcCustInfoSyncTempPOS = this.umcCustInfoSyncTempMapper.getListPage(umcCustInfoSyncTempPO, (Page<UmcCustInfoSyncTempPO>)poPag);
        UmcCustInfoSyncListQryRspBo umcCustInfoSyncListQryRspBo = new UmcCustInfoSyncListQryRspBo();
        umcCustInfoSyncListQryRspBo.setRows(UmcRu.jsl(umcCustInfoSyncTempPOS, UmcCustInfoSyncTemp.class));
        umcCustInfoSyncListQryRspBo.setPageNo(umcCustInfoSyncListQryReqBo.getPageNo().intValue());
        umcCustInfoSyncListQryRspBo.setTotal(poPag.getTotalPages());
        umcCustInfoSyncListQryRspBo.setRecordsTotal(poPag.getTotalCount());
        return umcCustInfoSyncListQryRspBo;
    }

    public void updateCustSyncInfoTempState(UmcUserInfoDo umcUserInfoDo) {
        UmcCustInfoSyncTemp umcCustInfoSyncTemp = umcUserInfoDo.getUmcCustInfoSyncTemp();
        if (!CollectionUtils.isEmpty((Collection)umcCustInfoSyncTemp.getIds())) {
            UmcCustInfoSyncTempPO set = new UmcCustInfoSyncTempPO();
            set.setDealResult(umcCustInfoSyncTemp.getDealResult());
            UmcCustInfoSyncTempPO where = new UmcCustInfoSyncTempPO();
            where.setIds(umcCustInfoSyncTemp.getIds());
            this.umcCustInfoSyncTempMapper.updateBy(set, where);
        }
    }

    public void updateCustSyncInfoTemp(UmcUserInfoDo umcUserInfoDo) {
        if (null != umcUserInfoDo.getUmcCustInfoSyncTemp().getDealResult()) {
            this.umcCustInfoSyncTempMapper.updateByDealResoult(umcUserInfoDo.getUmcCustInfoSyncTemp().getDealResult());
        }
    }

    public void delUserRoleByUserId(UmcUserRoleRel umcUserRoleRel) {
        if (null != umcUserRoleRel && null != umcUserRoleRel.getUserId()) {
            UmcUserRoleRelPo set = new UmcUserRoleRelPo();
            UmcUserRoleRelPo where = new UmcUserRoleRelPo();
            set.setDelFlag(umcUserRoleRel.getDelFlag());
            where.setUserId(umcUserRoleRel.getUserId());
            this.umcUserRoleRelMapper.updateBy(set, where);
        }
    }

    public void addUser(UmcBatchAddUser umcBatchAddUser) {
        if (null != umcBatchAddUser) {
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserInfoDoList())) {
                this.umcUserInfoMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserInfoDoList(), UmcUserInfoPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getCustInfoList())) {
                this.umcCustInfoMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getCustInfoList(), UmcCustInfoPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserRoleRelList())) {
                this.umcUserRoleRelMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserRoleRelList(), UmcUserRoleRelPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserTagRelList())) {
                this.umcUserTagRelMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserTagRelList(), UmcUserTagRelPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserExtMapList())) {
                this.umcUserExtMapMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserExtMapList(), UmcUserExtMapPo.class));
            }
        }
    }
}

