/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.signcontractapply.UmcSignContractApplyDo;
import com.tydic.dyc.umc.model.signcontractapply.qrybo.UmcGetSignContractApplyPageListBo;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractLog;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractYearRuleApply;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignSalesCategoryApply;
import com.tydic.dyc.umc.repository.UmcSignContractApplyRepository;
import com.tydic.dyc.umc.repository.dao.UmcSignContractApplyMapper;
import com.tydic.dyc.umc.repository.dao.UmcSignContractLogMapper;
import com.tydic.dyc.umc.repository.dao.UmcSignContractYearRuleApplyMapper;
import com.tydic.dyc.umc.repository.dao.UmcSignSalesCategoryApplyMapper;
import com.tydic.dyc.umc.repository.po.UmcSignContractApplyPo;
import com.tydic.dyc.umc.repository.po.UmcSignContractLogPo;
import com.tydic.dyc.umc.repository.po.UmcSignContractYearRuleApplyPo;
import com.tydic.dyc.umc.repository.po.UmcSignSalesCategoryApplyPo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UmcSignContractApplyRepositoryImpl
implements UmcSignContractApplyRepository {
    @Autowired
    private UmcSignContractApplyMapper umcSignContractApplyMapper;
    @Autowired
    private UmcSignSalesCategoryApplyMapper umcSignSalesCategoryApplyMapper;
    @Autowired
    private UmcSignContractYearRuleApplyMapper umcSignContractYearRuleApplyMapper;
    @Autowired
    private UmcSignContractLogMapper umcSignContractLogMapper;
    private static final String NOT_CHARGE_YEAR_FEE = "0";
    private static final String CHARGE_YEAR_FEE_CONFIRM = "1";
    private Sequence sequence = Sequence.getInstance();

    public UmcSignContractApplyDo createSignContractApply(UmcSignContractApplyDo reqDo) {
        int insert;
        if (reqDo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (reqDo.getApplyId() == null) {
            reqDo.setApplyId(Long.valueOf(this.sequence.nextId()));
        }
        if ((insert = this.umcSignContractApplyMapper.insert((UmcSignContractApplyPo)UmcRu.js((Object)reqDo, UmcSignContractApplyPo.class))) < 1) {
            throw new BaseBusinessException("200001", "\u63d2\u5165\u7b7e\u7ea6\u7533\u8bf7\u5355\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)reqDo.getSignSalesCategoryApplies())) {
            for (SignSalesCategoryApply signSalesCategory : reqDo.getSignSalesCategoryApplies()) {
                if (signSalesCategory.getSalesCategoryId() != null) continue;
                signSalesCategory.setSalesCategoryId(Long.valueOf(this.sequence.nextId()));
            }
            this.umcSignSalesCategoryApplyMapper.insertBatch(UmcRu.jsl((List)reqDo.getSignSalesCategoryApplies(), UmcSignSalesCategoryApplyPo.class));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDo.getSignContractLogs())) {
            for (SignContractLog signContractLog : reqDo.getSignContractLogs()) {
                if (signContractLog.getLogId() != null) continue;
                signContractLog.setLogId(Long.valueOf(this.sequence.nextId()));
            }
            this.umcSignContractLogMapper.insertBatch(UmcRu.jsl((List)reqDo.getSignContractLogs(), UmcSignContractLogPo.class));
        }
        reqDo.setRespCode("0000");
        reqDo.setRespDesc("\u6210\u529f");
        return reqDo;
    }

    public BasePageRspBo<UmcSignContractApplyDo> getSignContractApplyPageList(UmcGetSignContractApplyPageListBo reqBo) {
        Page page;
        List<UmcSignContractApplyPo> listPage;
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UmcSignContractApplyPo reqPo = (UmcSignContractApplyPo)UmcRu.js((Object)reqBo, UmcSignContractApplyPo.class);
        reqPo.setOrgId(null);
        reqPo.setOrgName(null);
        reqPo.setTenantId(null);
        if (!StringUtils.isEmpty((Object)reqBo.getOrgNameWeb())) {
            reqPo.setOrgName(reqBo.getOrgNameWeb());
        }
        if (reqBo.getOrgIdWeb() != null) {
            reqPo.setOrgId(reqBo.getOrgIdWeb());
        }
        if (reqBo.getTenantIdWeb() != null) {
            reqPo.setTenantId(reqBo.getTenantIdWeb());
        }
        if (CollectionUtils.isEmpty(listPage = this.umcSignContractApplyMapper.getListPage(reqPo, (Page<UmcSignContractApplyPo>)(page = new Page(reqBo.getPageNo(), reqBo.getPageSize()))))) {
            rspBo.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        for (UmcSignContractApplyPo signContractBO : listPage) {
            if (UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.CONFIRM.equals(signContractBO.getStatus()) && UmcStatusConstant.SUP_SIGN_CONTRACT_CONTRACT_STATUS.OLD.equals(signContractBO.getContractStatus())) continue;
            signContractBO.setContractCode(null);
            signContractBO.setContractId(null);
        }
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(UmcRu.jsl(listPage, UmcSignContractApplyDo.class));
        return rspBo;
    }

    public UmcSignContractApplyDo getSignContractApplyDetail(UmcSignContractApplyDo reqDo) {
        if (reqDo.getApplyId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u7b7e\u7ea6\u7533\u8bf7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcSignContractApplyPo reqPo = new UmcSignContractApplyPo();
        reqPo.setApplyId(reqDo.getApplyId());
        UmcSignContractApplyPo modelBy = this.umcSignContractApplyMapper.getModelBy(reqPo);
        if (modelBy == null) {
            throw new BaseBusinessException("200001", "\u6ca1\u6709\u6b64\u7b7e\u7ea6\u7533\u8bf7\u5355\u4fe1\u606f");
        }
        UmcSignContractApplyDo rspDo = (UmcSignContractApplyDo)UmcRu.js((Object)modelBy, UmcSignContractApplyDo.class);
        if (rspDo.getContractStatus() == null || !new Integer(1).equals(rspDo.getContractStatus())) {
            rspDo.setContractId(null);
            rspDo.setContractCode(null);
        }
        if (CHARGE_YEAR_FEE_CONFIRM.equals(rspDo.getYearServiceFee())) {
            UmcSignContractYearRuleApplyPo yearRulePo = new UmcSignContractYearRuleApplyPo();
            yearRulePo.setApplyId(reqDo.getApplyId());
            List<UmcSignContractYearRuleApplyPo> yearRulePoList = this.umcSignContractYearRuleApplyMapper.getList(yearRulePo);
            if (!CollectionUtils.isEmpty(yearRulePoList)) {
                List yearRules = UmcRu.jsl(yearRulePoList, SignContractYearRuleApply.class);
                rspDo.setSignContractYearRuleApplies(yearRules);
            }
        }
        UmcSignSalesCategoryApplyPo categoryPo = new UmcSignSalesCategoryApplyPo();
        categoryPo.setApplyId(reqDo.getApplyId());
        List<UmcSignSalesCategoryApplyPo> categoryPos = this.umcSignSalesCategoryApplyMapper.getList(categoryPo);
        if (!CollectionUtils.isEmpty(categoryPos)) {
            rspDo.setSignSalesCategoryApplies(UmcRu.jsl(categoryPos, SignSalesCategoryApply.class));
        }
        rspDo.setRespDesc("\u6210\u529f");
        rspDo.setRespCode("0000");
        return rspDo;
    }

    public UmcSignContractApplyDo updateSignContractApply(UmcSignContractApplyDo reqDo) {
        int i = this.umcSignContractApplyMapper.updateById((UmcSignContractApplyPo)UmcRu.js((Object)reqDo, UmcSignContractApplyPo.class));
        if (i < 1) {
            throw new BaseBusinessException("200001", "\u66f4\u65b0\u6b64\u7b7e\u7ea6\u7533\u8bf7\u5355\u4fe1\u606f\u5931\u8d25");
        }
        return reqDo;
    }

    public UmcSignContractApplyDo addSignContractLogs(UmcSignContractApplyDo reqDo) {
        for (SignContractLog bo : reqDo.getSignContractLogs()) {
            if (bo.getLogId() != null) continue;
            bo.setLogId(Long.valueOf(this.sequence.nextId()));
        }
        this.umcSignContractLogMapper.insertBatch(UmcRu.jsl((List)reqDo.getSignContractLogs(), UmcSignContractLogPo.class));
        return reqDo;
    }

    public UmcSignContractApplyDo updateSignSalesCategoryApplies(UmcSignContractApplyDo reqDo) {
        for (SignSalesCategoryApply bo : reqDo.getSignSalesCategoryApplies()) {
            if (bo.getSalesCategoryId() == null) {
                throw new BaseBusinessException("200001", "\u7b7e\u7ea6\u7533\u8bf7\u5355\u54c1\u7c7bId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            UmcSignSalesCategoryApplyPo where = new UmcSignSalesCategoryApplyPo();
            where.setSalesCategoryId(bo.getSalesCategoryId());
            UmcSignSalesCategoryApplyPo set = (UmcSignSalesCategoryApplyPo)UmcRu.js((Object)bo, UmcSignSalesCategoryApplyPo.class);
            set.setSalesCategoryId(null);
            int i = this.umcSignSalesCategoryApplyMapper.updateBy(set, where);
            if (i >= 1) continue;
            throw new BaseBusinessException("200001", "\u66f4\u65b0\u7b7e\u7ea6\u7533\u8bf7\u5355\u54c1\u7c7b\u5931\u8d25");
        }
        return reqDo;
    }

    public UmcSignContractApplyDo addSignContractYearRuleApplies(UmcSignContractApplyDo reqDo) {
        for (SignContractYearRuleApply bo : reqDo.getSignContractYearRuleApplies()) {
            if (bo.getRuleId() != null) continue;
            bo.setRuleId(Long.valueOf(this.sequence.nextId()));
        }
        this.umcSignContractYearRuleApplyMapper.insertBatch(UmcRu.jsl((List)reqDo.getSignContractYearRuleApplies(), UmcSignContractYearRuleApplyPo.class));
        return reqDo;
    }

    public UmcSignContractApplyDo queryAllSignSalesCategory(UmcSignContractApplyDo reqDo) {
        UmcSignSalesCategoryApplyPo reqPo = new UmcSignSalesCategoryApplyPo();
        reqPo.setOrgId(reqDo.getOrgId());
        List<UmcSignSalesCategoryApplyPo> categoryPos = this.umcSignSalesCategoryApplyMapper.querySignSalesCategoryBySupId(reqPo);
        reqDo.setSignSalesCategoryApplies(UmcRu.jsl(categoryPos, SignSalesCategoryApply.class));
        return reqDo;
    }
}

