/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.model.sysdictionary.qrybo.PesDicConfigQryBo;
import com.tydic.dyc.umc.model.sysdictionary.qrybo.SysDicDictionaryReqPageBO;
import com.tydic.dyc.umc.model.sysdictionary.qrybo.SysDicDictionaryRspBo;
import com.tydic.dyc.umc.model.sysdictionary.qrybo.UmcDictionaryRspBo;
import com.tydic.dyc.umc.model.sysdictionary.qrybo.UmcPesDicConfigRspBo;
import com.tydic.dyc.umc.model.sysdictionary.sub.PesDicConfig;
import com.tydic.dyc.umc.repository.UmcSysDicDictionaryRepository;
import com.tydic.dyc.umc.repository.dao.PesDicConfigMapper;
import com.tydic.dyc.umc.repository.dao.SysDicDictionaryMapper;
import com.tydic.dyc.umc.repository.po.PesDicConfigPo;
import com.tydic.dyc.umc.repository.po.SysDicDictionaryPo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UmcSysDicDictionaryRepositoryImpl
implements UmcSysDicDictionaryRepository {
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Autowired
    private PesDicConfigMapper pesDicConfigMapper;
    private static final String SYS_CODE_DEFAULT = "UMC_PLUS";
    private static final Integer DIC_ORDER_ID = 1;

    public UmcDictionaryRspBo queryBypCodeBackMap(SysDicDictionaryDo sysDicDictionaryDo) {
        List<SysDicDictionaryPo> listPo = this.sysDicDictionaryMapper.getList(this.getDicDictionaryPO(sysDicDictionaryDo.getSysCode(), sysDicDictionaryDo.getPCode()));
        UmcDictionaryRspBo umcDictionaryRspBo = new UmcDictionaryRspBo();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(listPo)) {
            for (SysDicDictionaryPo po : listPo) {
                map.put(po.getCode(), po.getTitle());
            }
        }
        umcDictionaryRspBo.setMap(map);
        return umcDictionaryRspBo;
    }

    public SysDicDictionaryPo getDicDictionaryPO(String sysCode, String pCode) {
        SysDicDictionaryPo queryDictionaryPO = new SysDicDictionaryPo();
        queryDictionaryPO.setPCode(pCode);
        if (StringUtils.isEmpty((Object)sysCode)) {
            sysCode = SYS_CODE_DEFAULT;
        }
        queryDictionaryPO.setSysCode(sysCode);
        return queryDictionaryPO;
    }

    public SysDicDictionaryDo getDictionaryByDo(SysDicDictionaryDo dicDictionaryDo) {
        SysDicDictionaryDo dictionaryDo = new SysDicDictionaryDo();
        SysDicDictionaryPo dictionaryPo = new SysDicDictionaryPo();
        BeanUtils.copyProperties((Object)dicDictionaryDo, (Object)dictionaryPo);
        SysDicDictionaryPo sysDicDictionaryPo = this.sysDicDictionaryMapper.getModelBy(dictionaryPo);
        if (null != sysDicDictionaryPo) {
            BeanUtils.copyProperties((Object)sysDicDictionaryPo, (Object)dictionaryDo);
        }
        return dictionaryDo;
    }

    public UmcPesDicConfigRspBo qryPesDicListByConfigKeys(PesDicConfigQryBo pesDicConfigQryBo) {
        UmcPesDicConfigRspBo umcPesDicConfigRspBo = new UmcPesDicConfigRspBo();
        List<PesDicConfigPo> dics = this.pesDicConfigMapper.getListByConfigKeys(pesDicConfigQryBo.getConfigKeyList());
        umcPesDicConfigRspBo.setRows(UmcRu.jsl(dics, PesDicConfig.class));
        return umcPesDicConfigRspBo;
    }

    public SysDicDictionaryRspBo queryBypCodeBackPo(SysDicDictionaryDo dicDictionaryDo) {
        SysDicDictionaryPo js = (SysDicDictionaryPo)UmcRu.js((Object)dicDictionaryDo, SysDicDictionaryPo.class);
        if (StringUtils.isEmpty((Object)js.getOrderBy())) {
            js.setOrderBy("ORDER_ID Asc");
        }
        List<SysDicDictionaryPo> list = this.sysDicDictionaryMapper.getList(js);
        List sysDicDictionaryDoList = UmcRu.jsl(list, SysDicDictionaryDo.class);
        SysDicDictionaryRspBo sysDicDictionaryRspBo = new SysDicDictionaryRspBo();
        sysDicDictionaryRspBo.setRows(sysDicDictionaryDoList);
        return sysDicDictionaryRspBo;
    }

    public SysDicDictionaryDo updateByPCode(SysDicDictionaryDo dicDictionaryDo) {
        SysDicDictionaryPo set = (SysDicDictionaryPo)UmcRu.js((Object)dicDictionaryDo, SysDicDictionaryPo.class);
        SysDicDictionaryPo where = new SysDicDictionaryPo();
        where.setPCode(dicDictionaryDo.getPCode());
        int i = this.sysDicDictionaryMapper.updateBy(set, where);
        if (i < 1) {
            throw new BaseBusinessException("200100", "\u66f4\u65b0\u5b57\u5178\u5931\u8d25");
        }
        return dicDictionaryDo;
    }

    public SysDicDictionaryRspBo queryBypCodeBackPoPage(SysDicDictionaryReqPageBO reqPageBO) {
        SysDicDictionaryPo dicDictionary = new SysDicDictionaryPo();
        ArrayList<SysDicDictionaryDo> rows = new ArrayList<SysDicDictionaryDo>();
        dicDictionary.setSysCode(reqPageBO.getSysCode());
        dicDictionary.setPCode(reqPageBO.getPCode());
        dicDictionary.setTitle(reqPageBO.getTitle());
        Page page = new Page(reqPageBO.getPageNo(), reqPageBO.getPageSize());
        SysDicDictionaryRspBo dicDictionaryBOS = new SysDicDictionaryRspBo();
        List<SysDicDictionaryPo> dicDictionaryPOS = this.sysDicDictionaryMapper.getListPage(dicDictionary, (Page<SysDicDictionaryPo>)page);
        if (dicDictionaryPOS != null) {
            for (SysDicDictionaryPo dicDictionaryPO : dicDictionaryPOS) {
                SysDicDictionaryDo dicDictionaryBO = new SysDicDictionaryDo();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                rows.add(dicDictionaryBO);
            }
        }
        dicDictionaryBOS.setRows(rows);
        dicDictionaryBOS.setRecordsTotal(page.getTotalCount());
        dicDictionaryBOS.setTotal(page.getTotalPages());
        dicDictionaryBOS.setPageNo(page.getPageNo());
        return dicDictionaryBOS;
    }

    public void updateDicDictionary(SysDicDictionaryDo dicDictionaryBO) {
        SysDicDictionaryPo dicDictionaryModel = new SysDicDictionaryPo();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(dicDictionaryBO.getOrderId());
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelFlag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        this.sysDicDictionaryMapper.updateByCondition(dicDictionaryModel);
    }

    public void deleteDicDictionary(SysDicDictionaryDo dicDictionaryBO) {
        SysDicDictionaryPo dicDictionaryModel = new SysDicDictionaryPo();
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        dicDictionaryModel.setDelFlag("1");
        this.sysDicDictionaryMapper.updateByCondition(dicDictionaryModel);
    }

    public void addDicDictionary(SysDicDictionaryDo sysDicDictionaryDo) {
        SysDicDictionaryPo sysDicDictionaryPo = new SysDicDictionaryPo();
        sysDicDictionaryPo.setTitle(sysDicDictionaryDo.getTitle());
        sysDicDictionaryPo.setOrderId(DIC_ORDER_ID);
        sysDicDictionaryPo.setDescrip(sysDicDictionaryDo.getDescrip());
        sysDicDictionaryPo.setDelFlag(sysDicDictionaryDo.getDelFlag());
        sysDicDictionaryPo.setSysCode(sysDicDictionaryDo.getSysCode());
        sysDicDictionaryPo.setCode(sysDicDictionaryDo.getCode());
        sysDicDictionaryPo.setPCode(sysDicDictionaryDo.getPCode());
        this.sysDicDictionaryMapper.insert(sysDicDictionaryPo);
    }

    public UmcPesDicConfigRspBo getPesDicConfListPage(PesDicConfigQryBo pesDicConfigQryBo) {
        Page page = new Page(pesDicConfigQryBo.getPageNo(), pesDicConfigQryBo.getPageSize());
        List<PesDicConfigPo> pesDicConfigPoList = this.pesDicConfigMapper.getListPage((PesDicConfigPo)UmcRu.js((Object)pesDicConfigQryBo, PesDicConfigPo.class), (Page<PesDicConfigPo>)page);
        UmcPesDicConfigRspBo basePageRspBo = new UmcPesDicConfigRspBo();
        basePageRspBo.setRows(UmcRu.jsl(pesDicConfigPoList, PesDicConfig.class));
        basePageRspBo.setPageNo(page.getPageNo());
        basePageRspBo.setRecordsTotal(page.getTotalCount());
        basePageRspBo.setTotal(page.getTotalPages());
        return basePageRspBo;
    }

    public void updatePesInfo(PesDicConfig pesDicConfig) {
        this.pesDicConfigMapper.updateById((PesDicConfigPo)UmcRu.js((Object)pesDicConfig, PesDicConfigPo.class));
    }

    private void validationParamsInvoice(SysDicDictionaryDo reqBO) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getPCode())) {
            throw new BaseBusinessException("200100", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[pcode]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getCode())) {
            throw new BaseBusinessException("200100", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[code]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

