/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.signcontract.SignContractDo;
import com.tydic.dyc.umc.model.signcontract.qrybo.UmcGetSignContractPageListBo;
import com.tydic.dyc.umc.model.signcontract.qrybo.UmcSigningInfoQryBo;
import com.tydic.dyc.umc.model.signcontract.sup.SignContractYearRule;
import com.tydic.dyc.umc.model.signcontract.sup.SignSalesCategory;
import com.tydic.dyc.umc.model.signcontract.sup.UmcSigningInfo;
import com.tydic.dyc.umc.repository.UmcSignContractRepository;
import com.tydic.dyc.umc.repository.dao.UmcSignContractMapper;
import com.tydic.dyc.umc.repository.dao.UmcSignContractYearRuleMapper;
import com.tydic.dyc.umc.repository.dao.UmcSignSalesCategoryMapper;
import com.tydic.dyc.umc.repository.dao.UmcSigningInfoMapper;
import com.tydic.dyc.umc.repository.po.UmcSignContractPo;
import com.tydic.dyc.umc.repository.po.UmcSignContractYearRulePo;
import com.tydic.dyc.umc.repository.po.UmcSignSalesCategoryPo;
import com.tydic.dyc.umc.repository.po.UmcSigningInfoPo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UmcSignContractRepositoryImpl
implements UmcSignContractRepository {
    @Autowired
    private UmcSignContractMapper umcSignContractMapper;
    @Autowired
    private UmcSignSalesCategoryMapper umcSignSalesCategoryMapper;
    @Autowired
    private UmcSignContractYearRuleMapper umcSignContractYearRuleMapper;
    @Autowired
    private UmcSigningInfoMapper umcSigningInfoMapper;
    private static final String NOT_CHARGE_YEAR_FEE = "0";
    private static final String CHARGE_YEAR_FEE_CONFIRM = "1";
    private Sequence sequence = Sequence.getInstance();

    public SignContractDo createSignContract(SignContractDo reqDo) {
        int insert;
        if (reqDo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDo.getSignContractId() == null) {
            reqDo.setSignContractId(Long.valueOf(this.sequence.nextId()));
        }
        if ((insert = this.umcSignContractMapper.insert((UmcSignContractPo)UmcRu.js((Object)reqDo, UmcSignContractPo.class))) < 1) {
            throw new BaseBusinessException("200001", "\u65b0\u589e\u7b7e\u7ea6\u5355\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)reqDo.getSignSalesCategories())) {
            for (SignSalesCategory signSalesCategory : reqDo.getSignSalesCategories()) {
                if (signSalesCategory.getSalesCategoryId() != null) continue;
                signSalesCategory.setSalesCategoryId(Long.valueOf(this.sequence.nextId()));
            }
            List jsl = UmcRu.jsl((List)reqDo.getSignSalesCategories(), UmcSignSalesCategoryPo.class);
            this.umcSignSalesCategoryMapper.insertBatch(jsl);
        }
        reqDo.setRespCode("0000");
        reqDo.setRespDesc("\u6210\u529f");
        return reqDo;
    }

    public BasePageRspBo<SignContractDo> getSignContractPageList(UmcGetSignContractPageListBo reqBo) {
        Page page;
        List<UmcSignContractPo> listPage;
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UmcSignContractPo reqPo = (UmcSignContractPo)UmcRu.js((Object)reqBo, UmcSignContractPo.class);
        reqPo.setOrgId(null);
        reqPo.setOrgName(null);
        reqPo.setTenantId(null);
        if (!StringUtils.isEmpty((Object)reqBo.getOrgNameWeb())) {
            reqPo.setOrgName(reqBo.getOrgNameWeb());
        }
        if (reqBo.getOrgIdWeb() != null) {
            reqPo.setOrgId(reqBo.getOrgIdWeb());
        }
        if (reqBo.getTenantIdWeb() != null) {
            reqPo.setTenantId(reqBo.getTenantIdWeb());
        }
        if (CollectionUtils.isEmpty(listPage = this.umcSignContractMapper.getListPage(reqPo, (Page<UmcSignContractPo>)(page = new Page(reqBo.getPageNo(), reqBo.getPageSize()))))) {
            rspBo.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        for (UmcSignContractPo signContractBO : listPage) {
            if (UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.CONFIRM.equals(signContractBO.getSignStatus()) && UmcStatusConstant.SUP_SIGN_CONTRACT_CONTRACT_STATUS.OLD.equals(signContractBO.getContractStatus())) continue;
            signContractBO.setContractCode(null);
            signContractBO.setContractId(null);
        }
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(UmcRu.jsl(listPage, SignContractDo.class));
        return rspBo;
    }

    public SignContractDo getSignContractDetail(SignContractDo reqDo) {
        if (reqDo.getSignContractId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u7b7e\u7ea6\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcSignContractPo reqPo = new UmcSignContractPo();
        reqPo.setSignContractId(reqDo.getSignContractId());
        UmcSignContractPo modelBy = this.umcSignContractMapper.getModelBy(reqPo);
        if (modelBy == null) {
            throw new BaseBusinessException("200001", "\u6ca1\u6709\u6b64\u7b7e\u7ea6\u5355\u4fe1\u606f");
        }
        SignContractDo rspDo = (SignContractDo)UmcRu.js((Object)modelBy, SignContractDo.class);
        if (rspDo.getContractStatus() == null || !new Integer(1).equals(rspDo.getContractStatus())) {
            rspDo.setContractId(null);
            rspDo.setContractCode(null);
        }
        if (CHARGE_YEAR_FEE_CONFIRM.equals(rspDo.getYearServiceFee())) {
            UmcSignContractYearRulePo yearRulePo = new UmcSignContractYearRulePo();
            yearRulePo.setSignContractId(reqDo.getSignContractId());
            List<UmcSignContractYearRulePo> yearRulePoList = this.umcSignContractYearRuleMapper.getList(yearRulePo);
            if (!CollectionUtils.isEmpty(yearRulePoList)) {
                List yearRules = UmcRu.jsl(yearRulePoList, SignContractYearRule.class);
                rspDo.setSignContractYearRules(yearRules);
            }
        }
        UmcSignSalesCategoryPo categoryPo = new UmcSignSalesCategoryPo();
        categoryPo.setSignContractId(reqDo.getSignContractId());
        List<UmcSignSalesCategoryPo> categoryPos = this.umcSignSalesCategoryMapper.getList(categoryPo);
        if (!CollectionUtils.isEmpty(categoryPos)) {
            rspDo.setSignSalesCategories(UmcRu.jsl(categoryPos, SignSalesCategory.class));
        }
        rspDo.setRespDesc("\u6210\u529f");
        rspDo.setRespCode("0000");
        return rspDo;
    }

    public SignContractDo updateSignContract(SignContractDo reqDo) {
        if (reqDo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDo.getSignContractId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u7b7e\u7ea6\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = this.umcSignContractMapper.updateById((UmcSignContractPo)UmcRu.js((Object)reqDo, UmcSignContractPo.class));
        if (i < 1) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u7b7e\u7ea6\u5355\u5931\u8d25");
        }
        UmcSignContractPo qryPo = new UmcSignContractPo();
        qryPo.setSignContractId(reqDo.getSignContractId());
        return (SignContractDo)UmcRu.js((Object)this.umcSignContractMapper.getModelBy(qryPo), SignContractDo.class);
    }

    public SignContractDo updateSignContractDeleteApplyId(SignContractDo reqDo) {
        if (reqDo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDo.getSignContractId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u7b7e\u7ea6\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = this.umcSignContractMapper.updateRemoveApplyId((UmcSignContractPo)UmcRu.js((Object)reqDo, UmcSignContractPo.class));
        if (i < 1) {
            throw new BaseBusinessException("200001", "\u7b7e\u7ea6\u5355\u5220\u9664\u7533\u8bf7\u5355ID\u5931\u8d25");
        }
        UmcSignContractPo qryPo = new UmcSignContractPo();
        qryPo.setSignContractId(reqDo.getSignContractId());
        return (SignContractDo)UmcRu.js((Object)this.umcSignContractMapper.getModelBy(qryPo), SignContractDo.class);
    }

    public SignContractDo deleteSignSalesCategorie(SignContractDo reqDo) {
        UmcSignSalesCategoryPo set = new UmcSignSalesCategoryPo();
        set.setDelFlag(CHARGE_YEAR_FEE_CONFIRM);
        UmcSignSalesCategoryPo where = new UmcSignSalesCategoryPo();
        where.setSignContractId(reqDo.getSignContractId());
        int i = this.umcSignSalesCategoryMapper.updateBy(set, where);
        return reqDo;
    }

    public SignContractDo addSignSalesCategories(SignContractDo reqDo) {
        for (SignSalesCategory bo : reqDo.getSignSalesCategories()) {
            if (bo.getSalesCategoryId() != null) continue;
            bo.setSalesCategoryId(Long.valueOf(this.sequence.nextId()));
        }
        this.umcSignSalesCategoryMapper.insertBatch(UmcRu.jsl((List)reqDo.getSignSalesCategories(), UmcSignSalesCategoryPo.class));
        return reqDo;
    }

    public SignContractDo addSignContractYearRules(SignContractDo reqDo) {
        for (SignContractYearRule bo : reqDo.getSignContractYearRules()) {
            if (bo.getRuleId() != null) continue;
            bo.setRuleId(Long.valueOf(this.sequence.nextId()));
        }
        this.umcSignContractYearRuleMapper.insertBatch(UmcRu.jsl((List)reqDo.getSignContractYearRules(), UmcSignContractYearRulePo.class));
        return reqDo;
    }

    public UmcSigningInfo getSigningInfo(UmcSigningInfoQryBo qryBo) {
        UmcSigningInfoPo modelBy = this.umcSigningInfoMapper.getModelBy((UmcSigningInfoPo)UmcRu.js((Object)qryBo, UmcSigningInfoPo.class));
        if (modelBy == null) {
            return new UmcSigningInfo();
        }
        return (UmcSigningInfo)UmcRu.js((Object)modelBy, UmcSigningInfo.class);
    }

    public UmcSigningInfo addSigningInfo(UmcSigningInfoQryBo qryBo) {
        int insert;
        if (qryBo.getId() == null) {
            qryBo.setId(Long.valueOf(IdUtil.nextId()));
        }
        if ((insert = this.umcSigningInfoMapper.insert((UmcSigningInfoPo)UmcRu.js((Object)qryBo, UmcSigningInfoPo.class))) < 1) {
            throw new BaseBusinessException("200100", "\u6dfb\u52a0\u7b7e\u7ea6\u4fe1\u606f\u5931\u8d25");
        }
        return new UmcSigningInfo();
    }
}

