/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.shoppingcart.UmcShoppingCartDo;
import com.tydic.dyc.umc.model.shoppingcart.qrybo.GetShoppingCartPageListReqBo;
import com.tydic.dyc.umc.model.shoppingcart.qrybo.UmcShoppingCartQryBo;
import com.tydic.dyc.umc.model.shoppingcart.qrybo.UmcShoppingCartQryRspBo;
import com.tydic.dyc.umc.model.shoppingcart.sub.UmcChannelCountBO;
import com.tydic.dyc.umc.model.shoppingcart.sub.UmcSecondTabCountBO;
import com.tydic.dyc.umc.model.shoppingcart.sub.UmcShoppingCartAmount;
import com.tydic.dyc.umc.model.shoppingcart.sub.UmcShoppingCartLog;
import com.tydic.dyc.umc.repository.UmcShoppingCartRepository;
import com.tydic.dyc.umc.repository.dao.UmcShoppingCartLogMapper;
import com.tydic.dyc.umc.repository.dao.UmcShoppingCartMapper;
import com.tydic.dyc.umc.repository.po.UmcShoppingCartLogPo;
import com.tydic.dyc.umc.repository.po.UmcShoppingCartPo;
import com.tydic.dyc.umc.repository.po.UmcTabCountBO;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcShoppingCartRepositoryImpl
implements UmcShoppingCartRepository {
    @Autowired
    private UmcShoppingCartLogMapper umcShoppingCartLogMapper;
    @Autowired
    private UmcShoppingCartMapper umcShoppingCartMapper;
    private final Sequence sequence = Sequence.getInstance();

    public UmcShoppingCartDo addShoppingCart(UmcShoppingCartDo reqDo) {
        reqDo.setSpId(Long.valueOf(this.sequence.nextId()));
        int insert = this.umcShoppingCartMapper.insert((UmcShoppingCartPo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqDo, UmcShoppingCartPo.class)));
        if (insert < 1) {
            throw new BaseBusinessException("200001", "\u63d2\u5165\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)reqDo.getShoppingCartLogs())) {
            for (UmcShoppingCartLog logDo : reqDo.getShoppingCartLogs()) {
                logDo.setSpId(reqDo.getSpId());
                logDo.setId(Long.valueOf(this.sequence.nextId()));
            }
            this.umcShoppingCartLogMapper.insertBatch(UmcRu.jsl((List)reqDo.getShoppingCartLogs(), UmcShoppingCartLogPo.class));
        }
        reqDo.setRespCode("0000");
        reqDo.setRespDesc("\u6210\u529f");
        return reqDo;
    }

    public UmcShoppingCartDo updateSoppingCart(UmcShoppingCartDo reqDo) {
        int i = this.umcShoppingCartMapper.updateById((UmcShoppingCartPo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqDo, UmcShoppingCartPo.class)));
        if (i < 1) {
            throw new BaseBusinessException("200001", "\u66f4\u65b0\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)reqDo.getShoppingCartLogs())) {
            for (UmcShoppingCartLog logDo : reqDo.getShoppingCartLogs()) {
                logDo.setSpId(reqDo.getSpId());
                logDo.setId(Long.valueOf(this.sequence.nextId()));
            }
            this.umcShoppingCartLogMapper.insertBatch(UmcRu.jsl((List)reqDo.getShoppingCartLogs(), UmcShoppingCartLogPo.class));
        }
        reqDo.setRespCode("0000");
        reqDo.setRespDesc("\u6210\u529f");
        return reqDo;
    }

    public UmcShoppingCartQryRspBo getShoppingCartPageList(GetShoppingCartPageListReqBo reqBo) {
        UmcShoppingCartQryRspBo rspBo = new UmcShoppingCartQryRspBo();
        reqBo.setPageSize(-1);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UmcShoppingCartPo reqListPo = (UmcShoppingCartPo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqBo, UmcShoppingCartPo.class));
        reqListPo.setUserId(reqBo.getUserId());
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List<UmcShoppingCartPo> listPage = this.umcShoppingCartMapper.getListPage(reqListPo, (Page<UmcShoppingCartPo>)page);
        if (CollectionUtils.isEmpty(listPage)) {
            rspBo.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        rspBo.setRows(UmcRu.jsl(listPage, UmcShoppingCartDo.class));
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setPageNo(reqBo.getPageNo());
        return rspBo;
    }

    public UmcShoppingCartAmount qryShoppingCartAmount(UmcShoppingCartDo reqDo) {
        UmcShoppingCartAmount rspBO = new UmcShoppingCartAmount();
        UmcShoppingCartPo js = (UmcShoppingCartPo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqDo, UmcShoppingCartPo.class));
        List<UmcTabCountBO> tabCountList = this.umcShoppingCartMapper.getTabCount(js);
        if (CollectionUtils.isEmpty(tabCountList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u8d2d\u7269\u8f66\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        ArrayList uscSecondTabCountBOList = new ArrayList();
        HashMap<Integer, UmcSecondTabCountBO> uscSecondTabCountBOMap = new HashMap<Integer, UmcSecondTabCountBO>();
        for (UmcTabCountBO umcTabCountBO : tabCountList) {
            if (!uscSecondTabCountBOMap.containsKey(umcTabCountBO.getOrderSource())) {
                UmcSecondTabCountBO uscSecondTabCountBO = new UmcSecondTabCountBO();
                uscSecondTabCountBO.setOrderSource(umcTabCountBO.getOrderSource());
                uscSecondTabCountBO.setCount(Integer.valueOf(0));
                ArrayList uscChannelCountsBOList = new ArrayList();
                uscSecondTabCountBO.setUscChannelCountsBOList(uscChannelCountsBOList);
                uscSecondTabCountBOMap.put(umcTabCountBO.getOrderSource(), uscSecondTabCountBO);
            }
            if (uscSecondTabCountBOMap.get(umcTabCountBO.getOrderSource()) == null) continue;
            UmcChannelCountBO uscChannelCountBO = new UmcChannelCountBO();
            uscChannelCountBO.setChannelId(umcTabCountBO.getChannelId());
            uscChannelCountBO.setCount(umcTabCountBO.getCount());
            ((UmcSecondTabCountBO)uscSecondTabCountBOMap.get(umcTabCountBO.getOrderSource())).getUscChannelCountsBOList().add(uscChannelCountBO);
            ((UmcSecondTabCountBO)uscSecondTabCountBOMap.get(umcTabCountBO.getOrderSource())).setCount(Integer.valueOf(((UmcSecondTabCountBO)uscSecondTabCountBOMap.get(umcTabCountBO.getOrderSource())).getCount() + umcTabCountBO.getCount()));
        }
        for (Map.Entry entry : uscSecondTabCountBOMap.entrySet()) {
            uscSecondTabCountBOList.add(entry.getValue());
        }
        rspBO.setUscSecondTabCountBOList(uscSecondTabCountBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8d2d\u7269\u8f66\u4e8c\u7ea7\u9875\u7b7e\u6570\u91cf\u67e5\u8be2\u6210\u529f\uff01");
        return rspBO;
    }

    public UmcShoppingCartDo qryGoodUscInfo(UmcShoppingCartQryBo umcShoppingCartQryBo) {
        UmcShoppingCartPo umcShoppingCartPo = this.umcShoppingCartMapper.getModelBy((UmcShoppingCartPo)UmcRu.js((Object)umcShoppingCartQryBo, UmcShoppingCartPo.class));
        return (UmcShoppingCartDo)UmcRu.js((Object)umcShoppingCartPo, UmcShoppingCartDo.class);
    }

    public void updateCompareType(UmcShoppingCartDo umcShoppingCartDo) {
        if (null == umcShoppingCartDo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == umcShoppingCartDo.getSpId()) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u8d2d\u7269\u8f66id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcShoppingCartPo umcShoppingCartPo = new UmcShoppingCartPo();
        umcShoppingCartPo.setSpId(umcShoppingCartDo.getSpId());
        umcShoppingCartPo.setComparisonType(umcShoppingCartDo.getComparisonType());
        this.umcShoppingCartMapper.updateById(umcShoppingCartPo);
    }
}

