/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoSyncListQryReqBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoSyncListQryRspBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcMemberQryListPageQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserRoleRelQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserTagRelQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcBatchAddUser;
import com.tydic.dyc.umc.model.user.sub.UmcCustExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfoSyncTemp;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfos;
import com.tydic.dyc.umc.model.user.sub.UmcMember;
import com.tydic.dyc.umc.model.user.sub.UmcMemberQryListPageRspBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcUserInfoDos;
import com.tydic.dyc.umc.model.user.sub.UmcUserInfoQryRspBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRelListBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRelDos;
import com.tydic.dyc.umc.repository.UmcUserInfoRepository;
import com.tydic.dyc.umc.repository.dao.UmcCustExtMapMapper;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoSyncTempMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserExtMapMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserPartJobBatchMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserPartJobSyncTempLogMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserPartJobSyncTempMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserRoleRelMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserTagRelMapper;
import com.tydic.dyc.umc.repository.po.UmcCustExtMapPo;
import com.tydic.dyc.umc.repository.po.UmcCustInfoPo;
import com.tydic.dyc.umc.repository.po.UmcCustInfoSyncTempPO;
import com.tydic.dyc.umc.repository.po.UmcMemberPo;
import com.tydic.dyc.umc.repository.po.UmcMemberQryListPageQryPo;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserExtMapPo;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserPartJobBatchPo;
import com.tydic.dyc.umc.repository.po.UmcUserPartJobSyncTempLogPo;
import com.tydic.dyc.umc.repository.po.UmcUserPartJobSyncTempPo;
import com.tydic.dyc.umc.repository.po.UmcUserRoleRelPo;
import com.tydic.dyc.umc.repository.po.UmcUserTagRelPo;
import com.tydic.dyc.umc.service.user.bo.UmcAddCustPartJobBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobSyncBatchFinishReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempDealReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempDealRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempResultUpdateReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcGetCustPartJobTempListReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcGetCustPartJobTempListRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcPartJobUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcPartJobUserRoleBo;
import com.tydic.dyc.umc.service.user.bo.UmcPartJobUserTagRelBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcUserInfoRepositoryImpl
implements UmcUserInfoRepository {
    @Autowired
    private UmcCustExtMapMapper umcCustExtMapMapper;
    @Autowired
    private UmcCustInfoMapper umcCustInfoMapper;
    @Autowired
    private UmcUserExtMapMapper umcUserExtMapMapper;
    @Autowired
    private UmcUserInfoMapper umcUserInfoMapper;
    @Autowired
    private UmcUserRoleRelMapper umcUserRoleRelMapper;
    @Autowired
    private UmcUserTagRelMapper umcUserTagRelMapper;
    @Autowired
    private UmcCustInfoSyncTempMapper umcCustInfoSyncTempMapper;
    @Autowired
    private UmcUserPartJobSyncTempMapper umcUserPartJobSyncTempMapper;
    @Autowired
    private UmcUserPartJobBatchMapper umcUserPartJobBatchMapper;
    @Autowired
    private UmcUserPartJobSyncTempLogMapper umcUserPartJobSyncTempLogMapper;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Value(value="${umc.part.job.cust.fail.times:3}")
    private int partJobFailTimes;
    @Value(value="${auth.part.job.user.role.default.ids:5}")
    private String defaultRoleIds;
    private static final Integer FINISH = 1;

    public UmcUserInfoDo createUserInfo(UmcUserInfoDo userInfoDo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)userInfoDo, UmcUserInfoPo.class);
        this.umcUserInfoMapper.insert(umcUserInfoPo);
        if (ObjectUtil.isNotEmpty((Object)userInfoDo.getUserTagRelList())) {
            List umcUserTagRelPoList = UmcRu.jsl((List)userInfoDo.getUserTagRelList(), UmcUserTagRelPo.class);
            this.umcUserTagRelMapper.insertBatch(umcUserTagRelPoList);
        }
        if (ObjectUtil.isNotEmpty((Object)userInfoDo.getUserRoleRelList())) {
            List umcUserRoleRelPoList = UmcRu.jsl((List)userInfoDo.getUserRoleRelList(), UmcUserRoleRelPo.class);
            this.umcUserRoleRelMapper.insertBatch(umcUserRoleRelPoList);
        }
        if (ObjectUtil.isNotEmpty((Object)userInfoDo.getUserExtMapList())) {
            List umcUserExtMapPoList = UmcRu.jsl((List)userInfoDo.getUserExtMapList(), UmcUserExtMapPo.class);
            this.umcUserExtMapMapper.insertBatch(umcUserExtMapPoList);
        }
        return userInfoDo;
    }

    public UmcCustInfo createCustInfo(UmcCustInfo custInfo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)custInfo, UmcCustInfoPo.class);
        this.umcCustInfoMapper.insert(umcCustInfoPo);
        if (ObjectUtil.isNotEmpty((Object)custInfo.getCustExtMapList())) {
            List umcCustExtMapPoList = UmcRu.jsl((List)custInfo.getCustExtMapList(), UmcCustExtMapPo.class);
            this.umcCustExtMapMapper.insertBatch(umcCustExtMapPoList);
        }
        return custInfo;
    }

    public void updateUserInfo(UmcUserInfoDo set) {
        UmcUserInfoPo setPo = (UmcUserInfoPo)UmcRu.js((Object)set, UmcUserInfoPo.class);
        UmcUserInfoPo wherePo = new UmcUserInfoPo();
        wherePo.setUserId(set.getUserId());
        StrUtil.noNullStringAttr((Object)setPo);
        StrUtil.noNullStringAttr((Object)wherePo);
        this.umcUserInfoMapper.updateBy(setPo, wherePo);
        if (ObjectUtil.isNotEmpty((Object)set.getUserRoleRelList())) {
            for (UmcUserRoleRel userRoleRel : set.getUserRoleRelList()) {
                UmcUserRoleRelPo umcUserRoleRelPo = (UmcUserRoleRelPo)UmcRu.js((Object)userRoleRel, UmcUserRoleRelPo.class);
                StrUtil.noNullStringAttr((Object)umcUserRoleRelPo);
                if (null == umcUserRoleRelPo.getRelId()) {
                    umcUserRoleRelPo.setRelId(IdUtil.nextId());
                    this.umcUserRoleRelMapper.insert(umcUserRoleRelPo);
                    continue;
                }
                int i = this.umcUserRoleRelMapper.updateById(umcUserRoleRelPo);
                if (i == 1) continue;
                throw new BaseBusinessException("203003", "\u7528\u6237\u66f4\u65b0\u5931\u8d25\uff0c\u66f4\u65b0\u7528\u6237\u89d2\u8272\u5931\u8d25\uff01");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)set.getUserExtMapList())) {
            for (UmcUserExtMap userExtMap : set.getUserExtMapList()) {
                UmcUserExtMapPo umcUserExtMapPo = (UmcUserExtMapPo)UmcRu.js((Object)userExtMap, UmcUserExtMapPo.class);
                StrUtil.noNullStringAttr((Object)umcUserExtMapPo);
                this.umcUserExtMapMapper.updateById(umcUserExtMapPo);
            }
        }
    }

    public void updateCustInfo(UmcCustInfo set) {
        UmcCustInfoPo setPo = (UmcCustInfoPo)UmcRu.js((Object)set, UmcCustInfoPo.class);
        UmcCustInfoPo wherePo = new UmcCustInfoPo();
        wherePo.setCustId(setPo.getCustId());
        StrUtil.noNullStringAttr((Object)setPo);
        StrUtil.noNullStringAttr((Object)wherePo);
        this.umcCustInfoMapper.updateBy(setPo, wherePo);
        if (ObjectUtil.isNotEmpty((Object)set.getCustExtMapList())) {
            for (UmcCustExtMap custExtMap : set.getCustExtMapList()) {
                UmcCustExtMapPo umcCustExtMapPo = (UmcCustExtMapPo)UmcRu.js((Object)custExtMap, UmcCustExtMapPo.class);
                StrUtil.noNullStringAttr((Object)umcCustExtMapPo);
                this.umcCustExtMapMapper.updateById(umcCustExtMapPo);
            }
        }
    }

    public UmcUserInfoDo getUserInfo(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        if (null == (umcUserInfoPo = this.umcUserInfoMapper.getModelBy(umcUserInfoPo))) {
            throw new BaseBusinessException("203004", "\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u7528\u6237\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcUserInfoDo userInfoDo = (UmcUserInfoDo)UmcRu.js((Object)umcUserInfoPo, UmcUserInfoDo.class);
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        umcUserTagRelPo.setUserId(umcUserInfoPo.getUserId());
        List<UmcUserTagRelPo> umcUserTagRelPoList = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        if (!CollectionUtils.isEmpty(umcUserTagRelPoList)) {
            userInfoDo.setUserTagRelList(UmcRu.jsl(umcUserTagRelPoList, UmcUserTagRel.class));
        }
        UmcUserRoleRelPo userRoleRelPo = new UmcUserRoleRelPo();
        userRoleRelPo.setUserId(umcUserInfoPo.getUserId());
        List<UmcUserRoleRelPo> umcUserRoleRelPoList = this.umcUserRoleRelMapper.getList(userRoleRelPo);
        if (!CollectionUtils.isEmpty(umcUserRoleRelPoList)) {
            userInfoDo.setUserRoleRelList(UmcRu.jsl(umcUserRoleRelPoList, UmcUserRoleRel.class));
        }
        UmcUserExtMapPo umcUserExtMapPo = new UmcUserExtMapPo();
        umcUserExtMapPo.setUserId(umcUserInfoPo.getUserId());
        List<UmcUserExtMapPo> umcUserExtMapPoList = this.umcUserExtMapMapper.getList(umcUserExtMapPo);
        if (!CollectionUtils.isEmpty(umcUserExtMapPoList)) {
            userInfoDo.setUserExtMapList(UmcRu.jsl(umcUserExtMapPoList, UmcUserExtMap.class));
        }
        return userInfoDo;
    }

    public UmcCustInfo getCustInfo(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)qryBo, UmcCustInfoPo.class);
        if (ObjectUtil.isEmpty((Object)(umcCustInfoPo = this.umcCustInfoMapper.getModelBy(umcCustInfoPo)))) {
            throw new BaseBusinessException("203004", "\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u5ba2\u6237\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcCustInfo custInfo = (UmcCustInfo)UmcRu.js((Object)umcCustInfoPo, UmcCustInfo.class);
        UmcCustExtMapPo umcCustExtMapPo = new UmcCustExtMapPo();
        umcCustExtMapPo.setCustId(umcCustInfoPo.getCustId());
        List<UmcCustExtMapPo> umcCustExtMapPoList = this.umcCustExtMapMapper.getList(umcCustExtMapPo);
        if (ObjectUtil.isNotEmpty(umcCustExtMapPoList)) {
            custInfo.setCustExtMapList(UmcRu.jsl(umcCustExtMapPoList, UmcCustExtMap.class));
        }
        return custInfo;
    }

    public UmcUserInfoDos getUserInfoPageList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        if (null != qryBo.getCustInfo()) {
            umcUserInfoPo.setRegAccount(qryBo.getCustInfo().getRegAccount());
            umcUserInfoPo.setRegMobile(qryBo.getCustInfo().getRegMobile());
            umcUserInfoPo.setCustName(qryBo.getCustInfo().getCustName());
        }
        StrUtil.noNullStringAttr((Object)umcUserInfoPo);
        List<UmcUserInfoDo> umcUserInfoDoList = this.umcUserInfoMapper.getListPage(umcUserInfoPo, (Page<UmcUserInfoPo>)page);
        if (!CollectionUtils.isEmpty(umcUserInfoDoList)) {
            for (UmcUserInfoDo row : umcUserInfoDoList) {
                if (StringUtils.isEmpty((CharSequence)row.getUserTagRel())) continue;
                List<String> userTagRels = Arrays.asList(row.getUserTagRel().split(","));
                List userTagRelList = userTagRels.stream().map(item -> {
                    UmcUserTagRel userTagRel = new UmcUserTagRel();
                    userTagRel.setUserId(row.getUserId());
                    userTagRel.setTagId(item);
                    return userTagRel;
                }).collect(Collectors.toList());
                row.setUserTagRelList(userTagRelList);
            }
        }
        UmcUserInfoDos rspBo = new UmcUserInfoDos();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(umcUserInfoDoList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UmcCustInfos getCustInfoPageList(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)qryBo, UmcCustInfoPo.class);
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        List<UmcCustInfoPo> umcCustInfoPoList = this.umcCustInfoMapper.getListPage(umcCustInfoPo, (Page<UmcCustInfoPo>)page);
        UmcCustInfos rspBo = new UmcCustInfos();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(umcCustInfoPoList) ? UmcRu.jsl(umcCustInfoPoList, UmcCustInfo.class) : new ArrayList(0));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UmcCustInfos getCustInfoList(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)qryBo, UmcCustInfoPo.class);
        List<UmcCustInfoPo> umcCustInfoPoList = this.umcCustInfoMapper.getList(umcCustInfoPo);
        UmcCustInfos umcUserInfoDos = new UmcCustInfos();
        umcUserInfoDos.setRows(UmcRu.jsl(umcCustInfoPoList, UmcCustInfo.class));
        return umcUserInfoDos;
    }

    public UmcUserInfoDo getCheckUserInfo(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        int checkBy = this.umcUserInfoMapper.getCheckBy(umcUserInfoPo);
        UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
        umcUserInfoDo.setCheck(Integer.valueOf(checkBy));
        return umcUserInfoDo;
    }

    public UmcUserTagRelDos getUserTagRel(UmcUserTagRelQryBo qryBo) {
        UmcUserTagRelPo umcUserTagRelPo = (UmcUserTagRelPo)UmcRu.js((Object)qryBo, UmcUserTagRelPo.class);
        List<UmcUserTagRelPo> umcUserTagRelPoList = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        UmcUserTagRelDos umcUserTagRelDos = new UmcUserTagRelDos();
        umcUserTagRelDos.setRows(UmcRu.jsl(umcUserTagRelPoList, UmcUserTagRel.class));
        return umcUserTagRelDos;
    }

    public UmcUserRoleRelListBo getUserRoleRel(UmcUserRoleRelQryBo qryBo) {
        UmcUserRoleRelPo umcUserRoleRelPo = (UmcUserRoleRelPo)UmcRu.js((Object)qryBo, UmcUserRoleRelPo.class);
        List<UmcUserRoleRelPo> umcUserRoleRelPoList = this.umcUserRoleRelMapper.getList(umcUserRoleRelPo);
        UmcUserRoleRelListBo umcUserRoleRelListBo = new UmcUserRoleRelListBo();
        umcUserRoleRelListBo.setRows(UmcRu.jsl(umcUserRoleRelPoList, UmcUserRoleRel.class));
        return umcUserRoleRelListBo;
    }

    public UmcUserInfoQryRspBo getUserInfoList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getList(umcUserInfoPo);
        List rows = new ArrayList(umcUserInfoPoList.size());
        if (!CollectionUtils.isEmpty(umcUserInfoPoList)) {
            rows = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoQryBo.class);
            List<Long> custIdList = umcUserInfoPoList.stream().map(UmcUserInfoPo::getCustId).distinct().collect(Collectors.toList());
            Map custMap = new HashMap();
            UmcCustInfoPo umcCustInfoPo = new UmcCustInfoPo();
            umcCustInfoPo.setCustIdList(custIdList);
            List<UmcCustInfoPo> umcCustInfoPoList = this.umcCustInfoMapper.getList(umcCustInfoPo);
            if (!CollectionUtils.isEmpty(umcCustInfoPoList)) {
                custMap = umcCustInfoPoList.stream().collect(Collectors.toConcurrentMap(UmcCustInfoPo::getCustId, o -> o));
            }
            for (UmcUserInfoQryBo row : rows) {
                UmcCustInfoPo umcCustInfoPo1 = (UmcCustInfoPo)custMap.get(row.getCustId());
                if (null == umcCustInfoPo1) continue;
                row.setCustInfo((UmcCustInfo)UmcRu.js((Object)umcCustInfoPo1, UmcCustInfo.class));
            }
        }
        UmcUserInfoQryRspBo umcUserInfoQryRspBo = new UmcUserInfoQryRspBo();
        umcUserInfoQryRspBo.setRows(rows);
        return umcUserInfoQryRspBo;
    }

    public UmcUserInfoQryRspBo getUserInfoWithoutCustList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getList(umcUserInfoPo);
        List rows = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoQryBo.class);
        UmcUserInfoQryRspBo umcUserInfoQryRspBo = new UmcUserInfoQryRspBo();
        umcUserInfoQryRspBo.setRows(rows);
        return umcUserInfoQryRspBo;
    }

    public UmcMemberQryListPageRspBo qryMemberListPage(UmcMemberQryListPageQryBo qryBo) {
        UmcMemberQryListPageRspBo rspBo = new UmcMemberQryListPageRspBo();
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        List<UmcMemberPo> list = this.umcUserInfoMapper.qryMemberListPage((UmcMemberQryListPageQryPo)((Object)UmcRu.js((Object)qryBo, UmcMemberQryListPageQryPo.class)), (Page<UmcMemberPo>)page);
        if (CollectionUtils.isEmpty(list)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        rspBo.setRows(UmcRu.jsl(list, UmcMember.class));
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setRespCode("0000");
        rspBo.setPageNo(qryBo.getPageNo());
        return rspBo;
    }

    public UmcUserInfoDo getCheckCustInfo(UmcCustInfoQryBo umcCustInfoQryBo) {
        int checkBy = this.umcCustInfoMapper.getCheckBy((UmcCustInfoPo)UmcRu.js((Object)umcCustInfoQryBo, UmcCustInfoPo.class));
        UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
        umcUserInfoDo.setCheck(Integer.valueOf(checkBy));
        return umcUserInfoDo;
    }

    public UmcUserTagRel addUserTagRel(UmcUserTagRel userTagRel) {
        if (null == userTagRel.getRelId()) {
            userTagRel.setRelId(Long.valueOf(IdUtil.nextId()));
        }
        UmcUserTagRelPo umcUserTagRelPo = (UmcUserTagRelPo)UmcRu.js((Object)userTagRel, UmcUserTagRelPo.class);
        this.umcUserTagRelMapper.insert(umcUserTagRelPo);
        return userTagRel;
    }

    public UmcUserTagRel updateUserTagRel(UmcUserTagRel set) {
        UmcUserTagRelPo setPo = (UmcUserTagRelPo)UmcRu.js((Object)set, UmcUserTagRelPo.class);
        UmcUserTagRelPo wherePo = new UmcUserTagRelPo();
        wherePo.setRelId(set.getRelId());
        wherePo.setUserId(set.getUserId());
        wherePo.setTagId(set.getTagId());
        this.umcUserTagRelMapper.updateBy(setPo, wherePo);
        return set;
    }

    public UmcUserInfoDos qryOrgUserByUserTag(UmcUserInfoQryBo qryBo) {
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.qryOrgUserByUserTag(qryBo);
        UmcUserInfoDos umcUserInfoDos = new UmcUserInfoDos();
        umcUserInfoDos.setRows(UmcRu.jsl(umcUserInfoPoList, UmcUserInfoDo.class));
        return umcUserInfoDos;
    }

    public void addCustInfoSyncTemp(UmcUserInfoDo umcUserInfoDo) {
        List<UmcCustInfoSyncTempPO> umcCustInfoSyncTempPOS = umcUserInfoDo.getUmcCustInfoSyncTemps().stream().map(umcCustInfoSyncTemp -> {
            UmcCustInfoSyncTempPO umcCustInfoSyncTempPO = (UmcCustInfoSyncTempPO)UmcRu.js((Object)umcCustInfoSyncTemp, UmcCustInfoSyncTempPO.class);
            umcCustInfoSyncTempPO.setId(Sequence.getInstance().nextId());
            umcCustInfoSyncTempPO.setSyncTime(new Date());
            if (null == umcCustInfoSyncTemp.getDealResult()) {
                umcCustInfoSyncTempPO.setDealResult(UmcStatusConstant.SyncDealResult.TO_DEAL);
            }
            if (!CollectionUtils.isEmpty((Collection)umcCustInfoSyncTemp.getUmcSyncExtBoList())) {
                umcCustInfoSyncTempPO.setExtField(JSONObject.toJSONString((Object)umcCustInfoSyncTemp.getUmcSyncExtBoList()));
            }
            if (!CollectionUtils.isEmpty((Collection)umcCustInfoSyncTemp.getUmcUserSyncRoleBos())) {
                umcCustInfoSyncTempPO.setRoleJson(JSONObject.toJSONString((Object)umcCustInfoSyncTemp.getUmcUserSyncRoleBos()));
            }
            return umcCustInfoSyncTempPO;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(umcCustInfoSyncTempPOS)) {
            this.umcCustInfoSyncTempMapper.insertBatch(umcCustInfoSyncTempPOS);
        }
    }

    public UmcCustInfoSyncListQryRspBo qryCustInfoTempList(UmcCustInfoSyncListQryReqBo umcCustInfoSyncListQryReqBo) {
        Page poPag = new Page(umcCustInfoSyncListQryReqBo.getPageNo().intValue(), umcCustInfoSyncListQryReqBo.getPageSize().intValue());
        UmcCustInfoSyncTempPO umcCustInfoSyncTempPO = (UmcCustInfoSyncTempPO)UmcRu.js((Object)umcCustInfoSyncListQryReqBo, UmcCustInfoSyncTempPO.class);
        List<UmcCustInfoSyncTempPO> umcCustInfoSyncTempPOS = this.umcCustInfoSyncTempMapper.getListPageTemp(umcCustInfoSyncTempPO, (Page<UmcCustInfoSyncTempPO>)poPag);
        UmcCustInfoSyncListQryRspBo umcCustInfoSyncListQryRspBo = new UmcCustInfoSyncListQryRspBo();
        umcCustInfoSyncListQryRspBo.setRows(UmcRu.jsl(umcCustInfoSyncTempPOS, UmcCustInfoSyncTemp.class));
        umcCustInfoSyncListQryRspBo.setPageNo(umcCustInfoSyncListQryReqBo.getPageNo().intValue());
        umcCustInfoSyncListQryRspBo.setTotal(poPag.getTotalPages());
        umcCustInfoSyncListQryRspBo.setRecordsTotal(poPag.getTotalCount());
        return umcCustInfoSyncListQryRspBo;
    }

    public void updateCustSyncInfoTempState(UmcUserInfoDo umcUserInfoDo) {
        UmcCustInfoSyncTemp umcCustInfoSyncTemp = umcUserInfoDo.getUmcCustInfoSyncTemp();
        if (!CollectionUtils.isEmpty((Collection)umcCustInfoSyncTemp.getIds())) {
            UmcCustInfoSyncTempPO set = new UmcCustInfoSyncTempPO();
            set.setDealResult(umcCustInfoSyncTemp.getDealResult());
            UmcCustInfoSyncTempPO where = new UmcCustInfoSyncTempPO();
            where.setIds(umcCustInfoSyncTemp.getIds());
            this.umcCustInfoSyncTempMapper.updateBy(set, where);
        }
    }

    public void updateCustSyncInfoTemp(UmcUserInfoDo umcUserInfoDo) {
        if (null != umcUserInfoDo.getUmcCustInfoSyncTemp().getDealResult()) {
            this.umcCustInfoSyncTempMapper.updateByDealResoult(umcUserInfoDo.getUmcCustInfoSyncTemp().getDealResult());
        }
    }

    public void delUserRoleByUserId(UmcUserRoleRel umcUserRoleRel) {
        if (null != umcUserRoleRel && null != umcUserRoleRel.getUserId()) {
            UmcUserRoleRelPo set = new UmcUserRoleRelPo();
            UmcUserRoleRelPo where = new UmcUserRoleRelPo();
            set.setDelFlag(umcUserRoleRel.getDelFlag());
            where.setUserId(umcUserRoleRel.getUserId());
            this.umcUserRoleRelMapper.updateBy(set, where);
        }
    }

    public void addUser(UmcBatchAddUser umcBatchAddUser) {
        if (null != umcBatchAddUser) {
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserInfoDoList())) {
                this.umcUserInfoMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserInfoDoList(), UmcUserInfoPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getCustInfoList())) {
                this.umcCustInfoMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getCustInfoList(), UmcCustInfoPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserRoleRelList())) {
                this.umcUserRoleRelMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserRoleRelList(), UmcUserRoleRelPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserTagRelList())) {
                this.umcUserTagRelMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserTagRelList(), UmcUserTagRelPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserExtMapList())) {
                this.umcUserExtMapMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserExtMapList(), UmcUserExtMapPo.class));
            }
        }
    }

    public void deleteOrgInfoSyncTempState(UmcUserInfoDo userInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)userInfoDo.getUmcCustInfoSyncTemp().getIds())) {
            UmcCustInfoSyncTempPO set = new UmcCustInfoSyncTempPO();
            set.setIds(userInfoDo.getUmcCustInfoSyncTemp().getIds());
            this.umcCustInfoSyncTempMapper.deleteBy(set);
        }
    }

    public void addCustPartJobSyncTemp(UmcUserInfoDo umcUserInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)umcUserInfoDo.getUmcCustPartJobTempList())) {
            this.umcUserPartJobSyncTempMapper.insertBatch(UmcRu.jsl((List)umcUserInfoDo.getUmcCustPartJobTempList(), UmcUserPartJobSyncTempPo.class));
        }
    }

    public void addCustPartJobSyncTempLog(UmcUserInfoDo umcUserInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)umcUserInfoDo.getUmcCustPartJobTempList())) {
            this.umcUserPartJobSyncTempLogMapper.insertBatch(UmcRu.jsl((List)umcUserInfoDo.getUmcCustPartJobTempList(), UmcUserPartJobSyncTempLogPo.class));
        }
    }

    public UmcGetCustPartJobTempListRspBo getCustPartJobTempList(UmcGetCustPartJobTempListReqBo reqBo) {
        Page pageBatch = new Page(1, 1);
        UmcUserPartJobBatchPo umcUserPartJobBatchPo = new UmcUserPartJobBatchPo();
        umcUserPartJobBatchPo.setBatchId(reqBo.getBatchId());
        umcUserPartJobBatchPo.setOrderBy("batchId,syncTime");
        umcUserPartJobBatchPo.setDealResult(0);
        List<UmcUserPartJobBatchPo> umcUserPartJobBatchPoList = this.umcUserPartJobBatchMapper.getListPage(umcUserPartJobBatchPo, (Page<UmcUserPartJobBatchPo>)pageBatch);
        if (CollectionUtils.isEmpty(umcUserPartJobBatchPoList)) {
            return (UmcGetCustPartJobTempListRspBo)UmcRu.success(UmcGetCustPartJobTempListRspBo.class);
        }
        String batchId = umcUserPartJobBatchPoList.get(0).getBatchId();
        UmcUserPartJobSyncTempPo umcUserPartJobSyncTempPo = new UmcUserPartJobSyncTempPo();
        umcUserPartJobSyncTempPo.setDealResult(UmcCommConstant.PartJobDealResult.WAIT);
        umcUserPartJobSyncTempPo.setBatchId(batchId);
        umcUserPartJobSyncTempPo.setSHARDING_PARAMETER(reqBo.getSHARDING_PARAMETER());
        umcUserPartJobSyncTempPo.setSHARDING_SHARDNUM(reqBo.getSHARDING_SHARDNUM());
        umcUserPartJobSyncTempPo.setOrderBy("id");
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<UmcUserPartJobSyncTempPo> umcUserPartJobSyncTempPoList = this.umcUserPartJobSyncTempMapper.getExtCustId(umcUserPartJobSyncTempPo, (Page<UmcUserPartJobSyncTempPo>)page);
        UmcGetCustPartJobTempListRspBo rspBo = (UmcGetCustPartJobTempListRspBo)UmcRu.success(UmcGetCustPartJobTempListRspBo.class);
        if (CollectionUtils.isEmpty(umcUserPartJobSyncTempPoList)) {
            UmcUserPartJobSyncTempPo checkPartJobPo = new UmcUserPartJobSyncTempPo();
            checkPartJobPo.setBatchId(batchId);
            int checkCount = this.umcUserPartJobSyncTempMapper.getCheckBy(checkPartJobPo);
            if (checkCount == 0) {
                UmcUserPartJobBatchPo umcUserPartJobBatchPo1 = new UmcUserPartJobBatchPo();
                umcUserPartJobBatchPo1.setBatchId(batchId);
                umcUserPartJobBatchPo1.setDealResult(1);
                this.umcUserPartJobBatchMapper.updateByBatchId(umcUserPartJobBatchPo1);
            }
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        UmcUserPartJobSyncTempPo userPartJobPo = new UmcUserPartJobSyncTempPo();
        userPartJobPo.setExtCustIds(umcUserPartJobSyncTempPoList.stream().map(UmcUserPartJobSyncTempPo::getExtCustId).collect(Collectors.toList()));
        userPartJobPo.setBatchId(batchId);
        List<UmcUserPartJobSyncTempPo> userPartJobSyncTempPoList = this.umcUserPartJobSyncTempMapper.getList(userPartJobPo);
        rspBo.setRows(UmcRu.jsl(userPartJobSyncTempPoList, UmcCustPartJobTempBo.class));
        return rspBo;
    }

    public void updateCustPartJobResult(UmcCustPartJobTempResultUpdateReqBo reqBo) {
        UmcUserPartJobSyncTempPo where;
        UmcUserPartJobSyncTempPo set;
        Date now = new Date();
        if (UmcCommConstant.PartJobDealResult.DEALING.equals(reqBo.getDealResult())) {
            set = new UmcUserPartJobSyncTempPo();
            set.setDealResult(reqBo.getDealResult());
            set.setDealTime(now);
            where = new UmcUserPartJobSyncTempPo();
            where.setIds(reqBo.getIds());
            this.umcUserPartJobSyncTempMapper.updateTimesBy(set, where);
        }
        if (UmcCommConstant.PartJobDealResult.SUCCESS.equals(reqBo.getDealResult()) || UmcCommConstant.PartJobDealResult.FAIL.equals(reqBo.getDealResult())) {
            UmcUserPartJobSyncTempPo umcUserPartJobSyncTempPo = new UmcUserPartJobSyncTempPo();
            umcUserPartJobSyncTempPo.setIds(reqBo.getIds());
            List<UmcUserPartJobSyncTempPo> umcUserPartJobSyncTempPoList = this.umcUserPartJobSyncTempMapper.getList(umcUserPartJobSyncTempPo);
            if (!CollectionUtils.isEmpty(umcUserPartJobSyncTempPoList)) {
                ArrayList<UmcUserPartJobSyncTempLogPo> umcUserPartJobSyncTempLogPos = new ArrayList<UmcUserPartJobSyncTempLogPo>();
                for (UmcUserPartJobSyncTempPo userPartJobSyncTempPo : umcUserPartJobSyncTempPoList) {
                    UmcUserPartJobSyncTempLogPo umcUserPartJobSyncTempLogPo = (UmcUserPartJobSyncTempLogPo)UmcRu.js((Object)userPartJobSyncTempPo, UmcUserPartJobSyncTempLogPo.class);
                    umcUserPartJobSyncTempLogPo.setLogId(IdUtil.nextId());
                    umcUserPartJobSyncTempLogPo.setDealTime(now);
                    umcUserPartJobSyncTempLogPo.setDealResultDesc(reqBo.getDealResultDesc());
                    umcUserPartJobSyncTempLogPo.setDealResult(reqBo.getDealResult());
                    if (StringUtils.isBlank((CharSequence)reqBo.getDealResultDesc())) {
                        umcUserPartJobSyncTempLogPo.setDealResultDesc("\u6210\u529f");
                    }
                    umcUserPartJobSyncTempLogPos.add(umcUserPartJobSyncTempLogPo);
                }
                this.umcUserPartJobSyncTempLogMapper.insertBatch(umcUserPartJobSyncTempLogPos);
                this.umcUserPartJobSyncTempMapper.del(reqBo.getIds());
            }
        }
        if (UmcCommConstant.PartJobDealResult.WAIT.equals(reqBo.getDealResult())) {
            set = new UmcUserPartJobSyncTempPo();
            set.setDealResult(reqBo.getDealResult());
            set.setDealResultDesc(reqBo.getDealResultDesc());
            where = new UmcUserPartJobSyncTempPo();
            where.setIds(reqBo.getIds());
            this.umcUserPartJobSyncTempMapper.updateWaitByIds(set, where);
        }
    }

    public UmcCustPartJobTempDealRspBo dealCustPartJob(UmcCustPartJobTempDealReqBo reqBo) {
        UmcCustPartJobTempDealRspBo rspBo = new UmcCustPartJobTempDealRspBo();
        UmcOrgInfoPo umcOrgInfoPo = new UmcOrgInfoPo();
        umcOrgInfoPo.setExtOrgIds(reqBo.getUmcCustPartJobTempBoList().stream().map(UmcCustPartJobTempBo::getExtOrgId).collect(Collectors.toList()));
        List<UmcOrgInfoPo> umcOrgInfoPoList = this.umcOrgInfoMapper.getList(umcOrgInfoPo);
        if (CollectionUtils.isEmpty(umcOrgInfoPoList)) {
            this.dealFail(reqBo.getUmcCustPartJobTempBoList(), "\u6240\u5c5e\u673a\u6784\u6570\u636e\u672a\u540c\u6b65\u5230\u4e3b\u8868");
            return rspBo;
        }
        List<String> extCustIdList = reqBo.getUmcCustPartJobTempBoList().stream().map(UmcCustPartJobTempBo::getExtCustId).collect(Collectors.toList());
        UmcUserInfoPo qryByExtCustIdPo = new UmcUserInfoPo();
        qryByExtCustIdPo.setExtCustIdList(extCustIdList);
        List<UmcUserInfoPo> mainUserInfoList = this.umcUserInfoMapper.getMainPartJobUserList(qryByExtCustIdPo);
        if (CollectionUtils.isEmpty(mainUserInfoList)) {
            this.dealFail(reqBo.getUmcCustPartJobTempBoList(), "\u4e3b\u804c\u7528\u6237\u672a\u540c\u6b65\u5230\u4e3b\u8868");
            return rspBo;
        }
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setCustIdList(mainUserInfoList.stream().map(UmcUserInfoPo::getCustId).collect(Collectors.toList()));
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getPartJobUserList(umcUserInfoPo);
        this.compare(reqBo, rspBo, umcOrgInfoPoList, mainUserInfoList, umcUserInfoPoList);
        return rspBo;
    }

    private void compare(UmcCustPartJobTempDealReqBo reqBo, UmcCustPartJobTempDealRspBo rspBo, List<UmcOrgInfoPo> umcOrgInfoPoList, List<UmcUserInfoPo> mainUserInfoList, List<UmcUserInfoPo> umcUserInfoPoList) {
        ConcurrentMap<Object, Object> extCustOrgIdMap = new ConcurrentHashMap();
        if (!CollectionUtils.isEmpty(umcUserInfoPoList)) {
            extCustOrgIdMap = umcUserInfoPoList.stream().collect(Collectors.toConcurrentMap(o -> o.getExtCustId() + o.getExtOrgId(), o -> o, (old, cur) -> old));
        }
        ConcurrentMap<String, UmcUserInfoPo> extCustIdMap = mainUserInfoList.stream().collect(Collectors.toConcurrentMap(UmcUserInfoPo::getExtCustId, o -> o, (old, cur) -> old));
        ConcurrentMap<String, UmcOrgInfoPo> extOrgIdMap = umcOrgInfoPoList.stream().collect(Collectors.toConcurrentMap(UmcOrgInfoPo::getExtOrgId, o -> o, (old, cur) -> old));
        ConcurrentMap<String, UmcCustPartJobTempBo> reqExtCustOrgIdMap = reqBo.getUmcCustPartJobTempBoList().stream().collect(Collectors.toConcurrentMap(o -> o.getExtCustId() + o.getExtOrgId(), o -> o, (old, cur) -> old));
        ArrayList<UmcUserInfoPo> addPartJobUserList = new ArrayList<UmcUserInfoPo>();
        ArrayList deleteUserPos = new ArrayList();
        ArrayList<UmcCustPartJobTempBo> failOrgPartJobUser = new ArrayList<UmcCustPartJobTempBo>();
        ArrayList<UmcCustPartJobTempBo> failMainCustPartJobUser = new ArrayList<UmcCustPartJobTempBo>();
        ArrayList<UmcCustPartJobTempBo> noChangePartJobUser = new ArrayList<UmcCustPartJobTempBo>();
        ConcurrentMap<Object, Object> finalExtCustOrgIdMap = extCustOrgIdMap;
        reqExtCustOrgIdMap.forEach((reqExtCustOrgId, umcCustPartJobTempBo) -> {
            UmcUserInfoPo userInfoPo = (UmcUserInfoPo)finalExtCustOrgIdMap.get(reqExtCustOrgId);
            if (null == userInfoPo) {
                UmcOrgInfoPo orgInfoPo = (UmcOrgInfoPo)extOrgIdMap.get(umcCustPartJobTempBo.getExtOrgId());
                if (null == orgInfoPo) {
                    failOrgPartJobUser.add((UmcCustPartJobTempBo)umcCustPartJobTempBo);
                } else {
                    UmcUserInfoPo mainUserInfoPo = (UmcUserInfoPo)extCustIdMap.get(umcCustPartJobTempBo.getExtCustId());
                    if (null == mainUserInfoPo) {
                        failMainCustPartJobUser.add((UmcCustPartJobTempBo)umcCustPartJobTempBo);
                    } else if (umcCustPartJobTempBo.getExtOrgId().equals(mainUserInfoPo.getExtOrgId())) {
                        noChangePartJobUser.add((UmcCustPartJobTempBo)umcCustPartJobTempBo);
                    } else {
                        UmcUserInfoPo addUser = new UmcUserInfoPo();
                        addUser.setCustId(mainUserInfoPo.getCustId());
                        addUser.setExtCustId(mainUserInfoPo.getExtCustId());
                        addUser.setOrgId(orgInfoPo.getOrgId());
                        addUser.setCompanyId(orgInfoPo.getCompanyId());
                        addUser.setOrgTreePath(orgInfoPo.getOrgTreePath());
                        addUser.setExtOrgId(orgInfoPo.getExtOrgId());
                        addUser.setUserId(IdUtil.nextId());
                        addPartJobUserList.add(addUser);
                    }
                }
            } else {
                umcCustPartJobTempBo.setId(umcCustPartJobTempBo.getId());
                noChangePartJobUser.add((UmcCustPartJobTempBo)umcCustPartJobTempBo);
            }
        });
        extCustOrgIdMap.forEach((extCustOrgId, userInfo) -> {
            UmcCustPartJobTempBo umcCustPartJobTempBo = (UmcCustPartJobTempBo)reqExtCustOrgIdMap.get(extCustOrgId);
            if (null == umcCustPartJobTempBo) {
                deleteUserPos.add(userInfo);
            }
        });
        if (!CollectionUtils.isEmpty(failOrgPartJobUser)) {
            this.dealFail(failOrgPartJobUser, "\u6240\u5c5e\u673a\u6784\u6570\u636e\u672a\u540c\u6b65\u5230\u4e3b\u8868");
        }
        if (!CollectionUtils.isEmpty(failMainCustPartJobUser)) {
            this.dealFail(failMainCustPartJobUser, "\u4e3b\u804c\u7528\u6237\u672a\u540c\u6b65\u5230\u4e3b\u8868");
        }
        if (!CollectionUtils.isEmpty(noChangePartJobUser)) {
            this.dealSuccess(noChangePartJobUser, "\u7528\u6237\u5df2\u5728\u5546\u57ce\u517c\u804c\uff0c\u65e0\u9700\u5904\u7406\u8be5\u6570\u636e");
        }
        List<Object> deleteUserList = new ArrayList();
        if (!CollectionUtils.isEmpty(deleteUserPos)) {
            deleteUserList = deleteUserPos.stream().map(UmcUserInfoPo::getUserId).collect(Collectors.toList());
            List<Long> delUserIds = deleteUserPos.stream().map(UmcUserInfoPo::getUserId).collect(Collectors.toList());
            this.umcUserInfoMapper.deleteUser(delUserIds);
            this.umcUserRoleRelMapper.deleteUser(delUserIds);
            this.umcUserTagRelMapper.deleteUser(delUserIds);
        }
        ArrayList<UmcPartJobUserInfoBo> sysPartJobUserInfoBoList = new ArrayList<UmcPartJobUserInfoBo>();
        ArrayList<UmcPartJobUserTagRelBo> sysPartJobUserTagRelBoList = new ArrayList<UmcPartJobUserTagRelBo>();
        ArrayList<UmcPartJobUserRoleBo> sysPartJobUserRoleBoList = new ArrayList<UmcPartJobUserRoleBo>();
        if (!CollectionUtils.isEmpty(addPartJobUserList)) {
            this.batchCreatePartJobUser(addPartJobUserList, sysPartJobUserInfoBoList, sysPartJobUserTagRelBoList, sysPartJobUserRoleBoList);
            ArrayList<UmcCustPartJobTempBo> successBo = new ArrayList<UmcCustPartJobTempBo>();
            for (UmcUserInfoPo userPo : addPartJobUserList) {
                UmcCustPartJobTempBo tempBo = (UmcCustPartJobTempBo)reqExtCustOrgIdMap.get(userPo.getExtCustId() + userPo.getExtOrgId());
                if (null == tempBo) continue;
                successBo.add(tempBo);
            }
            this.dealSuccess(successBo, "\u7528\u6237\u517c\u804c\u6210\u529f");
        }
        UmcAddCustPartJobBo umcAddCustPartJobBo = new UmcAddCustPartJobBo();
        umcAddCustPartJobBo.setSysPartJobUserInfoBoList(sysPartJobUserInfoBoList);
        umcAddCustPartJobBo.setSysPartJobUserTagRelBoList(sysPartJobUserTagRelBoList);
        umcAddCustPartJobBo.setSysPartJobUserRoleBoList(sysPartJobUserRoleBoList);
        rspBo.setAddCustPartJobBo(umcAddCustPartJobBo);
        rspBo.setDeleteUserIds(deleteUserList);
    }

    private void batchCreatePartJobUser(List<UmcUserInfoPo> addPartJobUserList, List<UmcPartJobUserInfoBo> sysPartJobUserInfoBoList, List<UmcPartJobUserTagRelBo> sysPartJobUserTagRelBoList, List<UmcPartJobUserRoleBo> sysPartJobUserRoleBoList) {
        List<Long> custIds = addPartJobUserList.stream().map(UmcUserInfoPo::getCustId).collect(Collectors.toList());
        ConcurrentHashMap<Long, List<UmcUserTagRelPo>> userIdTagMap = new ConcurrentHashMap();
        ConcurrentHashMap<Long, List<UmcUserExtMapPo>> userIdExtMap = new ConcurrentHashMap();
        ConcurrentHashMap<Long, UmcUserInfoPo> custIdMap = new ConcurrentHashMap();
        UmcUserInfoPo userInfoPo = new UmcUserInfoPo();
        userInfoPo.setCustIdList(custIds);
        userInfoPo.setIsMain("1");
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getList(userInfoPo);
        if (!CollectionUtils.isEmpty(umcUserInfoPoList)) {
            custIdMap = umcUserInfoPoList.stream().collect(Collectors.toConcurrentMap(UmcUserInfoPo::getCustId, o -> o, (o1, o2) -> o2));
        }
        List<Long> userIds = umcUserInfoPoList.stream().map(UmcUserInfoPo::getUserId).collect(Collectors.toList());
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        umcUserTagRelPo.setUserIds(userIds);
        List<UmcUserTagRelPo> umcUserTagRelPoList = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        if (!CollectionUtils.isEmpty(umcUserTagRelPoList)) {
            userIdTagMap = umcUserTagRelPoList.stream().collect(Collectors.groupingByConcurrent(UmcUserTagRelPo::getUserId));
        }
        UmcUserExtMapPo umcUserExtMapPo = new UmcUserExtMapPo();
        umcUserExtMapPo.setUserIds(userIds);
        List<UmcUserExtMapPo> umcUserExtMapPoList = this.umcUserExtMapMapper.getList(umcUserExtMapPo);
        if (!CollectionUtils.isEmpty(umcUserExtMapPoList)) {
            userIdExtMap = umcUserExtMapPoList.stream().collect(Collectors.groupingByConcurrent(UmcUserExtMapPo::getUserId));
        }
        ArrayList<UmcUserInfoPo> addUserInfoList = new ArrayList<UmcUserInfoPo>();
        ArrayList<UmcUserTagRelPo> addUserTagList = new ArrayList<UmcUserTagRelPo>();
        ArrayList<UmcUserRoleRelPo> addUserRoleList = new ArrayList<UmcUserRoleRelPo>();
        ArrayList<UmcUserExtMapPo> addUserExtMapList = new ArrayList<UmcUserExtMapPo>();
        Date now = new Date();
        for (UmcUserInfoPo umcUserInfoPo : addPartJobUserList) {
            this.setUser(custIdMap, addUserInfoList, now, umcUserInfoPo, sysPartJobUserInfoBoList);
            this.setUserTag(custIdMap, userIdTagMap, addUserTagList, now, umcUserInfoPo, sysPartJobUserTagRelBoList);
            this.setUserRole(addUserRoleList, now, umcUserInfoPo, sysPartJobUserRoleBoList);
            this.setUserExt(custIdMap, userIdExtMap, addUserExtMapList, now, umcUserInfoPo);
        }
        this.umcUserInfoMapper.insertBatch(addUserInfoList);
        if (ObjectUtil.isNotEmpty(addUserTagList)) {
            this.umcUserTagRelMapper.insertBatch(addUserTagList);
        }
        if (ObjectUtil.isNotEmpty(addUserRoleList)) {
            this.umcUserRoleRelMapper.insertBatch(addUserRoleList);
        }
        if (ObjectUtil.isNotEmpty(addUserExtMapList)) {
            this.umcUserExtMapMapper.insertBatch(addUserExtMapList);
        }
    }

    private void setUserExt(ConcurrentMap<Long, UmcUserInfoPo> custIdMap, ConcurrentMap<Long, List<UmcUserExtMapPo>> userIdExtMap, List<UmcUserExtMapPo> addUserExtMapList, Date now, UmcUserInfoPo umcUserInfoPo) {
        List umcUserExtMapPos;
        UmcUserInfoPo mainUserPo = (UmcUserInfoPo)custIdMap.get(umcUserInfoPo.getCustId());
        if (null != mainUserPo && !CollectionUtils.isEmpty((Collection)(umcUserExtMapPos = (List)userIdExtMap.get(mainUserPo.getUserId())))) {
            for (UmcUserExtMapPo userExtMapPo : umcUserExtMapPos) {
                userExtMapPo.setExtId(IdUtil.nextId());
                userExtMapPo.setUserId(umcUserInfoPo.getUserId());
                userExtMapPo.setCreateTime(now);
                userExtMapPo.setCreateOperId(UmcCommConstant.System.ID);
                userExtMapPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                userExtMapPo.setUpdateTime(now);
                userExtMapPo.setUpdateOperId(UmcCommConstant.System.ID);
                userExtMapPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                userExtMapPo.setDelFlag("0");
                addUserExtMapList.add(userExtMapPo);
            }
        }
    }

    private void setUserRole(List<UmcUserRoleRelPo> addUserRoleList, Date now, UmcUserInfoPo umcUserInfoPo, List<UmcPartJobUserRoleBo> sysPartJobUserRoleBoList) {
        if (!StringUtils.isBlank((CharSequence)this.defaultRoleIds)) {
            List<Object> roleIds = new ArrayList<String>();
            if (this.defaultRoleIds.contains(",")) {
                roleIds = Arrays.asList(this.defaultRoleIds.split(","));
            } else {
                roleIds.add(this.defaultRoleIds);
            }
            for (String string : roleIds) {
                UmcUserRoleRelPo umcUserRoleRelPo = new UmcUserRoleRelPo();
                umcUserRoleRelPo.setRelId(IdUtil.nextId());
                umcUserRoleRelPo.setUserId(umcUserInfoPo.getUserId());
                umcUserRoleRelPo.setRoleId(Convert.toLong((Object)string));
                umcUserRoleRelPo.setTenantId(UmcCommConstant.System.TENANT_ID);
                umcUserRoleRelPo.setCreateTime(now);
                umcUserRoleRelPo.setCreateOperId(UmcCommConstant.System.ID);
                umcUserRoleRelPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                umcUserRoleRelPo.setUpdateTime(now);
                umcUserRoleRelPo.setUpdateOperId(UmcCommConstant.System.ID);
                umcUserRoleRelPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                umcUserRoleRelPo.setDelFlag("0");
                addUserRoleList.add(umcUserRoleRelPo);
                UmcPartJobUserRoleBo umcPartJobUserRoleBo = (UmcPartJobUserRoleBo)UmcRu.js((Object)umcUserRoleRelPo, UmcPartJobUserRoleBo.class);
                umcPartJobUserRoleBo.setAuthId(umcUserRoleRelPo.getRelId());
                umcPartJobUserRoleBo.setDisAgFlag(Integer.valueOf(1));
                umcPartJobUserRoleBo.setDisFlag(Integer.valueOf(1));
                umcPartJobUserRoleBo.setOrgId(umcUserInfoPo.getOrgId());
                umcPartJobUserRoleBo.setOrgTreePath(umcUserInfoPo.getOrgTreePath());
                umcPartJobUserRoleBo.setManageLevel(Integer.valueOf(40));
                sysPartJobUserRoleBoList.add(umcPartJobUserRoleBo);
            }
        }
    }

    private void setUserTag(ConcurrentMap<Long, UmcUserInfoPo> custIdMap, ConcurrentMap<Long, List<UmcUserTagRelPo>> userIdTagMap, List<UmcUserTagRelPo> addUserTagList, Date now, UmcUserInfoPo umcUserInfoPo, List<UmcPartJobUserTagRelBo> sysPartJobUserTagRelBoList) {
        List addUserTags;
        UmcUserInfoPo mainUserPo = (UmcUserInfoPo)custIdMap.get(umcUserInfoPo.getCustId());
        if (null != mainUserPo && !CollectionUtils.isEmpty((Collection)(addUserTags = (List)userIdTagMap.get(mainUserPo.getUserId())))) {
            for (UmcUserTagRelPo addUserTag : addUserTags) {
                addUserTag.setRelId(IdUtil.nextId());
                addUserTag.setUserId(umcUserInfoPo.getUserId());
                addUserTag.setCreateTime(now);
                addUserTag.setCreateOperId(UmcCommConstant.System.ID);
                addUserTag.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                addUserTag.setUpdateTime(now);
                addUserTag.setUpdateOperId(UmcCommConstant.System.ID);
                addUserTag.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                addUserTag.setDelFlag("0");
                addUserTagList.add(addUserTag);
                sysPartJobUserTagRelBoList.add((UmcPartJobUserTagRelBo)UmcRu.js((Object)addUserTag, UmcPartJobUserTagRelBo.class));
            }
        }
    }

    private void setUser(ConcurrentMap<Long, UmcUserInfoPo> custIdMap, List<UmcUserInfoPo> addUserInfoList, Date now, UmcUserInfoPo umcUserInfoPo, List<UmcPartJobUserInfoBo> sysPartJobUserInfoBoList) {
        UmcUserInfoPo mainUserPo = (UmcUserInfoPo)custIdMap.get(umcUserInfoPo.getCustId());
        if (null != mainUserPo) {
            UmcUserInfoPo addUserPo = (UmcUserInfoPo)UmcRu.js((Object)mainUserPo, UmcUserInfoPo.class);
            addUserPo.setUserId(umcUserInfoPo.getUserId());
            addUserPo.setOrgId(umcUserInfoPo.getOrgId());
            addUserPo.setCustId(umcUserInfoPo.getCustId());
            addUserPo.setMainCustId(umcUserInfoPo.getCustId());
            addUserPo.setOrgTreePath(umcUserInfoPo.getOrgTreePath());
            addUserPo.setCompanyId(umcUserInfoPo.getCompanyId());
            addUserPo.setIsMain("0");
            addUserPo.setStopStatus("01");
            addUserPo.setCreateTime(now);
            addUserPo.setCreateOperId(UmcCommConstant.System.ID);
            addUserPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            addUserPo.setUpdateTime(now);
            addUserPo.setUpdateOperId(UmcCommConstant.System.ID);
            addUserPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            addUserPo.setDelFlag("0");
            addUserInfoList.add(addUserPo);
            UmcPartJobUserInfoBo umcPartJobUserInfoBo = (UmcPartJobUserInfoBo)UmcRu.js((Object)addUserPo, UmcPartJobUserInfoBo.class);
            umcPartJobUserInfoBo.setUserStatus("1");
            sysPartJobUserInfoBoList.add(umcPartJobUserInfoBo);
        }
    }

    private void dealSuccess(List<UmcCustPartJobTempBo> umcCustPartJobTempBoList, String desc) {
        UmcCustPartJobTempResultUpdateReqBo umcCustPartJobTempResultUpdateReqBo = new UmcCustPartJobTempResultUpdateReqBo();
        umcCustPartJobTempResultUpdateReqBo.setDealResult(UmcCommConstant.PartJobDealResult.SUCCESS);
        umcCustPartJobTempResultUpdateReqBo.setDealResultDesc(desc);
        umcCustPartJobTempResultUpdateReqBo.setIds(umcCustPartJobTempBoList.stream().map(UmcCustPartJobTempBo::getId).collect(Collectors.toList()));
        this.updateCustPartJobResult(umcCustPartJobTempResultUpdateReqBo);
    }

    private void dealFail(List<UmcCustPartJobTempBo> umcCustPartJobTempBoList, String desc) {
        UmcCustPartJobTempResultUpdateReqBo umcCustPartJobTempResultUpdateReqBo;
        ArrayList<Long> failIds = new ArrayList<Long>();
        ArrayList<Long> todoIds = new ArrayList<Long>();
        for (UmcCustPartJobTempBo umcCustPartJobTempBo : umcCustPartJobTempBoList) {
            if (umcCustPartJobTempBo.getDealCount() >= this.partJobFailTimes) {
                failIds.add(umcCustPartJobTempBo.getId());
                continue;
            }
            todoIds.add(umcCustPartJobTempBo.getId());
        }
        if (!CollectionUtils.isEmpty(failIds)) {
            umcCustPartJobTempResultUpdateReqBo = new UmcCustPartJobTempResultUpdateReqBo();
            umcCustPartJobTempResultUpdateReqBo.setDealResult(UmcCommConstant.PartJobDealResult.FAIL);
            umcCustPartJobTempResultUpdateReqBo.setDealResultDesc(desc);
            umcCustPartJobTempResultUpdateReqBo.setIds(failIds);
            this.updateCustPartJobResult(umcCustPartJobTempResultUpdateReqBo);
        }
        if (!CollectionUtils.isEmpty(todoIds)) {
            umcCustPartJobTempResultUpdateReqBo = new UmcCustPartJobTempResultUpdateReqBo();
            umcCustPartJobTempResultUpdateReqBo.setDealResult(UmcCommConstant.PartJobDealResult.WAIT);
            umcCustPartJobTempResultUpdateReqBo.setDealResultDesc(desc);
            umcCustPartJobTempResultUpdateReqBo.setIds(todoIds);
            this.updateCustPartJobResult(umcCustPartJobTempResultUpdateReqBo);
        }
    }

    public void finishSyncPartJobUser(UmcCustPartJobSyncBatchFinishReqBo reqBo) {
        if (FINISH.equals(reqBo.getDealResult())) {
            UmcUserPartJobSyncTempPo umcUserPartJobSyncTempPo = new UmcUserPartJobSyncTempPo();
            umcUserPartJobSyncTempPo.setBatchId(reqBo.getBatchId());
            int count = this.umcUserPartJobSyncTempMapper.getCheckBy(umcUserPartJobSyncTempPo);
            if (count == 0) {
                UmcUserPartJobBatchPo umcUserPartJobBatchPo = new UmcUserPartJobBatchPo();
                umcUserPartJobBatchPo.setBatchId(reqBo.getBatchId());
                umcUserPartJobBatchPo.setDealResult(FINISH);
                this.umcUserPartJobBatchMapper.updateByBatchId(umcUserPartJobBatchPo);
            }
        } else {
            UmcUserPartJobBatchPo umcUserPartJobBatchPo = new UmcUserPartJobBatchPo();
            umcUserPartJobBatchPo.setBatchId(reqBo.getBatchId());
            umcUserPartJobBatchPo.setId(IdUtil.nextId());
            umcUserPartJobBatchPo.setDealResult(0);
            umcUserPartJobBatchPo.setSyncTime(new Date());
            this.umcUserPartJobBatchMapper.insert(umcUserPartJobBatchPo);
        }
    }

    public UmcUserInfoDo getUserInfoByExt(UmcUserInfoQryBo umcUserInfoQryBo) {
        UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setExtCustId(umcUserInfoQryBo.getExtCustId());
        umcUserInfoPo.setExtOrgId(umcUserInfoQryBo.getExtOrgId());
        umcUserInfoPo = this.umcUserInfoMapper.getUserInfnByExt(umcUserInfoPo);
        if (null != umcUserInfoPo) {
            umcUserInfoDo.setUserId(umcUserInfoPo.getUserId());
            umcUserInfoDo.setCustId(umcUserInfoPo.getCustId());
        }
        return umcUserInfoDo;
    }

    public UmcUserInfoQryRspBo getUserOrgBaseInfoList(UmcUserInfoQryBo umcUserInfoQryBo) {
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setUserId(umcUserInfoQryBo.getUserId());
        umcUserInfoPo.setUserIdList(umcUserInfoQryBo.getUserIdList());
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getUserOrgBaseInfoList(umcUserInfoPo);
        List umcUserInfoQryBoList = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoQryBo.class);
        UmcUserInfoQryRspBo umcUserInfoQryRspBo = new UmcUserInfoQryRspBo();
        umcUserInfoQryRspBo.setRows(umcUserInfoQryBoList);
        return umcUserInfoQryRspBo;
    }

    public UmcUserInfoDo getUserInfoExtCustIdForLogin(UmcUserInfoQryBo umcUserInfoQryBo) {
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setExtCustId(umcUserInfoQryBo.getExtCustId());
        UmcUserInfoPo umcUserInfoPo1 = this.umcUserInfoMapper.getUserInfoExtCustIdForLogin(umcUserInfoPo);
        if (null == umcUserInfoPo1) {
            return null;
        }
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        umcUserTagRelPo.setUserId(umcUserInfoPo1.getUserId());
        umcUserTagRelPo.setIsDefalt("1");
        List<UmcUserTagRelPo> umcUserTagRelPo1 = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        UmcUserInfoDo umcUserInfoDo = (UmcUserInfoDo)UmcRu.js((Object)umcUserInfoPo1, UmcUserInfoDo.class);
        umcUserInfoDo.setUserTagRel("" + umcUserTagRelPo1.get(0).getTagId());
        return umcUserInfoDo;
    }

    public UmcUserInfoDos getExtIdByIds(UmcUserInfoQryBo umcUserInfoQryBo) {
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getExtIdByIds(umcUserInfoQryBo.getUserIdList(), umcUserInfoQryBo.getExtCustIdList());
        List umcUserInfoDoList = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoDo.class);
        UmcUserInfoDos umcUserInfoDos = new UmcUserInfoDos();
        umcUserInfoDos.setRows(umcUserInfoDoList);
        if (!CollectionUtils.isEmpty((Collection)umcUserInfoDoList)) {
            UmcUserExtMapPo umcUserExtMapPo = new UmcUserExtMapPo();
            umcUserExtMapPo.setUserIds(umcUserInfoDoList.stream().map(UmcUserInfoDo::getUserId).collect(Collectors.toList()));
            List<UmcUserExtMapPo> umcUserExtMapPoList = this.umcUserExtMapMapper.getList(umcUserExtMapPo);
            ConcurrentMap<Long, List<UmcUserExtMapPo>> userIdListMap = umcUserExtMapPoList.stream().collect(Collectors.groupingByConcurrent(UmcUserExtMapPo::getUserId));
            if (!CollectionUtils.isEmpty(userIdListMap)) {
                for (UmcUserInfoDo umcUserInfoDo : umcUserInfoDoList) {
                    List umcUserExtMapPos = (List)userIdListMap.get(umcUserInfoDo.getUserId());
                    if (CollectionUtils.isEmpty((Collection)umcUserExtMapPos)) continue;
                    umcUserInfoDo.setUserExtMapList(UmcRu.jsl((List)umcUserExtMapPos, UmcUserExtMap.class));
                }
            }
        }
        return umcUserInfoDos;
    }

    public void insertUserExtMap(List<UmcUserExtMap> insertUserExtMapList) {
        List<Long> userIds;
        if (!CollectionUtils.isEmpty(insertUserExtMapList) && !CollectionUtils.isEmpty(userIds = insertUserExtMapList.stream().map(UmcUserExtMap::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList()))) {
            UmcUserExtMapPo set = new UmcUserExtMapPo();
            set.setDelFlag("1");
            UmcUserExtMapPo where = new UmcUserExtMapPo();
            where.setDelFlag("0");
            where.setUserIds(userIds);
            this.umcUserExtMapMapper.updateBy(set, where);
            this.umcUserExtMapMapper.insertBatch(UmcRu.jsl(insertUserExtMapList, UmcUserExtMapPo.class));
        }
    }
}

