/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.service.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.menu.bo.AccessMenu;
import com.ohaotian.authority.menu.bo.AuthorityMenu;
import com.ohaotian.authority.menu.bo.SelectAccessMenuReqBO;
import com.ohaotian.authority.menu.bo.SelectAccessMenuRspBO;
import com.ohaotian.authority.menu.bo.SelectAuthoritysMenuReqBO;
import com.ohaotian.authority.menu.bo.SelectAuthoritysMenuRspBO;
import com.ohaotian.authority.menu.service.SelectAccessMenuService;
import com.ohaotian.authority.menu.service.SelectAuthoritysMenuService;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.role.bo.SelectRoleAuthoritysReqBO;
import com.ohaotian.authority.role.bo.SelectRoleAuthoritysRspBO;
import com.ohaotian.authority.role.service.SelectRoleAuthoritysService;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.SelectUserInfoReqBO;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.ListUtils;
import com.tydic.umc.ability.DictionaryAbilityService;
import com.tydic.umc.ability.UmcApplicationPropertyAbilityService;
import com.tydic.umc.ability.UmcMemDetailQueryAbilityService;
import com.tydic.umc.ability.bo.UmcQryOrgByUserStationAbilityReqBO;
import com.tydic.umc.ability.bo.UmcQryOrgByUserStationAbilityRspBO;
import com.tydic.umc.ability.bo.UmcQrySingleValuePropertyAbilityReqBO;
import com.tydic.umc.ability.bo.UmcQrySingleValuePropertyAbilityRspBO;
import com.tydic.umc.ability.org.UmcQryOrgByUserStationAbilityService;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcUserDetails;
import com.tydic.umc.security.entity.AuthorityInfo;
import com.tydic.umc.security.entity.MenuInfo;
import com.tydic.umc.security.service.GetUserInfoByUserIdService;
import com.tydic.umcext.ability.member.UmcQryMemIdByUserIdAbilityService;
import com.tydic.umcext.ability.member.bo.UmcQryMemInfoByUserIdAbilityReqBO;
import com.tydic.umcext.ability.member.bo.UmcQryMemInfoByUserIdAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetUserInfoByUserIdServiceImpl
implements GetUserInfoByUserIdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetUserInfoByUserIdServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectUserInfoService selectUserInfoService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectTenantByIdService selectTenantByIdService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectRoleAuthoritysService selectRoleAuthoritysService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcQryMemIdByUserIdAbilityService umcQryMemIdByUserIdAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcQryOrgByUserStationAbilityService umcQryOrgByUserStationAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectAuthoritysMenuService selectAuthoritysMenuService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectAccessMenuService selectAccessMenuService;
    @Autowired
    private CacheClient cacheTemplate;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${EXTENTERPRISE_REGIST_ROLE_AUTH_IDENTITY:extenterprise:regist:role}")
    private String EXTENTERPRISE_REGIST_ROLE_AUTH_IDENTITY;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private DictionaryAbilityService dictionaryAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcApplicationPropertyAbilityService umcApplicationPropertyAbilityService;

    @Override
    public UmcUserDetails getUserInfoByUserId(Long userId, String token, String appCode, String uri) {
        List mcs;
        String o;
        UmcMemInfoBO uInfo;
        UmcUserDetails umcUserDetails = new UmcUserDetails();
        umcUserDetails.setRespCode("0000");
        umcUserDetails.setRespDesc("\u6210\u529f");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bf7\u6c42uri==>{}", (Object)uri);
        }
        if ((uInfo = (UmcMemInfoBO)JSONObject.parseObject((String)(o = (String)this.cacheTemplate.get(token)), UmcMemInfoBO.class)) != null && uInfo.getUserId() != null && uInfo.getMemIdExt() != null) {
            List mcs2;
            umcUserDetails.setUserDetails(uInfo);
            Object obj = this.cacheTemplate.get("DIC_MENU_CODE_REDIS_" + uri);
            if (obj != null && !CollectionUtils.isEmpty((Collection)(mcs2 = (List)obj))) {
                for (String menuCode : mcs2) {
                    if (!uInfo.getMenuCodeList().contains(menuCode)) continue;
                    return umcUserDetails;
                }
                umcUserDetails.setRespDesc("\u65e0\u6743\u9650\u64cd\u4f5c[" + uri + "]");
                umcUserDetails.setRespCode("AE403");
            }
            return umcUserDetails;
        }
        UmcMemInfoBO userInfo = this.loadUserInfo(userId, token);
        String defaltAppCode = "dyc";
        if (StringUtils.isBlank((CharSequence)appCode)) {
            appCode = defaltAppCode;
        }
        try {
            if (userInfo.getMemAffiliation().equals("01")) {
                this.loadUserMenus(userInfo, appCode);
                this.loadUserAuthoritys(userInfo, appCode);
            }
        }
        catch (Exception e) {
            umcUserDetails.setRespDesc("\u9519\u8bef" + e);
            umcUserDetails.setRespCode("AE403");
            e.printStackTrace();
            return umcUserDetails;
        }
        if (null != userInfo) {
            this.cacheTemplate.set(token, (Object)JSONObject.toJSONString((Object)userInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), this.expTime);
        }
        umcUserDetails.setUserDetails(userInfo);
        Object obj = this.cacheTemplate.get("DIC_MENU_CODE_REDIS_" + uri);
        if (obj != null && !CollectionUtils.isEmpty((Collection)(mcs = (List)obj))) {
            for (String menuCode : mcs) {
                if (!userInfo.getMenuCodeList().contains(menuCode)) continue;
                return umcUserDetails;
            }
            umcUserDetails.setRespDesc("\u65e0\u6743\u9650\u64cd\u4f5c[" + uri + "]");
            umcUserDetails.setRespCode("AE403");
        }
        return umcUserDetails;
    }

    private UmcMemInfoBO loadUserInfo(Long userId, String token) {
        UmcMemInfoBO userInfo = new UmcMemInfoBO();
        SelectUserInfoReqBO userInfoReqBO = new SelectUserInfoReqBO();
        userInfoReqBO.setUserId(userId);
        UmcQryMemInfoByUserIdAbilityReqBO abilityReqBO = new UmcQryMemInfoByUserIdAbilityReqBO();
        abilityReqBO.setUserIdWeb(userId);
        UmcQryMemInfoByUserIdAbilityRspBO rspUser = this.umcQryMemIdByUserIdAbilityService.qryMemInfoByUserId(abilityReqBO);
        if (rspUser != null) {
            BeanUtils.copyProperties((Object)rspUser, (Object)userInfo);
            userInfo.setUserId(rspUser.getUserId());
            userInfo.setName(rspUser.getMemName2());
            userInfo.setCompanyIdExt(userInfo.getCompanyId());
            userInfo.setMgOrgIdsExt(rspUser.getMgOrgIds());
            userInfo.setMemIdIn(rspUser.getMemId());
            userInfo.setOrgIdIn(userInfo.getOrgId());
            userInfo.setUserIdIn(userInfo.getUserId());
            userInfo.setMemAffiliationExt(userInfo.getMemAffiliation());
            userInfo.setMemIdExt(rspUser.getMemId());
            userInfo.setSupSaleOrgList(rspUser.getSupSaleOrgList());
            userInfo.setIsprofess(rspUser.getIsprofess());
            userInfo.setSex(rspUser.getSex());
            userInfo.setRegEmail(rspUser.getRegEmail());
            userInfo.setPsDiscountRate(rspUser.getPsDiscountRate());
            userInfo.setOrgLevelIn(rspUser.getOrgLevel());
            userInfo.setUmcStationsListWebExt(rspUser.getUmcStationsListWeb());
            userInfo.setUsername(rspUser.getRegAccount());
            userInfo.setOrgId(rspUser.getOrgId());
            userInfo.setOrgCodeIn(rspUser.getOrgCode());
            userInfo.setCellphone(rspUser.getRegMobile());
            userInfo.setOrgTypeIn(rspUser.getOrgType());
            userInfo.setOrgPath(rspUser.getOrgTreePath());
            userInfo.setOrgName(rspUser.getOrgName());
            userInfo.setOldMemIdIn(rspUser.getOldMemIdIn());
            userInfo.setMemUserType(rspUser.getUserType());
            userInfo.setIntExtPropertyCook(rspUser.getIntExtPropertyCook());
            userInfo.setTradeCapacityCook(rspUser.getTradeCapacityCook());
            userInfo.setTradeUserTypeCook(rspUser.getTradeUserTypeCook());
            userInfo.setTradeUserTypeSelectCook(rspUser.getTradeUserTypeSelectCook());
            Long adminId = 1L;
            if (adminId.equals(rspUser.getMemId())) {
                ArrayList<Long> mgOrgIds = new ArrayList<Long>();
                mgOrgIds.add(1L);
                userInfo.setMgOrgIdsExt(mgOrgIds);
            }
            ArrayList<String> outerUserTypes = new ArrayList<String>();
            if ("2".equals(rspUser.getIsProfessionalOrgExt())) {
                if (null != rspUser.getIsBranchUnit() && 1 == rspUser.getIsBranchUnit()) {
                    outerUserTypes.add("6");
                } else {
                    outerUserTypes.add("5");
                }
            } else {
                outerUserTypes.add(rspUser.getUserType());
            }
            String loginSource = (String)this.cacheTemplate.get(token + "loginSource");
            userInfo.setLoginSource(loginSource);
            userInfo.setOuterUserTypes(outerUserTypes);
            UmcQrySingleValuePropertyAbilityReqBO umcQrySingleValuePropertyAbilityReqBO = new UmcQrySingleValuePropertyAbilityReqBO();
            umcQrySingleValuePropertyAbilityReqBO.setKey("staff.welfare.pay.config.enable");
            UmcQrySingleValuePropertyAbilityRspBO umcQrySingleValuePropertyAbilityRspBO = this.umcApplicationPropertyAbilityService.qrySingleValue(umcQrySingleValuePropertyAbilityReqBO);
            if ("0000".equals(umcQrySingleValuePropertyAbilityRspBO.getRespCode()) && !StringUtils.isBlank((CharSequence)umcQrySingleValuePropertyAbilityRspBO.getValue())) {
                userInfo.setStaffWelfarePayConfigEnable(Boolean.parseBoolean(umcQrySingleValuePropertyAbilityRspBO.getValue()));
            }
        }
        return userInfo;
    }

    private void loadUserMenus(UmcMemInfoBO userInfo, String appCode) throws Exception {
        ArrayList<String> roleTagCodes = new ArrayList<String>();
        roleTagCodes.add("common");
        if ("1".equals(userInfo.getTradeUserTypeSelectCook())) {
            roleTagCodes.add("pur");
        }
        if ("2".equals(userInfo.getTradeUserTypeSelectCook())) {
            roleTagCodes.add("sup");
        }
        SelectAccessMenuReqBO menuReqBO = new SelectAccessMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        menuReqBO.setApplicationCode(appCode);
        menuReqBO.setTagRoleCodes(roleTagCodes);
        SelectAccessMenuRspBO menuRspBO = this.selectAccessMenuService.selectAccessMenuService(menuReqBO);
        ArrayList<String> menuCodeList = new ArrayList<String>();
        List menuList = menuRspBO.getAccessMenuList();
        if (menuList != null && menuList.size() > 0) {
            for (AccessMenu menu : menuList) {
                if (StringUtils.isNotBlank((CharSequence)menu.getMenuDomain())) {
                    menu.setDomain(menu.getMenuDomain());
                }
                menuCodeList.add(menu.getMenuCode());
            }
            List unMenuInfos = ListUtils.copyListProperties((List)menuList, MenuInfo.class);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appCode})) {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setOrgPath(userInfo.getOrgPath());
                applicationByUserReqBO.setUserId(userInfo.getUserId());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                applicationBOS.forEach(a -> {
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{a.getApplicationCode()}) && a.getApplicationCode().equals(appCode) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getUrl()})) {
                        MenuInfo m = new MenuInfo();
                        m.setUrl(a.getUrl());
                        unMenuInfos.add(m);
                    }
                });
            }
            MenuInfo m = new MenuInfo();
            m.setUrl("/index.html");
            unMenuInfos.add(m);
            MenuInfo m1 = new MenuInfo();
            m1.setUrl("/rest/**");
            unMenuInfos.add(m1);
            userInfo.setUnstructuredMunes(unMenuInfos);
            HashMap<String, List<MenuInfo>> menuMap = new HashMap<String, List<MenuInfo>>();
            Map<String, List<AccessMenu>> menuListMap = this.groupBillingDataByAppCode(menuList);
            menuListMap.keySet().forEach(key -> {
                List accessMenus = (List)menuListMap.get(key);
                List menuInfos = ListUtils.copyListProperties((List)accessMenus, MenuInfo.class);
                if (menuInfos.size() > 0) {
                    List<MenuInfo> buildByRecursive = this.buildByRecursive(menuInfos);
                    menuMap.put((String)key, buildByRecursive);
                }
            });
            userInfo.setMenus(menuMap);
            userInfo.setMenuCodeList(menuCodeList);
        }
    }

    private void loadManagerOrg(UmcMemInfoBO userInfo) {
        UmcQryOrgByUserStationAbilityReqBO reqBO = new UmcQryOrgByUserStationAbilityReqBO();
        reqBO.setMemIdExt(userInfo.getMemIdExt());
        reqBO.setStationType("ORDER_QRY_ORG_AUTH");
        UmcQryOrgByUserStationAbilityRspBO rspBO = this.umcQryOrgByUserStationAbilityService.qryOrgByUserStation(reqBO);
        userInfo.setManagerOrgListIn(rspBO.getRows());
    }

    private List<MenuInfo> buildByRecursive(List<MenuInfo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<MenuInfo> trees = new ArrayList<MenuInfo>();
        for (MenuInfo treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private MenuInfo findChildren(MenuInfo root, List<MenuInfo> allMenus) {
        for (MenuInfo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getSubMenus() == null) {
                root.setSubMenus(new ArrayList<MenuInfo>());
            }
            root.getSubMenus().add(this.findChildren(it, allMenus));
        }
        return root;
    }

    private void loadUserAuthoritys(UmcMemInfoBO userInfo, String appCode) {
        HashSet<AuthorityInfo> authorities = new HashSet<AuthorityInfo>();
        ArrayList<String> roleTagCodes = new ArrayList<String>();
        roleTagCodes.add("common");
        if ("1".equals(userInfo.getTradeUserTypeSelectCook())) {
            roleTagCodes.add("pur");
        }
        if ("2".equals(userInfo.getTradeUserTypeSelectCook())) {
            roleTagCodes.add("sup");
        }
        SelectAuthoritysMenuReqBO menuReqBO = new SelectAuthoritysMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setApplicationCode(appCode);
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        menuReqBO.setTagRoleCodes(roleTagCodes);
        SelectAuthoritysMenuRspBO authoritysMenuRspBO = this.selectAuthoritysMenuService.selectAuthoritysMenuService(menuReqBO);
        List authorityMenuList = authoritysMenuRspBO.getAuthorityMenuList();
        if (authorityMenuList != null && authorityMenuList.size() > 0) {
            List authorityInfos = ListUtils.copyListProperties((List)authorityMenuList, AuthorityInfo.class);
            authorities.addAll(authorityInfos);
        }
        SelectRoleAuthoritysReqBO roleAuthoritysReqBO = new SelectRoleAuthoritysReqBO();
        roleAuthoritysReqBO.setUserId(userInfo.getUserId());
        roleAuthoritysReqBO.setOrgTreePath(userInfo.getOrgPath());
        roleAuthoritysReqBO.setRoleTagCodes(roleTagCodes);
        SelectRoleAuthoritysRspBO roleAuthoritysRspBO = this.selectRoleAuthoritysService.selectRoleAuthoritysService(roleAuthoritysReqBO);
        List roleAuthoritysRspBOAuthorityMenuList = roleAuthoritysRspBO.getAuthorityMenuList();
        if (roleAuthoritysRspBOAuthorityMenuList != null && roleAuthoritysRspBOAuthorityMenuList.size() > 0) {
            List authorityInfos = ListUtils.copyListProperties((List)roleAuthoritysRspBOAuthorityMenuList, AuthorityInfo.class);
            authorities.addAll(authorityInfos);
            ArrayList<String> roleNames = new ArrayList<String>();
            for (AuthorityMenu authorityInfoItem : roleAuthoritysRspBOAuthorityMenuList) {
                if (this.EXTENTERPRISE_REGIST_ROLE_AUTH_IDENTITY.equals(authorityInfoItem.getKey())) {
                    userInfo.setEnterprisePerfectFlag("1");
                }
                roleNames.add(authorityInfoItem.getTitle());
            }
            userInfo.setRoleNames(roleNames);
            if (!"1".equals(userInfo.getEnterprisePerfectFlag())) {
                userInfo.setSupplierPerfectFlag("1");
            }
        }
        userInfo.setPermission(authorities);
    }

    private Map<String, List<AccessMenu>> groupBillingDataByAppCode(List<AccessMenu> billingList) throws Exception {
        HashMap<String, List<AccessMenu>> resultMap = new HashMap<String, List<AccessMenu>>();
        try {
            for (AccessMenu accessMenu : billingList) {
                if (resultMap.containsKey(accessMenu.getAppCode())) {
                    ((List)resultMap.get(accessMenu.getAppCode())).add(accessMenu);
                    continue;
                }
                ArrayList<AccessMenu> tmpList = new ArrayList<AccessMenu>();
                tmpList.add(accessMenu);
                resultMap.put(accessMenu.getAppCode(), tmpList);
            }
        }
        catch (Exception e) {
            throw new Exception("\u6309\u7167\u5b50\u7cfb\u7edf\u7f16\u7801\u5bf9\u83dc\u5355\u6570\u636e\u8fdb\u884c\u5206\u7ec4\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
        return resultMap;
    }
}

