/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util.http;

import com.cgd.base.util.http.HSNHttpPoolHelper;
import com.cgd.base.util.http.HttpRetBean;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

public class HSHttpHelper {
    private static final Log log = LogFactory.getLog(HSHttpHelper.class);
    private static final boolean isDebugLog = log.isDebugEnabled();

    public static HttpRetBean doUrlPostRequest(URI uri, Header[] headers, byte[] reqBody, String HpartyEnconding, Boolean isHttps) throws ConnectException, IOException, URISyntaxException {
        return HSHttpHelper.doUrlExecuteRequest((HttpUriRequest)new HttpPost(uri), headers, reqBody, HpartyEnconding, isHttps);
    }

    public static HttpRetBean doUrlGetRequest(URI uri, Header[] headers, String HpartyEnconding, Boolean isHttps) throws ConnectException, IOException, URISyntaxException {
        return HSHttpHelper.doUrlExecuteRequest((HttpUriRequest)new HttpGet(uri), headers, null, HpartyEnconding, isHttps);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HttpRetBean doUrlExecuteRequest(HttpUriRequest request, Header[] headers, byte[] reqBody, String HpartyEnconding, Boolean isHttps) throws ConnectException, IOException, URISyntaxException {
        HttpRetBean var10;
        if (headers != null && headers.length > 0) {
            request.setHeaders(headers);
        }
        if (reqBody != null && request instanceof HttpEntityEnclosingRequestBase) {
            ByteArrayEntity entity = new ByteArrayEntity(reqBody);
            entity.setChunked(false);
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
        }
        HttpClient httpClient = null;
        ObjectPool httpClientPool = null;
        try {
            httpClientPool = isHttps != false ? HSNHttpPoolHelper.hsnHttpsObjectPoolBean.getHttpClientPool() : HSNHttpPoolHelper.hsnHttpObjectPoolBean.getHttpClientPool();
            httpClient = (HttpClient)httpClientPool.borrowObject();
            HttpResponse httpResponse = httpClient.execute(request);
            String returnData = null;
            InputStream inputStream = httpResponse.getEntity().getContent();
            returnData = inputStream == null ? null : IOUtils.toString((InputStream)inputStream, (String)HpartyEnconding);
            if (inputStream != null) {
                inputStream.close();
            }
            var10 = new HttpRetBean(httpResponse.getStatusLine().getStatusCode(), httpResponse.getAllHeaders(), returnData);
            if (httpClient == null) return var10;
        }
        catch (ConnectException var22) {
            try {
                request.abort();
                throw var22;
                catch (IOException var23) {
                    request.abort();
                    throw var23;
                }
                catch (URISyntaxException var24) {
                    request.abort();
                    throw var24;
                }
                catch (Exception var25) {
                    throw new RuntimeException(request.getURI().toString() + ":" + var25.getMessage(), var25);
                }
            }
            catch (Throwable throwable) {
                if (httpClient == null) throw throwable;
                try {
                    httpClientPool.returnObject(httpClient);
                    throw throwable;
                }
                catch (Exception var21) {
                    log.warn((Object)"HttpClient\u5bf9\u8c61\u5f52\u8fd8\u5931\u8d25", (Throwable)var21);
                }
                throw throwable;
            }
        }
        try {
            httpClientPool.returnObject((Object)httpClient);
            return var10;
        }
        catch (Exception var21) {
            log.warn((Object)"HttpClient\u5bf9\u8c61\u5f52\u8fd8\u5931\u8d25", (Throwable)var21);
            return var10;
        }
    }
}

