/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.base.utils;

import com.tydic.uoc.base.utils.MD5Util;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ESBSignUtil {
    private static final String KEY = "KEY";
    private static final String APP_KEY = "APP_KEY";
    private static final String SERIALNUMBER = "SERIALNUMBER";
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final String TOKEN = "TOKEN";

    public static String getESBToken(String characterEncoding, String key, String appkey, String serialnumber, String timesTamp) {
        TreeMap<Object, Object> parameters = new TreeMap<Object, Object>();
        parameters.put(KEY, key);
        parameters.put(APP_KEY, appkey);
        parameters.put(SERIALNUMBER, serialnumber);
        parameters.put(TIMESTAMP, timesTamp);
        return ESBSignUtil.createToken(characterEncoding, parameters);
    }

    private static String createToken(String characterEncoding, SortedMap<Object, Object> parameters) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<Object, Object>> es = parameters.entrySet();
        for (Map.Entry<Object, Object> entry : es) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String[]) {
                v = ((String[])v)[0];
            }
            if (null == v || "".equals(v) || TOKEN.equals(k) || KEY.equals(k)) continue;
            sb.append(k).append(v);
        }
        sb.append(parameters.get(KEY));
        return ESBSignUtil.getMD5Encode(characterEncoding, sb.toString());
    }

    private static String getMD5Encode(String characterEncoding, String md5Code) {
        return MD5Util.MD5Encode(md5Code, characterEncoding);
    }
}

