/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.ability.impl.afterservice;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.cgd.common.util.DateUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.order.extend.ability.afterservice.PebExtAfterSalesDetailsQueryAbilityService;
import com.tydic.order.extend.ability.afterservice.PebExtAfterSalesExportAbilityService;
import com.tydic.order.extend.bo.afs.PebExtAfterSalesDetailsQueryReqBO;
import com.tydic.order.extend.bo.afs.PebExtAfterSalesDetailsQueryRspBO;
import com.tydic.order.extend.bo.afs.PebExtAfterSalesExportReqBO;
import com.tydic.order.extend.bo.afs.PebExtAfterSalesExportRspBO;
import com.tydic.order.extend.bo.afs.PebExtOrdAsItemRspBO;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.uoc.dao.OrdAgreementMapper;
import com.tydic.order.uoc.dao.OrdGoodsMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdAgreementPO;
import com.tydic.order.uoc.dao.po.OrdGoodsPO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtAfterSalesExportAbilityService.class)
public class PebExtAfterSalesExportAbilityServiceImpl
implements PebExtAfterSalesExportAbilityService {
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV")
    private PebExtAfterSalesDetailsQueryAbilityService pebExtAfterSalesDetailsQueryAbilityService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    public PebExtAfterSalesExportRspBO doExport(PebExtAfterSalesExportReqBO reqBO) {
        OrderPO orderPO = this.doQueryOrder(reqBO.getOrderId());
        PebExtAfterSalesDetailsQueryRspBO detailRsp = this.doQueryAfsDetail(reqBO);
        Map<Long, BigDecimal> shipItemIdMap = this.doQueryShipItem(reqBO.getOrderId());
        Map<Long, String> ordItemIdMap = this.doQueryGoods(reqBO.getOrderId());
        String vendorName = this.doQueryAgreement(reqBO.getOrderId());
        String export = this.doUploadFile(reqBO.getPrintType(), detailRsp, orderPO, shipItemIdMap, ordItemIdMap, vendorName);
        PebExtAfterSalesExportRspBO rspBO = new PebExtAfterSalesExportRspBO();
        rspBO.setExportUrl(export);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String doQueryAgreement(Long orderId) {
        OrdAgreementPO ordAgreementPO = new OrdAgreementPO();
        ordAgreementPO.setOrderId(orderId);
        List list = this.ordAgreementMapper.selectByCondition(ordAgreementPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return "";
        }
        return ((OrdAgreementPO)list.get(0)).getVendorName();
    }

    private Map<Long, String> doQueryGoods(Long orderId) {
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderId(orderId);
        List list = this.ordGoodsMapper.getList(ordGoodsPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            HashMap<Long, String> map = new HashMap<Long, String>(list.size());
            list.forEach(po -> map.put(po.getOrdItemId(), "\u89c4\u683c\uff1a" + this.convertNullToString(po.getSpec()) + "\\\u578b\u53f7\uff1a" + this.convertNullToString(po.getModel()) + "\\\u56fe\u53f7\uff1a" + this.convertNullToString(po.getFigure())));
            return map;
        }
        return new HashMap<Long, String>(0);
    }

    private Map<Long, BigDecimal> doQueryShipItem(Long orderId) {
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(orderId);
        List list = this.ordShipItemMapper.getList(ordShipItemPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new HashMap<Long, BigDecimal>(0);
        }
        return list.stream().collect(Collectors.toMap(OrdShipItemPO::getShipItemId, OrdShipItemPO::getReturnCount));
    }

    private OrderPO doQueryOrder(Long orderId) {
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(orderId);
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new UocProBusinessException("0200", "\u67e5\u8be2\u8ba2\u5355\u65e0\u6570\u636e\uff01");
        }
        return orderPO;
    }

    private PebExtAfterSalesDetailsQueryRspBO doQueryAfsDetail(PebExtAfterSalesExportReqBO reqBO) {
        PebExtAfterSalesDetailsQueryReqBO detailReqBO = new PebExtAfterSalesDetailsQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)detailReqBO);
        PebExtAfterSalesDetailsQueryRspBO detailRsp = this.pebExtAfterSalesDetailsQueryAbilityService.getUocAfterSalesDetails(detailReqBO);
        if (!"0000".equals(detailRsp.getRespCode())) {
            throw new UocProBusinessException("0100", detailRsp.getRespDesc());
        }
        if (detailRsp.getOrdAfterServiceRspBO() == null) {
            throw new UocProBusinessException("0200", "\u67e5\u8be2\u552e\u540e\u65e0\u6570\u636e\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)detailRsp.getOrdAsItemRspBOList())) {
            throw new UocProBusinessException("0200", "\u67e5\u8be2\u552e\u540e\u660e\u7ec6\u65e0\u6570\u636e\uff01");
        }
        return detailRsp;
    }

    private String doUploadFile(Integer printType, PebExtAfterSalesDetailsQueryRspBO afsDetail, OrderPO orderPO, Map<Long, BigDecimal> shipItemIdMap, Map<Long, String> ordItemIdMap, String vendorName) {
        String fileName;
        byte[] bytes;
        String exportUrl = "";
        if (PebExtConstant.PrintType.EXCEL.equals(printType)) {
            bytes = this.doCreateExcel(afsDetail, orderPO, shipItemIdMap, ordItemIdMap, vendorName);
            fileName = "\u9000\u8d27\u5355.xls";
        } else if (PebExtConstant.PrintType.PDF.equals(printType)) {
            bytes = this.doCreatePdf(afsDetail, orderPO, shipItemIdMap, ordItemIdMap, vendorName);
            fileName = "\u9000\u8d27\u5355.pdf";
        } else {
            throw new UocProBusinessException("0100", "\u5165\u53c2\u6253\u5370\u7c7b\u578b\u65e0\u6548");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doCreateExcel(PebExtAfterSalesDetailsQueryRspBO afsDetail, OrderPO orderPO, Map<Long, BigDecimal> shipItemIdMap, Map<Long, String> ordItemIdMap, String vendorName) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        String sheetName = "\u9000\u8d27\u5355";
        HSSFCellStyle dataStyle = PebExtAfterSalesExportAbilityServiceImpl.getStyleInCommon(workbook, (short)11, "\u5b8b\u4f53", true, HorizontalAlignment.CENTER, BorderStyle.THIN);
        HSSFCellStyle titleStyle = PebExtAfterSalesExportAbilityServiceImpl.getStyleInCommon(workbook, (short)18, "\u5b8b\u4f53", false, HorizontalAlignment.CENTER, BorderStyle.NONE);
        HSSFCellStyle totalMoneyStyle = PebExtAfterSalesExportAbilityServiceImpl.getStyleInCommon(workbook, (short)11, "\u5b8b\u4f53", true, HorizontalAlignment.RIGHT, BorderStyle.THIN);
        HSSFSheet sheet = workbook.createSheet(sheetName);
        int LENGTH = 7;
        sheet.setDisplayGridlines(false);
        sheet.setDefaultColumnWidth(20);
        for (int rowIndex = 0; rowIndex <= 3; ++rowIndex) {
            HSSFRow titleRow = sheet.createRow(rowIndex);
            titleRow.setHeightInPoints(30.0f);
            for (int columnIndex = 0; columnIndex <= 6; ++columnIndex) {
                titleRow.createCell(columnIndex);
            }
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 6));
        HSSFRow titleRow = sheet.getRow(0);
        HSSFCell titleCell = titleRow.getCell(0);
        titleCell.setCellStyle(titleStyle);
        titleCell.setCellValue("\u9000\u8d27\u5355");
        HSSFRow orderInfoRow = sheet.getRow(1);
        HSSFCell orderInfoCell = orderInfoRow.getCell(0);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell.setCellValue("\u5382\u5546\u540d\u79f0");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 2));
        orderInfoCell = orderInfoRow.getCell(1);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell.setCellValue(this.convertNullToString(vendorName));
        orderInfoCell = orderInfoRow.getCell(2);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(3);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell.setCellValue("\u8ba2\u5355\u540d\u79f0");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 4, 6));
        orderInfoCell = orderInfoRow.getCell(4);
        orderInfoCell.setCellValue(this.convertNullToString(orderPO.getOrderName()));
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(5);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(6);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoRow = sheet.getRow(2);
        orderInfoCell = orderInfoRow.getCell(0);
        orderInfoCell.setCellValue("\u9a8c\u6536\u5355\u4f4d");
        orderInfoCell.setCellStyle(dataStyle);
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 1, 2));
        orderInfoCell = orderInfoRow.getCell(1);
        orderInfoCell.setCellValue("");
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(2);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(3);
        orderInfoCell.setCellValue("\u8ba2\u5355\u7f16\u53f7");
        orderInfoCell.setCellStyle(dataStyle);
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 6));
        orderInfoCell = orderInfoRow.getCell(4);
        orderInfoCell.setCellValue(this.convertNullToString(afsDetail.getOrdAfterServiceRspBO().getSaleVoucherNo()));
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(5);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(6);
        orderInfoCell.setCellStyle(dataStyle);
        String[] headers = new String[]{"\u5e8f\u53f7", "\u7269\u8d44\u540d\u79f0", "\u89c4\u683c\\\u578b\u53f7\\\u56fe\u53f7", "\u5230\u8d27\u6570\u91cf", "\u9000\u8d27\u6570\u91cf", "\u7ed3\u7b97\u5355\u4ef7\uff08\u5143\uff09", "\u5230\u8d27\u91d1\u989d\uff08\u5143\uff09"};
        HSSFRow row = sheet.getRow(3);
        for (int i = 0; i < headers.length; i = (int)((short)(i + 1))) {
            HSSFCell cell = row.getCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellStyle(dataStyle);
            cell.setCellValue((RichTextString)text);
        }
        BigDecimal arriveTotalmoney = BigDecimal.ZERO;
        int index = 3;
        for (int i = 0; i < afsDetail.getOrdAsItemRspBOList().size() + 1; ++i) {
            row = sheet.createRow(++index);
            for (int column = 0; column <= 6; ++column) {
                HSSFCell cell = row.createCell(column);
                cell.setCellStyle(dataStyle);
                if (i >= afsDetail.getOrdAsItemRspBOList().size()) continue;
                PebExtOrdAsItemRspBO item = (PebExtOrdAsItemRspBO)afsDetail.getOrdAsItemRspBOList().get(i);
                arriveTotalmoney = arriveTotalmoney.add(shipItemIdMap.get(item.getShipItemId()).multiply(item.getSalePriceMoney()));
                if (column == 0) {
                    cell.setCellValue(String.valueOf(i + 1));
                    continue;
                }
                if (column == 1) {
                    cell.setCellValue(this.convertNullToString(item.getSkuMaterialName()));
                    continue;
                }
                if (column == 2) {
                    cell.setCellValue(this.convertNullToString(ordItemIdMap.get(item.getOrdItemId())));
                    continue;
                }
                if (column == 3) {
                    cell.setCellValue(this.convertNullToString(shipItemIdMap.get(item.getShipItemId())));
                    continue;
                }
                if (column == 4) {
                    cell.setCellValue(this.convertNullToString(item.getReturnCount()));
                    continue;
                }
                if (column == 5) {
                    cell.setCellValue(this.convertNullToString(item.getSalePriceMoney()));
                    continue;
                }
                if (column != 6) continue;
                cell.setCellValue(this.convertNullToString(shipItemIdMap.get(item.getShipItemId()).multiply(item.getSalePriceMoney())));
            }
        }
        sheet.addMergedRegion(new CellRangeAddress(index - 1, index - 1, 0, 6));
        titleRow = sheet.getRow(index - 1);
        titleCell = titleRow.getCell(0);
        titleCell.setCellStyle(totalMoneyStyle);
        titleCell.setCellValue("\u5230\u8d27\u91d1\u989d\u5408\u8ba1\uff1a" + this.convertNullToString(arriveTotalmoney));
        titleRow = sheet.getRow(index);
        sheet.addMergedRegion(new CellRangeAddress(index, index, 0, 1));
        titleCell = titleRow.getCell(0);
        titleCell.setCellValue("\u9000\u8d27\u7533\u8bf7\u65f6\u95f4\uff1a" + DateUtil.dateToStr((Date)afsDetail.getOrdAfterServiceRspBO().getSubmiteTime()));
        sheet.addMergedRegion(new CellRangeAddress(index, index, 2, 4));
        titleCell = titleRow.getCell(2);
        titleCell.setCellValue("\u9000\u8d27\u7533\u8bf7\u4eba\uff1a" + this.convertNullToString(afsDetail.getOrdAfterServiceRspBO().getSubmitterOperName()));
        sheet.addMergedRegion(new CellRangeAddress(index, index, 5, 6));
        titleCell = titleRow.getCell(5);
        titleCell.setCellValue("\u9000\u8d27\u786e\u8ba4\u65f6\u95f4\uff1a" + DateUtil.dateToStr((Date)afsDetail.getOrdAfterServiceRspBO().getFinishTime()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static HSSFCellStyle getStyleInCommon(HSSFWorkbook workbook, short fontHeightInPoints, String fontName, boolean wrapText, HorizontalAlignment alignment, BorderStyle borderStyle) {
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setAlignment(alignment);
        cellStyle.setBorderBottom(borderStyle);
        cellStyle.setBorderLeft(borderStyle);
        cellStyle.setBorderRight(borderStyle);
        cellStyle.setBorderTop(borderStyle);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(wrapText);
        HSSFFont titleFont = workbook.createFont();
        titleFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleFont.setFontHeightInPoints(fontHeightInPoints);
        titleFont.setFontName(fontName);
        cellStyle.setFont(titleFont);
        return cellStyle;
    }

    private byte[] doCreatePdf(PebExtAfterSalesDetailsQueryRspBO afsDetail, OrderPO orderPO, Map<Long, BigDecimal> shipItemIdMap, Map<Long, String> ordItemIdMap, String vendorName) {
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("0100", "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519", (Throwable)e);
        }
        int COLUMNS = 7;
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font titleFont = new Font(baseFont, 14.0f, 1);
        document.open();
        PdfPTable titleTable = new PdfPTable(1);
        PdfPCell titleCell = new PdfPCell(new Phrase("\u9000\u8d27\u5355", titleFont));
        titleCell.setColspan(1);
        titleCell.setFixedHeight(60.0f);
        titleCell.setBorder(0);
        titleCell.setVerticalAlignment(5);
        titleCell.setHorizontalAlignment(1);
        titleTable.addCell(titleCell);
        try {
            document.add((Element)titleTable);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("0100", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        PdfPTable pdfPTable1 = new PdfPTable(7);
        PdfPCell pdfPCell1 = new PdfPCell(new Phrase("\u5382\u5546\u540d\u79f0", contentFont));
        pdfPCell1.setFixedHeight(20.0f);
        pdfPCell1.setHorizontalAlignment(2);
        pdfPCell1.setVerticalAlignment(5);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(this.convertNullToString(vendorName), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u8ba2\u5355\u540d\u79f0", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(this.convertNullToString(orderPO.getOrderName()), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(3);
        pdfPTable1.addCell(pdfPCell1);
        try {
            document.add((Element)pdfPTable1);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("0100", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        PdfPTable pdfPTable2 = new PdfPTable(7);
        PdfPCell pdfPCell2 = new PdfPCell(new Phrase("\u9a8c\u6536\u5355\u4f4d", contentFont));
        pdfPCell2.setFixedHeight(20.0f);
        pdfPCell2.setHorizontalAlignment(2);
        pdfPCell2.setVerticalAlignment(5);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase("", contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(2);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase("\u8ba2\u5355\u7f16\u53f7", contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(this.convertNullToString(afsDetail.getOrdAfterServiceRspBO().getSaleVoucherNo()), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(3);
        pdfPTable2.addCell(pdfPCell2);
        try {
            document.add((Element)pdfPTable2);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("0100", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        PdfPTable headTable = new PdfPTable(7);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setFixedHeight(20.0f);
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u8d44\u540d\u79f0", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u89c4\u683c\\\u578b\u53f7\\\u56fe\u53f7", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5230\u8d27\u6570\u91cf", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u9000\u8d27\u6570\u91cf", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7ed3\u7b97\u5355\u4ef7\uff08\u5143\uff09", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5230\u8d27\u91d1\u989d\uff08\u5143\uff09", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("0100", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        BigDecimal arriveTotalmoney = BigDecimal.ZERO;
        int count = 1;
        for (PebExtOrdAsItemRspBO item : afsDetail.getOrdAsItemRspBOList()) {
            PdfPTable detailTable = new PdfPTable(7);
            PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setFixedHeight(20.0f);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(this.convertNullToString(item.getSkuMaterialName()), contentFont));
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(ordItemIdMap.get(item.getOrdItemId()), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(this.convertNullToString(shipItemIdMap.get(item.getShipItemId())), contentFont));
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(this.convertNullToString(item.getReturnCount()), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(this.convertNullToString(item.getSalePriceMoney()), contentFont));
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            arriveTotalmoney = arriveTotalmoney.add(shipItemIdMap.get(item.getShipItemId()).multiply(item.getSalePriceMoney()));
            detailCell.setPhrase(new Phrase(String.valueOf(shipItemIdMap.get(item.getShipItemId()).multiply(item.getSalePriceMoney())), contentFont));
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            try {
                document.add((Element)detailTable);
            }
            catch (DocumentException e) {
                throw new UocProBusinessException("0100", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
            }
        }
        PdfPTable pdfPTable3 = new PdfPTable(7);
        PdfPCell pdfPCell3 = new PdfPCell(new Phrase("\u5230\u8d27\u91d1\u989d\u5408\u8ba1\uff1a" + this.convertNullToString(arriveTotalmoney), contentFont));
        pdfPCell3.setVerticalAlignment(5);
        pdfPCell3.setHorizontalAlignment(2);
        pdfPCell3.setColspan(7);
        pdfPTable3.addCell(pdfPCell3);
        try {
            document.add((Element)pdfPTable3);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("0100", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        PdfPTable pdfPTable4 = new PdfPTable(7);
        PdfPCell pdfPCell4 = new PdfPCell(new Phrase("\u9000\u8d27\u7533\u8bf7\u65f6\u95f4\uff1a" + DateUtil.dateToStr((Date)afsDetail.getOrdAfterServiceRspBO().getSubmiteTime()), contentFont));
        pdfPCell4.setVerticalAlignment(5);
        pdfPCell4.setHorizontalAlignment(2);
        pdfPCell4.setColspan(2);
        pdfPTable4.addCell(pdfPCell4);
        pdfPCell4 = new PdfPCell(new Phrase("\u9000\u8d27\u7533\u8bf7\u4eba\uff1a" + afsDetail.getOrdAfterServiceRspBO().getSubmitterOperName(), contentFont));
        pdfPCell4.setVerticalAlignment(5);
        pdfPCell4.setHorizontalAlignment(2);
        pdfPCell4.setColspan(3);
        pdfPTable4.addCell(pdfPCell4);
        pdfPCell4 = new PdfPCell(new Phrase("\u9000\u8d27\u786e\u8ba4\u65f6\u95f4\uff1a" + DateUtil.dateToStr((Date)afsDetail.getOrdAfterServiceRspBO().getFinishTime()), contentFont));
        pdfPCell4.setVerticalAlignment(5);
        pdfPCell4.setHorizontalAlignment(2);
        pdfPCell4.setColspan(2);
        pdfPTable4.addCell(pdfPCell4);
        try {
            document.add((Element)pdfPTable4);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("0100", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        document.close();
        return byteArrayOutputStream.toByteArray();
    }

    private String convertNullToString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }
}

