/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.ability.impl.order;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.extend.ability.order.PebExtFscPayResultAbilityService;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.order.extend.bo.plan.PebOrderInfoBO;
import com.tydic.order.extend.bo.saleorder.OrdInterLogBO;
import com.tydic.order.extend.bo.saleorder.PebExtFieldInReqBO;
import com.tydic.order.extend.busi.order.PebExtPayResultBusiService;
import com.tydic.order.extend.busi.saleorder.PebExtFieldInBusiService;
import com.tydic.order.extend.dao.OrdPayConfMapper;
import com.tydic.order.extend.dao.po.OrdPayConfPO;
import com.tydic.order.pec.busi.es.order.UocPebPreOrderSubmitBsuiService;
import com.tydic.order.pec.busi.es.order.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.third.intf.ability.fsc.PenIntfPaymentFlowService;
import com.tydic.order.third.intf.bo.fsc.PenIntfPaymentFlowReqBO;
import com.tydic.order.third.intf.bo.fsc.PenIntfPaymentFlowRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtFscPayResultAbilityService.class)
public class PebExtFscPayResultAbilityServiceImpl
implements PebExtFscPayResultAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtFscPayResultAbilityServiceImpl.class);
    @Autowired
    private PebExtPayResultBusiService pebExtPayResultBusiService;
    @Value(value="${uoc.pay.publicKey}")
    private String publicKey;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;
    @Autowired
    private PenIntfPaymentFlowService penIntfPaymentFlowService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;

    public PebExtPayResultRspBO dealPayResult(PebExtPayResultReqBO reqBO) {
        log.info("\u63a5\u6536\u5230\u7ed3\u7b97\u652f\u4ed8\u56de\u8c03\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)reqBO));
        String success = "SUCCESS";
        if (!success.equals(reqBO.getResultCode())) {
            PebExtPayResultRspBO rspBO = new PebExtPayResultRspBO();
            rspBO.setNotifyResult(success);
            rspBO.setResultCode(success);
            return rspBO;
        }
        PebExtPayResultRspBO rspBO = this.pebExtPayResultBusiService.dealPayResult(reqBO);
        rspBO.setNotifyResult(rspBO.getResultCode());
        if (rspBO.getSaleId() != null) {
            this.ordIdxSync(rspBO.getOrderId(), rspBO.getSaleId());
        }
        if (CollectionUtils.isNotEmpty((Collection)rspBO.getOrderInfo())) {
            for (PebOrderInfoBO infoBO : rspBO.getOrderInfo()) {
                UocPebPreOrderSubmitReqBO submitReqBO = new UocPebPreOrderSubmitReqBO();
                submitReqBO.setSaleVoucherId(infoBO.getSaleVoucherId());
                submitReqBO.setOrderId(infoBO.getOrderId());
                this.uocPebPreOrderSubmitBsuiService.submit(submitReqBO);
                this.ordIdxSync(infoBO.getOrderId(), infoBO.getSaleVoucherId());
                this.push(reqBO, infoBO.getOrderId(), infoBO.getSaleFee(), infoBO.getSaleCode());
            }
        } else if (UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString().equals(rspBO.getOrderSource())) {
            UocPebPreOrderSubmitReqBO submitReqBO = new UocPebPreOrderSubmitReqBO();
            submitReqBO.setSaleVoucherId(rspBO.getSaleId());
            submitReqBO.setOrderId(rspBO.getOrderId());
            this.uocPebPreOrderSubmitBsuiService.submit(submitReqBO);
            this.push(reqBO, rspBO.getOrderId(), rspBO.getSaleFee(), rspBO.getSaleCode());
            this.ordIdxSync(rspBO.getOrderId(), rspBO.getSaleId());
        }
        return rspBO;
    }

    private void ordIdxSync(Long orderId, Long saleId) {
        UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
        combReqBO.setOrderId(orderId);
        combReqBO.setObjId(saleId);
        combReqBO.setIsStatistics(Boolean.valueOf(false));
        combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
    }

    public void push(PebExtPayResultReqBO reqBO, Long orderId, Long saleFee, String saleCode) {
        PenIntfPaymentFlowReqBO flowReqBO = new PenIntfPaymentFlowReqBO();
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setFieldCode("busiMode");
        mapPO.setOrderId(orderId);
        mapPO.setObjId(orderId);
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        OrdPayConfPO payConfPO = new OrdPayConfPO();
        OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(orderId.longValue());
        payConfPO.setOrderId(orderId);
        payConfPO = (OrdPayConfPO)this.ordPayConfMapper.selectByCondition(payConfPO).get(0);
        flowReqBO.setOrderCode(saleCode);
        flowReqBO.setOutOrderId(reqBO.getOutOrderId());
        flowReqBO.setPaymentFlowId(reqBO.getPayOrderId());
        flowReqBO.setMerchantId(Long.valueOf(reqBO.getMerchantId()));
        flowReqBO.setOrgId(stakeholderPO.getCompanyId());
        try {
            flowReqBO.setOrderAmt(payConfPO.getPrePaySup().multiply(MoneyUtils.Long2BigDecimal((Long)saleFee)).divide(new BigDecimal(100), 2, 2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        flowReqBO.setFlowFlag(reqBO.getPayMethod());
        flowReqBO.setPayType(payConfPO.getPayType().toString());
        flowReqBO.setCreateUserId(Long.valueOf(orderPO.getCreateOperId()));
        flowReqBO.setCreateUserName(stakeholderPO.getPurPlaceOrderName());
        flowReqBO.setPayOrderId(reqBO.getPayOrderId());
        flowReqBO.setPayTime(new Date());
        flowReqBO.setCreateTime(orderPO.getCreateTime());
        flowReqBO.setFlowFlag("00");
        flowReqBO.setPaymentStatus("SUCCESS");
        if (mapPO != null) {
            if ("0".equals(mapPO.getFieldValue())) {
                flowReqBO.setRecName(stakeholderPO.getCompanyName());
            } else {
                flowReqBO.setRecName(stakeholderPO.getSupName());
            }
        } else {
            flowReqBO.setRecName(stakeholderPO.getCompanyName());
        }
        if ("1".equals(orderPO.getUserType())) {
            flowReqBO.setPayName(stakeholderPO.getPurPlaceOrderName());
        } else {
            flowReqBO.setPayName(stakeholderPO.getPurName());
        }
        flowReqBO.setBusiCode(reqBO.getBusiCode());
        PenIntfPaymentFlowRspBO flowRspBO = this.penIntfPaymentFlowService.addPaymentFlow(flowReqBO);
        String in = JSON.toJSONString((Object)flowReqBO);
        String out = JSON.toJSONString((Object)flowRspBO);
        if (StringUtils.isBlank((CharSequence)in)) {
            in = "in";
        }
        if (StringUtils.isBlank((CharSequence)out)) {
            out = "out";
        }
        int max = 3096;
        if (in.length() > max) {
            in = in.substring(0, max - 1);
        }
        if (out.length() > max) {
            out = out.substring(0, max - 1);
        }
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setCallCount(Integer.valueOf(1));
        logBO.setCallState("1");
        logBO.setCallTime(new Date());
        logBO.setCreateLoginId("1");
        logBO.setErrCode(flowRspBO.getRespCode());
        logBO.setErrDetail("1");
        logBO.setFlowFlag(Integer.valueOf(1));
        logBO.setInContent(in);
        logBO.setInterCode("addPaymentFlow");
        logBO.setInterSn("1");
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setOrderId(orderId);
        logBO.setObjId(orderId);
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        PebExtFieldInReqBO inReqBO = new PebExtFieldInReqBO();
        inReqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(inReqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

