/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.ability.impl.order;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.extend.ability.order.PebExtPayRefundAbilityService;
import com.tydic.order.extend.bo.order.PebExtPayRefundReqBO;
import com.tydic.order.extend.bo.order.PebExtPayRefundRspBO;
import com.tydic.order.extend.bo.saleorder.OrdInterLogBO;
import com.tydic.order.extend.bo.saleorder.PebExtFieldInReqBO;
import com.tydic.order.extend.busi.order.PebExtPayRefundBusiService;
import com.tydic.order.extend.busi.saleorder.PebExtFieldInBusiService;
import com.tydic.order.extend.dao.OrdPayConfMapper;
import com.tydic.order.extend.dao.po.OrdPayConfPO;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.third.intf.ability.fsc.PenIntfPaymentFlowService;
import com.tydic.order.third.intf.bo.fsc.PenIntfPaymentFlowReqBO;
import com.tydic.order.third.intf.bo.fsc.PenIntfPaymentFlowRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtPayRefundAbilityService.class)
public class PebExtPayRefundAbilityServiceImpl
implements PebExtPayRefundAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPayRefundAbilityServiceImpl.class);
    @Value(value="${uoc.pay.publicKey}")
    private String publicKey;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebExtPayRefundBusiService pebExtPayRefundBusiService;
    @Autowired
    private PenIntfPaymentFlowService penIntfPaymentFlowService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;

    public PebExtPayRefundRspBO dealPayResult(PebExtPayRefundReqBO reqBO) {
        String retStr = PayCenterUtils.deCode((String)reqBO.getContent(), (String)this.publicKey);
        reqBO = (PebExtPayRefundReqBO)JSON.parseObject((String)retStr, PebExtPayRefundReqBO.class);
        log.info("\u652f\u4ed8\u56de\u8c03\u53c2\u6570" + retStr);
        PebExtPayRefundRspBO rspBO = this.pebExtPayRefundBusiService.dealPayResult(reqBO);
        if (rspBO.getSaleId() != null) {
            this.ordIdxSync(rspBO);
            rspBO.setResultCode("02");
            this.push(reqBO, rspBO.getOrderId(), rspBO.getSaleCode());
        }
        return rspBO;
    }

    public void push(PebExtPayRefundReqBO reqBO, Long orderId, String saleCode) {
        PenIntfPaymentFlowReqBO flowReqBO = new PenIntfPaymentFlowReqBO();
        OrdExtMapPO comOrgId = new OrdExtMapPO();
        comOrgId.setFieldCode("companyId");
        comOrgId.setOrderId(orderId);
        comOrgId.setObjId(orderId);
        comOrgId.setObjType(UocConstant.OBJ_TYPE.ORDER);
        comOrgId = this.ordExtMapMapper.getModelBy(comOrgId);
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setFieldCode("busiMode");
        mapPO.setOrderId(orderId);
        mapPO.setObjId(orderId);
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        OrdPayConfPO payConfPO = new OrdPayConfPO();
        OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(orderId.longValue());
        payConfPO.setOrderId(orderId);
        payConfPO = (OrdPayConfPO)this.ordPayConfMapper.selectByCondition(payConfPO).get(0);
        flowReqBO.setOrderCode(saleCode);
        flowReqBO.setOutOrderId(reqBO.getOutOrderId());
        flowReqBO.setPaymentFlowId(reqBO.getPayOrderId());
        flowReqBO.setMerchantId(Long.valueOf(reqBO.getMerchantId()));
        flowReqBO.setOrgId(Long.valueOf(comOrgId.getFieldValue()));
        try {
            flowReqBO.setOrderAmt(new BigDecimal(reqBO.getRealFee()).divide(new BigDecimal(100), 2, 2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        flowReqBO.setFlowFlag(reqBO.getPayMethod());
        flowReqBO.setPayType(payConfPO.getPayType().toString());
        flowReqBO.setCreateUserId(Long.valueOf(orderPO.getCreateOperId()));
        flowReqBO.setCreateUserName(stakeholderPO.getPurPlaceOrderName());
        flowReqBO.setPayOrderId(reqBO.getPayOrderId());
        flowReqBO.setPayTime(new Date());
        flowReqBO.setCreateTime(orderPO.getCreateTime());
        flowReqBO.setFlowFlag("01");
        flowReqBO.setPaymentStatus("SUCCESS");
        if ("0".equals(mapPO.getFieldValue())) {
            flowReqBO.setRecName(stakeholderPO.getCompanyName());
        } else {
            flowReqBO.setRecName(stakeholderPO.getSupName());
        }
        if ("1".equals(orderPO.getUserType())) {
            flowReqBO.setPayName(stakeholderPO.getPurPlaceOrderName());
        } else {
            flowReqBO.setPayName(stakeholderPO.getPurName());
        }
        flowReqBO.setBusiCode(reqBO.getBusiCode());
        PenIntfPaymentFlowRspBO flowRspBO = this.penIntfPaymentFlowService.addPaymentFlow(flowReqBO);
        String in = JSON.toJSONString((Object)flowReqBO);
        String out = JSON.toJSONString((Object)flowRspBO);
        if (StringUtils.isBlank((CharSequence)in)) {
            in = "in";
        }
        if (StringUtils.isBlank((CharSequence)out)) {
            out = "out";
        }
        int max = 3096;
        if (in.length() > max) {
            in = in.substring(0, max - 1);
        }
        if (out.length() > max) {
            out = out.substring(0, max - 1);
        }
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setCallCount(Integer.valueOf(1));
        logBO.setCallState("1");
        logBO.setCallTime(new Date());
        logBO.setCreateLoginId("1");
        logBO.setErrCode(flowRspBO.getRespCode());
        logBO.setErrDetail("1");
        logBO.setFlowFlag(Integer.valueOf(1));
        logBO.setInContent(in);
        logBO.setInterCode("addPaymentFlow");
        logBO.setInterSn("1");
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setOrderId(orderId);
        logBO.setObjId(orderId);
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        PebExtFieldInReqBO inReqBO = new PebExtFieldInReqBO();
        inReqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(inReqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ordIdxSync(PebExtPayRefundRspBO reqBO) {
        UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
        combReqBO.setOrderId(reqBO.getOrderId());
        combReqBO.setObjId(reqBO.getSaleId());
        combReqBO.setIsStatistics(Boolean.valueOf(false));
        combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getAfsId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
        uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getShipVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }
}

