/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.ability.impl.saleorder;

import cn.hutool.core.date.DateUtil;
import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.extend.ability.saleorder.PebExtApprovalOrderAbilityService;
import com.tydic.order.extend.aop.OrderLogRecord;
import com.tydic.order.extend.bo.notify.PebExtSendMessageReqBO;
import com.tydic.order.extend.bo.saleorder.OrdInterLogBO;
import com.tydic.order.extend.bo.saleorder.PebExtApprovalOrderReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtApprovalOrderRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtDealOrderBO;
import com.tydic.order.extend.bo.saleorder.PebExtFieldInReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtSerPriceReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtSerPriceRspBO;
import com.tydic.order.extend.busi.notify.PebExtSendMessageBusiService;
import com.tydic.order.extend.busi.saleorder.PebExtFieldInBusiService;
import com.tydic.order.extend.comb.saleorder.PebExtSerPriceCombService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.pec.ability.bo.PebDealOrderBO;
import com.tydic.order.pec.ability.order.PebOrderApprovalAbilityService;
import com.tydic.order.pec.ability.order.UocApprovalOrderAbilityService;
import com.tydic.order.pec.atom.es.order.UocQrySaleOrderAtomService;
import com.tydic.order.pec.bo.order.PebOrderApprovalReqBO;
import com.tydic.order.pec.bo.order.PebOrderApprovalRspBO;
import com.tydic.order.pec.bo.order.UocApprovalOrderReqBO;
import com.tydic.order.pec.bo.order.UocApprovalOrderRspBO;
import com.tydic.order.uoc.bo.common.annotation.OrderFlowLog;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.uoc.base.bo.UocProBaseRspBo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtApprovalOrderAbilityService.class)
public class PebExtApprovalOrderAbilityServiceImpl
implements PebExtApprovalOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtApprovalOrderAbilityServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV")
    private PebOrderApprovalAbilityService pebOrderApprovalAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV")
    private UocApprovalOrderAbilityService uocApprovalOrderAbilityService;
    @Autowired
    private PebExtSerPriceCombService pebExtSerPriceCombService;
    @Autowired
    private UocQrySaleOrderAtomService saleOrderAtomService;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Autowired
    private PebExtSendMessageBusiService pebExtSendMessageBusiService;
    @Value(value="${UOC_NOTIFY_ORDER_TOPIC}")
    private String notifyTopic;
    @Value(value="${UOC_NOTIFY_ORDER_TAG}")
    private String notifyTag;
    @Resource(name="notifyOrderMsgProvider")
    private ProxyMessageProducer notifyOrderMsgProvider;

    @OrderFlowLog(operationLink="\u8ba2\u5355\u5ba1\u6279", description="\u8ba2\u5355\u5ba1\u6279")
    public PebExtApprovalOrderRspBO dealApprovalOrder(PebExtApprovalOrderReqBO reqBO) {
        this.val(reqBO);
        if (!StringUtils.isBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        PebExtApprovalOrderRspBO rspBO = new PebExtApprovalOrderRspBO();
        String jsonStr = JSON.toJSONString((Object)reqBO);
        PebExtSendMessageReqBO pebExtSendMessageReqBO = (PebExtSendMessageReqBO)JSON.parseObject((String)jsonStr, PebExtSendMessageReqBO.class);
        if (PebExtConstant.pageType.ZONE_SALE.equals(reqBO.getPageType())) {
            PebOrderApprovalReqBO pebOrderApprovalReqBO = (PebOrderApprovalReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebOrderApprovalReqBO.class);
            if ("1".equals(reqBO.getFlag())) {
                pebOrderApprovalReqBO.setAuditResult(Integer.valueOf("0"));
            } else if ("0".equals(reqBO.getFlag())) {
                pebOrderApprovalReqBO.setAuditResult(Integer.valueOf("1"));
            }
            pebOrderApprovalReqBO.setActionCode("ACTPEB007");
            pebOrderApprovalReqBO.setApprovalRemark(reqBO.getDealDesc());
            pebOrderApprovalReqBO.setOperId(reqBO.getUserId() + "");
            pebOrderApprovalReqBO.setOperName(reqBO.getUsername());
            pebOrderApprovalReqBO.setOperDept(reqBO.getOrgName());
            ArrayList<PebDealOrderBO> orderApprovalList = new ArrayList<PebDealOrderBO>();
            for (PebExtDealOrderBO pebExtDealOrderBO : reqBO.getOrderInfo()) {
                PebDealOrderBO pebDealOrderBO = new PebDealOrderBO();
                BeanUtils.copyProperties((Object)pebExtDealOrderBO, (Object)pebDealOrderBO);
                if (null != pebExtDealOrderBO.getStepId() && 0L != pebExtDealOrderBO.getStepId()) {
                    pebDealOrderBO.setStepId(pebExtDealOrderBO.getStepId().toString());
                }
                orderApprovalList.add(pebDealOrderBO);
            }
            pebOrderApprovalReqBO.setOrderApprovalList(orderApprovalList);
            PebOrderApprovalRspBO pebOrderApprovalRspBO = this.pebOrderApprovalAbilityService.dealPebOrderApproval(pebOrderApprovalReqBO);
            if (!"0000".equals(pebOrderApprovalRspBO.getRespCode())) {
                throw new UocProBusinessException(pebOrderApprovalRspBO.getRespCode(), pebOrderApprovalRspBO.getRespDesc());
            }
            pebExtSendMessageReqBO.setOrderType(PebExtConstant.NOTIFY_ORDER_TYPE.ORDER_AGREEMENT);
        } else if (PebExtConstant.pageType.ES_SALE.equals(reqBO.getPageType())) {
            UocApprovalOrderReqBO uocApprovalOrderReqBO = (UocApprovalOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocApprovalOrderReqBO.class);
            UocApprovalOrderRspBO uocApprovalOrderRspBO = this.uocApprovalOrderAbilityService.dealApprovalOrder(uocApprovalOrderReqBO);
            if (!"0000".equals(uocApprovalOrderRspBO.getRespCode())) {
                throw new UocProBusinessException(uocApprovalOrderRspBO.getRespCode(), uocApprovalOrderRspBO.getRespDesc());
            }
            pebExtSendMessageReqBO.setOrderType(PebExtConstant.NOTIFY_ORDER_TYPE.ORDER_STORE);
        }
        List orderInfo = reqBO.getOrderInfo();
        orderInfo.forEach(order -> {
            pebExtSendMessageReqBO.setOrderId(order.getOrderId());
            if ("1".equals(reqBO.getFlag())) {
                pebExtSendMessageReqBO.setNotifyBusiness(PebExtConstant.NOTIFY_BUSINESS.ORDER_APPROVE);
            } else {
                pebExtSendMessageReqBO.setNotifyBusiness(PebExtConstant.NOTIFY_BUSINESS.ORDER_APPROVE_REFUSED);
            }
            pebExtSendMessageReqBO.setNotifyType(PebExtConstant.NOTIFY_TYPE.ORDER_NOTIFY);
            pebExtSendMessageReqBO.setUserId(reqBO.getUserId());
            pebExtSendMessageReqBO.setPushTime(DateUtil.formatDate((Date)new Date()));
            this.notifyOrderMsgProvider.send(new ProxyMessage(this.notifyTopic, this.notifyTag, JSONObject.toJSONString((Object)pebExtSendMessageReqBO)));
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(PebExtApprovalOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("0100", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getPageType()) {
            throw new UocProBusinessException("0100", "\u5165\u53c2pageType\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getFlag())) {
            throw new UocProBusinessException("0100", "\u5165\u53c2flag\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderInfo())) {
            throw new UocProBusinessException("0100", "\u5165\u53c2orderInfo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (PebExtDealOrderBO pebExtDealOrderBO : reqBO.getOrderInfo()) {
            if (null == pebExtDealOrderBO.getOrderId() || 0L == pebExtDealOrderBO.getOrderId()) {
                throw new UocProBusinessException("0100", "\u5165\u53c2orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != pebExtDealOrderBO.getSaleVoucherId() && 0L != pebExtDealOrderBO.getSaleVoucherId()) continue;
            throw new UocProBusinessException("0100", "\u5165\u53c2saleVoucherId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @OrderLogRecord(description="\u65b0\u589e")
    private UocProBaseRspBo serPrice(Long orderId, Long saleVoucherId) {
        PebExtSerPriceReqBO reqBO = new PebExtSerPriceReqBO();
        reqBO.setPush(Boolean.valueOf(true));
        reqBO.setOrderId(orderId);
        PebExtSerPriceRspBO rspBO = this.pebExtSerPriceCombService.serPrice(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            PebExtSerPriceRspBO rspBO2 = this.pebExtSerPriceCombService.serPrice(reqBO);
            if (!"0000".equals(rspBO2.getRespCode())) {
                PebExtSerPriceRspBO rspBO3 = this.pebExtSerPriceCombService.serPrice(reqBO);
                this.saveLog(orderId, saleVoucherId, JSON.toJSONString((Object)reqBO), JSON.toJSONString((Object)rspBO3), "ApprovalOrderSerPrice", rspBO3.getRespCode());
                if (!"0000".equals(rspBO3.getRespCode())) {
                    UocProBaseRspBo rspInfoBO = new UocProBaseRspBo();
                    rspInfoBO.setRespCode("8888");
                    rspInfoBO.setRespDesc("\u4e13\u533a\u8ba2\u5355\u521b\u5efa\u5931\u8d25,\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u4fdd\u5b58\u6210\u4ea4\u670d\u52a1\u8d39\u5931\u8d25!" + rspBO3.getRespDesc());
                    return rspInfoBO;
                }
            }
            this.saveLog(orderId, saleVoucherId, JSON.toJSONString((Object)reqBO), JSON.toJSONString((Object)rspBO), "ApprovalOrderSerPrice", rspBO.getRespCode());
        }
        this.saveLog(orderId, saleVoucherId, JSON.toJSONString((Object)reqBO), JSON.toJSONString((Object)rspBO), "ApprovalOrderSerPrice", rspBO.getRespCode());
        UocProBaseRspBo rspInfoBO = new UocProBaseRspBo();
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u4fdd\u5b58\u6210\u4ea4\u670d\u52a1\u8d39\u6210\u529f");
        return rspInfoBO;
    }

    private void saveLog(Long orderId, Long saleId, String in, String out, String code, String errCode) {
        if (StringUtils.isBlank((CharSequence)in)) {
            in = "in";
        }
        if (StringUtils.isBlank((CharSequence)out)) {
            out = "out";
        }
        int max = 3096;
        if (in.length() > max) {
            in = in.substring(0, max - 1);
        }
        if (out.length() > max) {
            out = out.substring(0, max - 1);
        }
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setErrDetail("1");
        logBO.setFlowFlag(Integer.valueOf(1));
        logBO.setInContent(in);
        logBO.setInterCode(code);
        logBO.setInterSn("1");
        logBO.setCallCount(Integer.valueOf(1));
        logBO.setCallState("1");
        logBO.setCallTime(new Date());
        logBO.setCreateLoginId("1");
        logBO.setErrCode(errCode);
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        logBO.setOrderId(orderId);
        logBO.setObjId(saleId);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

