/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.ability.impl.saleorder;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.extend.ability.saleorder.PebExtDealCancelAbilityService;
import com.tydic.order.extend.aop.OrderLogRecord;
import com.tydic.order.extend.bo.saleorder.PebExtDealCancelReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtDealCancelRspBO;
import com.tydic.order.extend.busi.saleorder.PebExtDealCancelBusiService;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.uoc.bo.common.annotation.OrderFlowLog;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtDealCancelAbilityService.class)
public class PebExtDealCancelAbilityServiceImpl
implements PebExtDealCancelAbilityService {
    @Autowired
    private PebExtDealCancelBusiService pebExtDealCancelBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;

    @OrderLogRecord(description="\u53d6\u6d88")
    @OrderFlowLog(operationLink="\u53d6\u6d88\u8ba2\u5355", description="\u53d6\u6d88\u8ba2\u5355")
    public PebExtDealCancelRspBO dealCancel(PebExtDealCancelReqBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        this.val(reqBO);
        PebExtDealCancelRspBO rspBO = this.pebExtDealCancelBusiService.dealCancel(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
            syncReqBO.setOrderId(reqBO.getOrderId());
            syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            syncReqBO.setObjId(reqBO.getSaleVoucherId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
            if (rspBO.getAudit().booleanValue()) {
                this.cancelAudit(reqBO);
            }
        }
        return rspBO;
    }

    private void cancelAudit(PebExtDealCancelReqBO reqBO) {
        UacNoTaskAuditCancelReqBO taskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
        taskAuditCancelReqBO.setCancelOperId(reqBO.getUserId().toString());
        taskAuditCancelReqBO.setCancelReason(StringUtils.isBlank((CharSequence)reqBO.getDealDesc()) ? "\u8ba2\u5355\u64a4\u56de" : reqBO.getDealDesc());
        taskAuditCancelReqBO.setObjId(reqBO.getCancelId().toString());
        taskAuditCancelReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        taskAuditCancelReqBO.setSaveLog(Boolean.valueOf(false));
        taskAuditCancelReqBO.setOperName(reqBO.getUsername());
        this.uacNoTaskAuditCancelAbilityService.auditCancel(taskAuditCancelReqBO);
    }

    private void val(PebExtDealCancelReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("0001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCancelId() == null) {
            throw new UocProBusinessException("0001", "\u53d6\u6d88\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

