/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.ability.impl.saleorder;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.extend.ability.impl.saleorder.PebExtOrdIdxSyncThreadsImpl;
import com.tydic.order.extend.ability.saleorder.PebExtOrdIdxSyncAbilityService;
import com.tydic.order.extend.bo.es.PebExtOrdIdxSyncReqBO;
import com.tydic.order.extend.bo.es.PebExtOrdIdxSyncRspBO;
import com.tydic.order.extend.comb.es.PebExtOrdIdxSyncCombService;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncRspBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.pec.es.bo.UocEsDeleteIndexReqBO;
import com.tydic.order.pec.es.bo.UocEsDeleteIndexRspBO;
import com.tydic.order.pec.es.bo.UocEsSyncAbnormalListRspBO;
import com.tydic.order.pec.es.bo.UocEsSyncAfsListRspBO;
import com.tydic.order.pec.es.bo.UocEsSyncInspectionListRspBO;
import com.tydic.order.pec.es.bo.UocEsSyncOrderListRspBO;
import com.tydic.order.pec.es.bo.UocEsSyncShipListRspBO;
import com.tydic.order.pec.es.service.UocEsDeleteIndexBusiService;
import com.tydic.order.pec.es.service.UocEsSyncAbnormalListBusiService;
import com.tydic.order.pec.es.service.UocEsSyncAfsListBusiService;
import com.tydic.order.pec.es.service.UocEsSyncInspectionListBusiService;
import com.tydic.order.pec.es.service.UocEsSyncOrderListBusiService;
import com.tydic.order.pec.es.service.UocEsSyncShipListBusiService;
import com.tydic.order.pec.es.service.UocEsSyncStatisticsBusiService;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdAbnormalMapper;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdInspectionMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdAbnormalPO;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdInspectionPO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtOrdIdxSyncAbilityService.class)
public class PebExtOrdIdxSyncAbilityServiceImpl
implements PebExtOrdIdxSyncAbilityService {
    private static final Logger logger = LoggerFactory.getLogger(PebExtOrdIdxSyncAbilityServiceImpl.class);
    @Autowired
    private PebExtOrdIdxSyncCombService uocPebOrdIdxSyncCombService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdAbnormalMapper ordAbnormalMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private UocEsSyncOrderListBusiService esSyncOrderListBusiService;
    @Autowired
    private UocEsSyncAfsListBusiService esSyncAfsListBusiService;
    @Autowired
    private UocEsSyncAbnormalListBusiService esSyncAbnormalListBusiService;
    @Autowired
    private UocEsSyncInspectionListBusiService esSyncInspectionListBusiService;
    @Autowired
    private UocEsSyncShipListBusiService esSyncShipListBusiService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocEsSyncStatisticsBusiService esSyncStatisticsBusiService;
    @Autowired
    private UocEsDeleteIndexBusiService esDeleteIndexBusiService;

    public UocPebOrdIdxSyncRspBO dealOrdIdxSync(UocPebOrdIdxSyncReqBO reqBO) {
        UocPebOrdIdxSyncRspBO rspBO = new UocPebOrdIdxSyncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (UocCoreConstant.OperationType.DELETE_ES_INDEX.equals(reqBO.getPurIdxFlag())) {
            logger.info("---------------\u624b\u52a8\u5220\u9664ES\u7d22\u5f15\u5f00\u59cb---------------{}", (Object)JSON.toJSONString((Object)reqBO));
            this.deleteEsIndex(reqBO);
            logger.info("---------------\u624b\u52a8\u5220\u9664ES\u7d22\u5f15\u7ed3\u675f---------------");
            return rspBO;
        }
        logger.info("---------------\u624b\u52a8ES\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u7d22\u5f15\u5f00\u59cb---------------{}", (Object)JSON.toJSONString((Object)reqBO));
        this.validateParam(reqBO);
        if (reqBO.getIsAll().booleanValue()) {
            if (null == reqBO.getThreadNum()) {
                reqBO.setThreadNum(Integer.valueOf(0));
            }
            if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
                this.batchDealOrder(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.AFTER_SERVICE.equals(reqBO.getObjType())) {
                this.batchDealAfterService(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.ABNORMAL.equals(reqBO.getObjType())) {
                this.batchDealAbnormal(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.INSPECTION.equals(reqBO.getObjType())) {
                this.batchDealInspection(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.SHIP.equals(reqBO.getObjType())) {
                this.batchDealShip(reqBO, rspBO);
            }
        } else {
            PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
            combReqBO.setOrderId(reqBO.getOrderId());
            combReqBO.setObjId(reqBO.getObjId());
            combReqBO.setObjType(reqBO.getObjType());
            combReqBO.setIsAll(Boolean.valueOf(true));
            combReqBO.setCreateTimeEff("\u9632\u6b62\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f");
            if (reqBO.getIsMQ().booleanValue()) {
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
            } else {
                this.dealEsIdxSync(combReqBO);
            }
        }
        logger.info("---------------\u624b\u52a8ES\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u7d22\u5f15\u7ed3\u675f---------------");
        return rspBO;
    }

    private void validateParam(UocPebOrdIdxSyncReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("7777", "\u7d22\u5f15\u540c\u6b65API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getObjType() == null) {
            throw new UocProBusinessException("7777", "\u7d22\u5f15\u540c\u6b65API\u5165\u53c2objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void dealEsIdxSync(PebExtOrdIdxSyncReqBO combReqBO) {
        PebExtOrdIdxSyncRspBO combRspBO = this.uocPebOrdIdxSyncCombService.dealOrdIdxSync(combReqBO);
        if ("0000".equals(combRspBO.getRespCode())) {
            UocEsSyncShipListRspBO esSyncShipListRspBO;
            if (UocConstant.OBJ_TYPE.SALE.equals(combReqBO.getObjType())) {
                UocEsSyncOrderListRspBO esSyncOrderListRspBO = this.esSyncOrderListBusiService.esSyncOrderList(combRspBO.getUocEsSyncOrderListReqBO());
                if (!"0000".equals(esSyncOrderListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncOrderListRspBO.getRespCode(), esSyncOrderListRspBO.getRespDesc());
                }
            } else if (PecConstant.OBJ_TYPE.AFTER_SERVICE.equals(combReqBO.getObjType())) {
                UocEsSyncAfsListRspBO esSyncAfsListRspBO = this.esSyncAfsListBusiService.esSyncAfsList(combRspBO.getUocEsSyncAfsListReqBO());
                if (!"0000".equals(esSyncAfsListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncAfsListRspBO.getRespCode(), esSyncAfsListRspBO.getRespDesc());
                }
            } else if (UocConstant.OBJ_TYPE.ABNORMAL.equals(combReqBO.getObjType())) {
                UocEsSyncAbnormalListRspBO esSyncAbnormalListRspBO = this.esSyncAbnormalListBusiService.esUocEsSyncAbnormalList(combRspBO.getUocEsSyncAbnormalListReqBO());
                if (!"0000".equals(esSyncAbnormalListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncAbnormalListRspBO.getRespCode(), esSyncAbnormalListRspBO.getRespDesc());
                }
            } else if (UocConstant.OBJ_TYPE.INSPECTION.equals(combReqBO.getObjType())) {
                UocEsSyncInspectionListRspBO esSyncInspectionListRspBO = this.esSyncInspectionListBusiService.esSyncInspection(combRspBO.getUocEsSyncInspectionListReqBO());
                if (!"0000".equals(esSyncInspectionListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncInspectionListRspBO.getRespCode(), esSyncInspectionListRspBO.getRespDesc());
                }
            } else if (UocConstant.OBJ_TYPE.SHIP.equals(combReqBO.getObjType()) && !"0000".equals((esSyncShipListRspBO = this.esSyncShipListBusiService.esSyncShipList(combRspBO.getUocEsSyncShipListReqBO())).getRespCode())) {
                throw new UocProBusinessException(esSyncShipListRspBO.getRespCode(), esSyncShipListRspBO.getRespDesc());
            }
        } else {
            throw new UocProBusinessException(combRspBO.getRespCode(), combRspBO.getRespDesc());
        }
    }

    private void batchDealOrder(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrderPO orderPO = new OrderPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            orderPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            orderPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        orderPO.setOrderBy("t.CREATE_TIME DESC");
        List listByCreateTime = this.orderMapper.getListByCreateTime(orderPO);
        boolean isSyncStatistics = false;
        if (StringUtils.isBlank((CharSequence)reqBO.getCreateTimeExp()) && StringUtils.isBlank((CharSequence)reqBO.getCreateTimeEff())) {
            isSyncStatistics = true;
        }
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + listByCreateTime.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)listByCreateTime)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrderPO po : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    BeanUtils.copyProperties((Object)reqBO, (Object)combReqBO);
                    combReqBO.setOrderId(po.getOrderId());
                    combReqBO.setObjId(po.getUpperOrderId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), isSyncStatistics).booleanValue()) {
                        rspBO.setRespCode("0100");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrderPO po : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(po.getOrderId());
                    combReqBO.setObjId(po.getUpperOrderId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealAfterService(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            ordAfterServicePO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            ordAfterServicePO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        ordAfterServicePO.setOrderBy("t.CREATE_TIME DESC");
        List listByCreateTime = this.ordAfterServiceMapper.getListByCreateTime(ordAfterServicePO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + listByCreateTime.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)listByCreateTime)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrdAfterServicePO afterServicePO : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(afterServicePO.getOrderId());
                    combReqBO.setObjId(afterServicePO.getAfterServId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), false).booleanValue()) {
                        rspBO.setRespCode("0100");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdAfterServicePO afterServicePO : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(afterServicePO.getOrderId());
                    combReqBO.setObjId(afterServicePO.getAfterServId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealAbnormal(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdAbnormalPO abnormalPO = new OrdAbnormalPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            abnormalPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            abnormalPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        abnormalPO.setOrderBy("CREATE_TIME DESC");
        List ordAbnormalPOS = this.ordAbnormalMapper.getList(abnormalPO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + ordAbnormalPOS.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)ordAbnormalPOS)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrdAbnormalPO ordAbnormalPO : ordAbnormalPOS) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordAbnormalPO.getOrderId());
                    combReqBO.setObjId(ordAbnormalPO.getAbnormalVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ABNORMAL);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), false).booleanValue()) {
                        rspBO.setRespCode("0100");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdAbnormalPO ordAbnormalPO : ordAbnormalPOS) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordAbnormalPO.getOrderId());
                    combReqBO.setObjId(ordAbnormalPO.getAbnormalVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ABNORMAL);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealInspection(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdInspectionPO inspectionPO = new OrdInspectionPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            inspectionPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            inspectionPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        inspectionPO.setOrderBy("CREATE_TIME DESC");
        List listByCreateTime = this.ordInspectionMapper.getListByCreateTime(inspectionPO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + listByCreateTime.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)listByCreateTime)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrdInspectionPO ordInspectionPO : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordInspectionPO.getOrderId());
                    combReqBO.setObjId(ordInspectionPO.getInspectionVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), false).booleanValue()) {
                        rspBO.setRespCode("0100");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdInspectionPO ordInspectionPO : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordInspectionPO.getOrderId());
                    combReqBO.setObjId(ordInspectionPO.getInspectionVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealShip(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setOrderBy("CREATE_TIME DESC");
        List ordShipPOList = this.ordShipMapper.getList(ordShipPO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + ordShipPOList.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)ordShipPOList)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrdShipPO shipPO : ordShipPOList) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(shipPO.getOrderId());
                    combReqBO.setObjId(shipPO.getShipVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), false).booleanValue()) {
                        rspBO.setRespCode("0100");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdShipPO shipPO : ordShipPOList) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(shipPO.getOrderId());
                    combReqBO.setObjId(shipPO.getShipVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void deleteEsIndex(UocPebOrdIdxSyncReqBO reqBO) {
        UocEsDeleteIndexRspBO deleteIndexRspBO;
        UocEsDeleteIndexReqBO deleteIndexReqBO = new UocEsDeleteIndexReqBO();
        if (UocCoreConstant.OperationType.DELETE_ES_INDEX.equals(reqBO.getSupIdxFlag())) {
            deleteIndexReqBO.setIsDeleteStatistics(true);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getThreadRemark())) {
            deleteIndexReqBO.setIndexName(reqBO.getThreadRemark());
        }
        if (null != reqBO.getObjType()) {
            deleteIndexReqBO.setObjTypeList(Collections.singletonList(reqBO.getObjType()));
        }
        if (!"0000".equals((deleteIndexRspBO = this.esDeleteIndexBusiService.deleteIndex(deleteIndexReqBO)).getRespCode())) {
            throw new UocProBusinessException(deleteIndexRspBO.getRespCode(), deleteIndexRspBO.getRespDesc());
        }
    }
}

