/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.order.extend.bo.saleorder.PebExtAgreementSubmitOrderSaleItemRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtDealOrderBO;
import com.tydic.order.uoc.atom.core.UocCoreBusiOperRecordAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreBusiOperRecordReqBO;
import com.tydic.order.uoc.bo.common.annotation.OrderFlowLog;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=202)
public class OrderFlowLogAspect {
    private static final Logger log = LoggerFactory.getLogger(OrderFlowLogAspect.class);
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @Pointcut(value="@annotation(com.tydic.order.uoc.bo.common.annotation.OrderFlowLog)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) {
        Object result = null;
        try {
            result = point.proceed();
            this.saveOrderFlowLog(point, result);
        }
        catch (UocProBusinessException e) {
            String msgCode = StringUtils.isBlank((CharSequence)e.getMsgCode()) ? "8888" : e.getMsgCode();
            throw new UocProBusinessException(msgCode, e.getMessage());
        }
        catch (Throwable e) {
            log.error("\u8ba2\u5355\u6d41\u8f6c\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new UocProBusinessException("8888", e.getMessage(), e);
        }
        return result;
    }

    private void saveOrderFlowLog(ProceedingJoinPoint joinPoint, Object result) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        OrderFlowLog orderFlowLog = method.getAnnotation(OrderFlowLog.class);
        String description = orderFlowLog.description();
        log.info("\u672c\u6b21\u64cd\u4f5c\u63cf\u8ff0\uff1a{}", (Object)description);
        String operationLink = orderFlowLog.operationLink();
        log.info("\u672c\u6b21\u64cd\u4f5c\u8282\u70b9\uff1a{}", (Object)operationLink);
        UocCoreBusiOperRecordReqBO recordReqBO = new UocCoreBusiOperRecordReqBO();
        Object[] args = joinPoint.getArgs();
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
        String userId = params.getString("userId");
        String userName = params.getString("username");
        String orgName = params.getString("orgName");
        recordReqBO.setDealCompName(params.getString("companyName"));
        recordReqBO.setDealDeptName(orgName);
        JSONArray jsonArray = params.getJSONArray("umcStationsListWebExt");
        String postName = null;
        if (null != jsonArray && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject postJsonObject = jsonArray.getJSONObject(i);
                postName = 0 == i ? postJsonObject.getString("stationName") : postName + "," + postJsonObject.getString("stationName");
            }
            if (1024 < postName.length()) {
                postName = postName.substring(0, 1024);
            }
        } else {
            postName = "-";
        }
        recordReqBO.setDealPostName(postName);
        recordReqBO.setDealOperId(userId);
        recordReqBO.setDealOperName(userName);
        JSONObject response = JSON.parseObject((String)JSON.toJSONString((Object)result));
        recordReqBO.setDealTypeName(operationLink);
        recordReqBO.setDealDesc(description + (response.getString("respDesc") == null ? "" : response.getString("respDesc")));
        switch (description) {
            case "\u521b\u5efa\u8ba2\u5355": {
                recordReqBO.setCreateTime(params.getDate("giveTime"));
                this.dealCreateOrder(operationLink, recordReqBO, response);
                break;
            }
            case "\u8ba2\u5355\u5ba1\u6279": {
                this.dealApproveOrder(operationLink, recordReqBO, params);
                break;
            }
            case "\u53d6\u6d88\u8ba2\u5355": {
                String cancelReason = params.getString("cancelReason");
                recordReqBO.setDealReason(cancelReason);
                this.buildBaseOrderFlowInfo(operationLink, recordReqBO, params);
                break;
            }
            default: {
                this.buildBaseOrderFlowInfo(operationLink, recordReqBO, params);
            }
        }
    }

    private void dealApproveOrder(String operationLink, UocCoreBusiOperRecordReqBO recordReqBO, JSONObject params) {
        String orderInfo = params.getString("orderInfo");
        recordReqBO.setCreateTime(new Date());
        if (StringUtils.isNotBlank((CharSequence)orderInfo)) {
            List pebExtDealOrder = JSON.parseArray((String)orderInfo, PebExtDealOrderBO.class);
            operationLink = "1".equals(params.getString("flag")) ? operationLink + "(\u901a\u8fc7)" : operationLink + "(\u9a73\u56de)";
            recordReqBO.setDealName(operationLink);
            recordReqBO.setDealReason(params.getString("dealDesc"));
            pebExtDealOrder.forEach(order -> {
                recordReqBO.setOrderId(order.getOrderId());
                OrdSalePO ordSale = this.getOrdSale(order.getSaleVoucherId(), order.getOrderId());
                if (ordSale != null) {
                    recordReqBO.setOrderNo(ordSale.getSaleVoucherNo());
                }
                this.buildOrderLog(recordReqBO);
            });
        } else {
            this.buildOrderLog(recordReqBO);
        }
    }

    private void dealCreateOrder(String operationLink, UocCoreBusiOperRecordReqBO recordReqBO, JSONObject response) {
        recordReqBO.setDealName(operationLink);
        recordReqBO.setDealReason(response.getString("failMsg"));
        String json = response.getString("submitOrderSaleItem");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            List saleItems = JSONArray.parseArray((String)json, PebExtAgreementSubmitOrderSaleItemRspBO.class);
            saleItems.forEach(item -> {
                recordReqBO.setOrderNo(item.getSaleOrderCode());
                recordReqBO.setOrderId(item.getOrderId());
                OrdSalePO ordSale = this.getOrdSale(Long.valueOf(item.getSaleOrderId()), item.getOrderId());
                if (null != ordSale && null != ordSale.getSaleState() && UocConstant.SALE_ORDER_STATUS.CANCEL.equals(ordSale.getSaleState())) {
                    recordReqBO.setDealDesc("\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
                }
                this.buildOrderLog(recordReqBO);
            });
        } else {
            this.buildOrderLog(recordReqBO);
        }
    }

    private void buildOrderLog(UocCoreBusiOperRecordReqBO recordReqBO) {
        recordReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        recordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
        recordReqBO.setDealTime(new Date());
        this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(recordReqBO);
        log.debug("\u8bb0\u5f55\u8ba2\u5355\u6d41\u6c34\u4fe1\u606f\u6210\u529f\uff1a{}", (Object)recordReqBO);
    }

    private OrdSalePO getOrdSale(Long saleVoucherId, Long orderId) {
        OrdSalePO sale = this.ordSaleMapper.getModelById(saleVoucherId.longValue());
        if (sale == null) {
            OrdSalePO ordSale = new OrdSalePO();
            ordSale.setOrderId(orderId);
            sale = this.ordSaleMapper.getModelBy(ordSale);
        }
        return sale;
    }

    private void buildBaseOrderFlowInfo(String operationLink, UocCoreBusiOperRecordReqBO recordReqBO, JSONObject params) {
        recordReqBO.setDealName(operationLink);
        recordReqBO.setOrderId(params.getLong("orderId"));
        OrdSalePO ordSale = this.getOrdSale(params.getLong("saleVoucherId"), params.getLong("orderId"));
        if (ordSale != null) {
            recordReqBO.setOrderNo(ordSale.getSaleVoucherNo());
        }
        this.buildOrderLog(recordReqBO);
    }
}

