/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.es;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.order.extend.bo.es.PebExtOrdIdxSyncRspBO;
import com.tydic.order.extend.bo.es.PebExtSyncEsCommonReqBO;
import com.tydic.order.extend.busi.es.PebExtInspectionSyncEsBusiService;
import com.tydic.order.pec.bo.es.order.UocPebApprovalTaskQueryBO;
import com.tydic.order.pec.bo.inspection.UocInspectionDetailsListBO;
import com.tydic.order.pec.bo.inspection.UocInspectionDetailsListQueryReqBO;
import com.tydic.order.pec.bo.inspection.UocInspectionDetailsListQueryRspBO;
import com.tydic.order.pec.bo.inspection.UocInspectionDetailsQueryRspBO;
import com.tydic.order.pec.bo.inspection.UocInspectionItemListBO;
import com.tydic.order.pec.bo.inspection.UocOrdInspectionItemRspBO;
import com.tydic.order.pec.bo.order.UocMainOrderDetailQueryReqBO;
import com.tydic.order.pec.bo.order.UocMainOrderDetailQueryRspBO;
import com.tydic.order.pec.bo.sale.UocOrdItemRspBO;
import com.tydic.order.pec.bo.sale.UocSalesSingleDetailsQueryReqBO;
import com.tydic.order.pec.bo.sale.UocSalesSingleDetailsQueryRspBO;
import com.tydic.order.pec.busi.inspection.UocInspectionDetailsListQueryBusiService;
import com.tydic.order.pec.busi.order.UocMainOrderDetailQueryBusiService;
import com.tydic.order.pec.busi.sale.UocSalesSingleDetailsQueryBusiService;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.pec.es.bo.UocEsSyncInspectionListReqBO;
import com.tydic.order.uoc.bo.sale.SaleOrdItemRspBO;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdPurchaseMapper;
import com.tydic.order.uoc.dao.OrdShipInspectionMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrdTaskCandidateMapper;
import com.tydic.order.uoc.dao.po.OrdPurchasePO;
import com.tydic.order.uoc.dao.po.OrdShipInspectionPO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrdTaskCandidatePO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebExtInspectionSyncEsBusiServiceImpl
implements PebExtInspectionSyncEsBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtInspectionSyncEsBusiServiceImpl.class);
    private final UocMainOrderDetailQueryBusiService mainOrderDetailQueryBusiService;
    private final UocInspectionDetailsListQueryBusiService inspectionDetailsListQueryBusiService;
    private final UocSalesSingleDetailsQueryBusiService salesSingleDetailsQueryBusiService;
    private final OrdShipInspectionMapper shipInspectionMapper;
    private final OrdShipItemMapper shipItemMapper;
    private final OrdTaskCandidateMapper ordTaskCandidateMapper;
    private final OrdPurchaseMapper ordPurchaseMapper;
    @Value(value="${status.auth:false}")
    private Boolean isStatusAuth;

    @Autowired
    public PebExtInspectionSyncEsBusiServiceImpl(UocMainOrderDetailQueryBusiService mainOrderDetailQueryBusiService, UocInspectionDetailsListQueryBusiService inspectionDetailsListQueryBusiService, UocSalesSingleDetailsQueryBusiService salesSingleDetailsQueryBusiService, OrdShipInspectionMapper shipInspectionMapper, OrdShipItemMapper shipItemMapper, OrdTaskCandidateMapper ordTaskCandidateMapper, OrdPurchaseMapper ordPurchaseMapper) {
        this.mainOrderDetailQueryBusiService = mainOrderDetailQueryBusiService;
        this.inspectionDetailsListQueryBusiService = inspectionDetailsListQueryBusiService;
        this.salesSingleDetailsQueryBusiService = salesSingleDetailsQueryBusiService;
        this.shipInspectionMapper = shipInspectionMapper;
        this.shipItemMapper = shipItemMapper;
        this.ordTaskCandidateMapper = ordTaskCandidateMapper;
        this.ordPurchaseMapper = ordPurchaseMapper;
    }

    public PebExtOrdIdxSyncRspBO dealInspectionSyncEs(PebExtSyncEsCommonReqBO reqBO) {
        PebExtOrdIdxSyncRspBO rspBO = new PebExtOrdIdxSyncRspBO();
        UocInspectionDetailsQueryRspBO inspectionDetails = this.getInspectionDetails((UocPebOrdIdxSyncReqBO)reqBO);
        OrdPurchasePO purchasePO = new OrdPurchasePO();
        purchasePO.setOrderId(reqBO.getOrderId());
        purchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
        UocMainOrderDetailQueryRspBO mainOrderDetail = this.getMainOrderDetail((UocPebOrdIdxSyncReqBO)reqBO);
        UocSalesSingleDetailsQueryRspBO salesSingleDetails = this.getSalesSingleDetails(inspectionDetails.getOrdInspectionRspBO().getOrderId(), inspectionDetails.getOrdInspectionRspBO().getSaleVoucherId());
        UocEsSyncInspectionListReqBO operateInspectionPurIdxReqBO = this.buildEsSyncInspectionListReqBO(inspectionDetails, mainOrderDetail, salesSingleDetails, purchasePO);
        rspBO.setUocEsSyncInspectionListReqBO(operateInspectionPurIdxReqBO);
        return rspBO;
    }

    private UocEsSyncInspectionListReqBO buildEsSyncInspectionListReqBO(UocInspectionDetailsQueryRspBO inspectionDetails, UocMainOrderDetailQueryRspBO mainOrderDetail, UocSalesSingleDetailsQueryRspBO salesSingleDetails, OrdPurchasePO purchasePO) {
        UocEsSyncInspectionListReqBO operateInspectionPurIdxReqBO = new UocEsSyncInspectionListReqBO();
        this.buildInspectionEsSearchCondition(operateInspectionPurIdxReqBO, inspectionDetails, mainOrderDetail, salesSingleDetails, purchasePO);
        UocInspectionDetailsListBO inspectionDetailsListBO = new UocInspectionDetailsListBO();
        BigDecimal availableOrderAfterCount = new BigDecimal(0);
        this.buildEsObjJsonMainInspectionInfo(inspectionDetailsListBO, inspectionDetails, mainOrderDetail, salesSingleDetails, availableOrderAfterCount, purchasePO);
        operateInspectionPurIdxReqBO.setAvailableOrderAfterCount(availableOrderAfterCount);
        operateInspectionPurIdxReqBO.setObjJson(JSON.toJSONString((Object)inspectionDetailsListBO));
        return operateInspectionPurIdxReqBO;
    }

    private void buildInspectionEsSearchCondition(UocEsSyncInspectionListReqBO operateInspectionPurIdxReqBO, UocInspectionDetailsQueryRspBO inspectionDetails, UocMainOrderDetailQueryRspBO mainOrderDetail, UocSalesSingleDetailsQueryRspBO salesSingleDetails, OrdPurchasePO purchasePO) {
        operateInspectionPurIdxReqBO.setOrderSource(salesSingleDetails.getOrdSaleRspBO().getOrderSource());
        operateInspectionPurIdxReqBO.setOrgPath(mainOrderDetail.getOrdStakeholderRspBO().getPurOrgPath());
        operateInspectionPurIdxReqBO.setOrgPathPro(mainOrderDetail.getOrdStakeholderRspBO().getProAccountOwnName());
        operateInspectionPurIdxReqBO.setObjId(inspectionDetails.getOrdInspectionRspBO().getInspectionVoucherId());
        operateInspectionPurIdxReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
        operateInspectionPurIdxReqBO.setOrderId(mainOrderDetail.getOrderRspBO().getOrderId());
        operateInspectionPurIdxReqBO.setOrderName(mainOrderDetail.getOrderRspBO().getOrderName());
        operateInspectionPurIdxReqBO.setSaleVoucherId(salesSingleDetails.getOrdSaleRspBO().getSaleVoucherId());
        operateInspectionPurIdxReqBO.setSaleVoucherNo(salesSingleDetails.getOrdSaleRspBO().getSaleVoucherNo());
        operateInspectionPurIdxReqBO.setOrderCreateTime(mainOrderDetail.getOrderRspBO().getCreateTime());
        operateInspectionPurIdxReqBO.setInspectionVoucherCode(inspectionDetails.getOrdInspectionRspBO().getInspectionVoucherCode());
        operateInspectionPurIdxReqBO.setInspectionTime(inspectionDetails.getOrdInspectionRspBO().getInspectionTime());
        operateInspectionPurIdxReqBO.setPurNo(mainOrderDetail.getOrdStakeholderRspBO().getPurNo());
        operateInspectionPurIdxReqBO.setCreateOperId(mainOrderDetail.getOrderRspBO().getCreateOperId());
        operateInspectionPurIdxReqBO.setCreateTime(inspectionDetails.getOrdInspectionRspBO().getCreateTime());
        operateInspectionPurIdxReqBO.setInspectionState(inspectionDetails.getOrdInspectionRspBO().getInspectionState());
        operateInspectionPurIdxReqBO.setOutOrderNo(salesSingleDetails.getOrdSaleRspBO().getElcOutSaleOrderNo());
        operateInspectionPurIdxReqBO.setProNo(mainOrderDetail.getOrdStakeholderRspBO().getProNo());
        operateInspectionPurIdxReqBO.setPayType(Integer.valueOf(mainOrderDetail.getOrderRspBO().getPayType()));
        operateInspectionPurIdxReqBO.setPayStatus(mainOrderDetail.getOrderRspBO().getPayState());
        operateInspectionPurIdxReqBO.setInspSaleFee(inspectionDetails.getOrdInspectionRspBO().getInspTotalSaleFee());
        operateInspectionPurIdxReqBO.setInspPurchaseFee(inspectionDetails.getOrdInspectionRspBO().getInspTotalPurchaseFee());
        operateInspectionPurIdxReqBO.setPurchaseVoucherNo(purchasePO.getPurchaseVoucherNo());
        if (this.isStatusAuth.booleanValue()) {
            ArrayList<String> tacheCode = new ArrayList<String>();
            tacheCode.add(inspectionDetails.getOrdInspectionRspBO().getInspectionState() + "");
            List<UocPebApprovalTaskQueryBO> approvalTaskQueryBOS = this.getStatusPostIdList(inspectionDetails, tacheCode);
            if (!CollectionUtils.isEmpty(approvalTaskQueryBOS)) {
                ArrayList<String> statusPostIdList = new ArrayList<String>();
                for (UocPebApprovalTaskQueryBO approvalTaskQueryBO : approvalTaskQueryBOS) {
                    statusPostIdList.add(approvalTaskQueryBO.getTaskOperId());
                }
                operateInspectionPurIdxReqBO.setStatusPostIdList(statusPostIdList);
            }
        }
    }

    private void buildEsObjJsonMainInspectionInfo(UocInspectionDetailsListBO inspectionDetailsListBO, UocInspectionDetailsQueryRspBO inspectionDetails, UocMainOrderDetailQueryRspBO mainOrderDetail, UocSalesSingleDetailsQueryRspBO salesSingleDetails, BigDecimal availableOrderAfterCount, OrdPurchasePO purchasePO) {
        inspectionDetailsListBO.setOrderId(inspectionDetails.getOrdInspectionRspBO().getOrderId() + "");
        inspectionDetailsListBO.setOrderName(mainOrderDetail.getOrderRspBO().getOrderName());
        inspectionDetailsListBO.setPurPlaceOrderName(mainOrderDetail.getOrdStakeholderRspBO().getPurPlaceOrderName());
        inspectionDetailsListBO.setPurMobile(mainOrderDetail.getOrdStakeholderRspBO().getPurMobile());
        inspectionDetailsListBO.setCreateOperId(mainOrderDetail.getOrderRspBO().getCreateOperId());
        inspectionDetailsListBO.setSupNo(mainOrderDetail.getOrdStakeholderRspBO().getSupNo());
        inspectionDetailsListBO.setSupName(mainOrderDetail.getOrdStakeholderRspBO().getSupName());
        inspectionDetailsListBO.setProNo(mainOrderDetail.getOrdStakeholderRspBO().getProNo());
        inspectionDetailsListBO.setProName(mainOrderDetail.getOrdStakeholderRspBO().getProName());
        inspectionDetailsListBO.setSaleVoucherId(salesSingleDetails.getOrdSaleRspBO().getSaleVoucherId() + "");
        inspectionDetailsListBO.setSaleVoucherNo(salesSingleDetails.getOrdSaleRspBO().getSaleVoucherNo());
        inspectionDetailsListBO.setInspectionVoucherId(inspectionDetails.getOrdInspectionRspBO().getInspectionVoucherId() + "");
        inspectionDetailsListBO.setInspectionVoucherCode(inspectionDetails.getOrdInspectionRspBO().getInspectionVoucherCode());
        inspectionDetailsListBO.setOrderCreateTime(DateUtils.dateToStrLong((Date)mainOrderDetail.getOrderRspBO().getCreateTime()));
        inspectionDetailsListBO.setPurNo(mainOrderDetail.getOrdStakeholderRspBO().getPurNo());
        inspectionDetailsListBO.setPurName(mainOrderDetail.getOrdStakeholderRspBO().getPurName());
        inspectionDetailsListBO.setInspectionTime(DateUtils.dateToStrLong((Date)inspectionDetails.getOrdInspectionRspBO().getInspectionTime()));
        inspectionDetailsListBO.setInspectionState(inspectionDetails.getOrdInspectionRspBO().getInspectionState() + "");
        inspectionDetailsListBO.setInspectionStateStr(inspectionDetails.getOrdInspectionRspBO().getInspectionStateStr());
        inspectionDetailsListBO.setInspectionOper(inspectionDetails.getOrdInspectionRspBO().getInspectionOper());
        inspectionDetailsListBO.setInspectionOperPhone(inspectionDetails.getOrdInspectionRspBO().getInspectionOperPhone());
        inspectionDetailsListBO.setIsDispatch(mainOrderDetail.getOrdAgreementRspBO().getIsDispatch() + "");
        inspectionDetailsListBO.setInspectionAccessoryInfo(inspectionDetails.getInspectionAccessoryList());
        ArrayList<UocInspectionItemListBO> inspectionItemInfo = new ArrayList<UocInspectionItemListBO>(inspectionDetails.getOrdInspectionItemRspBOList().size());
        this.buildEsObjJsonInspectionItemInfo(inspectionItemInfo, inspectionDetails, mainOrderDetail, salesSingleDetails, availableOrderAfterCount);
        inspectionDetailsListBO.setInspectionItemInfo(inspectionItemInfo);
        inspectionDetailsListBO.setInspTotalSaleMoney(inspectionDetails.getOrdInspectionRspBO().getInspTotalSaleMoney());
        inspectionDetailsListBO.setInspTotalPurchaseMoney(inspectionDetails.getOrdInspectionRspBO().getInspTotalPurchaseMoney());
        inspectionDetailsListBO.setOutOrderId(salesSingleDetails.getOrdSaleRspBO().getElcOutSaleOrderNo());
        inspectionDetailsListBO.setPayType(Integer.valueOf(mainOrderDetail.getOrderRspBO().getPayType()));
        inspectionDetailsListBO.setPayTypeStr(mainOrderDetail.getOrderRspBO().getPayTypeStr());
        inspectionDetailsListBO.setPayStatus(mainOrderDetail.getOrderRspBO().getPayState());
        inspectionDetailsListBO.setPayStatusStr(mainOrderDetail.getOrderRspBO().getPayStateStr());
        inspectionDetailsListBO.setUserType(Integer.valueOf(mainOrderDetail.getOrderRspBO().getUserType()));
        inspectionDetailsListBO.setUserTypeStr(mainOrderDetail.getOrderRspBO().getUserTypeStr());
        inspectionDetailsListBO.setPurchaseVoucherId(purchasePO.getPurchaseVoucherId());
        inspectionDetailsListBO.setPurchaseVoucherNo(purchasePO.getPurchaseVoucherNo());
    }

    private void buildEsObjJsonInspectionItemInfo(List<UocInspectionItemListBO> inspectionItemInfo, UocInspectionDetailsQueryRspBO inspectionDetails, UocMainOrderDetailQueryRspBO mainOrderDetail, UocSalesSingleDetailsQueryRspBO salesSingleDetails, BigDecimal availableOrderAfterCount) {
        Map ordItemRspBOMap = salesSingleDetails.getOrdItemRspBOList().stream().collect(Collectors.toMap(SaleOrdItemRspBO::getOrdItemId, Function.identity()));
        for (UocOrdInspectionItemRspBO inspectionItemRspBO : inspectionDetails.getOrdInspectionItemRspBOList()) {
            UocInspectionItemListBO inspectionItemListBO = new UocInspectionItemListBO();
            inspectionItemListBO.setInspectionItemId(inspectionItemRspBO.getInspectionItemId() + "");
            inspectionItemListBO.setShipItemId(inspectionItemRspBO.getShipItemId() + "");
            inspectionItemListBO.setOrdItemId(inspectionItemRspBO.getOrdItemId() + "");
            inspectionItemListBO.setInspectionVoucherId(inspectionItemRspBO.getInspectionVoucherId() + "");
            inspectionItemListBO.setOrderId(inspectionItemRspBO.getOrderId() + "");
            inspectionItemListBO.setCheckStatus(inspectionItemRspBO.getCheckStatus() + "");
            inspectionItemListBO.setInspSaleMoney(inspectionItemRspBO.getInspSaleMoney() + "");
            inspectionItemListBO.setInspPurchaseMoney(inspectionItemRspBO.getInspPurchaseMoney() + "");
            inspectionItemListBO.setUnitName(inspectionItemRspBO.getUnitName());
            inspectionItemListBO.setInspectionCount(inspectionItemRspBO.getInspectionCount() + "");
            inspectionItemListBO.setReturnCount(inspectionItemRspBO.getReturnCount() + "");
            inspectionItemListBO.setAlreadyReturnCount(inspectionItemRspBO.getAlreadyReturnCount() + "");
            inspectionItemListBO.setSkuId(inspectionItemRspBO.getSkuId() + "");
            inspectionItemListBO.setSkuName(inspectionItemRspBO.getSkuName());
            inspectionItemListBO.setPicUrl(inspectionItemRspBO.getPicUrl());
            inspectionItemListBO.setSupplierShopId(inspectionItemRspBO.getSupplierShopId() + "");
            inspectionItemListBO.setAvailableAfterServCount(inspectionItemRspBO.getInspectionCount().subtract(inspectionItemRspBO.getReturnCount()).subtract(inspectionItemRspBO.getAlreadyReturnCount()));
            availableOrderAfterCount = availableOrderAfterCount.add(inspectionItemListBO.getAvailableAfterServCount());
            for (UocOrdItemRspBO ordItemRspBO : salesSingleDetails.getOrdItemRspBOList()) {
                if (!ordItemRspBO.getOrdItemId().equals(inspectionItemRspBO.getOrdItemId())) continue;
                inspectionItemListBO.setPurchaseCount(ordItemRspBO.getPurchaseCount() + "");
                inspectionItemListBO.setPurchasingPrice(ordItemRspBO.getPurchasePriceMoney() + "");
                inspectionItemListBO.setSellingPrice(ordItemRspBO.getSalePriceMoney() + "");
                break;
            }
            inspectionItemListBO.setSendCount("0");
            OrdShipInspectionPO shipInspectionPO = new OrdShipInspectionPO();
            shipInspectionPO.setInspectionVoucherId(inspectionDetails.getOrdInspectionRspBO().getInspectionVoucherId());
            List shipInspectionPOS = this.shipInspectionMapper.getList(shipInspectionPO);
            if (!CollectionUtils.isEmpty((Collection)shipInspectionPOS)) {
                ArrayList<Long> shipVoucherIdList = new ArrayList<Long>();
                for (OrdShipInspectionPO ordShipInspectionPO : shipInspectionPOS) {
                    shipVoucherIdList.add(ordShipInspectionPO.getShipVoucherId());
                }
                OrdShipItemPO shipItemPO = new OrdShipItemPO();
                shipItemPO.setOrderId(mainOrderDetail.getOrderRspBO().getOrderId());
                shipItemPO.setShipVoucherIdList(shipVoucherIdList);
                List shipItemPOS = this.shipItemMapper.getList(shipItemPO);
                if (!CollectionUtils.isEmpty((Collection)shipItemPOS)) {
                    BigDecimal sendCount = new BigDecimal(0);
                    for (OrdShipItemPO ordShipItemPO : shipItemPOS) {
                        sendCount = sendCount.add(ordShipItemPO.getSendCount());
                    }
                    inspectionItemListBO.setSendCount(sendCount + "");
                }
            }
            inspectionItemListBO.setExtSkuId(inspectionItemRspBO.getSkuExtSkuId());
            inspectionItemListBO.setSkuNo(inspectionItemRspBO.getSkuCode());
            inspectionItemListBO.setSpec(inspectionItemRspBO.getSpec());
            inspectionItemListBO.setModel(inspectionItemRspBO.getModel());
            UocOrdItemRspBO ordItemRspBO = (UocOrdItemRspBO)ordItemRspBOMap.get(inspectionItemRspBO.getOrdItemId());
            inspectionItemListBO.setTaxCode(ordItemRspBO.getTaxId());
            inspectionItemListBO.setTax(ordItemRspBO.getTax());
            inspectionItemInfo.add(inspectionItemListBO);
        }
    }

    private UocInspectionDetailsQueryRspBO getInspectionDetails(UocPebOrdIdxSyncReqBO reqBO) {
        UocInspectionDetailsListQueryReqBO busiInspectionReqBO = new UocInspectionDetailsListQueryReqBO();
        busiInspectionReqBO.setOrderId(reqBO.getOrderId());
        busiInspectionReqBO.setInspectionVoucherId(reqBO.getObjId());
        UocInspectionDetailsListQueryRspBO busiInspectionRspBO = this.inspectionDetailsListQueryBusiService.getInspectionDetailsListQuery(busiInspectionReqBO);
        if (!"0000".equals(busiInspectionRspBO.getRespCode())) {
            throw new UocProBusinessException(busiInspectionRspBO.getRespCode(), busiInspectionRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)busiInspectionRspBO.getInspectionDetailsQueryRspBOList())) {
            throw new UocProBusinessException("0100", "\u67e5\u8be2\u4e0d\u5230\u9a8c\u6536\u5355\u8be6\u60c5");
        }
        return (UocInspectionDetailsQueryRspBO)busiInspectionRspBO.getInspectionDetailsQueryRspBOList().get(0);
    }

    private UocMainOrderDetailQueryRspBO getMainOrderDetail(UocPebOrdIdxSyncReqBO reqBO) {
        UocMainOrderDetailQueryReqBO busiMainOrderDetailQueryReqBO = new UocMainOrderDetailQueryReqBO();
        busiMainOrderDetailQueryReqBO.setOrderId(reqBO.getOrderId());
        UocMainOrderDetailQueryRspBO busiMainOrderDetailQueryRspBO = this.mainOrderDetailQueryBusiService.getMainOrderDetailQueryBusi(busiMainOrderDetailQueryReqBO);
        if (!"0000".equals(busiMainOrderDetailQueryRspBO.getRespCode())) {
            throw new UocProBusinessException(busiMainOrderDetailQueryRspBO.getRespCode(), busiMainOrderDetailQueryRspBO.getRespDesc());
        }
        return busiMainOrderDetailQueryRspBO;
    }

    private UocSalesSingleDetailsQueryRspBO getSalesSingleDetails(Long orderId, Long saleVoucherId) {
        UocSalesSingleDetailsQueryReqBO busiSalesDetail = new UocSalesSingleDetailsQueryReqBO();
        busiSalesDetail.setOrderId(orderId);
        busiSalesDetail.setSaleVoucherId(saleVoucherId);
        busiSalesDetail.setQueryLevel(UocCoreConstant.QUERY_LEVEL.QUERY_All);
        UocSalesSingleDetailsQueryRspBO salesSingleDetailsQuery = this.salesSingleDetailsQueryBusiService.getSalesSingleDetailsQuery(busiSalesDetail);
        if (!"0000".equals(salesSingleDetailsQuery.getRespCode())) {
            throw new UocProBusinessException(salesSingleDetailsQuery.getRespCode(), salesSingleDetailsQuery.getRespDesc());
        }
        return salesSingleDetailsQuery;
    }

    private List<UocPebApprovalTaskQueryBO> getStatusPostIdList(UocInspectionDetailsQueryRspBO inspectionDetails, List<String> tacheCode) {
        OrdTaskCandidatePO taskCandidatePO = new OrdTaskCandidatePO();
        taskCandidatePO.setOrderId(inspectionDetails.getOrdInspectionRspBO().getOrderId());
        taskCandidatePO.setTacheCode(tacheCode);
        ArrayList<Integer> objType = new ArrayList<Integer>();
        objType.add(UocCoreConstant.OBJ_TYPE.INSPECTION);
        ArrayList<Long> objId = new ArrayList<Long>();
        objId.add(inspectionDetails.getOrdInspectionRspBO().getInspectionVoucherId());
        taskCandidatePO.setObjType(objType);
        taskCandidatePO.setObjId(objId);
        return this.ordTaskCandidateMapper.getStatusPostIdList(taskCandidatePO);
    }
}

