/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.order;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.order.extend.bo.plan.PebOrderInfoBO;
import com.tydic.order.extend.busi.order.PebExtPayResultBusiService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.extend.dao.OrdPayConfMapper;
import com.tydic.order.extend.dao.OrderPayApplyMapper;
import com.tydic.order.extend.dao.po.OrdPayConfPO;
import com.tydic.order.extend.dao.po.OrderPayApply;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtPayResultBusiServiceImpl
implements PebExtPayResultBusiService {
    @Autowired
    OrdSaleMapper ordSaleMapper;
    @Autowired
    OrderMapper orderMapper;
    @Autowired
    OrdPayMapper ordPayMapper;
    @Autowired
    OrderPayApplyMapper orderPayApplyMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    private final String BOCPay = "180";
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;

    public PebExtPayResultRspBO dealPayResult(PebExtPayResultReqBO reqBO) {
        PebExtPayResultRspBO rspBO = new PebExtPayResultRspBO();
        String success = "SUCCESS";
        OrdPayPO ordPayPO = new OrdPayPO();
        if (StringUtils.isNotBlank((String)reqBO.getOrderId())) {
            ordPayPO.setOrderId(Long.valueOf(reqBO.getOrderId()));
        } else {
            OrdStakeholderPO ordStakeholder = new OrdStakeholderPO();
            ordStakeholder.setExtField4((String)reqBO.getPayableNos().get(0));
            ordStakeholder = this.ordStakeholderMapper.getModelBy(ordStakeholder);
            if (ordStakeholder == null) {
                throw new UocProBusinessException("0200", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u53f7\u5bf9\u5e94\u7684\u8ba2\u5355");
            }
            ordPayPO.setOrderId(ordStakeholder.getOrderId());
        }
        ordPayPO = this.ordPayMapper.getModelBy(ordPayPO);
        if (ordPayPO == null) {
            rspBO.setResultCode("FAIL");
            rspBO.setResultMsg("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u8ba2\u5355");
            return rspBO;
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(ordPayPO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (salePO == null) {
            rspBO.setResultCode(success);
            rspBO.setResultMsg("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u8ba2\u5355");
            return rspBO;
        }
        if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(salePO.getSaleState())) {
            rspBO.setResultCode(success);
            rspBO.setResultMsg("\u8be5\u8ba2\u5355\u5df2\u662f\u5f85\u53d1\u8d27\u72b6\u6001");
            return rspBO;
        }
        if (ordPayPO.getPayState().equals(UocConstant.PAY_ORDER_STATUS.SUCCESS) && !salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.PAYING)) {
            rspBO.setResultCode("FAIL");
            rspBO.setResultMsg("\u8ba2\u5355\u5df2\u652f\u4ed8");
            return rspBO;
        }
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setPayOrderId(salePO.getOrderId());
        List list = this.ordSaleMapper.getList(ordSalePO);
        rspBO.setSaleFee(salePO.getSaleFee());
        rspBO.setSaleCode(salePO.getSaleVoucherNo());
        rspBO.setResultCode(success);
        OrdPayConfPO payConfPO = new OrdPayConfPO();
        payConfPO.setOrderId(salePO.getOrderId());
        List payConfPOS = this.ordPayConfMapper.selectByCondition(payConfPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            OrdPayPO payPO = new OrdPayPO();
            payPO.setPayVoucherId(ordPayPO.getPayVoucherId());
            payPO.setOrderId(ordPayPO.getOrderId());
            if (CollectionUtils.isNotEmpty((Collection)payConfPOS)) {
                payConfPO = (OrdPayConfPO)payConfPOS.get(0);
                if (new BigDecimal(100).compareTo(payConfPO.getPrePaySup()) != 0) {
                    payPO.setPayState(UocConstant.PAY_ORDER_STATUS.PART);
                } else {
                    payPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
                }
            } else {
                payPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
            }
            this.ordPayMapper.updateById(payPO);
            this.success(salePO, reqBO);
            this.run(salePO);
            rspBO.setResultCode(success);
            rspBO.setNotifyResult(success);
            rspBO.setSaleId(salePO.getSaleVoucherId());
            rspBO.setOrderSource(salePO.getOrderSource());
            rspBO.setOrderId(salePO.getOrderId());
        } else {
            ArrayList<PebOrderInfoBO> orderInfo = new ArrayList<PebOrderInfoBO>();
            rspBO.setOrderInfo(orderInfo);
            for (OrdSalePO po : list) {
                if (!po.getSaleState().equals(PebExtConstant.P_ORDER_PAYING)) {
                    OrdSalePO update = new OrdSalePO();
                    update.setSaleVoucherId(po.getSaleVoucherId());
                    update.setOrderId(po.getOrderId());
                    update.setSaleState(PebExtConstant.P_ORDER_PAYING);
                    this.ordSaleMapper.updateById(update);
                }
                this.success(po, reqBO);
                PebOrderInfoBO infoBO = new PebOrderInfoBO();
                infoBO.setOrderId(po.getOrderId());
                infoBO.setSaleVoucherId(po.getSaleVoucherId());
                infoBO.setSaleFee(po.getSaleFee());
                infoBO.setSaleCode(po.getSaleVoucherNo());
                orderInfo.add(infoBO);
                OrdPayPO pay = new OrdPayPO();
                pay.setOrderId(po.getOrderId());
                if (CollectionUtils.isNotEmpty((Collection)payConfPOS)) {
                    payConfPO = (OrdPayConfPO)payConfPOS.get(0);
                    if (new BigDecimal(100).compareTo(payConfPO.getPrePaySup()) != 0) {
                        pay.setPayState(UocConstant.PAY_ORDER_STATUS.PART);
                    } else {
                        pay.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
                    }
                } else {
                    pay.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
                }
                this.ordPayMapper.updateById(pay);
                this.run(po);
            }
            OrdPayPO payPO = new OrdPayPO();
            payPO.setPayVoucherId(ordPayPO.getPayVoucherId());
            payPO.setOrderId(ordPayPO.getOrderId());
            payPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
            this.ordPayMapper.updateById(payPO);
            OrdSalePO update = new OrdSalePO();
            update.setSaleState(UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER);
            update.setOrderId(salePO.getOrderId());
            update.setSaleVoucherId(salePO.getSaleVoucherId());
            this.ordSaleMapper.updateById(update);
            rspBO.setResultCode(success);
            rspBO.setNotifyResult(success);
            rspBO.setSaleId(salePO.getSaleVoucherId());
            rspBO.setOrderId(salePO.getOrderId());
        }
        return rspBO;
    }

    private void success(OrdSalePO salePO, PebExtPayResultReqBO reqBO) {
        OrderPayApply orderPayApply = new OrderPayApply();
        orderPayApply.setOrderId(salePO.getOrderId());
        orderPayApply.setFailCount(Integer.valueOf(0));
        orderPayApply.setIsRealPay(Integer.valueOf(0));
        orderPayApply.setTradeTime(DateUtils.strToDateyyyyMMddHHmmss((String)reqBO.getTradeTime()));
        orderPayApply.setMerchantId(reqBO.getMerchantId());
        orderPayApply.setOutOrderId(reqBO.getOutOrderId());
        try {
            if (StringUtils.isNotBlank((String)reqBO.getRealFee())) {
                orderPayApply.setOrderFee(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(reqBO.getRealFee())));
            } else {
                orderPayApply.setOrderFee(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(reqBO.getTotalFee())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        orderPayApply.setId(Long.valueOf(this.idUtil.nextId()));
        switch (reqBO.getPayMethod()) {
            case "180": {
                orderPayApply.setPayChannel(PebExtConstant.PayMod.CN_BACK);
                break;
            }
            case "190": {
                orderPayApply.setPayChannel(PebExtConstant.PayMod.ICBC);
                break;
            }
            case "30": {
                orderPayApply.setPayChannel(PebExtConstant.PayMod.OFFLINE);
                break;
            }
            default: {
                orderPayApply.setPayChannel(Integer.valueOf(Integer.parseInt(reqBO.getPayMethod())));
            }
        }
        this.orderPayApplyMapper.insert(orderPayApply);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(salePO.getOrderId());
        ordPayPO.setOutPayOrderNo(reqBO.getPayOrderId());
        this.ordPayMapper.updateById(ordPayPO);
        OrderPO orderPO = new OrderPO();
        orderPO.setPayMod(reqBO.getPayMethod());
        orderPO.setOrderId(salePO.getOrderId());
        this.orderMapper.updateById(orderPO);
    }

    private void run(OrdSalePO salePO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(salePO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(salePO.getOrderId());
        processRunReqBO.setOperId("1");
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }
}

