/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.plan;

import com.tydic.order.extend.bo.es.PebExtExecuteSyncPlanReqBO;
import com.tydic.order.extend.bo.es.PebExtExecuteSyncPlanRspBO;
import com.tydic.order.extend.bo.plan.EcpItemBO;
import com.tydic.order.extend.bo.plan.PebExtPlanCreateReqBO;
import com.tydic.order.extend.bo.plan.PebExtPlanCreateRspBO;
import com.tydic.order.extend.busi.es.PebExtExecuteSyncPlanBusiService;
import com.tydic.order.extend.busi.plan.PebExtPlanCreateBusiService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.extend.dao.OrdEcpPlanItemMapper;
import com.tydic.order.extend.dao.OrdEcpPlanMapper;
import com.tydic.order.extend.dao.OrdServMapper;
import com.tydic.order.extend.dao.po.OrdEcpPlanItemPO;
import com.tydic.order.extend.dao.po.OrdEcpPlanPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pebExtPlanCreateBusiService")
public class PebExtPlanCreateBusiServiceImpl
implements PebExtPlanCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPlanCreateBusiServiceImpl.class);
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Autowired
    private OrdEcpPlanItemMapper ordEcpPlanItemMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdServMapper ordServMapper;
    @Autowired
    private PebExtExecuteSyncPlanBusiService pebExtExecuteSyncPlanBusiService;

    public PebExtPlanCreateRspBO dealPebExtPlanCreate(PebExtPlanCreateReqBO reqBO) {
        PebExtPlanCreateRspBO retBo = new PebExtPlanCreateRspBO();
        Long orderId = this.idUtil.nextId();
        Long planId = this.idUtil.nextId();
        Date nowTime = this.ordServMapper.getDbDate();
        OrdEcpPlanPO planPo = this.assemblePlanPo(orderId, planId, nowTime, reqBO);
        List<OrdEcpPlanItemPO> planItemPos = this.assemblePlanItemPo(orderId, planId, nowTime, reqBO);
        try {
            int result = this.ordEcpPlanMapper.insert(planPo);
            this.ordEcpPlanItemMapper.insertBatch(planItemPos);
        }
        catch (Exception e) {
            throw new UocProBusinessException("0100", "\u5199\u5165\u8ba1\u5212\u5355\u4fe1\u606f\u5f02\u5e38" + e.getMessage());
        }
        this.syncPlanInfo(planId, orderId);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setStatus("1");
        retBo.setMsg("\u6210\u529f");
        return retBo;
    }

    private void syncPlanInfo(Long planId, Long orderId) {
        PebExtExecuteSyncPlanReqBO syncPlanReqBo = new PebExtExecuteSyncPlanReqBO();
        syncPlanReqBo.setOrderId(orderId);
        syncPlanReqBo.setPlanId(planId);
        PebExtExecuteSyncPlanRspBO syncPlanRetBo = new PebExtExecuteSyncPlanRspBO();
        try {
            syncPlanRetBo = this.pebExtExecuteSyncPlanBusiService.executeSync(syncPlanReqBo);
        }
        catch (Exception e) {
            throw new UocProBusinessException("0100", "\u540c\u6b65ES\u6570\u636e\u5931\u8d25\uff0c\u5165\u53c2\uff1a" + syncPlanRetBo.getRespDesc());
        }
    }

    private List<OrdEcpPlanItemPO> assemblePlanItemPo(Long orderId, Long planId, Date nowTime, PebExtPlanCreateReqBO reqBO) {
        ArrayList<OrdEcpPlanItemPO> planItemPos = new ArrayList<OrdEcpPlanItemPO>();
        for (EcpItemBO item : reqBO.getMxItems()) {
            OrdEcpPlanItemPO itemPo = new OrdEcpPlanItemPO();
            itemPo.setPlanId(planId);
            itemPo.setOrderId(orderId);
            itemPo.setPlanItemId(Long.valueOf(this.idUtil.nextId()));
            itemPo.setJhmxbh(item.getJHMXBH());
            itemPo.setWlmc(item.getWLMC());
            itemPo.setWlbh(item.getWLBH());
            itemPo.setWxfl(item.getWXFL());
            itemPo.setGgxh(item.getGGXH());
            itemPo.setSl(item.getSL());
            itemPo.setDw(item.getDW());
            itemPo.setZzsmc(item.getZZSMC());
            itemPo.setBeiz(item.getBEIZ());
            itemPo.setCreateTime(nowTime);
            itemPo.setUsed(BigDecimal.ZERO);
            planItemPos.add(itemPo);
        }
        return planItemPos;
    }

    private OrdEcpPlanPO assemblePlanPo(Long orderId, Long planId, Date nowTime, PebExtPlanCreateReqBO reqBO) {
        OrdEcpPlanPO planPo = new OrdEcpPlanPO();
        planPo.setOrderId(orderId);
        planPo.setPlanId(planId);
        planPo.setJhmc(reqBO.getJHMC());
        planPo.setZxlsjhbh(reqBO.getZXLSJHBH());
        planPo.setJhtbr(reqBO.getJHTBR());
        planPo.setJhtbrlxdh(reqBO.getJHTBRLXDH());
        planPo.setSfgcjs(reqBO.getSFGCJS());
        planPo.setSfgcjsStr(PebExtConstant.PlanIsOrNot.getDesc((Integer)reqBO.getSFGCJS()).getDesc());
        planPo.setGcjsxmmc(reqBO.getGCJSXMMC());
        planPo.setCglx(reqBO.getCGLX());
        planPo.setCglxStr(PebExtConstant.ProcurementType.getDesc((Integer)reqBO.getCGLX()).getDesc());
        planPo.setSfgjcgsx(reqBO.getSFGJCGSX());
        planPo.setSfgjcgsxStr(PebExtConstant.PlanIsOrNot.getDesc((Integer)reqBO.getSFGJCGSX()).getDesc());
        planPo.setYsje(reqBO.getYSJE());
        planPo.setJycgfs(reqBO.getJYCGFS());
        planPo.setHtyjqdsj(reqBO.getHTYJQDSJ());
        planPo.setSwfzrmx(reqBO.getSWFZRMX());
        planPo.setSwfzrdh(reqBO.getSWFZRDH());
        planPo.setJsfzrmc(reqBO.getJSFZRMC());
        planPo.setJsfzrdh(reqBO.getJSFZRDH());
        planPo.setBz(reqBO.getBZ());
        planPo.setCjsj(reqBO.getCJSJ());
        planPo.setCgzxrbh(reqBO.getCGZXRBH());
        planPo.setCgzxjgbh(reqBO.getCGZXJGBH());
        planPo.setStatus(PebExtConstant.PlanStatus.TODO);
        planPo.setStatusStr("\u672a\u6267\u884c");
        planPo.setCreateTime(nowTime);
        planPo.setUsed(BigDecimal.ZERO);
        return planPo;
    }
}

