/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.saleorder;

import com.tydic.order.extend.bo.saleorder.FieldValueBO;
import com.tydic.order.extend.bo.saleorder.PebExtFieldInReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtFieldInRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtItemBO;
import com.tydic.order.extend.bo.saleorder.PebExtItemMapBO;
import com.tydic.order.extend.busi.saleorder.PebExtFieldInBusiService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdInterLogMapper;
import com.tydic.order.uoc.dao.OrdItemMapMapper;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdInterLogPO;
import com.tydic.order.uoc.dao.po.OrdItemMapPO;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtFieldInBusiServiceImpl
implements PebExtFieldInBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtFieldInBusiServiceImpl.class);
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdInterLogMapper ordInterLogMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;

    public PebExtFieldInRspBO dealCoreExtFieldIn(PebExtFieldInReqBO reqBO) {
        ArrayList<OrdExtMapPO> list = new ArrayList<OrdExtMapPO>();
        PebExtFieldInRspBO rspBO = new PebExtFieldInRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getExtFieldList())) {
            for (FieldValueBO fieldValueBO : reqBO.getExtFieldList()) {
                OrdExtMapPO extMapPO = new OrdExtMapPO();
                extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
                extMapPO.setFieldValue(fieldValueBO.getFieldValue());
                extMapPO.setFieldName(fieldValueBO.getFieldName());
                extMapPO.setFieldCode(fieldValueBO.getFieldCode());
                extMapPO.setOrderId(reqBO.getOrderId());
                extMapPO.setObjId(reqBO.getObjId());
                extMapPO.setObjType(reqBO.getObjType());
                list.add(extMapPO);
            }
            this.ordExtMapMapper.insertBatch(list);
        }
        try {
            if (reqBO.getLog() != null) {
                OrdInterLogPO logPO = new OrdInterLogPO();
                BeanUtils.copyProperties((Object)reqBO.getLog(), (Object)logPO);
                logPO.setId(Long.valueOf(this.idUtil.nextId()));
                this.ordInterLogMapper.insert(logPO);
            }
        }
        catch (Exception e) {
            return rspBO;
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderItemBO())) {
            this.dealUpdateSaleItem(reqBO);
        }
        return rspBO;
    }

    public PebExtFieldInRspBO dealUpdate(PebExtFieldInReqBO reqBO) {
        for (FieldValueBO fieldValueBO : reqBO.getExtFieldList()) {
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setFieldValue(fieldValueBO.getFieldValue());
            extMapPO.setOrderId(reqBO.getOrderId());
            extMapPO.setId(fieldValueBO.getId());
            extMapPO.setFieldCode(fieldValueBO.getFieldCode());
            this.ordExtMapMapper.updateById(extMapPO);
        }
        PebExtFieldInRspBO rspBO = new PebExtFieldInRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public PebExtFieldInRspBO dealUpdateSaleItem(PebExtFieldInReqBO reqBO) {
        for (PebExtItemBO pebExtItemBO : reqBO.getOrderItemBO()) {
            OrdItemPO ordItemPO = new OrdItemPO();
            BeanUtils.copyProperties((Object)pebExtItemBO, (Object)ordItemPO);
            try {
                this.ordItemMapper.updateById(ordItemPO);
            }
            catch (Exception e) {
                log.error("\u4e0b\u5355\u6dfb\u52a0\u6210\u4ea4\u670d\u52a1\u8d39\u62a5\u9519" + e);
                throw new UocProBusinessException("8888", "\u4e0b\u5355\u6dfb\u52a0\u6210\u4ea4\u670d\u52a1\u8d39\u62a5\u9519" + e.getMessage());
            }
        }
        PebExtFieldInRspBO rspBO = new PebExtFieldInRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public PebExtFieldInRspBO dealSaveLog(PebExtFieldInReqBO reqBO) {
        OrdInterLogPO logPO = new OrdInterLogPO();
        BeanUtils.copyProperties((Object)reqBO.getLog(), (Object)logPO);
        logPO.setId(Long.valueOf(this.idUtil.nextId()));
        this.ordInterLogMapper.insert(logPO);
        PebExtFieldInRspBO rspBO = new PebExtFieldInRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public PebExtFieldInRspBO dealItemExtField(PebExtFieldInReqBO reqBO) {
        PebExtFieldInRspBO rspBO = new PebExtFieldInRspBO();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getItemMapBOS())) {
            ArrayList<OrdItemMapPO> ordItemMapPOS = new ArrayList<OrdItemMapPO>();
            for (PebExtItemMapBO pebExtItemMapBO : reqBO.getItemMapBOS()) {
                OrdItemMapPO ordItemMapPO = new OrdItemMapPO();
                BeanUtils.copyProperties((Object)pebExtItemMapBO, (Object)ordItemMapPO);
                ordItemMapPO.setId(Long.valueOf(this.idUtil.nextId()));
                ordItemMapPOS.add(ordItemMapPO);
            }
            if (CollectionUtils.isNotEmpty(ordItemMapPOS)) {
                this.ordItemMapMapper.insertBatch(ordItemMapPOS);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public PebExtFieldInRspBO dealUpdateSale(PebExtFieldInReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        if (reqBO.getStatus() != null) {
            salePO.setSaleState(reqBO.getStatus());
        } else {
            salePO.setSaleState(PebExtConstant.FAIL_STATUS);
        }
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getObjId());
        this.ordSaleMapper.updateById(salePO);
        PebExtFieldInRspBO rspBO = new PebExtFieldInRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public PebExtFieldInRspBO dealCancel(PebExtFieldInReqBO reqBO) {
        PebExtFieldInRspBO rspBO = new PebExtFieldInRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrderPO orderPO = new OrderPO();
        orderPO.setCancelDesc(reqBO.getRemark());
        orderPO.setCancelReason(reqBO.getRemark());
        orderPO.setCancelTime(new Date());
        orderPO.setCancelOperId(reqBO.getUserId() == null ? orderPO.getCreateOperId() : String.valueOf(reqBO.getUserId()));
        orderPO.setProcState(reqBO.getFailCode());
        orderPO.setOrderState(UocConstant.CORE_ORDER_STATUS.CANCEL);
        this.orderMapper.updateById(orderPO);
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleState(UocConstant.SALE_ORDER_STATUS.CANCEL);
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getObjId());
        this.ordSaleMapper.updateById(salePO);
        return rspBO;
    }
}

