/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.saleorder;

import com.ohaotian.plugin.db.Page;
import com.tydic.order.extend.bo.saleorder.PebExtOrdLogRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtOrderLogQueryReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtOrderLogQueryRspBO;
import com.tydic.order.extend.busi.PebExtOrderLogQueryBusiService;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdBusiOperRecordMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.po.OrdBusiOperRecordPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtOrderLogQueryBusiServiceImpl
implements PebExtOrderLogQueryBusiService {
    private final OrdSaleMapper ordSaleMapper;
    private final OrdBusiOperRecordMapper ordBusiOperRecordMapper;

    @Autowired
    public PebExtOrderLogQueryBusiServiceImpl(OrdSaleMapper ordSaleMapper, OrdBusiOperRecordMapper ordBusiOperRecordMapper) {
        this.ordSaleMapper = ordSaleMapper;
        this.ordBusiOperRecordMapper = ordBusiOperRecordMapper;
    }

    public PebExtOrderLogQueryRspBO getOrderlog(PebExtOrderLogQueryReqBO reqBO) {
        PebExtOrderLogQueryRspBO rspBO = new PebExtOrderLogQueryRspBO();
        rspBO.setRespCode("0000");
        OrdBusiOperRecordPO ordBusiOperRecordModel = new OrdBusiOperRecordPO();
        ordBusiOperRecordModel.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_LOG_RECORD);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            ordBusiOperRecordModel.setOrderNo(reqBO.getSaleVoucherNo());
        }
        if (null != reqBO.getStartTime()) {
            ordBusiOperRecordModel.setStartTime(reqBO.getStartTime());
        }
        if (null != reqBO.getEndTime()) {
            ordBusiOperRecordModel.setEndTime(reqBO.getEndTime());
        }
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        List ordBusiOperRecordPOS = this.ordBusiOperRecordMapper.getListPage(page, ordBusiOperRecordModel);
        if (CollectionUtils.isEmpty((Collection)ordBusiOperRecordPOS)) {
            return this.buildNullRspBO(rspBO, "\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355\u7684\u6d41\u8f6c\u65e5\u5fd7\u4fe1\u606f");
        }
        ArrayList<PebExtOrdLogRspBO> pebExtOrdLogRspBOS = new ArrayList<PebExtOrdLogRspBO>();
        for (OrdBusiOperRecordPO ordBusiOperRecordPO : ordBusiOperRecordPOS) {
            PebExtOrdLogRspBO pebExtOrdLogRspBO = new PebExtOrdLogRspBO();
            BeanUtils.copyProperties((Object)ordBusiOperRecordPO, (Object)pebExtOrdLogRspBO);
            pebExtOrdLogRspBO.setDealIp(ordBusiOperRecordPO.getIpAddress());
            pebExtOrdLogRspBO.setSaleVoucherNo(ordBusiOperRecordPO.getOrderNo());
            pebExtOrdLogRspBO.setDealName(ordBusiOperRecordPO.getDealDesc());
            pebExtOrdLogRspBOS.add(pebExtOrdLogRspBO);
        }
        rspBO.setRespDesc("\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355\u6d41\u8f6c\u65e5\u5fd7\u4fe1\u606f\u6210\u529f");
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(pebExtOrdLogRspBOS);
        return rspBO;
    }

    private PebExtOrderLogQueryRspBO buildNullRspBO(PebExtOrderLogQueryRspBO rspBO, String returnDesc) {
        rspBO.setRespDesc(returnDesc);
        rspBO.setPageNo(1);
        rspBO.setRecordsTotal(0);
        rspBO.setTotal(0);
        rspBO.setRows(new ArrayList());
        return rspBO;
    }
}

