/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.serv;

import com.tydic.order.extend.bo.saleorder.PebExtAddressInfoIntfceReqBO;
import com.tydic.order.extend.bo.serv.PebExtOrderInvoiceModifyReqBO;
import com.tydic.order.extend.bo.serv.PebExtOrderInvoiceModifyRspBO;
import com.tydic.order.extend.busi.serc.PebExtOrderInvoiceModifyBusiService;
import com.tydic.order.uoc.atom.core.UocCoreCreateLogisticsRelaAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreCreateLogisticsRelaReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreCreateLogisticsRelaRspBO;
import com.tydic.order.uoc.bo.order.UocCoreInvoiceBO;
import com.tydic.order.uoc.dao.OrdInvoiceMapper;
import com.tydic.order.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.order.uoc.dao.po.OrdInvoicePO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PebExtOrderInvoiceModifyBusiService")
public class PebExtOrderInvoiceModifyBusiServiceImpl
implements PebExtOrderInvoiceModifyBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtOrderInvoiceModifyBusiServiceImpl.class);
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private UocCoreCreateLogisticsRelaAtomService uocCoreCreateLogisticsRelaTionAtomService;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    public PebExtOrderInvoiceModifyRspBO orderInvoiceModify(PebExtOrderInvoiceModifyReqBO reqBO) {
        this.validParam(reqBO);
        PebExtOrderInvoiceModifyRspBO rspBO = new PebExtOrderInvoiceModifyRspBO();
        OrdInvoicePO invoicePO = new OrdInvoicePO();
        invoicePO.setOrderId(reqBO.getOrderId());
        OrdInvoicePO ordInvoicePO = this.ordInvoiceMapper.getModelByPO(invoicePO);
        if (ordInvoicePO == null || ordInvoicePO.getOrderId() == null) {
            this.saveInvoice(reqBO.getInvoiceBO(), reqBO.getInvoiceAddressInfo(), reqBO.getOrderId(), reqBO.getSaleVoucherId());
            rspBO.setRemark("\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u6dfb\u52a0\u6210\u529f");
        } else {
            this.modifyInvoice(ordInvoicePO, reqBO.getInvoiceBO(), reqBO.getInvoiceAddressInfo(), reqBO.getOrderId());
            rspBO.setRemark("\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u4fee\u6539\u6210\u529f");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validParam(PebExtOrderInvoiceModifyReqBO reqBO) {
        if (reqBO == null || reqBO.getOrderId() == null) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("7777", "\u9500\u552e\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void saveInvoice(UocCoreInvoiceBO invoiceBO, PebExtAddressInfoIntfceReqBO invoiceAddressInfo, Long orderId, Long saleId) {
        if (invoiceBO != null) {
            Long contactId;
            if (invoiceAddressInfo != null) {
                UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, invoiceAddressInfo);
                UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
                if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
                    throw new UocProBusinessException("8888", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
                }
                contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
            } else {
                contactId = saleId;
            }
            Long id = this.idUtil.nextId();
            OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
            ordInvoicePO.setInvoiceType(invoiceBO.getInvoiceType());
            ordInvoicePO.setRelaEmail(invoiceBO.getRelaEmail());
            ordInvoicePO.setInvoiceUrl(invoiceBO.getInvoiceUrl());
            ordInvoicePO.setBankAccount(invoiceBO.getBankAccount());
            ordInvoicePO.setBuyerName(invoiceBO.getBuyerName());
            ordInvoicePO.setRelaPhone(invoiceBO.getRelaPhone());
            ordInvoicePO.setOrderId(orderId);
            ordInvoicePO.setId(id);
            ordInvoicePO.setSaleVoucherId(contactId);
            ordInvoicePO.setCompanyAddress(invoiceBO.getCompanyAddress());
            ordInvoicePO.setDepositBank(invoiceBO.getDepositBank());
            ordInvoicePO.setFixPhone(invoiceBO.getFixPhone());
            ordInvoicePO.setInvoiceNo(invoiceBO.getInvoiceNo());
            ordInvoicePO.setInvoiceSn(invoiceBO.getInvoiceSn());
            ordInvoicePO.setOutInvoiceId(invoiceBO.getUmcInvoiceId());
            this.ordInvoiceMapper.insert(ordInvoicePO);
        }
    }

    private void modifyInvoice(OrdInvoicePO ordInvoiceOld, UocCoreInvoiceBO invoiceBO, PebExtAddressInfoIntfceReqBO invoiceAddressInfo, Long orderId) {
        if (invoiceBO != null) {
            if (invoiceAddressInfo != null) {
                UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, invoiceAddressInfo);
                uocCoreCreateLogisticsRelaReqBO.setContactId(ordInvoiceOld.getSaleVoucherId());
                UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreModifyLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
                if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
                    throw new UocProBusinessException("8888", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
                }
            }
            OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
            ordInvoicePO.setId(ordInvoiceOld.getId());
            ordInvoicePO.setInvoiceType(invoiceBO.getInvoiceType());
            ordInvoicePO.setRelaEmail(invoiceBO.getRelaEmail());
            ordInvoicePO.setInvoiceUrl(invoiceBO.getInvoiceUrl());
            ordInvoicePO.setBankAccount(invoiceBO.getBankAccount());
            ordInvoicePO.setBuyerName(invoiceBO.getBuyerName());
            ordInvoicePO.setRelaPhone(invoiceBO.getRelaPhone());
            ordInvoicePO.setId(ordInvoiceOld.getId());
            ordInvoicePO.setCompanyAddress(invoiceBO.getCompanyAddress());
            ordInvoicePO.setDepositBank(invoiceBO.getDepositBank());
            ordInvoicePO.setFixPhone(invoiceBO.getFixPhone());
            ordInvoicePO.setInvoiceNo(invoiceBO.getInvoiceNo());
            ordInvoicePO.setInvoiceSn(invoiceBO.getInvoiceSn());
            ordInvoicePO.setOutInvoiceId(invoiceBO.getUmcInvoiceId());
            this.ordInvoiceMapper.updateById(ordInvoicePO);
        }
    }

    private UocCoreCreateLogisticsRelaReqBO buildLogisticsRelaTionParam(Long orderId, PebExtAddressInfoIntfceReqBO addressInfoIntfceBO) {
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = new UocCoreCreateLogisticsRelaReqBO();
        uocCoreCreateLogisticsRelaReqBO.setOrderId(orderId);
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        uocCoreCreateLogisticsRelaReqBO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        uocCoreCreateLogisticsRelaReqBO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        uocCoreCreateLogisticsRelaReqBO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        uocCoreCreateLogisticsRelaReqBO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        uocCoreCreateLogisticsRelaReqBO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        uocCoreCreateLogisticsRelaReqBO.setContactName(addressInfoIntfceBO.getReceiverName());
        uocCoreCreateLogisticsRelaReqBO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        uocCoreCreateLogisticsRelaReqBO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        uocCoreCreateLogisticsRelaReqBO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        uocCoreCreateLogisticsRelaReqBO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        return uocCoreCreateLogisticsRelaReqBO;
    }
}

